/*
 * Decompiled with CFR 0.152.
 */
package quatum.limitless_options_neoforge.gui;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ValuesList
extends ContainerObjectSelectionList<Entry> {
    String filter;
    private final ArrayList<Entry> internalChildren = new ArrayList();
    private final Screen screen;

    public ValuesList(Minecraft p_94465_, int p_94466_, int p_94467_, int p_94468_, int p_94469_, Screen screen) {
        super(p_94465_, p_94466_, p_94467_, p_94468_, p_94469_);
        this.screen = screen;
        this.centerListVertically = false;
    }

    public void add(OptionInstance<?> p_232531_, Font font) {
        this.internalChildren.add(Entry.normal(this.minecraft.options, this.width, p_232531_, font, this.screen));
        this.fillValues();
    }

    public void add(List<OptionInstance<?>> p_232534_, Font font) {
        p_232534_.forEach(optionInstance -> this.add((OptionInstance<?>)optionInstance, font));
    }

    public int getRowWidth() {
        return 310;
    }

    public Optional<AbstractWidget> getMouseOver(double p_94481_, double p_94482_) {
        for (Entry optionslist$entry : this.children()) {
            for (AbstractWidget abstractwidget : optionslist$entry.children) {
                if (!abstractwidget.isMouseOver(p_94481_, p_94482_)) continue;
                return Optional.of(abstractwidget);
            }
        }
        return Optional.empty();
    }

    public void updateFilter(String p_239901_) {
        this.filter = p_239901_;
        this.fillValues();
    }

    public void fillValues() {
        this.clearEntries();
        this.internalChildren.forEach(entry -> {
            if (this.filter == null || entry.name.toLowerCase().contains(this.filter.toLowerCase())) {
                this.addEntry((AbstractSelectionList.Entry)entry);
            }
        });
    }

    protected static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        final Map<OptionInstance<?>, List<AbstractWidget>> options;
        final List<AbstractWidget> children;
        private final Screen screen;
        final String name;

        private Entry(Map<OptionInstance<?>, List<AbstractWidget>> p_169047_, String name, Screen screen) {
            this.options = p_169047_;
            this.children = p_169047_.values().stream().toList().get(0);
            this.name = name;
            this.screen = screen;
        }

        public static Entry normal(Options p_232538_, int p_232539_, OptionInstance<?> p_232540_, Font font, Screen screen) {
            int type;
            EditBox editBox = new EditBox(font, p_232539_ / 2, 20, p_232539_ / 4, 10, (Component)Component.empty());
            Predicate<String> charPredicate = Objects::nonNull;
            editBox.setMaxLength(Integer.MAX_VALUE);
            if (p_232540_.get() instanceof Integer) {
                charPredicate = s -> s.matches("[0-9-]*");
                editBox.setValue(p_232540_.get().toString());
                type = 1;
            } else if (p_232540_.get() instanceof Double) {
                charPredicate = s -> s.matches("[0-9.,-]*");
                editBox.setValue(BigDecimal.valueOf((Double)p_232540_.get()).toPlainString());
                type = 2;
            } else {
                Object object = p_232540_.get();
                if (object instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    editBox.setMaxLength(1);
                    if (b.booleanValue()) {
                        editBox.setValue("t");
                    } else {
                        editBox.setValue("f");
                    }
                    charPredicate = s -> s.matches("[tf]*");
                    type = 3;
                } else {
                    type = 0;
                    editBox.setValue(p_232540_.get().toString());
                    editBox.active = false;
                }
            }
            editBox.setFilter(charPredicate);
            editBox.setResponder(arg_0 -> Entry.lambda$normal$3(p_232540_, (byte)type, editBox, p_232538_, arg_0));
            StringWidget stringWidget = new StringWidget(p_232539_ / 2, 20, (Component)Component.literal((String)p_232540_.toString()), font);
            stringWidget.setX(p_232539_ / 2 - 10 - font.width(p_232540_.toString()));
            List<EditBox> abstractWidgets = List.of(stringWidget, editBox);
            return new Entry((Map<OptionInstance<?>, List<AbstractWidget>>)ImmutableMap.of(p_232540_, abstractWidgets), p_232540_.toString(), screen);
        }

        public static void onChange(OptionInstance<?> p_232540_, byte type, EditBox editBox, Options options) {
            switch (type) {
                case 1: {
                    try {
                        int num = Integer.parseInt(editBox.getValue());
                        p_232540_.set((Object)num);
                    }
                    catch (NumberFormatException num) {}
                    break;
                }
                case 2: {
                    try {
                        BigDecimal number = new BigDecimal(editBox.getValue());
                        p_232540_.set((Object)number.doubleValue());
                    }
                    catch (NumberFormatException number) {}
                    break;
                }
                case 3: {
                    OptionInstance<?> option = p_232540_;
                    if (editBox.getValue().equals("t")) {
                        option.set((Object)true);
                        break;
                    }
                    if (!editBox.getValue().equals("f")) break;
                    option.set((Object)false);
                    break;
                }
            }
        }

        public void renderContent(GuiGraphics p_440603_, int p_440287_, int p_439324_, boolean p_439478_, float p_440210_) {
            boolean i = false;
            int j = this.screen.width / 2 - 155;
            this.children.forEach(p_280776_ -> {
                p_280776_.setPosition(p_280776_.getX(), this.getContentY());
                p_280776_.render(p_440603_, p_440287_, p_439324_, p_440210_);
            });
        }

        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        private static /* synthetic */ void lambda$normal$3(OptionInstance p_232540_, byte type, EditBox editBox, Options p_232538_, String s) {
            Entry.onChange(p_232540_, type, editBox, p_232538_);
        }
    }
}

