/*
 * Decompiled with CFR 0.152.
 */
package com.yzf.modwhitelist.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.yzf.modwhitelist.ModWhiteList;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.loading.FMLPaths;

public class ServerConfig {
    private static List<String> whiteList;
    private static List<String> blackList;
    private static final Path CONFIG_PATH;
    private static final Gson GSON;

    public static void init() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            ServerConfig.createConfig();
            return;
        }
        if (!ServerConfig.validateConfig()) {
            ServerConfig.backupConfig(CONFIG_PATH);
            ServerConfig.createConfig();
            return;
        }
        ServerConfig.readConfig();
    }

    public static void createConfig() {
        try {
            Files.deleteIfExists(CONFIG_PATH);
            Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);
            JsonObject config = new JsonObject();
            config.add("WhiteList", (JsonElement)new JsonArray());
            config.add("BlackList", (JsonElement)new JsonArray());
            GSON.toJson((JsonElement)config, (Appendable)writer);
            ((Writer)writer).close();
            ServerConfig.defaultValue();
        }
        catch (IOException e) {
            ModWhiteList.LOG.error("\u521b\u5efa\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01");
        }
    }

    public static void readConfig() {
        if (ServerConfig.validateConfig()) {
            try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
                JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                whiteList = ServerConfig.parseStringArray(object.get("WhiteList"));
                blackList = ServerConfig.parseStringArray(object.get("BlackList"));
            }
            catch (Exception e) {
                ModWhiteList.LOG.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01");
            }
        }
    }

    public static void backupConfig(Path configPath) {
        ServerConfig.defaultValue();
        String fileName = "mod_whitelist";
        int count = 1;
        Path backupPath = configPath.resolveSibling(fileName + "-" + count + ".json.bak");
        while (Files.exists(backupPath, new LinkOption[0])) {
            backupPath = configPath.resolveSibling(fileName + "-" + count + ".json.bak");
            ++count;
        }
        try {
            Files.copy(configPath, backupPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ModWhiteList.LOG.error("\u5907\u4efd\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean validateConfig() {
        try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
            JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (!object.has("WhiteList")) {
                boolean bl = false;
                return bl;
            }
            if (!object.has("BlackList")) {
                boolean bl = false;
                return bl;
            }
            if (ServerConfig.isValidArray(object.get("WhiteList"))) {
                boolean bl = false;
                return bl;
            }
            if (!ServerConfig.isValidArray(object.get("BlackList"))) return true;
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidArray(JsonElement element) {
        if (!element.isJsonArray()) {
            return true;
        }
        JsonArray array = element.getAsJsonArray();
        for (JsonElement item : array) {
            if (item.isJsonPrimitive() && item.getAsJsonPrimitive().isString()) continue;
            return true;
        }
        return false;
    }

    public static List<String> parseStringArray(JsonElement element) {
        ArrayList<String> list = new ArrayList<String>();
        if (element == null) {
            return list;
        }
        for (JsonElement item : element.getAsJsonArray()) {
            list.add(item.getAsString());
        }
        return list;
    }

    public static void defaultValue() {
        whiteList = new ArrayList<String>();
        blackList = new ArrayList<String>();
    }

    public static List<String> getWhiteList() {
        return whiteList;
    }

    public static List<String> getBlackList() {
        return blackList;
    }

    static {
        CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("mod_whitelist.json");
        GSON = new GsonBuilder().setPrettyPrinting().create();
    }
}

