/*
 * Decompiled with CFR 0.152.
 */
package com.yzf.modwhitelist.server;

import com.yzf.modwhitelist.config.ServerConfig;
import com.yzf.modwhitelist.packet.C2S.ModListPacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerHandler {
    private static List<String> forbidMods = new ArrayList<String>();

    public static void handleModList(ModListPacket p, IPayloadContext c) {
        c.enqueueWork(() -> {
            if (!ServerHandler.isValidClient_Black(p.data(), ServerConfig.getBlackList())) {
                c.disconnect((Component)Component.translatable((String)"modwhitelist.forbid_message", (Object[])new Object[]{forbidMods.toString()}));
                forbidMods = new ArrayList<String>();
            }
            if (!ServerHandler.isValidClient_White(p.data(), ServerConfig.getWhiteList())) {
                c.disconnect((Component)Component.translatable((String)"modwhitelist.forbid_message", (Object[])new Object[]{forbidMods.toString()}));
                forbidMods = new ArrayList<String>();
            }
        });
    }

    private static boolean isValidClient_White(List<String> clientList, List<String> whiteList) {
        if (whiteList.isEmpty()) {
            return true;
        }
        ServerHandler.forbidMod(clientList, whiteList, "white");
        return forbidMods.isEmpty();
    }

    private static boolean isValidClient_Black(List<String> clientList, List<String> blackList) {
        if (blackList.isEmpty()) {
            return true;
        }
        ServerHandler.forbidMod(clientList, blackList, "black");
        return forbidMods.isEmpty();
    }

    public static void forbidMod(List<String> clientList, List<String> list, String listType) {
        if (listType.equals("white")) {
            HashSet<String> clientSet = new HashSet<String>(clientList);
            clientSet.removeAll(new HashSet<String>(list));
            ArrayList<String> result = new ArrayList<String>(clientSet);
            result.sort(String::compareTo);
            forbidMods = result;
        }
        if (listType.equals("black")) {
            forbidMods = clientList.stream().filter(list::contains).toList();
        }
    }
}

