/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.cataclysm;

import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2complements.init.data.TagGen;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.AncientRemnantSandstormModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.EnderGuardianVoidRuneModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.HarbingerDeathBeamModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.HarbingerHomingMissileModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.IgnisAttackModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.IgnisFireballModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.LeviathanBlastPortalModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.MaledictusAttackModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.MaledictusEarthquakeModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.NetheriteMonstrosityEarthquakeModifier;
import dev.xkmc.modulargolems.compat.materials.cataclysm.modifiers.RageEffect;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.item.upgrade.SimpleUpgradeItem;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraftforge.fml.ModList;

public class CataCompatRegistry {
    public static final RegistryEntry<IgnisFireballModifier> IGNIS_FIREBALL = GolemModifiers.reg("ignis_fireball", () -> new IgnisFireballModifier(StatFilterType.HEAD, 2), "When target is faraway, shoot Ignis fireballs toward target.");
    public static final RegistryEntry<IgnisAttackModifier> IGNIS_ATTACK = GolemModifiers.reg("ignis_attack", () -> new IgnisAttackModifier(StatFilterType.ATTACK, 2), "Stack Blazing Brande effect and regenerate health when hit target. When health is lower than half, direct damage bypasses armor.");
    public static final RegistryEntry<HarbingerDeathBeamModifier> HARBINGER_BEAM = GolemModifiers.reg("harbinger_death_beam", () -> new HarbingerDeathBeamModifier(StatFilterType.HEAD, 1), "When target is faraway, shoot Death Beam toward target.");
    public static final RegistryEntry<HarbingerHomingMissileModifier> HARBINGER_MISSILE = GolemModifiers.reg("harbinger_missile", () -> new HarbingerHomingMissileModifier(StatFilterType.ATTACK, 2), "When target is faraway, shoot Homing Missile toward target.");
    public static final RegistryEntry<LeviathanBlastPortalModifier> PORTAL = GolemModifiers.reg("leviathan_blast_portal", LeviathanBlastPortalModifier::new, "When target is faraway, create blast portal at target position");
    public static final RegistryEntry<EnderGuardianVoidRuneModifier> RUNE = GolemModifiers.reg("ender_guardian_void_rune", EnderGuardianVoidRuneModifier::new, "Summon void rune toward target");
    public static final RegistryEntry<NetheriteMonstrosityEarthquakeModifier> EARTHQUAKE = GolemModifiers.reg("netherite_monstrosity_earthquake", NetheriteMonstrosityEarthquakeModifier::new, "Jump and cause earthquake on landing");
    public static final RegistryEntry<AncientRemnantSandstormModifier> SANDSTORM = GolemModifiers.reg("ancient_remnant_sandstorm", AncientRemnantSandstormModifier::new, "When target is faraway, summon sandstorm at target position");
    public static final RegistryEntry<MaledictusEarthquakeModifier> EARTHQUAKE_SPEAR = GolemModifiers.reg("maledictus_earthquake", MaledictusEarthquakeModifier::new, "Jump and cause earthquake on landing, summoning halberds");
    public static final RegistryEntry<MaledictusAttackModifier> MALEDICTUS_ATTACK = GolemModifiers.reg("maledictus_attack", MaledictusAttackModifier::new, "Golem melee damage bypass armor. Stack rage counter after dealing damage, up to %s layers");
    public static final RegistryEntry<RageEffect> EFF_FORCE = CataCompatRegistry.genEffect("maledictus_rage", () -> new RageEffect(MobEffectCategory.BENEFICIAL, -1), "Increase golem attack damage");
    public static final RegistryEntry<SimpleUpgradeItem> LEVIATHAN = GolemItems.regModUpgrade("leviathan_blast_portal", () -> PORTAL, "cataclysm").lang("Leviathan Upgrade").register();
    public static final RegistryEntry<SimpleUpgradeItem> ENDER_GUARDIAN = GolemItems.regModUpgrade("ender_guardian_void_rune", () -> RUNE, "cataclysm").lang("Ender Guardian Upgrade").register();
    public static final RegistryEntry<SimpleUpgradeItem> MONSTROSITY = GolemItems.regModUpgrade("netherite_monstrosity_earthquake", () -> EARTHQUAKE, "cataclysm").lang("Netherite Monstrosity Upgrade").register();
    public static final RegistryEntry<SimpleUpgradeItem> ANCIENT_REMNANT = GolemItems.regModUpgrade("ancient_remnant_sandstorm", () -> SANDSTORM, "cataclysm").lang("Ancient Remnant Upgrade").register();

    private static <T extends MobEffect> RegistryEntry<T> genEffect(String name, NonNullSupplier<T> sup, String desc) {
        return ((NoConfigBuilder)ModularGolems.REGISTRATE.effect(name, sup, desc).lang(MobEffect::m_19481_)).register();
    }

    public static void register() {
        if (ModList.get().isLoaded("l2complements")) {
            MGTagGen.OPTIONAL_EFF.add(e -> e.addTag(TagGen.SKILL_EFFECT).m_176839_(EFF_FORCE.getId()));
        }
    }
}

