/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.geoty.modifier;

import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.utils.SEHelper;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SoulRepairModifier
extends GolemModifier {
    public SoulRepairModifier() {
        super(StatFilterType.MASS, 5);
    }

    @Override
    public double onInventoryHealTick(double heal, GolemModifier.HealingContext ctx, int level) {
        if ((double)ctx.health() > (double)ctx.maxHealth() * (Double)MGConfig.COMMON.soulHealingThreshold.get()) {
            return heal;
        }
        Player player = null;
        Entity entity = ctx.owner();
        if (entity instanceof Player) {
            Player pl;
            player = pl = (Player)entity;
        } else {
            entity = ctx.owner();
            if (entity instanceof AbstractGolemEntity) {
                AbstractGolemEntity golem = (AbstractGolemEntity)entity;
                player = golem.getOwner();
            }
        }
        if (player == null) {
            return heal;
        }
        if (!SEHelper.getSoulsContainer((Player)player)) {
            return heal;
        }
        int rate = (Integer)ItemConfig.ItemsRepairAmount.get() * (Integer)MGConfig.COMMON.soulHealingCost.get();
        if (rate <= 0) {
            return heal;
        }
        int max = Math.min(level * (Integer)MGConfig.COMMON.soulHealingRate.get(), SEHelper.getSoulAmountInt((Player)player) / rate);
        if (max <= 0) {
            return heal;
        }
        SEHelper.decreaseSouls((Player)player, (int)(max * rate));
        return heal + (double)max;
    }

    @Override
    public double onHealTick(double heal, AbstractGolemEntity<?, ?> entity, int level) {
        Player player = entity.getOwner();
        if (player != null && SEHelper.getSoulsContainer((Player)player)) {
            int rate = (Integer)ItemConfig.ItemsRepairAmount.get();
            for (EquipmentSlot e : EquipmentSlot.values()) {
                int max;
                ItemStack stack = entity.m_6844_(e);
                if (stack.m_41619_() || !stack.m_41768_() || (max = Math.min(Math.min(stack.m_41773_(), level), SEHelper.getSoulAmountInt((Player)player) / rate)) <= 0) continue;
                SEHelper.decreaseSouls((Player)player, (int)(rate * max));
                stack.m_41721_(stack.m_41773_() - max);
            }
        }
        return super.onHealTick(heal, entity, level);
    }
}

