/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.l2complements;

import dev.xkmc.l2library.util.math.MathHelper;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ConduitModifier
extends GolemModifier {
    private static final String STR_ATK = "l2complements:conduit_attack";
    private static final String STR_SPEED = "l2complements:conduit_speed";
    private static final String STR_ARMOR = "l2complements:conduit_armor";
    private static final String STR_TOUGH = "l2complements:conduit_toughness";
    private static final UUID ID_ATK = MathHelper.getUUIDFromString((String)"l2complements:conduit_attack");
    private static final UUID ID_SPEED = MathHelper.getUUIDFromString((String)"l2complements:conduit_speed");
    private static final UUID ID_ARMOR = MathHelper.getUUIDFromString((String)"l2complements:conduit_armor");
    private static final UUID ID_TOUGH = MathHelper.getUUIDFromString((String)"l2complements:conduit_toughness");

    public ConduitModifier() {
        super(StatFilterType.MASS, 4);
    }

    @Override
    public void onHurt(AbstractGolemEntity<?, ?> entity, LivingHurtEvent event, int level) {
        if (event.getSource().m_269533_(DamageTypeTags.f_268738_) || event.getSource().m_269533_(DamageTypeTags.f_268437_) || !entity.m_20071_()) {
            return;
        }
        event.setAmount((float)((double)event.getAmount() * Math.pow(1.0 - (Double)MGConfig.COMMON.conduitBoostReduction.get(), level)));
    }

    @Override
    public List<MutableComponent> getDetail(int level) {
        int red = (int)Math.round(100.0 * Math.pow(1.0 - (Double)MGConfig.COMMON.conduitBoostReduction.get(), level));
        int atk = (int)Math.round((Double)MGConfig.COMMON.conduitBoostAttack.get() * (double)level * 100.0);
        int spe = (int)Math.round((Double)MGConfig.COMMON.conduitBoostSpeed.get() * (double)level * 100.0);
        int armor = (Integer)MGConfig.COMMON.conduitBoostArmor.get() * level;
        int tough = (Integer)MGConfig.COMMON.conduitBoostToughness.get() * level;
        int damage = (Integer)MGConfig.COMMON.conduitDamage.get() * level;
        int freq = (Integer)MGConfig.COMMON.conduitCooldown.get() / 20;
        return List.of(Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{red, freq, damage}).m_130940_(ChatFormatting.GREEN), Component.m_237115_((String)Attributes.f_22281_.m_22087_()).m_130946_(": +" + atk + "%").m_130940_(ChatFormatting.BLUE), Component.m_237115_((String)Attributes.f_22279_.m_22087_()).m_130946_(": +" + spe + "%").m_130940_(ChatFormatting.BLUE), Component.m_237115_((String)Attributes.f_22284_.m_22087_()).m_130946_(": +" + armor).m_130940_(ChatFormatting.BLUE), Component.m_237115_((String)Attributes.f_22285_.m_22087_()).m_130946_(": +" + tough).m_130940_(ChatFormatting.BLUE));
    }

    @Override
    public void onAiStep(AbstractGolemEntity<?, ?> golem, int level) {
        AttributeInstance gatk = golem.m_21051_(Attributes.f_22281_);
        AttributeInstance gspe = golem.m_21051_(Attributes.f_22279_);
        AttributeInstance garm = golem.m_21051_(Attributes.f_22284_);
        AttributeInstance gtgh = golem.m_21051_(Attributes.f_22285_);
        if (!golem.m_20071_()) {
            if (gatk != null && gatk.m_22111_(ID_ATK) != null) {
                gatk.m_22120_(ID_ATK);
            }
            if (gspe != null && gspe.m_22111_(ID_SPEED) != null) {
                gspe.m_22120_(ID_SPEED);
            }
            if (garm != null && garm.m_22111_(ID_ARMOR) != null) {
                garm.m_22120_(ID_ARMOR);
            }
            if (gtgh != null && gtgh.m_22111_(ID_TOUGH) != null) {
                gtgh.m_22120_(ID_TOUGH);
            }
            return;
        }
        double atk = (Double)MGConfig.COMMON.conduitBoostAttack.get() * (double)level;
        double spe = (Double)MGConfig.COMMON.conduitBoostSpeed.get() * (double)level;
        int armor = (Integer)MGConfig.COMMON.conduitBoostArmor.get() * level;
        double tough = (Integer)MGConfig.COMMON.conduitBoostToughness.get() * level;
        if (gatk != null && gatk.m_22111_(ID_ATK) == null) {
            gatk.m_22118_(new AttributeModifier(ID_ATK, STR_ATK, atk, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (gspe != null && gspe.m_22111_(ID_SPEED) == null) {
            gspe.m_22118_(new AttributeModifier(ID_SPEED, STR_SPEED, spe, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if (garm != null && garm.m_22111_(ID_ARMOR) == null) {
            garm.m_22118_(new AttributeModifier(ID_ARMOR, STR_ARMOR, (double)armor, AttributeModifier.Operation.ADDITION));
        }
        if (gtgh != null && gtgh.m_22111_(ID_TOUGH) == null) {
            gtgh.m_22118_(new AttributeModifier(ID_TOUGH, STR_TOUGH, tough, AttributeModifier.Operation.ADDITION));
        }
        LivingEntity target = golem.m_5448_();
        if (level > 0 && target != null && target.f_20916_ == 0 && target.m_20071_() && golem.f_19797_ % (Integer)MGConfig.COMMON.conduitCooldown.get() == 0) {
            int damage = (Integer)MGConfig.COMMON.conduitDamage.get() * level;
            Level pLevel = golem.m_9236_();
            pLevel.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11823_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            golem.m_5448_().m_6469_(pLevel.m_269111_().m_269104_(golem, golem), (float)damage);
        }
    }
}

