/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.musket;

import ewewukek.musketmod.GunItem;
import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class RangedGunAttackGoal<T extends Mob>
extends Goal {
    public final T mob;
    private boolean isLoading;

    public RangedGunAttackGoal(T mob) {
        this(mob, EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public RangedGunAttackGoal(T mob, EnumSet<Goal.Flag> flags) {
        this.mob = mob;
        this.m_7021_(flags);
    }

    public boolean m_8036_() {
        return this.isTargetValid() && this.canUseGun();
    }

    public boolean isTargetValid() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public boolean canUseGun() {
        return GunItem.isHoldingGun(this.mob) && GunItem.canUse(this.mob);
    }

    public boolean isReady() {
        InteractionHand hand = GunItem.getHoldingHand(this.mob);
        if (hand == null) {
            return false;
        }
        ItemStack stack = this.mob.m_21120_(hand);
        return GunItem.isReady((ItemStack)stack);
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    public void onReady() {
    }

    public void reload() {
        InteractionHand hand = GunItem.getHoldingHand(this.mob);
        if (hand != null) {
            ItemStack stack = this.mob.m_21120_(hand);
            if (!this.isLoading && !GunItem.isLoaded((ItemStack)stack)) {
                GunItem.setLoadingStage((ItemStack)stack, (int)1);
                this.mob.m_6672_(hand);
                this.isLoading = true;
            }
        }
    }

    public void fire(float spread) {
        InteractionHand hand = GunItem.getHoldingHand(this.mob);
        if (hand != null) {
            ItemStack stack = this.mob.m_21120_(hand);
            GunItem gun = (GunItem)stack.m_41720_();
            Vec3 direction = gun.aimAt(this.mob, this.mob.m_5448_());
            if (spread > 0.0f) {
                direction = GunItem.addUniformSpread((Vec3)direction, (RandomSource)this.mob.m_217043_(), (float)spread);
            }
            gun.mobUse(this.mob, hand, direction);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.isLoading) {
            if (this.mob.m_6117_()) {
                if (GunItem.isLoaded((ItemStack)this.mob.m_21211_())) {
                    this.mob.m_21253_();
                    this.isLoading = false;
                    this.onReady();
                }
            } else {
                this.isLoading = false;
            }
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.isLoading = false;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
        }
    }
}

