/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.config;

import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.CollectType;
import dev.xkmc.l2library.serial.config.ConfigCollect;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.modulargolems.content.core.GolemStatType;
import dev.xkmc.modulargolems.content.modifier.base.AttributeGolemModifier;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.ModularGolems;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.http.util.Asserts;

@SerialClass
public class GolemMaterialConfig
extends BaseConfig {
    @ConfigCollect(value=CollectType.MAP_COLLECT)
    @SerialClass.SerialField
    public HashMap<ResourceLocation, HashMap<GolemStatType, Double>> stats = new HashMap();
    @ConfigCollect(value=CollectType.MAP_COLLECT)
    @SerialClass.SerialField
    public HashMap<ResourceLocation, HashMap<GolemModifier, Integer>> modifiers = new HashMap();
    @ConfigCollect(value=CollectType.MAP_OVERWRITE)
    @SerialClass.SerialField
    public HashMap<ResourceLocation, Ingredient> ingredients = new HashMap();
    @ConfigCollect(value=CollectType.MAP_OVERWRITE)
    @SerialClass.SerialField
    public HashMap<ResourceLocation, Ingredient> repairIngredients = new HashMap();

    public static GolemMaterialConfig get() {
        return (GolemMaterialConfig)ModularGolems.MATERIALS.getMerged();
    }

    public List<ResourceLocation> getAllMaterials() {
        TreeSet<ResourceLocation> set = new TreeSet<ResourceLocation>(this.stats.keySet());
        set.retainAll(this.modifiers.keySet());
        set.retainAll(this.ingredients.keySet());
        set.removeIf(e -> GolemMaterialConfig.isEmpty(this.ingredients.get(e)));
        ArrayList<ResourceLocation> ans = new ArrayList<ResourceLocation>(set);
        ans.sort(Comparator.comparing(rl -> rl.m_135827_().equals("modulargolems") ? 0 : 1).thenComparing(ResourceLocation::m_135827_).thenComparing(ResourceLocation::m_135815_));
        return ans;
    }

    public Ingredient getCraftIngredient(ResourceLocation id) {
        Ingredient ans = this.ingredients.get(id);
        return ans == null ? Ingredient.f_43901_ : ans;
    }

    public Ingredient getRepairIngredient(ResourceLocation id) {
        Ingredient rep = this.repairIngredients.get(id);
        if (rep != null) {
            return rep;
        }
        Ingredient ans = this.ingredients.get(id);
        return ans == null ? Ingredient.f_43901_ : ans;
    }

    private static boolean isEmpty(Ingredient ing) {
        ItemStack[] items = ing.m_43908_();
        return items.length == 0 || items[0].m_150930_(Items.f_42127_);
    }

    public Builder addMaterial(ResourceLocation id, Ingredient ingredient) {
        return new Builder(this, id, ingredient);
    }

    public Builder addMaterial(ResourceLocation id, Ingredient ingredient, Ingredient repair) {
        return new Builder(this, id, ingredient, repair);
    }

    public static class Builder {
        private final GolemMaterialConfig parent;
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Ingredient repairIngredient;
        private final HashMap<GolemStatType, Double> stats = new HashMap();
        private final HashMap<GolemModifier, Integer> modifiers = new HashMap();

        private Builder(GolemMaterialConfig parent, ResourceLocation id, Ingredient ingredient) {
            this.parent = parent;
            this.id = id;
            this.ingredient = ingredient;
            this.repairIngredient = ingredient;
        }

        private Builder(GolemMaterialConfig parent, ResourceLocation id, Ingredient ingredient, Ingredient repair) {
            this.parent = parent;
            this.id = id;
            this.ingredient = ingredient;
            this.repairIngredient = repair;
        }

        public Builder addStat(GolemStatType type, double val) {
            this.stats.put(type, val);
            return this;
        }

        public Builder addModifier(GolemModifier modifier, int lv) {
            Asserts.check((!(modifier instanceof AttributeGolemModifier) ? 1 : 0) != 0, (String)"Material cannot use attribute modifier");
            this.modifiers.put(modifier, lv);
            return this;
        }

        public GolemMaterialConfig end() {
            this.parent.stats.put(this.id, this.stats);
            this.parent.modifiers.put(this.id, this.modifiers);
            this.parent.ingredients.put(this.id, this.ingredient);
            this.parent.repairIngredients.put(this.id, this.repairIngredient);
            return this.parent;
        }
    }
}

