/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.common;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.PacketCodec;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.mob_weapon_api.api.ai.ItemWrapper;
import dev.xkmc.modulargolems.content.capability.GolemConfigEntry;
import dev.xkmc.modulargolems.content.capability.GolemConfigStorage;
import dev.xkmc.modulargolems.content.capability.GolemTracker;
import dev.xkmc.modulargolems.content.capability.PathConfig;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.entity.common.SyncedData;
import dev.xkmc.modulargolems.content.entity.goals.FollowOwnerGoal;
import dev.xkmc.modulargolems.content.entity.goals.Golem3DTargetGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemFloatGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemRandomStrollGoal;
import dev.xkmc.modulargolems.content.entity.goals.GolemSwimMoveControl;
import dev.xkmc.modulargolems.content.entity.goals.TeleportToOwnerGoal;
import dev.xkmc.modulargolems.content.entity.mode.GolemMode;
import dev.xkmc.modulargolems.content.entity.mode.GolemModes;
import dev.xkmc.modulargolems.content.item.card.DefaultFilterCard;
import dev.xkmc.modulargolems.content.item.card.PathRecordCard;
import dev.xkmc.modulargolems.content.item.equipments.GolemEquipmentItem;
import dev.xkmc.modulargolems.content.item.equipments.TickEquipmentItem;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.data.MGLangData;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

@SerialClass
public class AbstractGolemEntity<T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>>
extends AbstractGolem
implements IEntityAdditionalSpawnData,
NeutralMob,
OwnableEntity,
PowerableMob {
    private static final SyncedData GOLEM_DATA = new SyncedData(AbstractGolemEntity::defineId);
    @SerialClass.SerialField(toClient=true)
    private ArrayList<GolemMaterial> materials = new ArrayList();
    @SerialClass.SerialField(toClient=true)
    private ArrayList<Item> upgrades = new ArrayList();
    @SerialClass.SerialField(toClient=true)
    @Nullable
    private UUID owner;
    @SerialClass.SerialField(toClient=true)
    private HashMap<GolemModifier, Integer> modifiers = new LinkedHashMap<GolemModifier, Integer>();
    @SerialClass.SerialField(toClient=true)
    private final HashSet<GolemFlags> golemFlags = new HashSet();
    @SerialClass.SerialField
    private Vec3 recordedPosition = Vec3.f_82478_;
    @SerialClass.SerialField
    private BlockPos recordedGuardPos = BlockPos.f_121853_;
    public int inventoryTick = 0;
    public int specialAttackCoolDown = 0;
    protected final PathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;
    public final Set<MobEffect> effectImmunity = new HashSet<MobEffect>();
    private static final EntityDataAccessor<Integer> DATA_MODE = GOLEM_DATA.define(SyncedData.INT, 0, "follow_mode");
    private static final EntityDataAccessor<BlockPos> GUARD_POS = GOLEM_DATA.define(SyncedData.BLOCK_POS, BlockPos.f_121853_, "guard_pos");
    private static final EntityDataAccessor<Optional<UUID>> CONFIG_ID = GOLEM_DATA.define(SyncedData.UUID, Optional.empty(), "config_owner");
    private static final EntityDataAccessor<Integer> CONFIG_COLOR = GOLEM_DATA.define(SyncedData.INT, 0, "config_color");
    private static final EntityDataAccessor<Integer> PATROL_STAGE = GOLEM_DATA.define(SyncedData.INT, 0, "patrol_stage");
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = GOLEM_DATA.define(SyncedData.INT, 0, null);
    @Nullable
    private UUID persistentAngerTarget;
    private static final EntityDataAccessor<Boolean> IS_IN_RANGE_ATTACK = SynchedEntityData.m_135353_(AbstractGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    private static <T> EntityDataAccessor<T> defineId(EntityDataSerializer<T> ser) {
        return SynchedEntityData.m_135353_(AbstractGolemEntity.class, ser);
    }

    protected AbstractGolemEntity(EntityType<T> type, Level level) {
        super(type, level);
        this.waterNavigation = new AmphibiousPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
    }

    public void onCreate(ArrayList<GolemMaterial> materials, ArrayList<UpgradeItem> upgrades, @Nullable UUID owner) {
        this.updateAttributes(materials, upgrades, owner);
        this.m_21153_(this.m_21233_());
    }

    public void updateAttributes(ArrayList<GolemMaterial> materials, ArrayList<UpgradeItem> upgrades, @Nullable UUID owner) {
        this.materials = materials;
        this.upgrades = (ArrayList)Wrappers.cast(upgrades);
        this.owner = owner;
        this.modifiers = GolemMaterial.collectModifiers(materials, upgrades);
        this.golemFlags.clear();
        this.m_274367_(1.0f);
        this.getModifiers().forEach((m, i) -> m.onRegisterFlag(this.golemFlags::add));
        if (this.canSwim()) {
            this.f_21342_ = new GolemSwimMoveControl(this);
            this.f_21344_ = this.waterNavigation;
            this.m_21441_(BlockPathTypes.WATER, 0.0f);
            this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        }
        if (!this.m_9236_().m_5776_()) {
            this.getModifiers().forEach((m, i) -> m.onRegisterGoals(this, (int)i, (arg_0, arg_1) -> ((GoalSelector)this.f_21345_).m_25352_(arg_0, arg_1)));
        }
        GolemMaterial.addAttributes(materials, upgrades, this.getThis());
        this.m_6210_();
    }

    public EntityType<T> m_6095_() {
        return (EntityType)Wrappers.cast((Object)super.m_6095_());
    }

    public ArrayList<GolemMaterial> getMaterials() {
        return this.materials;
    }

    public ArrayList<Item> getUpgrades() {
        return this.upgrades;
    }

    public HashMap<GolemModifier, Integer> getModifiers() {
        return this.modifiers;
    }

    public boolean hasFlag(GolemFlags flag) {
        return this.golemFlags.contains((Object)flag);
    }

    protected final InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_21120_(hand).m_204117_(MGTagGen.GOLEM_INTERACT)) {
            return InteractionResult.PASS;
        }
        for (Map.Entry<GolemModifier, Integer> ent : this.modifiers.entrySet()) {
            InteractionResult result = ent.getKey().interact(player, this, hand, ent.getValue());
            if (result == InteractionResult.PASS) continue;
            return result;
        }
        return this.mobInteractImpl(player, hand);
    }

    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        GolemEquipmentItem item;
        if (!((Boolean)MGConfig.COMMON.barehandRetrieve.get()).booleanValue() || !this.canModify(player)) {
            return InteractionResult.FAIL;
        }
        if (player.m_21205_().m_41619_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_19877_();
                player.m_8061_(EquipmentSlot.MAINHAND, this.toItem(player));
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        Item item2 = stack.m_41720_();
        if (item2 instanceof GolemEquipmentItem && (item = (GolemEquipmentItem)item2).isFor(this.m_6095_()) && this.m_6844_(item.getSlot()).m_41619_()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_8061_(item.getSlot(), stack.m_41620_(1));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void untrack(GolemTracker.Status type, @Nullable Entity cause) {
        UUID id = this.m_21805_();
        if (id == null || id.equals(Util.f_137441_)) {
            return;
        }
        if (this.getOwner() instanceof FakePlayer) {
            return;
        }
        GolemTracker tracker = GolemConfigStorage.get(this.m_9236_()).getTracker(id);
        tracker.untrack(this, type, cause);
    }

    public ItemStack toItem(Player player) {
        this.recordedPosition = this.m_20182_();
        this.recordedGuardPos = this.getGuardPos();
        this.untrack(player == this.getOwner() ? GolemTracker.Status.RETRIEVED : GolemTracker.Status.OTHER_RETRIEVED, (Entity)player);
        ItemStack ans = GolemHolder.setEntity(this.getThis());
        this.m_9236_().m_7605_((Entity)this, (byte)60);
        this.m_146870_();
        return ans;
    }

    public boolean m_5825_() {
        return this.hasFlag(GolemFlags.FIRE_IMMUNE);
    }

    protected void m_6475_(DamageSource source, float damage) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            damage *= 1000.0f;
        }
        super.m_6475_(source, damage);
        if (this.m_21223_() <= 0.0f && this.hasFlag(GolemFlags.RECYCLE)) {
            Player player = this.getOwner();
            this.m_19877_();
            this.untrack(GolemTracker.Status.DEATH_RECYCLE, source.m_7639_());
            ItemStack stack = GolemHolder.setEntity(this.getThis());
            if (player != null && player.m_6084_()) {
                player.m_150109_().m_150079_(stack);
            } else {
                this.m_19983_(stack);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_146870_();
        }
    }

    protected void m_7472_(DamageSource source, int i, boolean b) {
        HashMap<Item, Integer> drop = new HashMap<Item, Integer>();
        for (GolemMaterial mat : this.getMaterials()) {
            Item item = GolemMaterialConfig.get().getCraftIngredient(mat.id()).m_43908_()[0].m_41720_();
            drop.compute(item, (e, old) -> (old == null ? 0 : old) + 1);
        }
        drop.forEach((k, v) -> this.m_19983_(new ItemStack((ItemLike)k, v.intValue())));
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.dropSlot(slot, true);
        }
    }

    protected void dropSlot(EquipmentSlot slot, boolean isDeath) {
        ItemStack itemstack = this.m_6844_(slot);
        if (itemstack.m_41619_()) {
            return;
        }
        if (!isDeath && EnchantmentHelper.m_44920_((ItemStack)itemstack)) {
            return;
        }
        if (isDeath && EnchantmentHelper.m_44924_((ItemStack)itemstack)) {
            return;
        }
        this.m_19983_(itemstack);
        this.m_8061_(slot, ItemStack.f_41583_);
    }

    public float m_6134_() {
        if (this.materials == null || this.materials.isEmpty() || this.m_19880_().contains("ClientOnly")) {
            return 1.0f;
        }
        return (float)(this.m_21133_((Attribute)GolemTypes.GOLEM_SIZE.get()) / DefaultAttributes.m_22297_(this.m_6095_()).m_22245_((Attribute)GolemTypes.GOLEM_SIZE.get()));
    }

    public boolean canSwim() {
        return this.hasFlag(GolemFlags.SWIM);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (!this.getMode().isMovable()) {
            pTravelVector = Vec3.f_82478_;
        }
        if ((this.m_6109_() || this.m_21515_()) && this.m_20069_() && this.canSwim()) {
            this.m_19920_(0.08f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_6109_()) {
                super.m_7023_(pTravelVector);
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            this.m_20282_(this.m_21515_() && this.m_20069_() && this.canSwim());
        }
    }

    public boolean m_6094_() {
        return this.getMode().isMovable();
    }

    public boolean m_6063_() {
        return !this.m_6069_() && this.getMode().isMovable();
    }

    @Nullable
    public UUID m_21805_() {
        return this.owner;
    }

    @Nullable
    public Player getOwner() {
        try {
            UUID uuid = this.m_21805_();
            return uuid == null ? null : this.m_9236_().m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_21678_(tag);
        tag.m_128365_("auto-serial", (Tag)Objects.requireNonNull(TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)((Object)this))));
        GOLEM_DATA.write(tag, this.f_19804_);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_147285_(this.m_9236_(), tag);
        if (tag.m_128441_("auto-serial")) {
            Wrappers.run(() -> TagCodec.fromTag((CompoundTag)tag.m_128469_("auto-serial"), ((Object)((Object)this)).getClass(), (Object)((Object)this), f -> true));
        }
        this.updateAttributes(this.materials, (ArrayList)Wrappers.cast(this.getUpgrades()), this.owner);
        GOLEM_DATA.read(tag, this.f_19804_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        PacketCodec.to((FriendlyByteBuf)buffer, (Object)((Object)this));
    }

    public void readSpawnData(FriendlyByteBuf data) {
        PacketCodec.from((FriendlyByteBuf)data, (Class)((Class)Wrappers.cast(((Object)((Object)this)).getClass())), this.getThis());
        this.updateAttributes(this.materials, (ArrayList)Wrappers.cast(this.upgrades), this.owner);
    }

    public T getThis() {
        return (T)((Object)((AbstractGolemEntity)((Object)Wrappers.cast((Object)((Object)this)))));
    }

    public boolean m_142582_(Entity target) {
        if (target.m_9236_() == this.m_9236_() && this.hasFlag(GolemFlags.SEE_THROUGH)) {
            Vec3 self = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
            Vec3 tarp = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
            double dist = tarp.m_82554_(self);
            if (dist <= 128.0) {
                if (target.m_9236_().m_45527_(target.m_20183_())) {
                    return true;
                }
                if (dist < 5.0) {
                    return true;
                }
                if (self.m_7098_() < tarp.m_7098_()) {
                    return true;
                }
            }
        }
        return super.m_142582_(target);
    }

    public boolean m_142079_() {
        return !this.hasFlag(GolemFlags.FREEZE_IMMUNE);
    }

    public boolean m_142066_() {
        return !this.hasFlag(GolemFlags.PASSIVE) && super.m_142066_();
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target != null && !this.m_6779_(target)) {
            return;
        }
        super.m_6710_(target);
        if (target instanceof Mob) {
            Mob mob = (Mob)target;
            if (mob.m_5448_() == null && mob.m_6779_((LivingEntity)this)) {
                mob.m_6710_((LivingEntity)this);
            }
            for (Map.Entry<GolemModifier, Integer> entry : this.getModifiers().entrySet()) {
                entry.getKey().onSetTarget(this, mob, entry.getValue());
            }
        }
    }

    public boolean m_6549_(EntityType<?> type) {
        return !this.hasFlag(GolemFlags.PASSIVE);
    }

    public boolean m_6779_(LivingEntity target) {
        GolemConfigEntry config;
        if (target == this.getOwner()) {
            return false;
        }
        if (target instanceof OwnableEntity) {
            OwnableEntity own = (OwnableEntity)target;
            if (this.getOwner() == own.m_269323_()) {
                return false;
            }
        }
        if ((config = this.getConfigEntry(null)) == null ? target.m_6095_().m_204039_(MGTagGen.GOLEM_FRIENDLY) : config.targetFilter.friendlyToward(target)) {
            return false;
        }
        return !this.m_7307_((Entity)target) && this.m_6549_(target.m_6095_()) && super.m_6779_(target);
    }

    protected float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.inventoryTick > 0) {
            --this.inventoryTick;
        }
        if (this.specialAttackCoolDown > 0) {
            --this.specialAttackCoolDown;
        }
        if (this.m_9236_().f_46443_) {
            for (Map.Entry entry : this.getModifiers().entrySet()) {
                ((GolemModifier)((Object)entry.getKey())).onClientTick(this, (Integer)entry.getValue());
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = this.m_6844_(slot);
            Item item = stack.m_41720_();
            if (!(item instanceof TickEquipmentItem)) continue;
            TickEquipmentItem tickItem = (TickEquipmentItem)item;
            tickItem.tick(stack, this.m_9236_(), (Entity)this);
        }
        UUID id = this.m_21805_();
        if (this.getOwner() instanceof FakePlayer) {
            return;
        }
        if (id == null || id.equals(Util.f_137441_)) {
            return;
        }
        GolemTracker golemTracker = GolemConfigStorage.get(this.m_9236_()).getTracker(id);
        golemTracker.track(this);
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ % 20 == 0) {
                double heal = this.m_21133_((Attribute)GolemTypes.GOLEM_REGEN.get());
                for (Map.Entry<GolemModifier, Integer> entry : this.getModifiers().entrySet()) {
                    heal = entry.getKey().onHealTick(heal, this, entry.getValue());
                }
                if (heal > 0.0) {
                    this.m_5634_((float)heal);
                }
            }
            for (Map.Entry entry : this.getModifiers().entrySet()) {
                ((GolemModifier)((Object)entry.getKey())).onAiStep(this, (Integer)entry.getValue());
            }
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = this.m_6844_(slot);
            if (stack.m_41619_()) continue;
            stack.m_41666_(this.m_9236_(), (Entity)this, slot.ordinal(), slot == EquipmentSlot.MAINHAND);
        }
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_214076_(ServerLevel level, LivingEntity target) {
        Player player = this.getOwner();
        if (player != null) {
            GolemTriggers.KILL.trigger((ServerPlayer)player, (Entity)target);
        }
        return super.m_214076_(level, target);
    }

    public void m_7822_(byte event) {
        for (Map.Entry<GolemModifier, Integer> e : this.modifiers.entrySet()) {
            e.getKey().handleEvent(this, e.getValue(), event);
        }
        super.m_7822_(event);
    }

    public GolemMode getMode() {
        return GolemModes.get((Integer)this.f_19804_.m_135370_(DATA_MODE));
    }

    public BlockPos getGuardPos() {
        return (BlockPos)this.f_19804_.m_135370_(GUARD_POS);
    }

    public void setMode(int mode, BlockPos pos) {
        this.f_19804_.m_135381_(DATA_MODE, (Object)mode);
        this.f_19804_.m_135381_(GUARD_POS, (Object)pos);
    }

    public boolean initMode(@Nullable Player player) {
        boolean succeed;
        GolemConfigEntry config = this.getConfigEntry(null);
        int mode = config == null ? 0 : config.defaultMode;
        boolean far = config != null && config.summonToPosition && mode != 0 && this.recordedPosition.m_82556_() > 0.0;
        BlockPos guard = far && !this.recordedGuardPos.equals((Object)BlockPos.f_121853_) ? this.recordedGuardPos : this.m_20183_();
        Vec3 pos = far ? this.recordedPosition : this.m_20182_();
        boolean bl = succeed = this.m_9236_().m_46749_(BlockPos.m_274446_((Position)pos)) && pos.m_82554_(this.m_20182_()) < (double)((Integer)MGConfig.COMMON.summonDistance.get()).intValue();
        if (!succeed) {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_213846_((Component)MGLangData.SUMMON_FAILED.get(this.m_5446_()));
            }
            return false;
        }
        if (far && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.m_213846_((Component)MGLangData.SUMMON_FAR.get(this.m_5446_(), (int)pos.m_7096_(), (int)pos.m_7098_(), (int)pos.m_7094_()));
        }
        this.setMode(mode, mode == 0 ? BlockPos.f_121853_ : guard);
        this.m_20219_(pos);
        this.m_6710_(null);
        this.m_6925_(null);
        return true;
    }

    public boolean m_6072_() {
        return this.getMode().canChangeDimensions() && super.m_6072_();
    }

    @Nullable
    public GolemConfigEntry getConfigEntry(@Nullable Component dummy) {
        UUID configOwner = ((Optional)this.f_19804_.m_135370_(CONFIG_ID)).orElse(null);
        int configColor = (Integer)this.f_19804_.m_135370_(CONFIG_COLOR);
        if (configColor < 0 || configOwner == null) {
            return null;
        }
        GolemConfigStorage storage = GolemConfigStorage.get(this.m_9236_());
        if (dummy == null) {
            return storage.getStorage(configOwner, configColor);
        }
        return storage.getOrCreateStorage(configOwner, configColor, dummy);
    }

    public void setConfigCard(@Nullable UUID owner, int color) {
        this.f_19804_.m_135381_(CONFIG_ID, Optional.ofNullable(owner));
        this.f_19804_.m_135381_(CONFIG_COLOR, (Object)color);
    }

    public void setPatrolStage(int stage) {
        this.f_19804_.m_135381_(PATROL_STAGE, (Object)stage);
    }

    public int getPatrolStage() {
        return (Integer)this.f_19804_.m_135370_(PATROL_STAGE);
    }

    public void advancePatrolStage() {
        List<PathRecordCard.Pos> list = PathConfig.getPath(this);
        if (list == null) {
            return;
        }
        int stage = this.getPatrolStage();
        if (++stage >= list.size()) {
            stage = 0;
        }
        this.setPatrolStage(stage);
    }

    public List<PathRecordCard.Pos> getPatrolList() {
        List<PathRecordCard.Pos> list = PathConfig.getPath(this);
        if (list == null) {
            return List.of();
        }
        int stage = this.getPatrolStage();
        if (stage > 0 && stage < list.size()) {
            List<PathRecordCard.Pos> first = list.subList(stage, list.size());
            List<PathRecordCard.Pos> second = list.subList(0, stage);
            ArrayList<PathRecordCard.Pos> ans = new ArrayList<PathRecordCard.Pos>(first);
            ans.addAll(second);
            return ans;
        }
        return list;
    }

    protected void m_8097_() {
        super.m_8097_();
        GOLEM_DATA.register(this.f_19804_);
        this.f_19804_.m_135372_(IS_IN_RANGE_ATTACK, (Object)false);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6925_(@Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public Team m_5647_() {
        Player owner = this.getOwner();
        if (owner != null) {
            return owner.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean canModify(Player player) {
        GolemConfigEntry entry = this.getConfigEntry(null);
        if (entry != null && entry.locked) {
            return false;
        }
        Player owner = this.getOwner();
        if (player == owner) {
            return true;
        }
        if (player.m_150110_().f_35937_ || this.m_21805_() == null && !this.predicateSecondaryTarget((LivingEntity)player)) {
            return true;
        }
        if (((Boolean)MGConfig.COMMON.ownerPickupOnly.get()).booleanValue()) {
            return false;
        }
        return this.m_7307_((Entity)player);
    }

    public boolean m_7307_(Entity other) {
        if (other == this) {
            return true;
        }
        Player owner = this.getOwner();
        if (other == owner) {
            return true;
        }
        if (owner != null) {
            return owner.m_7307_(other) || other.m_7307_((Entity)owner);
        }
        return super.m_7307_(other);
    }

    protected void m_7324_(Entity entity) {
        if (entity instanceof Enemy && !(entity instanceof Creeper)) {
            this.m_6710_((LivingEntity)entity);
        }
        super.m_7324_(entity);
    }

    public boolean m_7327_(Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            le.m_6598_(this.getOwner());
        }
        return super.m_7327_(target);
    }

    public int aiHurtTarget(Entity target) {
        boolean ans = this.m_7327_(target);
        return ans ? -1 : 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new GolemFloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TeleportToOwnerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new GolemRandomStrollGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, this::predicatePriorityTarget));
        this.f_21346_.m_25352_(3, new Golem3DTargetGoal<Mob>((Mob)this, Mob.class, 5, true, false, this::predicatePriorityTarget));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 5, false, false, this::predicateSecondaryTarget));
        this.f_21346_.m_25352_(5, new Golem3DTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 5, true, false, this::predicateSecondaryTarget));
        this.f_21346_.m_25352_(6, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected boolean predicatePriorityTarget(LivingEntity e) {
        if (e instanceof Mob) {
            Mob mob = (Mob)e;
            for (Optional<LivingEntity> target : List.of(Optional.ofNullable(mob.m_21214_()), Optional.ofNullable(mob.m_5448_()), Optional.ofNullable(mob.m_21188_()))) {
                if (!target.isPresent()) continue;
                Player owner = this.getOwner();
                if (target.get() == owner) {
                    return true;
                }
                if (!target.get().m_7307_((Entity)this)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean predicateSecondaryTarget(LivingEntity e) {
        GolemConfigEntry config = this.getConfigEntry(null);
        if (config == null) {
            return DefaultFilterCard.defaultPredicate(e);
        }
        return config.targetFilter.aggressiveToward(e);
    }

    public boolean isInSittingPose() {
        return false;
    }

    @Nullable
    public LivingEntity getFollowTarget() {
        if (this.getMode() == GolemModes.SQUAD) {
            return this.getCaptain();
        }
        return this.getOwner();
    }

    @Nullable
    public LivingEntity getCaptain() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            GolemConfigEntry config = this.getConfigEntry(null);
            if (config == null) {
                return null;
            }
            UUID uuid = config.squadConfig.getCaptainId();
            if (uuid == null) {
                return null;
            }
            Entity captain = sl.m_8791_(uuid);
            if (captain == null) {
                return null;
            }
            if (!captain.m_6084_() || captain.m_9236_() != sl) {
                return null;
            }
            if (captain instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)captain;
                return le;
            }
            return null;
        }
        return null;
    }

    public Vec3 getTargetPos() {
        if (this.getMode() == GolemModes.ROUTE) {
            List<PathRecordCard.Pos> list = PathConfig.getPath(this);
            if (list != null) {
                int target = this.getPatrolStage();
                if (!list.isEmpty()) {
                    return list.get(Math.min(target, list.size() - 1)).pos().m_252807_();
                }
            }
            return this.m_20182_();
        }
        if (this.getMode().hasPos()) {
            BlockPos pos = this.getGuardPos();
            return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        }
        LivingEntity owner = this.getFollowTarget();
        if (owner == null) {
            return this.m_20318_(1.0f);
        }
        return owner.m_20318_(1.0f);
    }

    public boolean m_7090_() {
        return true;
    }

    public boolean m_20147_() {
        return this.hasFlag(GolemFlags.IMMUNITY);
    }

    public void m_6667_(DamageSource source) {
        this.untrack(GolemTracker.Status.DEATH, source.m_7639_());
        ModularGolems.LOGGER.info("Golem {} died, message: '{}'", (Object)this, (Object)source.m_6157_((LivingEntity)this).getString());
        Player owner = this.getOwner();
        if (owner != null && !this.m_9236_().f_46443_) {
            owner.m_213846_(source.m_6157_((LivingEntity)this));
        }
        super.m_6667_(source);
    }

    public double m_262793_(LivingEntity target) {
        return GolemMeleeGoal.calculateDistSqr(this, target);
    }

    public void checkRide(LivingEntity target) {
    }

    public void resetTarget(@Nullable LivingEntity le) {
        for (WrappedGoal e : this.f_21346_.m_148105_()) {
            Goal goal = e.m_26015_();
            if (!(goal instanceof TargetGoal)) continue;
            TargetGoal t = (TargetGoal)goal;
            t.m_8041_();
        }
        if (le != null) {
            this.m_6703_(le);
        }
    }

    public ItemWrapper getWrapperOfHand(EquipmentSlot slot) {
        return ItemWrapper.simple(() -> this.m_6844_(slot), e -> super.m_8061_(slot, e));
    }

    @Nullable
    public Entity changeDimension(ServerLevel level, ITeleporter teleporter) {
        if (!((Boolean)MGConfig.COMMON.allowDimensionChange.get()).booleanValue()) {
            return null;
        }
        return super.changeDimension(level, teleporter);
    }

    public boolean isInRangedMode() {
        return this.getMode() == GolemModes.STAND || (Boolean)this.m_20088_().m_135370_(IS_IN_RANGE_ATTACK) != false;
    }

    public void setInRangeAttack(boolean flag) {
        this.m_20088_().m_135381_(IS_IN_RANGE_ATTACK, (Object)flag);
    }

    public boolean canSweep() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance ins) {
        if (this.effectImmunity.contains(ins.m_19544_())) {
            return false;
        }
        return super.m_7301_(ins);
    }

    public void m_7601_(BlockState state, Vec3 vec) {
        if (this.hasFlag(GolemFlags.FREE_MOVE)) {
            return;
        }
        super.m_7601_(state, vec);
    }
}

