/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.common;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.modulargolems.compat.curio.CurioCompatRegistry;
import dev.xkmc.modulargolems.content.client.override.ModelOverride;
import dev.xkmc.modulargolems.content.client.override.ModelOverrides;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemDefaultLayer;
import dev.xkmc.modulargolems.content.entity.common.IGolemModel;
import dev.xkmc.modulargolems.content.item.golem.GolemFacade;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractGolemRenderer<T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>, M extends EntityModel<T>>
extends MobRenderer<T, M> {
    public static final List<Function<AbstractGolemRenderer<?, ?, ?>, RenderLayer<? extends AbstractGolemEntity<?, ?>, ?>>> LIST = new ArrayList();
    private static final ResourceLocation GOLEM_LOCATION = new ResourceLocation("textures/entity/iron_golem/iron_golem.png");
    private final Supplier<P[]> list;

    public AbstractGolemRenderer(EntityRendererProvider.Context ctx, M model, float f, Supplier<P[]> list) {
        super(ctx, model, f);
        this.list = list;
        this.m_115326_(new GolemDefaultLayer(this));
        LIST.forEach(e -> this.m_115326_((RenderLayer)Wrappers.cast((Object)((RenderLayer)e.apply(this)))));
    }

    protected void scale(T entity, PoseStack pose, float f) {
        float r = ((AbstractGolemEntity)((Object)entity)).m_6134_();
        pose.m_85841_(r, r, r);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return GOLEM_LOCATION;
    }

    protected boolean delegated(T entity) {
        return false;
    }

    public void render(T entity, float f1, float f2, PoseStack stack, MultiBufferSource source, int i) {
        super.m_7392_(entity, f1, f2, stack, source, i);
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean b1, boolean b2, boolean b3) {
        if (this.delegated(entity)) {
            return super.m_7225_(entity, b1, b2, b3);
        }
        return null;
    }

    protected void renderAllParts(PoseStack pose, MultiBufferSource buffer, int light, T entity, float pTick) {
        Optional<ItemStack> opt;
        if (this.delegated(entity)) {
            return;
        }
        LocalPlayer player = Proxy.getClientPlayer();
        boolean visible = this.m_5933_((LivingEntity)entity);
        boolean ghost = !visible && player != null && !entity.m_20177_((Player)player);
        boolean glowing = Minecraft.m_91087_().m_91314_(entity);
        pose.m_85836_();
        ResourceLocation facade = null;
        if (ModList.get().isLoaded("curios") && (opt = CurioCompatRegistry.getItem(entity, "golem_skin")).isPresent() && opt.get().m_41720_() instanceof GolemFacade) {
            facade = GolemFacade.getMaterial(opt.get());
        }
        ArrayList<GolemMaterial> materials = ((AbstractGolemEntity)((Object)entity)).getMaterials();
        for (IGolemPart part : (IGolemPart[])this.list.get()) {
            ResourceLocation rl = facade;
            if (rl == null) {
                int index = part.ordinal();
                rl = materials.size() > index ? materials.get(index).id() : GolemMaterial.EMPTY;
            }
            ModelOverride override = ModelOverrides.getOverride(rl);
            override.renderAll(this, entity, part, pose, buffer, rl, light, pTick, visible, ghost, glowing);
        }
        pose.m_85849_();
    }

    public void renderPartModel(T entity, P part, PoseStack pose, VertexConsumer vc, int light, float pTick, boolean ghost) {
        int overlay = AbstractGolemRenderer.m_115338_(entity, (float)this.m_6931_((LivingEntity)entity, pTick));
        ((IGolemModel)this.f_115290_).renderToBufferInternal(part, pose, vc, light, overlay, 1.0f, 1.0f, 1.0f, ghost ? 0.15f : 1.0f);
    }
}

