/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.common;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.mob_weapon_api.api.ai.ISmartUser;
import dev.xkmc.mob_weapon_api.api.ai.IWeaponHolder;
import dev.xkmc.mob_weapon_api.api.ai.ItemWrapper;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemUser;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemWeaponManager;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemWeaponRegistry;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

@SerialClass
public abstract class SweepGolemEntity<T extends SweepGolemEntity<T, P>, P extends IGolemPart<P>>
extends AbstractGolemEntity<T, P>
implements RangedAttackMob,
IWeaponHolder {
    private final GolemWeaponManager<T> weaponManager;
    private boolean doReassessGoal = false;

    protected SweepGolemEntity(GolemWeaponRegistry<T> reg, EntityType<T> type, Level level) {
        super(type, level);
        this.weaponManager = new GolemWeaponManager<SweepGolemEntity>(reg, (SweepGolemEntity)((Object)this.getThis()));
        if (!this.m_9236_().f_46443_) {
            this.weaponManager.reassessWeaponGoal();
        }
    }

    protected boolean performRangedDamage(Entity target, float damage, double kb) {
        boolean flag = this.performDamageTarget(target, damage, kb);
        double range = this.m_21133_((Attribute)GolemTypes.GOLEM_SWEEP.get());
        if (range > 0.0 && this.canSweep()) {
            List list = this.m_9236_().m_6249_(target, this.getAttackBoundingBox(target, range), e -> {
                if (!(e instanceof LivingEntity)) return false;
                LivingEntity le = (LivingEntity)e;
                if (!(e instanceof Enemy)) return false;
                if (e instanceof Creeper) return false;
                if (!this.m_6779_(le)) return false;
                return true;
            });
            for (Entity t : list) {
                flag |= this.performDamageTarget(t, damage, kb);
            }
        }
        return flag;
    }

    protected AABB getAttackBoundingBox(Entity target, double range) {
        return target.m_20191_().m_82400_(range);
    }

    protected abstract boolean performDamageTarget(Entity var1, float var2, double var3);

    @Override
    public boolean canSweep() {
        return this.m_21133_((Attribute)GolemTypes.GOLEM_SWEEP.get()) > 0.0;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
        if (!this.m_9236_().f_46443_) {
            this.doReassessGoal = true;
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.weaponManager.reassessWeaponGoal();
    }

    public boolean m_5886_(ProjectileWeaponItem pProjectileWeapon) {
        return true;
    }

    public InteractionHand getWeaponHand() {
        return InteractionHand.MAIN_HAND;
    }

    public void m_6504_(LivingEntity target, float power) {
        this.weaponManager.performRangedAttack(target, power);
    }

    public ISmartUser toUser() {
        return new GolemUser((LivingEntity)this, this.m_5448_());
    }

    public void switchWeapon(ItemWrapper mainhand, ItemWrapper offhand) {
        LivingEntity target = this.m_5448_();
        ItemStack main = mainhand.getItem();
        ItemStack off = offhand.getItem();
        if (this.weaponManager.checkSwitch(target, mainhand, offhand)) {
            mainhand.setItem(off);
            offhand.setItem(main);
            this.doReassessGoal = true;
            this.inventoryTick = 10;
        }
    }

    @Override
    public void m_8107_() {
        if (this.doReassessGoal || this.f_19797_ % 100 == 0) {
            this.weaponManager.reassessWeaponGoal();
            this.doReassessGoal = false;
        }
        super.m_8107_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.inventoryTick > 0) {
            return;
        }
        this.inventoryTick = 4;
        this.switchWeapon(this.getWrapperOfHand(EquipmentSlot.MAINHAND), this.getAltWeaponHand());
    }

    protected ItemWrapper getAltWeaponHand() {
        return this.getWrapperOfHand(EquipmentSlot.OFFHAND);
    }

    public void triggerReassess() {
        this.doReassessGoal = true;
    }
}

