/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.dog;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemPartType;
import dev.xkmc.modulargolems.content.entity.goals.GolemMeleeGoal;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.init.data.MGConfig;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class DogGolemEntity
extends AbstractGolemEntity<DogGolemEntity, DogGolemPartType> {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(DogGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public float getJumpStrength() {
        float ans = (float)this.m_21133_((Attribute)GolemTypes.GOLEM_JUMP.get());
        MobEffectInstance ins = this.m_21124_(MobEffects.f_19603_);
        if (ins != null) {
            int lv = ins.m_19564_() + 1;
            ans *= 1.0f + (float)lv * 0.625f;
        }
        return ans;
    }

    public DogGolemEntity(EntityType<DogGolemEntity> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    public float getTailAngle() {
        if (this.m_21660_()) {
            return 1.5393804f;
        }
        float percentage = 1.0f - this.m_21223_() / this.m_21233_();
        return (0.55f - percentage * 0.16f) * (float)Math.PI;
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        if (this.m_6109_() && (this.m_20096_() || this.m_20072_()) && player.f_20899_) {
            this.executeRidersJump(vec3);
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity rider) {
        return new Vec2(rider.m_146909_() * 0.5f, rider.m_146908_());
    }

    protected Vec3 m_274312_(Player player, Vec3 input) {
        float f = player.f_20900_ * 0.5f;
        float f1 = player.f_20902_;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        Vec3 ans = new Vec3((double)f, 0.0, (double)f1);
        if (player.m_6144_()) {
            ans = ans.m_82520_(0.0, -1.0, 0.0);
        }
        return ans;
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            Player pl = (Player)entity;
            return pl;
        }
        if (entity instanceof AbstractGolemEntity) {
            AbstractGolemEntity pl = (AbstractGolemEntity)entity;
            return pl;
        }
        return null;
    }

    protected float m_245547_(Player rider) {
        return (float)(this.m_21133_(Attributes.f_22279_) * (Double)MGConfig.COMMON.riddenSpeedFactor.get());
    }

    protected void executeRidersJump(Vec3 action) {
        Vec3 vec3 = this.m_20184_();
        float jump = this.getJumpStrength();
        this.m_20334_(vec3.f_82479_, jump, vec3.f_82481_);
        this.f_19812_ = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
        if (action.f_82481_ > 0.0) {
            float x0 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float z0 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * x0 * jump), 0.0, (double)(0.4f * z0 * jump)));
        }
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 1.4 - 0.35;
    }

    protected void m_19956_(Entity rider, Entity.MoveFunction setPos) {
        int index = this.m_20197_().indexOf(rider);
        int total = this.m_20197_().size();
        if (index < 0) {
            return;
        }
        float width = this.m_20205_();
        float offset = index == 0 ? (float)index + 0.7f : (float)index + (this.m_6688_() instanceof Player ? 1.7f : 1.2f);
        float pos = width / 2.0f - width / (float)total * offset;
        double dy = rider.m_6049_() + this.m_6048_();
        Vec3 vec3 = new Vec3(0.0, 0.0, (double)pos).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
        setPos.m_20372_(rider, this.m_20185_() + vec3.f_82479_, this.m_20186_() + dy, this.m_20189_() + vec3.f_82481_);
        if (index > 0) {
            this.clampRotation(rider);
        }
    }

    public void m_7340_(Entity rider) {
        if (this.m_6688_() != rider) {
            this.clampRotation(rider);
        }
    }

    private void clampRotation(Entity rider) {
        rider.m_5618_(this.m_146908_());
        float yr0 = rider.m_146908_();
        float dyr = Mth.m_14177_((float)(yr0 - this.m_146908_()));
        float yr1 = Mth.m_14036_((float)dyr, (float)-160.0f, (float)160.0f);
        rider.f_19859_ += yr1 - dyr;
        float yr2 = yr0 + yr1 - dyr;
        rider.m_146922_(yr2);
        rider.m_5616_(yr2);
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() <= this.getModifiers().getOrDefault(GolemModifiers.SIZE_UPGRADE.get(), 0);
    }

    protected void m_20348_(Entity rider) {
        this.setInSittingPose(false);
        super.m_20348_(rider);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
        p_21819_.m_128379_("Sitting", this.isInSittingPose());
    }

    @Override
    public void m_7378_(CompoundTag p_21815_) {
        super.m_7378_(p_21815_);
        this.setInSittingPose(p_21815_.m_128471_("Sitting"));
    }

    @Override
    public boolean isInSittingPose() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setInSittingPose(boolean sit) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        this.m_21573_().m_26573_();
        this.m_6710_(null);
        if (sit) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 1)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new GolemMeleeGoal(this));
        super.m_8099_();
    }

    @Override
    protected boolean predicatePriorityTarget(LivingEntity e) {
        return !this.isInSittingPose() && super.predicatePriorityTarget(e);
    }

    @Override
    protected boolean predicateSecondaryTarget(LivingEntity e) {
        return !this.isInSittingPose() && super.predicateSecondaryTarget(e);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_) {
            this.setInSittingPose(false);
        }
        return super.m_6469_(source, amount);
    }

    protected SoundEvent m_7975_(DamageSource p_28872_) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected void m_7355_(BlockPos p_28864_, BlockState p_28865_) {
        this.m_5496_(SoundEvents.f_12624_, 1.0f, 1.0f);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (((Boolean)MGConfig.COMMON.strictInteract.get()).booleanValue() && !itemstack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_6144_() && itemstack.m_41619_()) {
            return super.mobInteractImpl(player, hand);
        }
        if (!this.m_9236_().m_5776_() && this.canModify(player)) {
            this.setInSittingPose(!this.isInSittingPose());
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6710_(@Nullable LivingEntity target) {
        if (target != null && this.isInSittingPose()) {
            return;
        }
        super.m_6710_(target);
    }

    @Override
    public boolean isInRangedMode() {
        for (Entity e : this.m_20197_()) {
            if (!(e instanceof HumanoidGolemEntity)) continue;
            HumanoidGolemEntity h = (HumanoidGolemEntity)e;
            return h.isInRangedMode();
        }
        return super.isInRangedMode() || this.isInSittingPose();
    }
}

