/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.goals;

import dev.xkmc.mob_weapon_api.api.goals.IMeleeGoal;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.modifier.special.EarthquakeHelper;
import dev.xkmc.modulargolems.init.data.MGConfig;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class GolemMeleeGoal
extends MeleeAttackGoal
implements IMeleeGoal {
    private final AbstractGolemEntity<?, ?> golem;
    private double lastDist;
    private double timeNoMovement;
    private boolean earthQuake = false;

    private static double getDistance(double a0, double a1, double b0, double b1) {
        if (a1 < b0) {
            return b0 - a1;
        }
        if (b1 < a0) {
            return a0 - b1;
        }
        return 0.0;
    }

    public static double calculateDistSqr(AbstractGolemEntity<?, ?> golem, LivingEntity target) {
        AABB aabb0 = golem.m_20191_();
        AABB aabb1 = target.m_20191_();
        double x = GolemMeleeGoal.getDistance(aabb0.f_82288_, aabb0.f_82291_, aabb1.f_82288_, aabb1.f_82291_);
        double y = GolemMeleeGoal.getDistance(aabb0.f_82289_, aabb0.f_82292_, aabb1.f_82289_, aabb1.f_82292_);
        double z = GolemMeleeGoal.getDistance(aabb0.f_82290_, aabb0.f_82293_, aabb1.f_82290_, aabb1.f_82293_);
        return x * x + y * y + z * z;
    }

    public static int getTargetResetTime() {
        return (Integer)MGConfig.COMMON.targetResetTime.get();
    }

    public static double getTargetDistanceDelta() {
        return (Double)MGConfig.COMMON.targetResetNoMovementRange.get();
    }

    public GolemMeleeGoal(AbstractGolemEntity<?, ?> entity) {
        super(entity, 1.0, true);
        this.golem = entity;
    }

    public int m_183277_(int tick) {
        double speed = this.f_25540_.m_21133_(Attributes.f_22283_);
        return (int)Math.ceil((double)super.m_183277_(tick) / Math.min(1.0, speed));
    }

    public int getMeleeInterval() {
        return this.m_183277_(20);
    }

    public double m_6639_(LivingEntity pAttackTarget) {
        double val = this.f_25540_.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
        return val * val;
    }

    public boolean canReachTarget(LivingEntity le) {
        return this.m_6639_(le) >= this.f_25540_.m_262793_(le);
    }

    public void m_8037_() {
        if (this.m_25564_() && this.golem.m_5448_() != null) {
            this.timeNoMovement += 1.0;
        }
        super.m_8037_();
    }

    protected void m_6739_(LivingEntity target, double distSqr) {
        double dist;
        if (this.m_25564_() && (dist = Math.sqrt(distSqr)) < this.lastDist - GolemMeleeGoal.getTargetDistanceDelta()) {
            this.lastDist = dist;
            this.timeNoMovement = 0.0;
        }
        this.doRealAttack(target, distSqr);
        if (!this.m_25564_()) {
            this.lastDist = 1000.0;
            this.timeNoMovement = 0.0;
        } else if (this.timeNoMovement > (double)GolemMeleeGoal.getTargetResetTime()) {
            this.golem.resetTarget(null);
            this.lastDist = 1000.0;
            this.timeNoMovement = 0.0;
        }
    }

    protected void doRealAttack(LivingEntity target, double distSqr) {
        if (this.m_25564_() && this.golem.hasFlag(GolemFlags.EARTH_QUAKE) && !this.golem.m_20069_() && this.golem.m_20096_()) {
            if (this.earthQuake) {
                this.earthQuake = false;
                this.m_25563_();
                EarthquakeHelper.performEarthQuake(this.golem);
                return;
            }
            double d0 = this.m_6639_(target);
            if (d0 < distSqr && distSqr <= d0 + 5.0) {
                this.golem.m_246865_(new Vec3(0.0, 1.0, 0.0));
                this.golem.f_19812_ = true;
                this.earthQuake = true;
                return;
            }
        }
        if (this.earthQuake && !this.golem.m_20096_()) {
            return;
        }
        super.m_6739_(target, distSqr);
    }
}

