/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.humanoid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.entity.common.IGolemModel;
import dev.xkmc.modulargolems.content.entity.common.IHeadedModel;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemPartType;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemShooterHelper;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.common.ToolActions;

public class HumanoidGolemModel
extends PlayerModel<HumanoidGolemEntity>
implements IGolemModel<HumanoidGolemEntity, HumanoidGolemPartType, HumanoidGolemModel>,
IHeadedModel {
    public HumanoidGolemModel(EntityModelSet set) {
        this(set.m_171103_(ModelLayers.f_171162_), false);
    }

    public HumanoidGolemModel(ModelPart modelPart, boolean slim) {
        super(modelPart, slim);
    }

    @Override
    public void renderToBufferInternal(HumanoidGolemPartType type, PoseStack stack, VertexConsumer consumer, int i, int j, float f1, float f2, float f3, float f4) {
        if (type == HumanoidGolemPartType.BODY) {
            this.f_102810_.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.f_102808_.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.f_102809_.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
        } else if (type == HumanoidGolemPartType.ARMS) {
            this.f_102812_.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.f_102811_.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
        } else if (type == HumanoidGolemPartType.LEGS) {
            this.f_102814_.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
            this.f_102813_.m_104306_(stack, consumer, i, j, f1, f2, f3, f4);
        }
    }

    @Override
    public ResourceLocation getTextureLocationInternal(ResourceLocation rl) {
        String id = rl.m_135827_();
        String mat = rl.m_135815_();
        return new ResourceLocation(id, "textures/entity/humanoid_golem/" + mat + ".png");
    }

    public void setupAnim(HumanoidGolemEntity entity, float f1, float f2, float f3, float f4, float f5) {
        super.m_6973_((LivingEntity)entity, f1, f2, f3, f4, f5);
        if (entity.m_5912_() && this.f_102608_ == 0.0f) {
            if (this.f_102815_ == HumanoidModel.ArmPose.ITEM) {
                this.f_102812_.f_104203_ = -1.8f;
            } else if (this.f_102816_ == HumanoidModel.ArmPose.ITEM) {
                this.f_102811_.f_104203_ = -1.8f;
            }
        }
        this.f_103374_.m_104315_(this.f_102812_);
        this.f_103375_.m_104315_(this.f_102811_);
    }

    protected void setupAttackAnimation(HumanoidGolemEntity entity, float time) {
        if ((this.f_102815_ == HumanoidModel.ArmPose.ITEM || this.f_102816_ == HumanoidModel.ArmPose.ITEM) && this.f_102608_ > 0.0f) {
            AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (Mob)entity, (float)this.f_102608_, (float)time);
        } else {
            super.m_7884_((LivingEntity)entity, time);
        }
    }

    public void prepareMobModel(HumanoidGolemEntity entity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.f_102808_.f_233556_ = false;
        this.f_102816_ = HumanoidModel.ArmPose.EMPTY;
        this.f_102815_ = HumanoidModel.ArmPose.EMPTY;
        InteractionHand hand = entity.getWeaponHand();
        ItemStack itemstack = entity.m_21120_(hand);
        HumanoidModel.ArmPose pos = HumanoidModel.ArmPose.EMPTY;
        if (entity.m_5912_() && GolemShooterHelper.isValidThrowableWeapon((LivingEntity)entity, itemstack, hand) && entity.m_6117_()) {
            pos = HumanoidModel.ArmPose.THROW_SPEAR;
        } else if (entity.m_5912_() && itemstack.m_41780_() == UseAnim.BOW) {
            pos = HumanoidModel.ArmPose.BOW_AND_ARROW;
        } else if (itemstack.m_41780_() == UseAnim.CROSSBOW) {
            if (entity.isChargingCrossbow()) {
                pos = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            } else if (entity.m_5912_()) {
                pos = HumanoidModel.ArmPose.CROSSBOW_HOLD;
            }
        } else if (entity.m_5912_()) {
            pos = HumanoidModel.ArmPose.ITEM;
        }
        HumanoidModel.ArmPose anti_pos = HumanoidModel.ArmPose.EMPTY;
        if (hand == InteractionHand.OFF_HAND) {
            anti_pos = pos;
            pos = HumanoidModel.ArmPose.EMPTY;
        }
        if (entity.m_21254_()) {
            if (entity.m_21205_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
                pos = HumanoidModel.ArmPose.BLOCK;
            } else {
                anti_pos = HumanoidModel.ArmPose.BLOCK;
            }
        }
        if (entity.m_5737_() == HumanoidArm.RIGHT) {
            this.f_102816_ = pos;
            this.f_102815_ = anti_pos;
        } else {
            this.f_102815_ = pos;
            this.f_102816_ = anti_pos;
        }
        super.m_6839_((LivingEntity)entity, pLimbSwing, pLimbSwingAmount, pPartialTick);
    }

    @Override
    public void translateToHead(PoseStack pose) {
        pose.m_252880_(0.0f, -0.25f, 0.0f);
        pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        pose.m_85841_(0.625f, -0.625f, -0.625f);
    }
}

