/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.item.equipments;

import dev.xkmc.modulargolems.content.item.equipments.GolemEquipmentItem;
import dev.xkmc.modulargolems.content.item.equipments.GolemModelItem;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class MetalGolemArmorItem
extends GolemEquipmentItem
implements GolemModelItem {
    private final ResourceLocation model;

    public MetalGolemArmorItem(Item.Properties properties, ArmorItem.Type type, int defense, float toughness, ResourceLocation model) {
        super(properties, type.m_266308_(), () -> GolemTypes.ENTITY_GOLEM.get(), builder -> {
            UUID uuid = (UUID)UUID.get(type.m_266308_());
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)defense, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)toughness, AttributeModifier.Operation.ADDITION));
        });
        this.model = model;
    }

    @Override
    public ResourceLocation getModelTexture() {
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)this);
        assert (rl != null);
        return new ResourceLocation(rl.m_135827_(), "textures/equipments/" + rl.m_135815_() + ".png");
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 15;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentCategory.ARMOR) {
            return true;
        }
        if (enchantment.f_44672_ == EnchantmentCategory.ARMOR_HEAD && this.getSlot() == EquipmentSlot.HEAD) {
            return true;
        }
        if (enchantment.f_44672_ == EnchantmentCategory.ARMOR_CHEST && this.getSlot() == EquipmentSlot.CHEST) {
            return true;
        }
        if (enchantment.f_44672_ == EnchantmentCategory.ARMOR_LEGS && this.getSlot() == EquipmentSlot.LEGS) {
            return true;
        }
        if (enchantment.f_44672_ == EnchantmentCategory.ARMOR_FEET && this.getSlot() == EquipmentSlot.FEET) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @Override
    public ResourceLocation getModelPath() {
        return this.model;
    }
}

