/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.menu.equipment;

import dev.xkmc.l2library.base.menu.base.BaseContainerMenu;
import dev.xkmc.l2library.base.menu.base.PredSlot;
import dev.xkmc.l2library.base.menu.base.SpriteManager;
import dev.xkmc.l2library.util.Proxy;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.dog.DogGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.HumanoidGolemEntity;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemArmorItem;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemBeaconItem;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemWeaponItem;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.menu.equipment.EquipmentsContainer;
import dev.xkmc.modulargolems.events.event.GolemEquipEvent;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class EquipmentsMenu
extends BaseContainerMenu<EquipmentsMenu> {
    public static EquipmentSlot[] SLOTS = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public static final SpriteManager MANAGER = new SpriteManager("modulargolems", "equipments");
    public static final SpriteManager EXTRA = new SpriteManager("modulargolems", "equipments_extra");
    public final AbstractGolemEntity<?, ?> golem;

    public static EquipmentsMenu fromNetwork(MenuType<EquipmentsMenu> type, int wid, Inventory plInv, FriendlyByteBuf buf) {
        AbstractGolemEntity golem;
        assert (Proxy.getClientWorld() != null);
        Entity entity = Proxy.getClientWorld().m_6815_(buf.readInt());
        return new EquipmentsMenu(type, wid, plInv, entity instanceof AbstractGolemEntity ? (golem = (AbstractGolemEntity)entity) : null);
    }

    protected EquipmentsMenu(MenuType<?> type, int wid, Inventory plInv, @Nullable AbstractGolemEntity<?, ?> golem) {
        super(type, wid, plInv, golem instanceof HumanoidGolemEntity ? EXTRA : MANAGER, EquipmentsContainer::new, false);
        this.golem = golem;
        this.addSlot("hand", (i, e) -> this.isValid(SLOTS[i], (ItemStack)e));
        this.addSlot("armor", (i, e) -> this.isValid(SLOTS[i + 2], (ItemStack)e));
        if (golem instanceof HumanoidGolemEntity) {
            this.addSlot("backup", e -> this.isValid(EquipmentSlot.MAINHAND, (ItemStack)e) || this.isValid(EquipmentSlot.OFFHAND, (ItemStack)e));
            this.addSlot("arrow", ItemStack::m_41753_);
        }
    }

    private boolean isValid(EquipmentSlot slot, ItemStack stack) {
        if (this.golem instanceof HumanoidGolemEntity && (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND)) {
            return true;
        }
        EquipmentSlot valid = this.getSlotForItem(stack);
        if (this.golem instanceof MetalGolemEntity && valid == EquipmentSlot.MAINHAND) {
            return slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND;
        }
        return valid == slot;
    }

    public boolean m_6875_(Player player) {
        if (this.golem == null) {
            return false;
        }
        this.golem.inventoryTick = 5;
        return this.golem.m_6084_() && !this.golem.m_213877_();
    }

    public PredSlot getAsPredSlot(String name, int i, int j) {
        return super.getAsPredSlot(name, i, j);
    }

    public ItemStack m_7648_(Player pl, int id) {
        if (this.golem != null) {
            ItemStack stack = ((Slot)this.f_38839_.get(id)).m_7993_();
            if (id >= 36) {
                this.m_38903_(stack, 0, 36, true);
            } else {
                EquipmentSlot es = this.getSlotForItem(stack);
                for (int i = 0; i < 6; ++i) {
                    if (SLOTS[i] != es) continue;
                    this.m_38903_(stack, 36 + i, 37 + i, false);
                }
            }
            this.container.m_6596_();
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public EquipmentSlot getSlotForItem(ItemStack stack) {
        if (!this.m_6875_(this.inventory.f_35978_) || this.golem == null) {
            return null;
        }
        if (!stack.m_41720_().m_142095_()) {
            return null;
        }
        if (stack.m_41720_() instanceof GolemHolder) {
            return null;
        }
        Item item = this.golem;
        if (item instanceof HumanoidGolemEntity) {
            HumanoidGolemEntity humanoidGolem = (HumanoidGolemEntity)item;
            GolemEquipEvent event = new GolemEquipEvent(humanoidGolem, stack);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.canEquip()) {
                return event.getSlot();
            }
            return null;
        }
        if (this.golem instanceof MetalGolemEntity) {
            item = stack.m_41720_();
            if (item instanceof MetalGolemArmorItem) {
                MetalGolemArmorItem mgai = (MetalGolemArmorItem)item;
                return mgai.getSlot();
            }
            if (stack.m_41720_() instanceof MetalGolemBeaconItem) {
                return EquipmentSlot.FEET;
            }
            if (stack.m_41720_() instanceof MetalGolemWeaponItem || stack.m_204117_(MGTagGen.LARGE_GOLEM_WEAPONS)) {
                return EquipmentSlot.MAINHAND;
            }
            if (stack.m_41720_() instanceof BannerItem) {
                if (this.golem.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                    return EquipmentSlot.HEAD;
                }
                return EquipmentSlot.FEET;
            }
        }
        if (this.golem instanceof DogGolemEntity && stack.m_41720_() instanceof BannerItem) {
            return EquipmentSlot.HEAD;
        }
        return null;
    }
}

