/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.alexscaves.modifier;

import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import dev.xkmc.l2complements.init.registrate.LCEffects;
import dev.xkmc.modulargolems.compat.materials.alexscaves.ACCompatRegistry;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.DummyConsumer;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.init.data.MGConfig;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;

public class AtomicFuelingModifier
extends GolemModifier {
    private static int time() {
        return (Integer)MGConfig.COMMON.atomicDuration.get();
    }

    private static float health() {
        return (float)((Double)MGConfig.COMMON.atomicHeal.get()).doubleValue();
    }

    public AtomicFuelingModifier() {
        super(StatFilterType.HEALTH, 2);
    }

    private void perform(AbstractGolemEntity<?, ?> golem, int level) {
        float max = golem.m_21233_();
        if (ModList.get().isLoaded("l2complements") && golem.m_21023_((MobEffect)LCEffects.CURSE.get())) {
            golem.m_21195_((MobEffect)LCEffects.CURSE.get());
        }
        golem.m_5634_(max * AtomicFuelingModifier.health() * (float)level);
        MobEffectInstance ins = golem.m_21124_((MobEffect)ACCompatRegistry.EFF_ATOMIC.get());
        int t = ins == null ? 0 : ins.m_19557_();
        golem.m_7292_(new MobEffectInstance((MobEffect)ACCompatRegistry.EFF_ATOMIC.get(), t + AtomicFuelingModifier.time(), level));
        float f1 = 1.0f + (golem.m_217043_().m_188501_() - golem.m_217043_().m_188501_()) * 0.2f;
        golem.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
    }

    @Override
    public void onAiStep(AbstractGolemEntity<?, ?> golem, int level) {
        if (golem.f_19797_ % 20 != 0) {
            return;
        }
        float hp = golem.m_21223_();
        float max = golem.m_21233_();
        if (max * (1.0f - AtomicFuelingModifier.health()) <= hp) {
            return;
        }
        ItemStack uranium = golem.m_6298_(ACCompatRegistry.DUMMY_URANIUM.asStack());
        if (uranium.m_41619_()) {
            return;
        }
        uranium.m_41774_(1);
        this.perform(golem, level);
    }

    @Override
    public InteractionResult interact(Player player, AbstractGolemEntity<?, ?> golem, InteractionHand hand, int level) {
        ItemStack stack = player.m_21120_(hand);
        if (!((DummyConsumer)((Object)ACCompatRegistry.DUMMY_URANIUM.get())).isValid(stack)) {
            return InteractionResult.PASS;
        }
        float hp = golem.m_21223_();
        float max = golem.m_21233_();
        if (!player.m_9236_().m_5776_()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.perform(golem, level);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onRegisterGoals(AbstractGolemEntity<?, ?> entity, int lv, BiConsumer<Integer, Goal> addGoal) {
        entity.effectImmunity.add((MobEffect)ACEffectRegistry.IRRADIATED.get());
        if (ModList.get().isLoaded("l2complements")) {
            entity.effectImmunity.add((MobEffect)LCEffects.CURSE.get());
        }
    }

    @Override
    public List<MutableComponent> getDetail(int v) {
        Component item = ((Item)ACItemRegistry.URANIUM_SHARD.get()).m_7968_().m_41786_();
        MutableComponent heal = Component.m_237113_((String)(Math.round(AtomicFuelingModifier.health() * 100.0f * (float)v) + "%")).m_130940_(ChatFormatting.AQUA);
        MutableComponent boost = Component.m_237113_((String)"20%").m_130940_(ChatFormatting.AQUA);
        MutableComponent time = Component.m_237113_((String)("" + AtomicFuelingModifier.time() / 20)).m_130940_(ChatFormatting.AQUA);
        return List.of(Component.m_237110_((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{item, heal, boost, time}).m_130940_(ChatFormatting.GREEN));
    }
}

