/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.create.automation;

import com.simibubi.create.content.kinetics.deployer.DeployerRecipeSearchEvent;
import dev.xkmc.modulargolems.compat.materials.create.automation.DeployerUpgradeRecipe;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.card.ConfigCard;
import dev.xkmc.modulargolems.content.item.equipments.GolemEquipmentItem;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.events.CraftEventListeners;
import dev.xkmc.modulargolems.init.registrate.GolemTypes;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CreateRecipeEvents {
    @SubscribeEvent
    public static void addRecipe(DeployerRecipeSearchEvent event) {
        ItemStack result;
        ItemStack first = event.getInventory().m_8020_(0);
        ItemStack second = event.getInventory().m_8020_(1);
        Item item = first.m_41720_();
        if (!(item instanceof GolemHolder)) {
            return;
        }
        GolemHolder holder = (GolemHolder)item;
        Level level = event.getBlockEntity().m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        Item item2 = second.m_41720_();
        if (item2 instanceof ConfigCard) {
            ConfigCard card = (ConfigCard)item2;
            id = ConfigCard.getUUID(second);
            if (id == null) {
                return;
            }
            result = first.m_41777_();
            GolemHolder.setGolemConfig(result, (UUID)id, card.getColor());
        } else {
            id = second.m_41720_();
            if (id instanceof UpgradeItem) {
                UpgradeItem upgrade = (UpgradeItem)((Object)id);
                result = CraftEventListeners.appendUpgrade(first, holder, upgrade);
            } else if (CreateRecipeEvents.isGolemCurio(holder, second)) {
                result = CreateRecipeEvents.equipCurio(holder, first, second, (Level)sl);
            } else if (holder.getEntityType() == GolemTypes.TYPE_GOLEM.get()) {
                Item item3 = second.m_41720_();
                if (!(item3 instanceof GolemEquipmentItem)) {
                    return;
                }
                GolemEquipmentItem equipment = (GolemEquipmentItem)item3;
                if (!equipment.isFor((EntityType)GolemTypes.ENTITY_GOLEM.get())) {
                    return;
                }
                EquipmentSlot slot = equipment.getSlot();
                result = CreateRecipeEvents.equip(holder, first, second, slot, (Level)sl);
            } else if (holder.getEntityType() == GolemTypes.TYPE_HUMANOID.get()) {
                EquipmentSlot slot = LivingEntity.m_147233_((ItemStack)second);
                result = CreateRecipeEvents.equip(holder, first, second, slot, (Level)sl);
            } else {
                return;
            }
        }
        if (result.m_41619_()) {
            return;
        }
        event.addRecipe(() -> Optional.of(new DeployerUpgradeRecipe(result)), 1000);
    }

    private static boolean isGolemCurio(GolemHolder<?, ?> holder, ItemStack stack) {
        if (!ModList.get().isLoaded("curios")) {
            return false;
        }
        Set set = CuriosApi.getEntitySlots(holder.getEntityType().type(), (boolean)false).keySet();
        return ForgeRegistries.ITEMS.tags().getReverseTag((Object)stack.m_41720_()).map(e -> e.getTagKeys().anyMatch(t -> t.f_203868_().m_135827_().equals("curios") && set.contains(t.f_203868_().m_135815_()))).orElse(false);
    }

    private static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack equipCurio(GolemHolder<T, P> holder, ItemStack golem, ItemStack equip, Level level) {
        if (!ModList.get().isLoaded("curios")) {
            return ItemStack.f_41583_;
        }
        T entity = holder.createDummy(golem, level);
        if (entity == null) {
            return ItemStack.f_41583_;
        }
        Optional opt = CuriosApi.getCuriosInventory(entity).resolve();
        if (opt.isEmpty()) {
            return ItemStack.f_41583_;
        }
        equip = equip.m_41777_();
        equip.m_41764_(1);
        for (String slot : CuriosApi.getItemStackSlots((ItemStack)equip, entity).keySet()) {
            Optional handler = ((ICuriosItemHandler)opt.get()).getStacksHandler(slot);
            if (handler.isEmpty()) continue;
            IDynamicStackHandler stacks = ((ICurioStacksHandler)handler.get()).getStacks();
            for (int i = 0; i < stacks.getSlots(); ++i) {
                if (!stacks.getStackInSlot(i).m_41619_()) continue;
                stacks.setStackInSlot(i, equip);
                return GolemHolder.setEntity(entity);
            }
        }
        return ItemStack.f_41583_;
    }

    private static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack equip(GolemHolder<T, P> holder, ItemStack golem, ItemStack equip, EquipmentSlot slot, Level level) {
        T entity = holder.createDummy(golem, level);
        if (entity == null) {
            return ItemStack.f_41583_;
        }
        if (!entity.m_6844_(slot).m_41619_()) {
            return ItemStack.f_41583_;
        }
        equip = equip.m_41777_();
        equip.m_41764_(1);
        entity.m_8061_(slot, equip);
        return GolemHolder.setEntity(entity);
    }
}

