/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.goety.title;

import dev.xkmc.mob_weapon_api.api.ai.ISmartUser;
import dev.xkmc.mob_weapon_api.api.ai.IWeaponHolder;
import dev.xkmc.mob_weapon_api.api.goals.IMeleeGoal;
import dev.xkmc.mob_weapon_api.api.projectile.BowUseContext;
import dev.xkmc.mob_weapon_api.api.projectile.IBowBehavior;
import dev.xkmc.mob_weapon_api.api.projectile.ProjectileWeaponUser;
import dev.xkmc.mob_weapon_api.example.goal.SmartBowAttackGoal;
import dev.xkmc.mob_weapon_api.registry.WeaponRegistry;
import dev.xkmc.modulargolems.compat.materials.goety.GoetyCompatRegistry;
import dev.xkmc.modulargolems.compat.materials.goety.revelation.GRCompatRegistry;
import dev.xkmc.modulargolems.content.entity.common.SweepGolemEntity;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.entity.EntityTypeTest;

public class ApollyonBowGoal<E extends SweepGolemEntity<?, ?>>
extends SmartBowAttackGoal<E> {
    @Nullable
    private LinkedList<LivingEntity> targets = null;
    private int count;

    public ApollyonBowGoal(E mob, IMeleeGoal melee, double speed, double radius) {
        super(mob, melee, speed, radius);
    }

    public ApollyonBowGoal(E mob, IWeaponHolder holder, IMeleeGoal melee, double speed, double radius) {
        super(mob, holder, melee, speed, radius);
    }

    protected void makeTarget(int range, int max) {
        List list = ((SweepGolemEntity)this.mob).m_9236_().m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), ((SweepGolemEntity)this.mob).m_20191_().m_82400_((double)range), e -> ((SweepGolemEntity)this.mob).m_6779_((LivingEntity)e) && ((SweepGolemEntity)this.mob).m_142582_((Entity)e));
        ArrayList<LivingEntity> first = new ArrayList<LivingEntity>();
        ArrayList<LivingEntity> second = new ArrayList<LivingEntity>();
        for (LivingEntity e2 : list) {
            if (((SweepGolemEntity)this.mob).predicatePriorityTarget(e2)) {
                first.add(e2);
                continue;
            }
            if (!((SweepGolemEntity)this.mob).predicateSecondaryTarget(e2)) continue;
            second.add(e2);
        }
        this.targets = new LinkedList();
        for (LivingEntity e2 : first) {
            if (this.targets.size() >= max) {
                return;
            }
            this.targets.add(e2);
        }
        for (LivingEntity e2 : second) {
            if (this.targets.size() >= max) {
                return;
            }
            this.targets.add(e2);
        }
    }

    public void m_8037_() {
        this.doMelee();
        this.strafing();
        LivingEntity target = ((SweepGolemEntity)this.mob).m_5448_();
        InteractionHand hand = this.holder.getWeaponHand();
        ItemStack stack = ((SweepGolemEntity)this.mob).m_21120_(hand);
        Optional weapon = WeaponRegistry.BOW.get((LivingEntity)this.mob, stack);
        if (weapon.isEmpty()) {
            return;
        }
        if (((SweepGolemEntity)this.mob).m_6117_() && target != null) {
            ISmartUser user = this.holder.toUser();
            double dist = ((SweepGolemEntity)this.mob).m_20270_((Entity)target);
            if (this.seeTime < -60) {
                ((SweepGolemEntity)this.mob).m_5810_();
            } else if (this.seeTime > 0) {
                int pullTime;
                int i = ((SweepGolemEntity)this.mob).m_21252_();
                if (i >= (pullTime = ((IBowBehavior)weapon.get()).getPreferredPullTime((BowUseContext)user, stack, dist))) {
                    if (this.performRangedAttack(((IBowBehavior)weapon.get()).getPowerForTime((BowUseContext)user, stack, i), stack, hand)) {
                        ((SweepGolemEntity)this.mob).m_5810_();
                    }
                } else {
                    ((IBowBehavior)weapon.get()).tickUsingBow((ProjectileWeaponUser)user, stack);
                }
            }
        } else if (this.seeTime >= -60) {
            ISmartUser user = this.holder.toUser();
            if (target != null) {
                double dist = ((SweepGolemEntity)this.mob).m_20270_((Entity)target);
                int pullTime = ((IBowBehavior)weapon.get()).getPreferredPullTime((BowUseContext)user, stack, dist);
                if (pullTime <= 0) {
                    this.performRangedAttack(target, 0.0f, stack, hand);
                    return;
                }
            }
            ((SweepGolemEntity)this.mob).m_6672_(hand);
            weapon.ifPresent(e -> e.startUsingBow((ProjectileWeaponUser)user, stack));
        }
    }

    public boolean performRangedAttack(float power, ItemStack stack, InteractionHand hand) {
        int lv = ((SweepGolemEntity)this.mob).getModifiers().getOrDefault(GRCompatRegistry.BOW.get(), 0);
        int range = 35;
        int max = 4 + 4 * lv;
        int maxCount = 2 + lv;
        if (this.targets == null) {
            this.makeTarget(range, max);
            int n = this.count = stack.m_204117_(GoetyCompatRegistry.REV_BOW) ? maxCount : 1;
        }
        if (this.targets.isEmpty()) {
            this.targets = null;
            return true;
        }
        LivingEntity old = ((SweepGolemEntity)this.mob).m_5448_();
        for (LivingEntity e : this.targets) {
            if (!e.m_6084_()) continue;
            ((SweepGolemEntity)this.mob).m_6710_(e);
            this.performRangedAttack(e, power, stack, hand);
        }
        ((SweepGolemEntity)this.mob).m_6710_(old);
        --this.count;
        if (this.count <= 0) {
            this.targets = null;
            return true;
        }
        return false;
    }
}

