/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.legendarymonsters;

import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.entity.common.GolemFlags;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.content.modifier.special.EarthquakeHelper;
import java.util.Comparator;
import java.util.function.Consumer;
import net.miauczel.legendary_monsters.effect.ModEffects;
import net.miauczel.legendary_monsters.entity.CameraShakeEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AncientAnchorModifier
extends GolemModifier
implements EarthquakeHelper.Modifier {
    public AncientAnchorModifier(StatFilterType type, int maxLevel) {
        super(type, maxLevel);
    }

    @Override
    public void onRegisterFlag(Consumer<GolemFlags> addFlag) {
        addFlag.accept(GolemFlags.EARTH_QUAKE);
    }

    @Override
    public void performEarthQuake(AbstractGolemEntity<?, ?> golem, int level) {
        Vec3 entityPosition = golem.m_20182_();
        CameraShakeEntity.cameraShake((Level)golem.m_9236_(), (Vec3)entityPosition, (float)15.0f, (float)0.3f, (int)0, (int)15);
        Level level2 = golem.m_9236_();
        if (level2 instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level2;
            this.execute(sl, golem.m_20185_(), golem.m_20186_(), golem.m_20189_(), golem, 5.0f, level);
        }
    }

    @Override
    public double getEarthquakeRangeSqr(AbstractGolemEntity<?, ?> golem, LivingEntity target, int lv) {
        return 16.0;
    }

    private void execute(ServerLevel level, double x, double y, double z, AbstractGolemEntity<?, ?> golem, float reach, int lv) {
        int n = 128;
        for (double i = 0.0; i < (double)n; i += 1.0) {
            level.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x + 0.5 + Math.cos(Math.PI * 2 / (double)n * i) * (double)reach, y, z + 0.5 + Math.sin(Math.PI * 2 / (double)n * i) * (double)reach, 0, 0.0, 0.05, 0.0, 1.0);
        }
        level.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), SoundEvents.f_12009_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        Vec3 cen = new Vec3(x, y, z);
        for (LivingEntity le : level.m_6443_(LivingEntity.class, new AABB(cen, cen).m_82400_((double)reach), e -> e != golem).stream().sorted(Comparator.comparingDouble(ec -> ec.m_20238_(cen))).toList()) {
            if (golem.m_7307_((Entity)le)) continue;
            le.m_7292_(new MobEffectInstance((MobEffect)ModEffects.STUN.get(), 20 * lv, 255, false, false));
            le.m_6469_(golem.m_269291_().m_269333_(golem), (float)golem.m_21133_(Attributes.f_22281_) * (float)lv * 0.4f);
            EarthquakeHelper.launch(golem, (Entity)le, 1.0f);
        }
    }
}

