/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.client.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xkmc.modulargolems.content.item.card.PathRecordCard;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class BlockOutliner {
    private static Level world;
    private static int time;
    private static List<PathRecordCard.Pos> selection;

    public static void drawOutlines(Player player, List<PathRecordCard.Pos> list) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_ != player) {
            return;
        }
        time = player.f_19797_;
        selection = list;
        world = level;
    }

    public static void renderOutline(PoseStack pose, Vec3 camera) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (selection == null || level == null || player == null || level != world || time + 3 < player.f_19797_) {
            selection = null;
            return;
        }
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vc = buffer.m_6299_(RenderType.m_110504_());
        BlockPos pre = null;
        BlockPos first = null;
        float time = ((float)level.m_46467_() + Minecraft.m_91087_().getPartialTick()) / 40.0f % 1.0f;
        for (PathRecordCard.Pos pos : selection) {
            BlockOutliner.renderBox(pose, vc, pos.pos(), camera.m_252839_(), pre == null ? -8388737 : -8401440);
            if (pre != null) {
                BlockOutliner.line(pose, vc, pre, pos.pos(), camera.m_252839_(), time);
            } else {
                first = pos.pos();
            }
            pre = pos.pos();
        }
        if (pre != null) {
            BlockOutliner.line(pose, vc, pre, first, camera.m_252839_(), time);
        }
    }

    private static void line(PoseStack pose, VertexConsumer vc, BlockPos a, BlockPos b, Vector3f pos, float time) {
        Vec3 c0 = a.m_252807_();
        Vec3 c1 = b.m_252807_();
        Vec3 v1 = c0.m_165921_(c1, (double)time);
        Vec3 v0 = c0;
        if ((double)time >= 0.5) {
            v0 = c0.m_165921_(c1, (double)time - 0.5);
        }
        Vector3f p0 = v0.m_252839_();
        Vector3f p1 = v1.m_252839_();
        BlockOutliner.renderLine(pose, vc, p0.x, p0.y, p0.z, p1.x, p1.y, p1.z, pos, -8401440);
        if ((double)time < 0.5) {
            v1 = c1;
            v0 = c0.m_165921_(c1, (double)time + 0.5);
            p0 = v0.m_252839_();
            p1 = v1.m_252839_();
            BlockOutliner.renderLine(pose, vc, p0.x, p0.y, p0.z, p1.x, p1.y, p1.z, pos, -8401440);
        }
    }

    private static void renderBox(PoseStack pose, VertexConsumer vc, BlockPos box, Vector3f pos, int color) {
        float offset = 0.03125f;
        BlockOutliner.renderCube(pose, vc, (float)box.m_123341_() + offset, (float)box.m_123342_() + offset, (float)box.m_123343_() + offset, (float)(box.m_123341_() + 1) - offset, (float)(box.m_123342_() + 1) - offset, (float)(box.m_123343_() + 1) - offset, pos, color);
    }

    public static void renderCube(PoseStack pose, VertexConsumer vc, float x0, float y0, float z0, float x1, float y1, float z1, Vector3f pos, int color) {
        BlockOutliner.renderLine(pose, vc, x0, y0, z0, x1, y0, z0, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y0, z0, x0, y1, z0, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y0, z0, x0, y0, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x1, y0, z0, x1, y1, z0, pos, color);
        BlockOutliner.renderLine(pose, vc, x1, y0, z0, x1, y0, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y1, z0, x1, y1, z0, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y1, z0, x0, y1, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y0, z1, x1, y0, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y0, z1, x0, y1, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x1, y1, z0, x1, y1, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x1, y0, z1, x1, y1, z1, pos, color);
        BlockOutliner.renderLine(pose, vc, x0, y1, z1, x1, y1, z1, pos, color);
    }

    private static void renderLine(PoseStack pose, VertexConsumer vc, float x0, float y0, float z0, float x1, float y1, float z1, Vector3f pos, int color) {
        PoseStack.Pose mat = pose.m_85850_();
        float rx = x1 - x0;
        float ry = y1 - y0;
        float rz = z1 - z0;
        float len = Mth.m_14116_((float)(rx * rx + ry * ry + rz * rz));
        vc.m_252986_(mat.m_252922_(), x0 - pos.x, y0 - pos.y, z0 - pos.z).m_193479_(color).m_252939_(mat.m_252943_(), rx /= len, ry /= len, rz /= len).m_5752_();
        vc.m_252986_(mat.m_252922_(), x1 - pos.x, y1 - pos.y, z1 - pos.z).m_193479_(color).m_252939_(mat.m_252943_(), rx, ry, rz).m_5752_();
    }

    static {
        time = 0;
    }
}

