/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.goals;

import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class FollowOwnerGoal
extends Goal {
    private final AbstractGolemEntity<?, ?> golem;
    private final double speedModifier;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public FollowOwnerGoal(AbstractGolemEntity<?, ?> golem) {
        this(golem, 1.0);
    }

    private FollowOwnerGoal(AbstractGolemEntity<?, ?> golem, double speed) {
        this.golem = golem;
        this.speedModifier = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.golem.isInSittingPose() || !this.golem.getMode().isMovable()) {
            return false;
        }
        if (this.golem.m_6688_() instanceof Player) {
            return false;
        }
        Vec3 target = this.golem.getTargetPos();
        double startDistance = this.golem.getMode().getStartFollowDistance(this.golem);
        return this.golem.m_20238_(target) > startDistance * startDistance;
    }

    public boolean m_8045_() {
        if (this.golem.m_21573_().m_26571_()) {
            this.golem.getMode().tick(this.golem);
            if (this.golem.m_21573_().m_26571_()) {
                return false;
            }
        }
        if (this.golem.isInSittingPose() || !this.golem.getMode().isMovable()) {
            return false;
        }
        Vec3 target = this.golem.getTargetPos();
        double stop = this.golem.getMode().getStopDistance();
        return !(this.golem.m_20238_(target) <= stop * stop);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.golem.m_21439_(BlockPathTypes.WATER);
        this.golem.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.golem.m_21573_().m_26573_();
        this.golem.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        Vec3 target = this.golem.getTargetPos();
        Player owner = this.golem.getOwner();
        if (owner != null) {
            this.golem.m_21563_().m_24960_((Entity)owner, 10.0f, (float)this.golem.m_8132_());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (!this.golem.m_21523_()) {
                this.golem.m_21573_().m_26519_(target.m_7096_(), target.m_7098_(), target.m_7094_(), this.speedModifier);
                return;
            }
        }
        this.golem.getMode().tick(this.golem);
    }
}

