/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.metalgolem;

import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.entity.common.SweepGolemEntity;
import dev.xkmc.modulargolems.content.entity.humanoid.weapon.GolemWeaponRegistry;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemPartType;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class MetalGolemEntity
extends SweepGolemEntity<MetalGolemEntity, MetalGolemPartType> {
    private int attackAnimationTick;

    public MetalGolemEntity(EntityType<MetalGolemEntity> type, Level level) {
        super(GolemWeaponRegistry.LARGE, type, level);
        this.m_274367_(1.0f);
    }

    @Override
    protected boolean performDamageTarget(Entity target, float damage, double kb) {
        boolean succeed;
        if (target instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)target;
            le.m_6598_(this.getOwner());
            damage += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)le.m_6336_());
            kb += (double)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if (succeed = target.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), damage)) {
            double d1 = Math.max(0.0, 1.0 - kb);
            double dokb = this.m_21133_(Attributes.f_22282_) * 0.4;
            target.m_20256_(target.m_20184_().m_82520_(0.0, dokb * d1, 0.0));
            this.m_19970_((LivingEntity)this, target);
            int i = EnchantmentHelper.m_44914_((LivingEntity)this);
            if (i > 0) {
                target.m_20254_(i * 4);
            }
        }
        return succeed;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0) {
            int i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
            int k = Mth.m_14107_((double)this.m_20189_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            if (!blockstate.m_60795_()) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
            }
        }
    }

    @Override
    public boolean m_7327_(Entity target) {
        double kb;
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float damage = this.getAttackDamage();
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            kb = livingentity.m_21133_(Attributes.f_22278_);
        } else {
            kb = 0.0;
        }
        boolean flag = this.performRangedDamage(target, damage, kb);
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return flag;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        IronGolem.Crackiness crack = this.getCrackiness();
        boolean flag = super.m_6469_(source, amount);
        if (flag && this.getCrackiness() != crack) {
            this.m_5496_(SoundEvents.f_12058_, 1.0f, 1.0f);
        }
        return flag;
    }

    public IronGolem.Crackiness getCrackiness() {
        return IronGolem.Crackiness.m_28901_((float)(this.m_21223_() / this.m_21233_()));
    }

    @Override
    public void m_7822_(byte event) {
        if (event == 4) {
            this.attackAnimationTick = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(event);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    protected SoundEvent m_7975_(DamageSource p_28872_) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected void m_7355_(BlockPos p_28864_, BlockState p_28865_) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    public boolean m_6914_(LevelReader p_28853_) {
        BlockPos blockpos = this.m_20183_();
        BlockPos blockpos1 = blockpos.m_7495_();
        BlockState blockstate = p_28853_.m_8055_(blockpos1);
        if (!blockstate.m_60634_((BlockGetter)p_28853_, blockpos1, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 3; ++i) {
            BlockState blockstate1;
            BlockPos blockpos2 = blockpos.m_6630_(i);
            if (NaturalSpawner.m_47056_((BlockGetter)p_28853_, (BlockPos)blockpos2, (BlockState)(blockstate1 = p_28853_.m_8055_(blockpos2)), (FluidState)blockstate1.m_60819_(), (EntityType)EntityType.f_20460_)) continue;
            return false;
        }
        return NaturalSpawner.m_47056_((BlockGetter)p_28853_, (BlockPos)blockpos, (BlockState)p_28853_.m_8055_(blockpos), (FluidState)Fluids.f_76191_.m_76145_(), (EntityType)EntityType.f_20460_) && p_28853_.m_45784_((Entity)this);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.875f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    protected InteractionResult mobInteractImpl(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.getMaterials().size() != MetalGolemPartType.values().length) {
            return super.mobInteractImpl(player, hand);
        }
        GolemMaterial mat = this.getMaterials().get(MetalGolemPartType.BODY.ordinal());
        Ingredient ing = GolemMaterialConfig.get().getRepairIngredient(mat.id());
        if (!ing.test(itemstack)) {
            if (((Boolean)MGConfig.COMMON.strictInteract.get()).booleanValue() && !itemstack.m_41619_()) {
                return InteractionResult.PASS;
            }
            return super.mobInteractImpl(player, hand);
        }
        float f = this.m_21223_();
        this.m_5634_(this.m_21233_() / 4.0f);
        if (this.m_21223_() == f) {
            return InteractionResult.PASS;
        }
        float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
        this.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
        if (!player.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        if (!this.m_9236_().m_5776_()) {
            GolemTriggers.HOT_FIX.trigger((ServerPlayer)player);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }
}

