/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.compat.jei.category;

import committee.nova.mods.avaritiadelight.recipe.ExtremeCookingPotRecipe;
import committee.nova.mods.avaritiadelight.recipe.ExtremeCookingPotShapedRecipe;
import committee.nova.mods.avaritiadelight.recipe.ExtremeCookingPotShapelessRecipe;
import committee.nova.mods.avaritiadelight.registry.ADBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtremeCookingPotCategory<T extends ExtremeCookingPotRecipe>
implements IRecipeCategory<T> {
    public static final RecipeType<ExtremeCookingPotShapedRecipe> SHAPED_TYPE = new RecipeType(ExtremeCookingPotShapedRecipe.ID, ExtremeCookingPotShapedRecipe.class);
    public static final RecipeType<ExtremeCookingPotShapelessRecipe> SHAPELESS_TYPE = new RecipeType(ExtremeCookingPotShapelessRecipe.ID, ExtremeCookingPotShapelessRecipe.class);
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"avaritia_delight", (String)"textures/gui/jei/extreme_cooking_pot.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final RecipeType<T> type;

    public ExtremeCookingPotCategory(IGuiHelper helper, RecipeType<T> type) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 192, 165);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ADBlocks.EXTREME_COOKING_POT.get()));
        this.type = type;
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)ExtremeCookingPotRecipe.ID.m_214296_("jei.category"));
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, ExtremeCookingPotRecipe recipe, @NotNull IFocusGroup focuses) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        assert (world != null);
        NonNullList inputs = recipe.m_7527_();
        int surroundWidth = (9 - recipe.width()) / 2;
        int surroundHeight = (9 - recipe.height()) / 2;
        for (int i = 0; i < recipe.height(); ++i) {
            for (int j = 0; j < recipe.width(); ++j) {
                int index = j + i * recipe.width();
                if (index >= inputs.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, (j + surroundWidth) * 18 + 2, (i + surroundHeight) * 18 + 2).addIngredients((Ingredient)inputs.get(index));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 168, 76).addItemStack(recipe.m_8043_(world.m_9598_()));
        builder.addSlot(RecipeIngredientRole.INPUT, 168, 99).addItemStack(recipe.getOutputContainer());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 168, 137).addItemStack(recipe.m_8043_(world.m_9598_()));
        builder.moveRecipeTransferButton(170, 30);
        if (recipe.shapeless()) {
            builder.setShapeless();
        }
    }
}

