/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.item.block;

import committee.nova.mods.avaritiadelight.item.block.entity.ExtremeCookingPotBlockEntity;
import committee.nova.mods.avaritiadelight.registry.ADBlockEntities;
import committee.nova.mods.avaritiadelight.util.BlockEntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;

public class ExtremeCookingPotBlock
extends CookingPotBlock {
    public ExtremeCookingPotBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60913_(0.5f, 6.0f).m_60918_(SoundType.f_56762_));
    }

    private CookingPotSupport getTrayState(LevelAccessor level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_204336_(ModTags.TRAY_HEAT_SOURCES) ? CookingPotSupport.TRAY : CookingPotSupport.NONE;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41619_() && player.m_6144_()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SUPPORT, (Comparable)(((CookingPotSupport)state.m_61143_((Property)SUPPORT)).equals((Object)CookingPotSupport.HANDLE) ? this.getTrayState((LevelAccessor)level, pos) : CookingPotSupport.HANDLE)));
            level.m_5594_(null, pos, SoundEvents.f_12028_, SoundSource.BLOCKS, 0.7f, 1.0f);
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof ExtremeCookingPotBlockEntity) {
                ExtremeCookingPotBlockEntity cookingPotEntity = (ExtremeCookingPotBlockEntity)tileEntity;
                ItemStack servingStack = cookingPotEntity.useHeldItemOnMeal(heldStack);
                if (servingStack != ItemStack.f_41583_) {
                    if (!player.m_150109_().m_36054_(servingStack)) {
                        player.m_36176_(servingStack, false);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)cookingPotEntity, cookingPotEntity::saveExtraData);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ExtremeCookingPotBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return ExtremeCookingPotBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ADBlockEntities.EXTREME_COOKING_POT.get()), (BlockEntityTicker)(level.f_46443_ ? ExtremeCookingPotBlockEntity::animationTick : ExtremeCookingPotBlockEntity::cookingTick));
    }

    @NotNull
    public ItemStack m_7397_(@NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return new ItemStack((ItemLike)this);
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof ExtremeCookingPotBlockEntity) {
            ExtremeCookingPotBlockEntity pot = (ExtremeCookingPotBlockEntity)blockEntity;
            pot.setCustomName(stack.m_41786_());
        }
    }

    public void m_214162_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        ExtremeCookingPotBlockEntity cookingPotEntity;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof ExtremeCookingPotBlockEntity && (cookingPotEntity = (ExtremeCookingPotBlockEntity)tileEntity).isHeated()) {
            SoundEvent boilSound = (SoundEvent)(cookingPotEntity.getMeal().m_41619_() ? ModSounds.BLOCK_COOKING_POT_BOIL : ModSounds.BLOCK_COOKING_POT_BOIL_SOUP).get();
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (random.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, boilSound, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.2f + 0.9f, false);
            }
        }
    }

    public int m_6782_(@NotNull BlockState blockState, Level level, @NotNull BlockPos pos) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof ExtremeCookingPotBlockEntity) {
            ExtremeCookingPotBlockEntity pot = (ExtremeCookingPotBlockEntity)tileEntity;
            return BlockEntityUtil.calcRedstoneFromInventory(pot);
        }
        return 0;
    }
}

