/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.item.block;

import committee.nova.mods.avaritiadelight.item.block.entity.ExtremeStoveBlockEntity;
import committee.nova.mods.avaritiadelight.registry.ADBlockEntities;
import committee.nova.mods.avaritiadelight.registry.ADItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class ExtremeStoveBlock
extends StoveBlock {
    public ExtremeStoveBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockEntity tileEntity;
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            if (heldStack.m_204117_(ItemTags.f_271138_)) {
                this.extinguish(state, level, pos);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem == Items.f_42447_) {
                if (!level.m_5776_()) {
                    level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.extinguish(state, level, pos);
                if (!player.m_7500_()) {
                    player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (heldItem instanceof FlintAndSteelItem) {
                level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
            if (heldItem instanceof FireChargeItem) {
                level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        if ((tileEntity = level.m_7702_(pos)) instanceof ExtremeStoveBlockEntity) {
            ExtremeStoveBlockEntity stoveEntity = (ExtremeStoveBlockEntity)tileEntity;
            int stoveSlot = stoveEntity.getNextEmptySlot();
            if (stoveSlot < 0 || stoveEntity.isStoveBlockedAbove()) {
                return InteractionResult.PASS;
            }
            if (heldStack.m_150930_((Item)ADItems.COSMIC_BEEF.get()) && !level.f_46443_ && stoveEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack, new CampfireCookingRecipe(ResourceLocation.m_214293_((String)"avaritia_delight", (String)"cosmic_beef_cooked"), "misc", CookingBookCategory.FOOD, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ADItems.COSMIC_BEEF.get()}), new ItemStack((ItemLike)ADItems.COSMIC_BEEF_COOKED.get()), 0.0f, 200), stoveSlot)) {
                return InteractionResult.SUCCESS;
            }
            Optional<CampfireCookingRecipe> recipe = stoveEntity.getMatchingRecipe((Container)new SimpleContainer(new ItemStack[]{heldStack}), stoveSlot);
            if (recipe.isPresent()) {
                if (!level.f_46443_ && stoveEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack, recipe.get(), stoveSlot)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState stateIn, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (rand.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, (SoundEvent)ModSounds.BLOCK_STOVE_CRACKLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Direction.Axis direction$axis = direction.m_122434_();
            double horizontalOffset = rand.m_188500_() * 0.6 - 0.3;
            double xOffset = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : horizontalOffset;
            double yOffset = rand.m_188500_() * 6.0 / 16.0;
            double zOffset = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : horizontalOffset;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ExtremeStoveBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return ExtremeStoveBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ADBlockEntities.EXTREME_STOVE.get()), (BlockEntityTicker)(level.f_46443_ ? ExtremeStoveBlockEntity::animationTick : ExtremeStoveBlockEntity::cookingTick));
    }
}

