/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.item.block.entity;

import committee.nova.mods.avaritiadelight.recipe.CropExtractorRecipe;
import committee.nova.mods.avaritiadelight.registry.ADBlockEntities;
import committee.nova.mods.avaritiadelight.screen.handler.CropExtractorScreenHandler;
import committee.nova.mods.avaritiadelight.util.ImplementedInventory;
import committee.nova.mods.avaritiadelight.util.InventoryHelper;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CropExtractorBlockEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory {
    private final NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int time;
    private int timeTotal;
    private CropExtractorRecipe lastRecipe = null;
    private final ContainerData cookingProgress = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CropExtractorBlockEntity.this.time;
                case 1 -> CropExtractorBlockEntity.this.timeTotal;
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CropExtractorBlockEntity.this.time = value;
                }
                case 1: {
                    CropExtractorBlockEntity.this.timeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CropExtractorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ADBlockEntities.CROP_EXTRACTOR.get(), pos, state);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.%s.crop_extractor".formatted("avaritia_delight"));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new CropExtractorScreenHandler(syncId, this, playerInventory, this.cookingProgress);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("Items"), this.stacks);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Items", (Tag)InventoryHelper.writeNbt(new CompoundTag(), this.stacks));
    }

    public static void tick(Level world, BlockPos pos, BlockState state, CropExtractorBlockEntity blockEntity) {
        CropExtractorRecipe matched = world.m_7465_().m_44015_((RecipeType)CropExtractorRecipe.Type.INSTANCE, (Container)blockEntity, world).orElse(null);
        if (blockEntity.lastRecipe != null && matched != null && Objects.equals(blockEntity.lastRecipe.m_6423_(), matched.m_6423_()) && InventoryHelper.canInsertItems(1, blockEntity, matched.getOutputs())) {
            ++blockEntity.time;
            if (blockEntity.time >= blockEntity.timeTotal) {
                blockEntity.time = 0;
                blockEntity.m_8020_(0).m_41774_(1);
                InventoryHelper.insertItems(1, blockEntity, matched.getOutputs());
            }
        } else {
            blockEntity.lastRecipe = matched;
            blockEntity.time = 0;
            blockEntity.timeTotal = matched == null ? 0 : matched.getTime();
        }
    }
}

