/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.item.block.entity;

import committee.nova.mods.avaritiadelight.recipe.ExtremeCookingPotRecipe;
import committee.nova.mods.avaritiadelight.recipe.ExtremeCookingPotShapedRecipe;
import committee.nova.mods.avaritiadelight.recipe.ExtremeCookingPotShapelessRecipe;
import committee.nova.mods.avaritiadelight.registry.ADBlockEntities;
import committee.nova.mods.avaritiadelight.screen.handler.ExtremeCookingPotScreenHandler;
import committee.nova.mods.avaritiadelight.util.ImplementedInventory;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class ExtremeCookingPotBlockEntity
extends SyncedBlockEntity
implements MenuProvider,
ImplementedInventory,
HeatableBlockEntity,
Nameable {
    public static final int RESULT_SLOT = 81;
    public static final int CONTAINER_SLOT = 82;
    public static final int RESULT_WITH_CONTAINER_SLOT = 83;
    private final NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)84, (Object)ItemStack.f_41583_);
    @Nullable
    private Component customName;
    private int cookTime;
    private int cookTimeTotal;
    @NotNull
    private ItemStack mealContainerStack = ItemStack.f_41583_;
    private final ContainerData cookingProgress = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ExtremeCookingPotBlockEntity.this.cookTime;
                case 1 -> ExtremeCookingPotBlockEntity.this.cookTimeTotal;
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ExtremeCookingPotBlockEntity.this.cookTime = value;
                }
                case 1: {
                    ExtremeCookingPotBlockEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public ExtremeCookingPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ADBlockEntities.EXTREME_COOKING_POT.get(), pos, state);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.stacks.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("Items"), this.stacks);
        if (nbt.m_128441_("CustomName")) {
            this.customName = Component.Serializer.m_130701_((String)nbt.m_128461_("CustomName"));
        }
        this.cookTime = nbt.m_128451_("cookTime");
        this.cookTimeTotal = nbt.m_128451_("cookTimeTotal");
        if (nbt.m_128441_("mealContainerStack")) {
            this.mealContainerStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("mealContainerStack"));
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Items", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.stacks));
        if (this.customName != null) {
            nbt.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        nbt.m_128405_("cookTime", this.cookTime);
        nbt.m_128405_("cookTimeTotal", this.cookTimeTotal);
        if (!this.mealContainerStack.m_41619_()) {
            nbt.m_128365_("mealContainerStack", (Tag)this.mealContainerStack.m_41739_(new CompoundTag()));
        }
    }

    @NotNull
    public Component m_7755_() {
        return this.customName;
    }

    public void setCustomName(@Nullable Component customName) {
        this.customName = customName;
    }

    @NotNull
    public Component m_5446_() {
        return this.customName != null ? this.customName : Component.m_237115_((String)"block.%s.extreme_cooking_pot".formatted("avaritia_delight"));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new ExtremeCookingPotScreenHandler(syncId, this, playerInventory, this, this.cookingProgress);
    }

    public void saveExtraData(FriendlyByteBuf buf) {
        buf.m_130064_(this.f_58858_);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    @Override
    public boolean m_6542_(@NotNull Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public boolean isHeated() {
        return this.f_58857_ != null && this.isHeated(this.f_58857_, this.f_58858_);
    }

    private boolean hasInput() {
        for (int i = 0; i < 81; ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, ExtremeCookingPotBlockEntity cookingPot) {
        boolean isHeated = cookingPot.isHeated(level, pos);
        boolean didInventoryChange = false;
        if (isHeated && cookingPot.hasInput()) {
            Optional recipe = level.m_7465_().m_44015_((RecipeType)ExtremeCookingPotShapedRecipe.Type.INSTANCE, (Container)cookingPot, level);
            if (recipe.isPresent() && cookingPot.canCook((ExtremeCookingPotRecipe)recipe.get())) {
                didInventoryChange = cookingPot.processCooking((ExtremeCookingPotRecipe)recipe.get());
            } else {
                Optional recipe2 = level.m_7465_().m_44015_((RecipeType)ExtremeCookingPotShapelessRecipe.Type.INSTANCE, (Container)cookingPot, level);
                if (recipe2.isPresent() && cookingPot.canCook((ExtremeCookingPotRecipe)recipe2.get())) {
                    didInventoryChange = cookingPot.processCooking((ExtremeCookingPotRecipe)recipe2.get());
                } else {
                    cookingPot.cookTime = 0;
                }
            }
        } else if (cookingPot.cookTime > 0) {
            cookingPot.cookTime = Mth.m_14045_((int)(cookingPot.cookTime - 2), (int)0, (int)cookingPot.cookTimeTotal);
        }
        ItemStack mealStack = cookingPot.getMeal();
        if (!mealStack.m_41619_()) {
            if (!cookingPot.doesMealHaveContainer(mealStack)) {
                cookingPot.moveMealToOutput();
                didInventoryChange = true;
            } else if (!cookingPot.m_8020_(82).m_41619_()) {
                cookingPot.useStoredContainersOnMeal();
                didInventoryChange = true;
            }
        }
        if (didInventoryChange) {
            cookingPot.inventoryChanged();
        }
    }

    private void moveMealToOutput() {
        ItemStack mealStack = this.m_8020_(81);
        ItemStack outputStack = this.m_8020_(83);
        int mealCount = Math.min(mealStack.m_41613_(), mealStack.m_41741_() - outputStack.m_41613_());
        if (outputStack.m_41619_()) {
            this.m_6836_(83, mealStack.m_41620_(mealCount));
        } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
            mealStack.m_41774_(mealCount);
            outputStack.m_41769_(mealCount);
        }
    }

    protected boolean canCook(ExtremeCookingPotRecipe recipe) {
        if (this.hasInput()) {
            assert (this.f_58857_ != null);
            ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
            if (resultStack.m_41619_()) {
                return false;
            }
            ItemStack storedMealStack = this.m_8020_(81);
            if (storedMealStack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)storedMealStack, (ItemStack)resultStack)) {
                return false;
            }
            if (storedMealStack.m_41613_() + resultStack.m_41613_() <= this.m_8020_(81).m_41741_()) {
                return true;
            }
            return storedMealStack.m_41613_() + resultStack.m_41613_() <= resultStack.m_41741_();
        }
        return false;
    }

    private boolean processCooking(ExtremeCookingPotRecipe recipe) {
        if (this.f_58857_ == null) {
            return false;
        }
        ++this.cookTime;
        this.cookTimeTotal = recipe.getCookTime();
        if (this.cookTime < this.cookTimeTotal) {
            return false;
        }
        this.cookTime = 0;
        this.mealContainerStack = recipe.getOutputContainer();
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
        ItemStack storedMealStack = this.m_8020_(81);
        if (storedMealStack.m_41619_()) {
            this.m_6836_(81, resultStack.m_41777_());
        } else if (ItemStack.m_41656_((ItemStack)storedMealStack, (ItemStack)resultStack)) {
            storedMealStack.m_41769_(resultStack.m_41613_());
        }
        for (int i = 0; i < 81; ++i) {
            ItemStack slotStack = this.m_8020_(i);
            ItemStack remainder = slotStack.getCraftingRemainingItem();
            if (remainder != null) {
                this.ejectIngredientRemainder(remainder);
            } else if (CookingPotBlockEntity.INGREDIENT_REMAINDER_OVERRIDES.containsKey(slotStack.m_41720_())) {
                this.ejectIngredientRemainder(((Item)CookingPotBlockEntity.INGREDIENT_REMAINDER_OVERRIDES.get(slotStack.m_41720_())).m_7968_());
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        return true;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.m_58900_().m_61143_((Property)CookingPotBlock.FACING)).m_122428_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
        double y = (double)this.f_58858_.m_123342_() + 0.7;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
        assert (this.f_58857_ != null);
        ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)remainderStack, (double)x, (double)y, (double)z, (double)((double)direction.m_122429_() * 0.08), (double)0.25, (double)((double)direction.m_122431_() * 0.08));
    }

    private void useStoredContainersOnMeal() {
        ItemStack mealStack = this.m_8020_(81);
        ItemStack containerInputStack = this.m_8020_(82);
        ItemStack outputStack = this.m_8020_(83);
        if (this.isContainerValid(containerInputStack) && outputStack.m_41613_() < outputStack.m_41741_()) {
            int smallerStackCount = Math.min(mealStack.m_41613_(), containerInputStack.m_41613_());
            int mealCount = Math.min(smallerStackCount, mealStack.m_41741_() - outputStack.m_41613_());
            if (outputStack.m_41619_()) {
                containerInputStack.m_41774_(mealCount);
                this.m_6836_(83, mealStack.m_41620_(mealCount));
            } else if (outputStack.m_41720_() == mealStack.m_41720_()) {
                mealStack.m_41774_(mealCount);
                containerInputStack.m_41774_(mealCount);
                outputStack.m_41769_(mealCount);
            }
        }
    }

    public ItemStack getMeal() {
        return this.m_8020_(81);
    }

    private boolean doesMealHaveContainer(ItemStack meal) {
        return !this.mealContainerStack.m_41619_() || meal.hasCraftingRemainingItem();
    }

    public boolean isContainerValid(ItemStack containerItem) {
        if (containerItem.m_41619_()) {
            return false;
        }
        return !this.mealContainerStack.m_41619_() ? ItemStack.m_41656_((ItemStack)this.mealContainerStack, (ItemStack)containerItem) : ItemStack.m_41656_((ItemStack)this.getMeal(), (ItemStack)containerItem);
    }

    public ItemStack useHeldItemOnMeal(ItemStack container) {
        if (this.isContainerValid(container) && !this.getMeal().m_41619_()) {
            container.m_41774_(1);
            this.inventoryChanged();
            return this.getMeal().m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, ExtremeCookingPotBlockEntity cookingPot) {
        if (cookingPot.isHeated(level, pos)) {
            double z;
            double y;
            double x;
            RandomSource random = level.f_46441_;
            if (random.m_188501_() < 0.2f) {
                x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
                y = (double)pos.m_123342_() + 0.7;
                z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.6 - 0.3);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123772_, x, y, z, 0.0, 0.0, 0.0);
            }
            if (random.m_188501_() < 0.05f) {
                x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                y = (double)pos.m_123342_() + 0.5;
                z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() * 0.4 - 0.2);
                double motionY = random.m_188499_() ? 0.015 : 0.005;
                level.m_7106_((ParticleOptions)ModParticleTypes.STEAM.get(), x, y, z, 0.0, motionY, 0.0);
            }
        }
    }
}

