/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.item.block.entity;

import committee.nova.mods.avaritiadelight.item.block.ExtremeStoveBlock;
import committee.nova.mods.avaritiadelight.registry.ADBlockEntities;
import committee.nova.mods.avaritiadelight.registry.ADItems;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.block.entity.SyncedBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class ExtremeStoveBlockEntity
extends SyncedBlockEntity {
    private static final VoxelShape GRILLING_AREA = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final int INVENTORY_SLOT_COUNT = 6;
    private final NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    private final int[] cookingTimes = new int[6];
    private final int[] cookingTimesTotal = new int[6];
    private final ResourceLocation[] lastRecipeIDs = new ResourceLocation[6];

    public ExtremeStoveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ADBlockEntities.EXTREME_STOVE.get(), pos, state);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        int[] arrayCookingTimesTotal;
        super.m_142466_(compound);
        this.stacks.clear();
        if (compound.m_128441_("Inventory")) {
            ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("Inventory"), this.stacks);
        } else {
            ContainerHelper.m_18980_((CompoundTag)compound, this.stacks);
        }
        if (compound.m_128425_("CookingTimes", 11)) {
            arrayCookingTimesTotal = compound.m_128465_("CookingTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTimes, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimesTotal.length));
        }
        if (compound.m_128425_("CookingTotalTimes", 11)) {
            arrayCookingTimesTotal = compound.m_128465_("CookingTotalTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTimesTotal, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimesTotal.length));
        }
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        this.writeItems(compound);
        compound.m_128385_("CookingTimes", this.cookingTimes);
        compound.m_128385_("CookingTotalTimes", this.cookingTimesTotal);
    }

    private CompoundTag writeItems(CompoundTag compound) {
        super.m_183515_(compound);
        CompoundTag nbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)nbt, this.stacks);
        compound.m_128365_("Inventory", (Tag)nbt);
        return compound;
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, ExtremeStoveBlockEntity stove) {
        boolean isStoveLit = (Boolean)state.m_61143_((Property)StoveBlock.LIT);
        if (stove.isStoveBlockedAbove()) {
            for (int i = 0; i < stove.stacks.size(); ++i) {
                ItemStack stack = (ItemStack)stove.stacks.get(i);
                if (!stack.m_41619_()) {
                    stove.stacks.set(i, (Object)ItemStack.f_41583_);
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
                stove.inventoryChanged();
            }
        } else {
            stove.cookAndOutputItems(isStoveLit);
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, ExtremeStoveBlockEntity stove) {
        for (int i = 0; i < stove.stacks.size(); ++i) {
            if (((ItemStack)stove.stacks.get(i)).m_41619_() || ((ItemStack)stove.stacks.get(i)).m_150930_((Item)ADItems.COSMIC_BEEF.get()) && !((Boolean)state.m_61143_((Property)ExtremeStoveBlock.LIT)).booleanValue() || !(level.f_46441_.m_188501_() < 0.2f)) continue;
            Vec2 stoveItemVector = stove.getStoveItemOffset(i);
            Direction direction = (Direction)state.m_61143_((Property)StoveBlock.FACING);
            int directionIndex = direction.m_122416_();
            Vec2 offset = directionIndex % 2 == 0 ? stoveItemVector : new Vec2(stoveItemVector.f_82471_, stoveItemVector.f_82470_);
            double x = (double)pos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * offset.f_82470_) + (double)((float)direction.m_122427_().m_122429_() * offset.f_82470_);
            double y = (double)pos.m_123342_() + 1.0;
            double z = (double)pos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * offset.f_82471_) + (double)((float)direction.m_122427_().m_122431_() * offset.f_82471_);
            for (int k = 0; k < 3; ++k) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    private void cookAndOutputItems(boolean lit) {
        if (this.f_58857_ != null) {
            boolean didInventoryChange = false;
            for (int i = 0; i < this.stacks.size(); ++i) {
                ItemStack stoveStack = (ItemStack)this.stacks.get(i);
                if (lit || !stoveStack.m_150930_((Item)ADItems.COSMIC_BEEF.get())) {
                    ItemStack resultStack;
                    if (stoveStack.m_41619_()) continue;
                    int n = i;
                    this.cookingTimes[n] = this.cookingTimes[n] + 1;
                    if (stoveStack.m_150930_((Item)ADItems.COSMIC_BEEF.get())) {
                        if (this.cookingTimes[i] < 200) continue;
                        ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)new ItemStack((ItemLike)ADItems.COSMIC_BEEF_COOKED.get()), (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (double)(this.f_58857_.f_46441_.m_188583_() * (double)0.01f), (double)0.1f, (double)(this.f_58857_.f_46441_.m_188583_() * (double)0.01f));
                        this.stacks.set(i, (Object)ItemStack.f_41583_);
                        didInventoryChange = true;
                        continue;
                    }
                    if (this.cookingTimes[i] < 20) continue;
                    SimpleContainer inventoryWrapper = new SimpleContainer(new ItemStack[]{stoveStack});
                    Optional<CampfireCookingRecipe> recipe = this.getMatchingRecipe((Container)inventoryWrapper, i);
                    if (recipe.isPresent() && !(resultStack = recipe.get().m_8043_(this.f_58857_.m_9598_())).m_41619_()) {
                        ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)resultStack.m_41777_(), (double)((double)this.f_58858_.m_123341_() + 0.5), (double)((double)this.f_58858_.m_123342_() + 1.0), (double)((double)this.f_58858_.m_123343_() + 0.5), (double)(this.f_58857_.f_46441_.m_188583_() * (double)0.01f), (double)0.1f, (double)(this.f_58857_.f_46441_.m_188583_() * (double)0.01f));
                    }
                    this.stacks.set(i, (Object)ItemStack.f_41583_);
                    didInventoryChange = true;
                    continue;
                }
                if (this.cookingTimes[i] <= 0) continue;
                this.cookingTimes[i] = Mth.m_14045_((int)(this.cookingTimes[i] - 2), (int)0, (int)this.cookingTimesTotal[i]);
            }
            if (didInventoryChange) {
                this.inventoryChanged();
            }
        }
    }

    public int getNextEmptySlot() {
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack slotStack = (ItemStack)this.stacks.get(i);
            if (!slotStack.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public boolean addItem(ItemStack itemStackIn, CampfireCookingRecipe recipe, int slot) {
        ItemStack slotStack;
        if (0 <= slot && slot < this.stacks.size() && (slotStack = (ItemStack)this.stacks.get(slot)).m_41619_()) {
            this.cookingTimesTotal[slot] = recipe.m_43753_();
            this.cookingTimes[slot] = 0;
            this.stacks.set(slot, (Object)itemStackIn.m_41620_(1));
            this.lastRecipeIDs[slot] = recipe.m_6423_();
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public Optional<CampfireCookingRecipe> getMatchingRecipe(Container recipeWrapper, int slot) {
        Recipe recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeIDs[slot] != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap(RecipeType.f_44111_).get(this.lastRecipeIDs[slot])) instanceof CampfireCookingRecipe) {
            CampfireCookingRecipe cookingRecipe = (CampfireCookingRecipe)recipe;
            if (recipe.m_5818_(recipeWrapper, this.f_58857_)) {
                return Optional.of(cookingRecipe);
            }
        }
        return this.f_58857_.m_7465_().m_44015_(RecipeType.f_44111_, recipeWrapper, this.f_58857_);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.stacks;
    }

    public boolean isStoveBlockedAbove() {
        if (this.f_58857_ != null) {
            BlockState above = this.f_58857_.m_8055_(this.f_58858_.m_7494_());
            return Shapes.m_83157_((VoxelShape)GRILLING_AREA, (VoxelShape)above.m_60808_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()), (BooleanOp)BooleanOp.f_82689_);
        }
        return false;
    }

    public Vec2 getStoveItemOffset(int index) {
        Vec2[] OFFSETS = new Vec2[]{new Vec2(0.3f, 0.2f), new Vec2(0.0f, 0.2f), new Vec2(-0.3f, 0.2f), new Vec2(0.3f, -0.2f), new Vec2(0.0f, -0.2f), new Vec2(-0.3f, -0.2f)};
        return OFFSETS[index];
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.writeItems(new CompoundTag());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

