/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.item.block.entity;

import committee.nova.mods.avaritiadelight.registry.ADBlockEntities;
import committee.nova.mods.avaritiadelight.screen.handler.InfinityCabinetScreenHandler;
import committee.nova.mods.avaritiadelight.util.ImplementedInventory;
import committee.nova.mods.avaritiadelight.util.InventoryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityCabinetBlockEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory,
Nameable {
    private final ContainerOpenersCounter viewerCountManager;
    private final NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)243, (Object)ItemStack.f_41583_);
    @Nullable
    private Component customName = null;

    public InfinityCabinetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ADBlockEntities.INFINITY_CABINET.get(), pos, state);
        this.viewerCountManager = new ContainerOpenersCounter(){

            protected void m_142292_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
                InfinityCabinetBlockEntity.this.playSound(state, SoundEvents.f_11725_);
                InfinityCabinetBlockEntity.this.setOpen(state, true);
            }

            protected void m_142289_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
                InfinityCabinetBlockEntity.this.playSound(state, SoundEvents.f_11724_);
                InfinityCabinetBlockEntity.this.setOpen(state, false);
            }

            protected void m_142148_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, int oldViewerCount, int newViewerCount) {
            }

            protected boolean m_142718_(@NotNull Player player) {
                InfinityCabinetScreenHandler handler;
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                return abstractContainerMenu instanceof InfinityCabinetScreenHandler && (handler = (InfinityCabinetScreenHandler)abstractContainerMenu).getInventory() == InfinityCabinetBlockEntity.this;
            }
        };
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.stacks.clear();
        InventoryHelper.readNbt(nbt.m_128469_("Items"), this.stacks);
        if (nbt.m_128441_("CustomName")) {
            this.customName = Component.Serializer.m_130701_((String)nbt.m_128461_("CustomName"));
        }
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Items", (Tag)InventoryHelper.writeNbt(new CompoundTag(), this.stacks));
        if (this.customName != null) {
            nbt.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    @NotNull
    public Component m_7755_() {
        return this.customName;
    }

    @NotNull
    public Component m_5446_() {
        return this.customName != null ? this.customName : Component.m_237115_((String)"block.%s.infinity_cabinet".formatted("avaritia_delight"));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new InfinityCabinetScreenHandler(syncId, this, playerInventory);
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public void setCustomName(@Nullable Component customName) {
        this.customName = customName;
    }

    @Override
    public boolean m_6542_(@NotNull Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public int m_6893_() {
        return Integer.MAX_VALUE;
    }

    public void m_5856_(@NotNull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.viewerCountManager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(@NotNull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.viewerCountManager.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void tick() {
        if (!this.f_58859_) {
            this.viewerCountManager.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    private void setOpen(BlockState state, boolean open) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(open)), 3);
    }

    private void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)BarrelBlock.f_49042_)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        assert (this.f_58857_ != null);
        this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

