/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CropExtractorRecipe
implements Recipe<Container> {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"avaritia_delight", (String)"crop_extractor");
    private final ResourceLocation id;
    private final Ingredient input;
    private final List<ItemStack> outputs;
    private final int time;

    public CropExtractorRecipe(ResourceLocation id, Ingredient input, List<ItemStack> outputs, int time) {
        this.id = id;
        this.input = input;
        this.outputs = outputs;
        this.time = time;
    }

    public boolean m_5818_(Container inventory, @NotNull Level world) {
        return this.input.test(inventory.m_8020_(0));
    }

    @Deprecated
    @NotNull
    public ItemStack m_5874_(@NotNull Container inventory, @NotNull RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public int getTime() {
        return this.time;
    }

    public boolean m_8004_(int width, int height) {
        return width * height > 0;
    }

    @Deprecated
    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registryManager) {
        return ItemStack.f_41583_;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static enum Serializer implements RecipeSerializer<CropExtractorRecipe>
    {
        INSTANCE;


        @NotNull
        public CropExtractorRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"ingredient"));
            List<ItemStack> outputs = GsonHelper.m_13933_((JsonObject)json, (String)"results").asList().stream().map(JsonElement::getAsJsonObject).map(ShapedRecipe::m_151274_).toList();
            int time = GsonHelper.m_13824_((JsonObject)json, (String)"time", (int)200);
            return new CropExtractorRecipe(id, input, outputs, time);
        }

        public CropExtractorRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            NonNullList outputs = NonNullList.m_122780_((int)buf.m_130242_(), (Object)ItemStack.f_41583_);
            outputs.replaceAll(ignored -> buf.m_130267_());
            int cookTimeIn = buf.readInt();
            return new CropExtractorRecipe(id, input, (List<ItemStack>)outputs, cookTimeIn);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, CropExtractorRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.writeInt(recipe.outputs.size());
            for (ItemStack stack : recipe.outputs) {
                buf.m_130055_(stack);
            }
            buf.writeInt(recipe.time);
        }
    }

    public static enum Type implements RecipeType<CropExtractorRecipe>
    {
        INSTANCE;

    }
}

