/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import committee.nova.mods.avaritiadelight.mixin.ShapedRecipeAccessor;
import committee.nova.mods.avaritiadelight.recipe.ExtremeCookingPotRecipe;
import committee.nova.mods.avaritiadelight.registry.ADBlocks;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ExtremeCookingPotShapedRecipe
implements ExtremeCookingPotRecipe {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"avaritia_delight", (String)"extreme_cooking_shaped");
    private final ResourceLocation id;
    private final String group;
    private final int width;
    private final int height;
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ItemStack container;
    private final int cookTime;

    public ExtremeCookingPotShapedRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> inputItems, ItemStack output, ItemStack container, int cookTime) {
        this.id = id;
        this.group = group;
        this.width = width;
        this.height = height;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.m_41619_() ? container : (output.hasCraftingRemainingItem() ? output.getCraftingRemainingItem() : ItemStack.f_41583_);
        this.cookTime = cookTime;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        return this.output;
    }

    @Override
    public ItemStack getOutputContainer() {
        return this.container;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container inv, @NotNull RegistryAccess access) {
        return this.output.m_41777_();
    }

    @Override
    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    public boolean shapeless() {
        return false;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    public boolean m_5818_(@NotNull Container inv, @NotNull Level level) {
        for (int i = 0; i <= 9 - this.width; ++i) {
            for (int j = 0; j <= 9 - this.height; ++j) {
                if (this.checkMatch(inv, i, j, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(Container inventory, int x, int y, boolean mirror) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int k = i - x;
                int l = j - y;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    Ingredient ingredient2 = ingredient = mirror ? (Ingredient)this.inputItems.get(this.width - k - 1 + l * this.width) : (Ingredient)this.inputItems.get(k + l * this.width);
                }
                if (ingredient.test(inventory.m_8020_(i + j * 9))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean m_8004_(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ADBlocks.EXTREME_COOKING_POT.get());
    }

    public static enum Serializer implements RecipeSerializer<ExtremeCookingPotShapedRecipe>
    {
        INSTANCE;


        @NotNull
        public ExtremeCookingPotShapedRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> map = ShapedRecipeAccessor.avaritia_delight$keyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] strings = ShapedRecipeAccessor.avaritia_delight$shrink(Serializer.getPattern(GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = strings[0].length();
            int height = strings.length;
            NonNullList<Ingredient> inputs = ShapedRecipeAccessor.avaritia_delight$dissolvePattern(strings, map, width, height);
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ItemStack container = GsonHelper.m_13900_((JsonObject)json, (String)"container") ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container")) : ItemStack.f_41583_;
            int cookTime = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)200);
            return new ExtremeCookingPotShapedRecipe(recipeId, group, width, height, inputs, output, container, cookTime);
        }

        static String[] getPattern(JsonArray json) {
            String[] strings = new String[json.size()];
            if (strings.length > 9) {
                throw new JsonSyntaxException("Invalid pattern: too many rows, 9 is maximum");
            }
            if (strings.length == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            for (int i = 0; i < strings.length; ++i) {
                String string = GsonHelper.m_13805_((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
                if (string.length() > 9) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, 9 is maximum");
                }
                if (i > 0 && strings[0].length() != string.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
                }
                strings[i] = string;
            }
            return strings;
        }

        @NotNull
        public ExtremeCookingPotShapedRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buf) {
            String groupIn = buf.m_130277_();
            int width = buf.readInt();
            int height = buf.readInt();
            NonNullList inputItemsIn = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            inputItemsIn.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack outputIn = buf.m_130267_();
            ItemStack container = buf.m_130267_();
            int cookTimeIn = buf.m_130242_();
            return new ExtremeCookingPotShapedRecipe(recipeId, groupIn, width, height, (NonNullList<Ingredient>)inputItemsIn, outputIn, container, cookTimeIn);
        }

        public void toNetwork(FriendlyByteBuf buf, ExtremeCookingPotShapedRecipe recipe) {
            buf.m_130070_(recipe.group);
            buf.writeInt(recipe.width);
            buf.writeInt(recipe.height);
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.output);
            buf.m_130055_(recipe.container);
            buf.m_130130_(recipe.cookTime);
        }
    }

    public static enum Type implements RecipeType<ExtremeCookingPotShapedRecipe>
    {
        INSTANCE;

    }
}

