/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import committee.nova.mods.avaritiadelight.recipe.ExtremeCookingPotRecipe;
import committee.nova.mods.avaritiadelight.registry.ADBlocks;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ExtremeCookingPotShapelessRecipe
implements ExtremeCookingPotRecipe {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"avaritia_delight", (String)"extreme_cooking_shapeless");
    private final ResourceLocation id;
    private final String group;
    private final NonNullList<Ingredient> inputItems;
    private final ItemStack output;
    private final ItemStack container;
    private final int cookTime;

    public ExtremeCookingPotShapelessRecipe(ResourceLocation id, String group, NonNullList<Ingredient> inputItems, ItemStack output, ItemStack container, int cookTime) {
        this.id = id;
        this.group = group;
        this.inputItems = inputItems;
        this.output = output;
        this.container = !container.m_41619_() ? container : (output.hasCraftingRemainingItem() ? output.getCraftingRemainingItem() : ItemStack.f_41583_);
        this.cookTime = cookTime;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public String m_6076_() {
        return this.group;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputItems;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess access) {
        return this.output;
    }

    @Override
    public ItemStack getOutputContainer() {
        return this.container;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container inv, @NotNull RegistryAccess access) {
        return this.output.m_41777_();
    }

    @Override
    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    public boolean shapeless() {
        return true;
    }

    @Override
    public int width() {
        return 9;
    }

    @Override
    public int height() {
        return 9;
    }

    public boolean m_5818_(@NotNull Container inv, @NotNull Level level) {
        StackedContents stackedContents = new StackedContents();
        int i = 0;
        for (int j = 0; j < 81; ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            stackedContents.m_36468_(itemstack, 1);
        }
        return i == this.inputItems.size() && stackedContents.m_36475_((Recipe)this, null);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ADBlocks.EXTREME_COOKING_POT.get());
    }

    public static enum Serializer implements RecipeSerializer<ExtremeCookingPotShapelessRecipe>
    {
        INSTANCE;


        @NotNull
        public ExtremeCookingPotShapelessRecipe fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            String groupIn = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for cooking recipe");
            }
            if (inputItemsIn.size() > 81) {
                throw new JsonParseException("Too many ingredients for cooking recipe! The max is 81");
            }
            ItemStack outputIn = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            ItemStack container = GsonHelper.m_13900_((JsonObject)json, (String)"container") ? ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container")) : ItemStack.f_41583_;
            int cookTimeIn = GsonHelper.m_13824_((JsonObject)json, (String)"cookingtime", (int)200);
            return new ExtremeCookingPotShapelessRecipe(recipeId, groupIn, inputItemsIn, outputIn, container, cookTimeIn);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList ingredients = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }

        @NotNull
        public ExtremeCookingPotShapelessRecipe fromNetwork(@NotNull ResourceLocation recipeId, FriendlyByteBuf buf) {
            String groupIn = buf.m_130277_();
            NonNullList inputItemsIn = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            inputItemsIn.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack outputIn = buf.m_130267_();
            ItemStack container = buf.m_130267_();
            int cookTimeIn = buf.m_130242_();
            return new ExtremeCookingPotShapelessRecipe(recipeId, groupIn, (NonNullList<Ingredient>)inputItemsIn, outputIn, container, cookTimeIn);
        }

        public void toNetwork(FriendlyByteBuf buf, ExtremeCookingPotShapelessRecipe recipe) {
            buf.m_130070_(recipe.group);
            buf.m_130130_(recipe.inputItems.size());
            for (Ingredient ingredient : recipe.inputItems) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.output);
            buf.m_130055_(recipe.container);
            buf.m_130130_(recipe.cookTime);
        }
    }

    public static enum Type implements RecipeType<ExtremeCookingPotShapelessRecipe>
    {
        INSTANCE;

    }
}

