/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritiadelight.util;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class InventoryHelper {
    public static CompoundTag writeNbt(CompoundTag nbt, NonNullList<ItemStack> stacks) {
        return InventoryHelper.writeNbt(nbt, stacks, true);
    }

    public static CompoundTag writeNbt(CompoundTag nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        ListTag nbtList = new ListTag();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemStack = (ItemStack)stacks.get(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag nbtCompound = new CompoundTag();
            nbtCompound.m_128344_("Slot", (byte)i);
            InventoryHelper.writeStackNbt(itemStack, nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        if (!nbtList.isEmpty() || setIfEmpty) {
            nbt.m_128365_("Items", (Tag)nbtList);
        }
        return nbt;
    }

    public static void readNbt(CompoundTag nbt, NonNullList<ItemStack> stacks) {
        ListTag nbtList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int j = nbtCompound.m_128445_("Slot") & 0xFF;
            if (j >= stacks.size()) continue;
            stacks.set(j, (Object)InventoryHelper.readStackNbt(nbtCompound));
        }
    }

    private static ItemStack readStackNbt(CompoundTag nbt) {
        ItemStack stack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(ResourceLocation.m_135820_((String)nbt.m_128461_("id"))), nbt.m_128451_("Count"));
        if (nbt.m_128425_("tag", 10)) {
            stack.m_41751_(nbt.m_128469_("tag"));
            stack.m_41720_().m_142312_(stack.m_41783_());
        }
        return stack;
    }

    private static void writeStackNbt(ItemStack stack, CompoundTag nbt) {
        ResourceLocation identifier = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        nbt.m_128359_("id", identifier.toString());
        nbt.m_128405_("Count", stack.m_41613_());
        if (stack.m_41783_() != null) {
            nbt.m_128365_("tag", (Tag)stack.m_41783_().m_6426_());
        }
    }

    public static boolean canInsertItems(int start, Container inventory, List<ItemStack> insert) {
        return InventoryHelper.insertItems(start, InventoryHelper.copy(inventory), insert);
    }

    public static boolean insertItems(int start, Container inventory, List<ItemStack> insert) {
        for (ItemStack insertStack : insert) {
            if (insertStack == null || InventoryHelper.tryAddItemToInventory(start, inventory, insertStack.m_41777_())) continue;
            return false;
        }
        return true;
    }

    private static boolean tryAddItemToInventory(int start, Container inventory, ItemStack stack) {
        if (stack.m_41619_()) {
            return true;
        }
        for (int i = start; i < inventory.m_6643_(); ++i) {
            ItemStack inventoryStack = inventory.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)inventoryStack, (ItemStack)stack) || stack.m_41741_() - inventoryStack.m_41613_() <= 0) continue;
            int countToAdd = Math.min(stack.m_41613_(), stack.m_41741_() - inventoryStack.m_41613_());
            inventoryStack.m_41769_(countToAdd);
            stack.m_41774_(countToAdd);
            if (stack.m_41613_() != 0) continue;
            return true;
        }
        if (inventory instanceof Inventory) {
            Inventory playerInventory = (Inventory)inventory;
            playerInventory.m_150079_(stack);
            return true;
        }
        for (int i = start; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            inventory.m_6836_(i, stack);
            return true;
        }
        return false;
    }

    public static Container copy(Container another) {
        SimpleContainer inventory = new SimpleContainer(another.m_6643_());
        for (int i = 0; i < another.m_6643_(); ++i) {
            inventory.m_6836_(i, another.m_8020_(i).m_41777_());
        }
        return inventory;
    }
}

