/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client.internal;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.util.Named;
import com.lightstreamer.client.LSSubscription;
import com.lightstreamer.client.internal.ClientMachine;
import com.lightstreamer.client.internal.ModeStrategy;
import com.lightstreamer.client.internal.ModeStrategyCommand1Level;
import com.lightstreamer.client.internal.ModeStrategyCommand2Level;
import com.lightstreamer.client.internal.ModeStrategyDistinct;
import com.lightstreamer.client.internal.ModeStrategyMerge;
import com.lightstreamer.client.internal.ModeStrategyRaw;
import com.lightstreamer.client.internal.SubscriptionManager;
import com.lightstreamer.internal.NullTools;
import com.lightstreamer.internal.RLock;
import com.lightstreamer.internal.RealMaxFrequency;
import com.lightstreamer.internal.RequestBuilder;
import com.lightstreamer.internal.RequestedBufferSize;
import com.lightstreamer.internal.RequestedMaxFrequency;
import com.lightstreamer.internal.RequestedMaxFrequencyTools;
import com.lightstreamer.internal.RequestedSnapshot;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.ds.IntMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Std;
import java.net.ProtocolFamily;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.AttributeView;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;

@ClassReflectionInformation(hasSuperClass=false)
public class SubscriptionManagerLiving
extends haxe.jvm.Object
implements SubscriptionManager {
    public int subId;
    public LSSubscription m_subscription;
    public ModeStrategy m_strategy;
    public Integer m_lastAddReqId;
    public Integer m_lastDeleteReqId;
    public Integer m_lastReconfReqId;
    public RequestedMaxFrequency m_currentMaxFrequency;
    public RequestedMaxFrequency m_reqMaxFrequency;
    public ClientMachine m_client;
    public RLock lock;
    public SubscriptionManager.State state;

    public static boolean is2LevelCommand(LSSubscription sub) {
        if (Jvm.stringCompare(sub.fetch_mode(), "COMMAND") == 0) {
            if (sub.getCommandSecondLevelFields() == null) {
                return sub.getCommandSecondLevelFieldSchema() != null;
            }
            return true;
        }
        return false;
    }

    public void finalize() {
        this.m_strategy.evtDispose();
        this.m_client.unrelateSubManager(this);
        this.m_subscription.unrelate(this);
    }

    public void evtExtSubscribe() {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtExtSubscribe_0(_gthis));
    }

    public void evtExtUnsubscribe() {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtExtUnsubscribe_0(_gthis));
    }

    @Override
    public void evtExtAbort() {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtExtAbort_0(_gthis));
    }

    @Override
    public void evtREQERR(int reqId, int code, String msg) {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtREQERR_0(_gthis, reqId, code, msg));
    }

    @Override
    public void evtREQOK(int reqId) {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtREQOK_0(_gthis, reqId));
    }

    public boolean checkItems(Integer expItems, int nItems) {
        if (expItems != null) {
            Integer n = expItems;
            return n == null ? false : Jvm.toInt(n) == nItems;
        }
        return true;
    }

    public boolean checkFields(Integer expFields, int nFields) {
        if (expFields != null) {
            Integer n = expFields;
            return n == null ? false : Jvm.toInt(n) == nFields;
        }
        return true;
    }

    public boolean checkItemsAndFields(Integer expItems, Integer expFields, int nItems, int nFields) {
        if (this.checkItems(expItems, nItems)) {
            return this.checkFields(expFields, nFields);
        }
        return false;
    }

    @Override
    public void evtSUBOK(int nItems, int nFields) {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtSUBOK_0(_gthis, nItems, nFields));
    }

    @Override
    public void evtSUBCMD(int nItems, int nFields, int keyIdx, int cmdIdx) {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtSUBCMD_0(_gthis, nItems, nFields, cmdIdx, keyIdx));
    }

    @Override
    public void evtUNSUB() {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtUNSUB_0(_gthis));
    }

    @Override
    public void evtU(int itemIdx, IntMap values2) {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtU_0(_gthis, itemIdx, values2));
    }

    @Override
    public void evtEOS(int itemIdx) {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtEOS_0(_gthis, itemIdx));
    }

    @Override
    public void evtCS(int itemIdx) {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtCS_0(_gthis, itemIdx));
    }

    @Override
    public void evtOV(int itemIdx, int lostUpdates) {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtOV_0(_gthis, itemIdx, lostUpdates));
    }

    @Override
    public void evtCONF(RealMaxFrequency freq) {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtCONF_0(_gthis, freq));
    }

    public void evtCheckFrequency() {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtCheckFrequency_0(_gthis));
    }

    public void evtExtConfigure() {
        SubscriptionManagerLiving _gthis = this;
        this.lock.synchronized(new Closure_evtExtConfigure_0(_gthis));
    }

    @Override
    public boolean isPending() {
        SubscriptionManagerLiving _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_isPending_0(_gthis)));
    }

    @Override
    public String encode(boolean isWS) {
        SubscriptionManagerLiving _gthis = this;
        return (String)this.lock.synchronized(new Closure_encode_0(_gthis, isWS));
    }

    @Override
    public String encodeWS() {
        SubscriptionManagerLiving _gthis = this;
        return (String)this.lock.synchronized(new Closure_encodeWS_0(_gthis));
    }

    public String getValue(int itemPos, int fieldPos) {
        SubscriptionManagerLiving _gthis = this;
        return (String)this.lock.synchronized(new Closure_getValue_0(_gthis, itemPos, fieldPos));
    }

    public String getCommandValue(int itemPos, String key, int fieldPos) {
        SubscriptionManagerLiving _gthis = this;
        return (String)this.lock.synchronized(new Closure_getCommandValue_0(_gthis, itemPos, key, fieldPos));
    }

    public String encodeAdd(boolean isWS) {
        RequestedBufferSize buff;
        RequestedMaxFrequency freq;
        RequestedSnapshot snapshot;
        String selector;
        RequestBuilder req = new RequestBuilder();
        this.m_lastAddReqId = this.m_client.generateFreshReqId();
        req.LS_reqId(Jvm.toInt(this.m_lastAddReqId));
        req.LS_op("add");
        req.LS_subId(this.subId);
        req.LS_mode(this.m_subscription.fetch_mode());
        String group = this.m_subscription.getItemGroup();
        Array items = this.m_subscription.fetchItems();
        if (group != null) {
            req.LS_group(group);
        } else if (items != null) {
            req.LS_group(items.join(" "));
        }
        String schema = this.m_subscription.getFieldSchema();
        Array fields = this.m_subscription.fetchFields();
        if (schema != null) {
            req.LS_schema(schema);
        } else if (fields != null) {
            req.LS_schema(fields.join(" "));
        }
        String adapter = this.m_subscription.getDataAdapter();
        if (adapter != null) {
            req.LS_data_adapter(adapter);
        }
        if ((selector = this.m_subscription.getSelector()) != null) {
            req.LS_selector(selector);
        }
        if ((snapshot = this.m_subscription.fetch_requestedSnapshot()) != null) {
            switch (snapshot.ordinal()) {
                case 0: {
                    req.LS_snapshot(true);
                    break;
                }
                case 1: {
                    req.LS_snapshot(false);
                    break;
                }
                case 2: {
                    req.LS_snapshot_Int(((RequestedSnapshot.SnpLength)snapshot).len);
                }
            }
        }
        if ((freq = this.m_currentMaxFrequency) != null) {
            switch (freq.ordinal()) {
                case 0: {
                    req.LS_requested_max_frequency_Float(((RequestedMaxFrequency.FreqLimited)freq).max);
                    break;
                }
                case 1: {
                    req.LS_requested_max_frequency("unlimited");
                    break;
                }
                case 2: {
                    req.LS_requested_max_frequency("unfiltered");
                }
            }
        }
        if ((buff = this.m_subscription.fetch_requestedBufferSize()) != null) {
            switch (buff.ordinal()) {
                case 0: {
                    req.LS_requested_buffer_size_Int(((RequestedBufferSize.BSLimited)buff).size);
                    break;
                }
                case 1: {
                    req.LS_requested_buffer_size("unlimited");
                }
            }
        }
        if (isWS) {
            req.LS_ack(false);
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending Subscription add: " + Std.string(req), null);
        }
        return req.getEncodedString();
    }

    public String encodeDelete(boolean isWS) {
        RequestBuilder req = new RequestBuilder();
        this.m_lastDeleteReqId = this.m_client.generateFreshReqId();
        req.LS_reqId(Jvm.toInt(this.m_lastDeleteReqId));
        req.LS_subId(this.subId);
        req.LS_op("delete");
        if (isWS) {
            req.LS_ack(false);
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending Subscription delete: " + Std.string(req), null);
        }
        return req.getEncodedString();
    }

    public String encodeReconf(boolean isWS) {
        RequestBuilder req = new RequestBuilder();
        this.m_lastReconfReqId = this.m_client.generateFreshReqId();
        req.LS_reqId(Jvm.toInt(this.m_lastReconfReqId));
        req.LS_subId(this.subId);
        req.LS_op("reconf");
        RequestedMaxFrequency freq = this.m_reqMaxFrequency;
        if (freq != null) {
            switch (freq.ordinal()) {
                case 0: {
                    req.LS_requested_max_frequency_Float(((RequestedMaxFrequency.FreqLimited)freq).max);
                    break;
                }
                case 1: {
                    req.LS_requested_max_frequency("unlimited");
                    break;
                }
                case 2: {
                    req.LS_requested_max_frequency("unfiltered");
                }
            }
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending Subscription configuration: " + Std.string(req), null);
        }
        return req.getEncodedString();
    }

    public void doSetActive() {
        this.m_subscription.setActive();
    }

    public void doSetInactive() {
        this.m_subscription.setInactive();
    }

    public void doSubscribe() {
        this.m_currentMaxFrequency = this.m_subscription.fetch_requestedMaxFrequency();
    }

    public void doUnsubscribe() {
        this.m_strategy.evtUnsubscribe();
        this.m_subscription.unrelate(this);
    }

    public void doAbort() {
        this.m_lastAddReqId = null;
        this.m_lastDeleteReqId = null;
        this.m_lastReconfReqId = null;
        this.m_reqMaxFrequency = null;
        this.m_currentMaxFrequency = this.m_subscription.fetch_requestedMaxFrequency();
        this.m_strategy.evtAbort();
    }

    public void genSendControl() {
        this.m_client.evtSendControl(this);
    }

    public void notifyOnSubscription() {
        this.m_subscription.fireOnSubscription(this.subId);
    }

    public void notifyOnUnsubscription() {
        this.m_subscription.fireOnUnsubscription(this.subId);
    }

    public void notifyOnSubscriptionError(int code, String msg) {
        this.m_subscription.fireOnSubscriptionError(this.subId, code, msg);
    }

    public void notifyOnSubscriptionError_CountMismatch(Integer expItems, Integer expFields, int nItems, int nFields) {
        if (!this.checkItems(expItems, nItems)) {
            this.m_subscription.fireOnSubscriptionError(this.subId, 61, "Expected " + expItems + " items but got " + nItems);
            return;
        }
        this.m_subscription.fireOnSubscriptionError(this.subId, 61, "Expected " + expFields + " fields but got " + nFields);
    }

    public void doConfigure() {
        this.m_reqMaxFrequency = this.m_subscription.fetch_requestedMaxFrequency();
        this.m_strategy.evtSetRequestedMaxFrequency(this.m_reqMaxFrequency);
    }

    public void doREQOKConfigure() {
        this.m_currentMaxFrequency = this.m_reqMaxFrequency;
    }

    public void doSUBOK(int nItems, int nFields) {
        this.m_subscription.setSubscribed(this.subId, nItems, nFields);
        this.m_strategy.evtOnSUB(nItems, nFields, null, null, null);
    }

    public void doSUBCMD(int nItems, int nFields, int cmdIdx, int keyIdx) {
        this.m_subscription.setSubscribedCMD(this.subId, nItems, nFields, cmdIdx, keyIdx);
        this.m_strategy.evtOnSUB(nItems, nFields, cmdIdx, keyIdx, this.m_currentMaxFrequency);
    }

    public void doUNSUB() {
        this.m_strategy.evtOnUNSUB();
    }

    public void doU(int itemIdx, IntMap values2) throws IllegalStateException {
        if (itemIdx > Jvm.toInt(NullTools.sure(this.m_subscription.fetch_nItems()))) {
            throw new IllegalStateException("Assertion failure: " + "itemIdx <= m_subscription.fetch_nItems().sure()");
        }
        this.m_strategy.evtUpdate(itemIdx, values2);
    }

    public void doEOS(int itemIdx) {
        this.m_strategy.evtOnEOS(itemIdx);
        this.m_subscription.fireOnEndOfSnapshot(itemIdx, this.subId);
    }

    public void doCS(int itemIdx) {
        this.m_strategy.evtOnCS(itemIdx);
        this.m_subscription.fireOnClearSnapshot(itemIdx, this.subId);
    }

    public void doOV(int itemIdx, int lostUpdates) {
        this.m_subscription.fireOnLostUpdates(itemIdx, lostUpdates, this.subId);
    }

    public void doCONF(RealMaxFrequency freq) {
        this.m_strategy.evtOnCONF(freq);
    }

    public void traceEvent(String evt) {
        if (LoggerTools_Fields_.internalLogger.isTraceEnabled()) {
            LoggerTools_Fields_.internalLogger.trace("sub#" + evt + "(" + this.subId + ") in " + Std.string(this.state), null);
        }
    }

    public SubscriptionManagerLiving(LSSubscription sub, ClientMachine client) {
        this.lock = client.lock;
        this.subId = client.generateFreshSubId();
        ModeStrategy tmp = null;
        String _hx_tmp = sub.fetch_mode();
        if (_hx_tmp != null) {
            switch (_hx_tmp.hashCode()) {
                case 80904: {
                    if (!_hx_tmp.equals("RAW")) break;
                    tmp = new ModeStrategyRaw(sub, client, this.subId);
                    break;
                }
                case 73247768: {
                    if (!_hx_tmp.equals("MERGE")) break;
                    tmp = new ModeStrategyMerge(sub, client, this.subId);
                    break;
                }
                case 1071324924: {
                    if (!_hx_tmp.equals("DISTINCT")) break;
                    tmp = new ModeStrategyDistinct(sub, client, this.subId);
                    break;
                }
                case 1668377387: {
                    if (!_hx_tmp.equals("COMMAND")) break;
                    tmp = SubscriptionManagerLiving.is2LevelCommand(sub) ? (ModeStrategy)new ModeStrategyCommand2Level(sub, client, this.subId) : (ModeStrategy)new ModeStrategyCommand1Level(sub, client, this.subId);
                    break;
                }
            }
        }
        this.m_strategy = tmp;
        this.state = new SubscriptionManager.State(this.subId);
        this.m_client = client;
        this.m_subscription = sub;
        this.m_client.relateSubManager(this);
        this.m_subscription.relate(this);
    }

    public /* synthetic */ SubscriptionManagerLiving(EmptyConstructor _) {
    }

    public static final class Closure_evtExtConfigure_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;

        public Closure_evtExtConfigure_0(SubscriptionManagerLiving _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("configure");
            Integer n = this._gthis.state.s_c;
            if (n == null ? false : Jvm.toInt(n) == 21) {
                this._gthis.state.s_c = 20;
                this._gthis.state.traceState();
                this._gthis.evtCheckFrequency();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtExtAbort_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;

        public Closure_evtExtAbort_0(SubscriptionManagerLiving _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("abort");
            if (this._gthis.state.s_m == 2) {
                this._gthis.state.s_m = 2;
                this._gthis.state.traceState();
                return;
            }
            if (this._gthis.state.s_m == 3) {
                this._gthis.doAbort();
                this._gthis.doSetActive();
                this._gthis.state.s_m = 2;
                this._gthis.state.traceState();
                return;
            }
            Integer n = this._gthis.state.s_s;
            if (n == null ? false : Jvm.toInt(n) == 10) {
                this._gthis.doAbort();
                this._gthis.doSetActive();
                this._gthis.notifyOnUnsubscription();
                this._gthis.state.s_s = null;
                this._gthis.state.s_c = null;
                this._gthis.state.s_m = 2;
                this._gthis.state.traceState();
                return;
            }
            if (this._gthis.state.s_m == 5) {
                this._gthis.finalize();
                this._gthis.state.s_m = 32;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtUNSUB_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;

        public Closure_evtUNSUB_0(SubscriptionManagerLiving _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("UNSUB");
            Integer n = this._gthis.state.s_s;
            if (n == null ? false : Jvm.toInt(n) == 10) {
                this._gthis.doUNSUB();
                this._gthis.doSetInactive();
                this._gthis.notifyOnUnsubscription();
                this._gthis.finalize();
                this._gthis.state.s_m = 31;
                this._gthis.state.s_s = null;
                this._gthis.state.s_c = null;
                this._gthis.state.traceState();
                return;
            }
            if (this._gthis.state.s_m == 5) {
                this._gthis.finalize();
                this._gthis.state.s_m = 32;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtCS_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;
        public final int itemIdx;

        /*
         * WARNING - void declaration
         */
        public Closure_evtCS_0(SubscriptionManagerLiving _gthis, int n) {
            void itemIdx;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("CS");
            Integer n = this._gthis.state.s_s;
            if (n == null ? false : Jvm.toInt(n) == 10) {
                this._gthis.doCS(this.itemIdx);
                this._gthis.state.s_s = 10;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtOV_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;
        public final int itemIdx;
        public final int lostUpdates;

        /*
         * WARNING - void declaration
         */
        public Closure_evtOV_0(SubscriptionManagerLiving _gthis, int n, int n2) {
            void lostUpdates;
            void itemIdx;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
            this.lostUpdates = lostUpdates;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("OV");
            Integer n = this._gthis.state.s_s;
            if (n == null ? false : Jvm.toInt(n) == 10) {
                this._gthis.doOV(this.itemIdx, this.lostUpdates);
                this._gthis.state.s_s = 10;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_isPending_0
    extends Function
    implements PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final SubscriptionManagerLiving _gthis;

        public Closure_isPending_0(SubscriptionManagerLiving _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            if (this._gthis.state.s_m != 2 && this._gthis.state.s_m != 5) {
                Integer n = this._gthis.state.s_c;
                return n == null ? false : Jvm.toInt(n) == 22;
            }
            return true;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtExtSubscribe_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;

        public Closure_evtExtSubscribe_0(SubscriptionManagerLiving _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("subscribe");
            if (this._gthis.state.s_m == 1) {
                this._gthis.doSetActive();
                this._gthis.doSubscribe();
                this._gthis.state.s_m = 2;
                this._gthis.state.traceState();
                this._gthis.genSendControl();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtREQOK_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;
        public final int reqId;

        /*
         * WARNING - void declaration
         */
        public Closure_evtREQOK_0(SubscriptionManagerLiving _gthis, int n) {
            void reqId;
            this._gthis = _gthis;
            this.reqId = reqId;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("REQOK");
            if (this._gthis.state.s_m == 2) {
                Integer n = this._gthis.m_lastAddReqId;
                if (n == null ? false : this.reqId == Jvm.toInt(n)) {
                    this._gthis.state.s_m = 3;
                    this._gthis.state.traceState();
                    return;
                }
            }
            if (this._gthis.state.s_m == 5) {
                Integer n = this._gthis.m_lastDeleteReqId;
                if (n == null ? false : this.reqId == Jvm.toInt(n)) {
                    this._gthis.finalize();
                    this._gthis.state.s_m = 32;
                    this._gthis.state.traceState();
                    return;
                }
            }
            Integer n = this._gthis.state.s_c;
            if (n == null ? false : Jvm.toInt(n) == 22) {
                Integer n2 = this._gthis.m_lastReconfReqId;
                if (n2 == null ? false : this.reqId == Jvm.toInt(n2)) {
                    this._gthis.doREQOKConfigure();
                    this._gthis.state.s_c = 20;
                    this._gthis.state.traceState();
                    this._gthis.evtCheckFrequency();
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtREQERR_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;
        public final int reqId;
        public final int code;
        public final String msg;

        /*
         * WARNING - void declaration
         */
        public Closure_evtREQERR_0(SubscriptionManagerLiving _gthis, int n, int n2, String string) {
            void msg;
            void code;
            void reqId;
            this._gthis = _gthis;
            this.reqId = reqId;
            this.code = code;
            this.msg = msg;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("REQERR");
            if (this._gthis.state.s_m == 2) {
                Integer n = this._gthis.m_lastAddReqId;
                if (n == null ? false : this.reqId == Jvm.toInt(n)) {
                    this._gthis.doSetInactive();
                    this._gthis.notifyOnSubscriptionError(this.code, this.msg);
                    this._gthis.finalize();
                    this._gthis.state.s_m = 30;
                    this._gthis.state.traceState();
                    return;
                }
            }
            if (this._gthis.state.s_m == 5) {
                Integer n = this._gthis.m_lastDeleteReqId;
                if (n == null ? false : this.reqId == Jvm.toInt(n)) {
                    this._gthis.finalize();
                    this._gthis.state.s_m = 32;
                    this._gthis.state.traceState();
                    return;
                }
            }
            Integer n = this._gthis.state.s_c;
            if (n == null ? false : Jvm.toInt(n) == 22) {
                Integer n2 = this._gthis.m_lastReconfReqId;
                if (n2 == null ? false : this.reqId == Jvm.toInt(n2)) {
                    if (RequestedMaxFrequencyTools.extEquals(this._gthis.m_reqMaxFrequency, this._gthis.m_subscription.fetch_requestedMaxFrequency())) {
                        this._gthis.state.s_c = 21;
                        this._gthis.state.traceState();
                    } else {
                        this._gthis.state.s_c = 20;
                        this._gthis.state.traceState();
                        this._gthis.evtCheckFrequency();
                    }
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtCONF_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;
        public final RealMaxFrequency freq;

        /*
         * WARNING - void declaration
         */
        public Closure_evtCONF_0(SubscriptionManagerLiving _gthis, RealMaxFrequency realMaxFrequency) {
            void freq;
            this._gthis = _gthis;
            this.freq = freq;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("CONF");
            Integer n = this._gthis.state.s_s;
            if (n == null ? false : Jvm.toInt(n) == 10) {
                this._gthis.doCONF(this.freq);
                this._gthis.state.s_s = 10;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encodeWS_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final SubscriptionManagerLiving _gthis;

        public Closure_encodeWS_0(SubscriptionManagerLiving _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return "control\r\n" + this._gthis.encode(true);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtCheckFrequency_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;

        public Closure_evtCheckFrequency_0(SubscriptionManagerLiving _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("check.frequency");
            Integer n = this._gthis.state.s_c;
            if (n == null ? false : Jvm.toInt(n) == 20) {
                if (!RequestedMaxFrequencyTools.extEquals(this._gthis.m_subscription.fetch_requestedMaxFrequency(), this._gthis.m_currentMaxFrequency)) {
                    this._gthis.doConfigure();
                    this._gthis.state.s_c = 22;
                    this._gthis.state.traceState();
                    this._gthis.genSendControl();
                } else {
                    this._gthis.state.s_c = 21;
                    this._gthis.state.traceState();
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtExtUnsubscribe_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;

        public Closure_evtExtUnsubscribe_0(SubscriptionManagerLiving _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("unsubscribe");
            if (this._gthis.state.s_m == 2) {
                this._gthis.doSetInactive();
                this._gthis.finalize();
                this._gthis.state.s_m = 30;
                this._gthis.state.traceState();
                return;
            }
            if (this._gthis.state.s_m == 3) {
                this._gthis.doUnsubscribe();
                this._gthis.doSetInactive();
                this._gthis.state.s_m = 5;
                this._gthis.state.traceState();
                this._gthis.genSendControl();
                return;
            }
            Integer n = this._gthis.state.s_s;
            if (n == null ? false : Jvm.toInt(n) == 10) {
                this._gthis.doUnsubscribe();
                this._gthis.m_subscription.setInactive();
                this._gthis.notifyOnUnsubscription();
                this._gthis.state.s_m = 5;
                this._gthis.state.s_s = null;
                this._gthis.state.s_c = null;
                this._gthis.state.traceState();
                this._gthis.genSendControl();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getCommandValue_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final SubscriptionManagerLiving _gthis;
        public final int itemPos;
        public final String key;
        public final int fieldPos;

        /*
         * WARNING - void declaration
         */
        public Closure_getCommandValue_0(SubscriptionManagerLiving _gthis, int n, String string, int n2) {
            void fieldPos;
            void key;
            void itemPos;
            this._gthis = _gthis;
            this.itemPos = itemPos;
            this.key = key;
            this.fieldPos = fieldPos;
        }

        @Override
        public String invoke() {
            return this._gthis.m_strategy.getCommandValue(this.itemPos, this.key, this.fieldPos);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtU_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;
        public final int itemIdx;
        public final IntMap values;

        /*
         * WARNING - void declaration
         */
        public Closure_evtU_0(SubscriptionManagerLiving _gthis, int n, IntMap intMap) {
            void values2;
            void itemIdx;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
            this.values = values2;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("U");
            Integer n = this._gthis.state.s_s;
            if (n == null ? false : Jvm.toInt(n) == 10) {
                this._gthis.doU(this.itemIdx, this.values);
                this._gthis.state.s_s = 10;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtSUBOK_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;
        public final int nItems;
        public final int nFields;

        /*
         * WARNING - void declaration
         */
        public Closure_evtSUBOK_0(SubscriptionManagerLiving _gthis, int n, int n2) {
            void nFields;
            void nItems;
            this._gthis = _gthis;
            this.nItems = nItems;
            this.nFields = nFields;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("SUBOK");
            if (this._gthis.state.s_m == 2 || this._gthis.state.s_m == 3) {
                Integer expFields;
                Array tmp = this._gthis.m_subscription.fetch_items();
                Integer expItems = tmp != null ? Integer.valueOf(tmp.length) : (Integer)null;
                Array tmp2 = this._gthis.m_subscription.fetch_fields();
                Integer n = expFields = tmp2 != null ? Integer.valueOf(tmp2.length) : (Integer)null;
                if (this._gthis.checkItemsAndFields(expItems, expFields, this.nItems, this.nFields)) {
                    this._gthis.doSUBOK(this.nItems, this.nFields);
                    this._gthis.notifyOnSubscription();
                    this._gthis.state.s_m = 4;
                    this._gthis.state.s_s = 10;
                    this._gthis.state.s_c = 20;
                    this._gthis.state.traceState();
                    this._gthis.evtCheckFrequency();
                } else {
                    this._gthis.doUnsubscribe();
                    this._gthis.doSetInactive();
                    this._gthis.notifyOnSubscriptionError_CountMismatch(expItems, expFields, this.nItems, this.nFields);
                    this._gthis.state.s_m = 5;
                    this._gthis.state.traceState();
                    this._gthis.genSendControl();
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encode_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final SubscriptionManagerLiving _gthis;
        public final boolean isWS;

        /*
         * WARNING - void declaration
         */
        public Closure_encode_0(SubscriptionManagerLiving _gthis, boolean bl) {
            void isWS;
            this._gthis = _gthis;
            this.isWS = isWS;
        }

        @Override
        public String invoke() throws IllegalStateException {
            if (this._gthis.state.s_m == 2) {
                return this._gthis.encodeAdd(this.isWS);
            }
            if (this._gthis.state.s_m == 5) {
                return this._gthis.encodeDelete(this.isWS);
            }
            Integer n = this._gthis.state.s_c;
            if (n == null ? false : Jvm.toInt(n) == 22) {
                return this._gthis.encodeReconf(this.isWS);
            }
            throw new IllegalStateException("Can't encode request");
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getValue_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final SubscriptionManagerLiving _gthis;
        public final int itemPos;
        public final int fieldPos;

        /*
         * WARNING - void declaration
         */
        public Closure_getValue_0(SubscriptionManagerLiving _gthis, int n, int n2) {
            void fieldPos;
            void itemPos;
            this._gthis = _gthis;
            this.itemPos = itemPos;
            this.fieldPos = fieldPos;
        }

        @Override
        public String invoke() {
            return this._gthis.m_strategy.getValue(this.itemPos, this.fieldPos);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtSUBCMD_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;
        public final int nItems;
        public final int nFields;
        public final int cmdIdx;
        public final int keyIdx;

        /*
         * WARNING - void declaration
         */
        public Closure_evtSUBCMD_0(SubscriptionManagerLiving _gthis, int n, int n2, int n3, int n4) {
            void keyIdx;
            void cmdIdx;
            void nFields;
            void nItems;
            this._gthis = _gthis;
            this.nItems = nItems;
            this.nFields = nFields;
            this.cmdIdx = cmdIdx;
            this.keyIdx = keyIdx;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("SUBCMD");
            if (this._gthis.state.s_m == 2 || this._gthis.state.s_m == 3) {
                Integer expFields;
                Array tmp = this._gthis.m_subscription.fetch_items();
                Integer expItems = tmp != null ? Integer.valueOf(tmp.length) : (Integer)null;
                Array tmp2 = this._gthis.m_subscription.fetch_fields();
                Integer n = expFields = tmp2 != null ? Integer.valueOf(tmp2.length) : (Integer)null;
                if (this._gthis.checkItemsAndFields(expItems, expFields, this.nItems, this.nFields)) {
                    this._gthis.doSUBCMD(this.nItems, this.nFields, this.cmdIdx, this.keyIdx);
                    this._gthis.notifyOnSubscription();
                    this._gthis.state.s_m = 4;
                    this._gthis.state.s_s = 10;
                    this._gthis.state.s_c = 20;
                    this._gthis.state.traceState();
                    this._gthis.evtCheckFrequency();
                } else {
                    this._gthis.doUnsubscribe();
                    this._gthis.doSetInactive();
                    this._gthis.notifyOnSubscriptionError_CountMismatch(expItems, expFields, this.nItems, this.nFields);
                    this._gthis.state.s_m = 5;
                    this._gthis.state.traceState();
                    this._gthis.genSendControl();
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtEOS_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final SubscriptionManagerLiving _gthis;
        public final int itemIdx;

        /*
         * WARNING - void declaration
         */
        public Closure_evtEOS_0(SubscriptionManagerLiving _gthis, int n) {
            void itemIdx;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("EOS");
            Integer n = this._gthis.state.s_s;
            if (n == null ? false : Jvm.toInt(n) == 10) {
                this._gthis.doEOS(this.itemIdx);
                this._gthis.state.s_s = 10;
                this._gthis.state.traceState();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }
}

