/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.internal;

import com.lightstreamer.client.LSProxy;
import com.lightstreamer.internal.CookieHelper;
import com.lightstreamer.internal.IHttpClient;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.Exception;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Std;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Credentials;
import okhttp3.JavaNetCookieJar;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okio.BufferedSource;

@ClassReflectionInformation(hasSuperClass=false)
public class HttpClient
extends haxe.jvm.Object
implements Callback,
Authenticator,
IHttpClient {
    public static MediaType TXT = MediaType.get("text/plain; charset=utf-8");
    public static OkHttpClient client = new OkHttpClient();
    public Call call;
    public LSProxy proxy;
    public Function onText;
    public Function onError;
    public Function onDone;
    public volatile boolean isCanceled;

    @Override
    public void dispose() {
        if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
            LoggerTools_Fields_.streamLogger.debug("HTTP disposing", null);
        }
        this.isCanceled = true;
        this.call.cancel();
    }

    @Override
    public boolean isDisposed() {
        return this.isCanceled;
    }

    @Override
    public void onFailure(Call call, IOException ex) {
        if (this.isCanceled) {
            return;
        }
        if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
            LoggerTools_Fields_.streamLogger.debug("HTTP event: error(" + ex.getMessage() + ")", ex);
        }
        this.onError.invoke(this, ex.getMessage());
        call.cancel();
    }

    @Override
    public void onResponse(Call call, Response response) {
        if (this.isCanceled) {
            response.close();
            return;
        }
        if (!response.isSuccessful()) {
            if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
                LoggerTools_Fields_.streamLogger.debug("HTTP event: error(HTTP code " + response.code() + ")", null);
            }
            this.onError.invoke(this, "Unexpected HTTP code: " + response.code());
            response.close();
            return;
        }
        try {
            String line = null;
            BufferedSource source2 = response.body().source();
            while ((line = source2.readUtf8Line()) != null) {
                if (this.isCanceled) {
                    response.close();
                    return;
                }
                if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
                    LoggerTools_Fields_.streamLogger.debug("HTTP event: text(" + line + ")", null);
                }
                this.onText.invoke(this, line);
            }
            if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
                LoggerTools_Fields_.streamLogger.debug("HTTP event: complete", null);
            }
            this.onDone.invoke(this);
        }
        catch (Throwable _g) {
            Exception _g2 = Exception.caught(_g);
            if (this.isCanceled) {
                response.close();
                return;
            }
            if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
                LoggerTools_Fields_.streamLogger.debug("HTTP event: error(" + _g2.get_message() + ")" + "\n" + _g2.details(), null);
            }
            this.onError.invoke(this, _g2.get_message());
        }
        response.close();
    }

    @Override
    public Request authenticate(Route route, Response response) throws IllegalStateException {
        String password;
        if (this.proxy == null) {
            throw new IllegalStateException("Assertion failure: " + "proxy != null");
        }
        String user = this.proxy.user == null ? "" : this.proxy.user;
        String string = password = this.proxy.password == null ? "" : this.proxy.password;
        if (response.request().header("Proxy-Authorization") != null) {
            return null;
        }
        String credential = Credentials.basic(user, password);
        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
    }

    /*
     * Unable to fully structure code
     */
    public HttpClient(String url, String body, StringMap headers, LSProxy proxy, TrustManagerFactory trustManagerFactory, Function onText, Function onError, Function onDone) throws IllegalStateException {
        this.isCanceled = false;
        super();
        if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
            LoggerTools_Fields_.streamLogger.debug("HTTP sending: " + url + " " + body + " headers(" + (headers == null ? "null" : headers.toString()) + ") proxy(" + Std.string(proxy) + ") trustManager(" + Std.string(trustManagerFactory) + ")", null);
        }
        this.proxy = proxy;
        this.onText = onText;
        this.onError = onError;
        this.onDone = onDone;
        reqBuilder = new Request.Builder();
        if (headers != null) {
            map = headers;
            _g_keys = map.keys();
            while (_g_keys.hasNext()) {
                key = (String)_g_keys.next();
                _g_value = (String)map.get(key);
                reqBuilder.header(key, _g_value);
            }
        }
        request = reqBuilder.url(url).post(RequestBody.create(body, HttpClient.TXT)).build();
        clientBuilder = HttpClient.client.newBuilder();
        cookieHandler = CookieHelper.instance.getCookieHandler();
        if (cookieHandler != null) {
            clientBuilder.cookieJar(new JavaNetCookieJar(cookieHandler));
        }
        if (proxy != null) {
            inet = new InetSocketAddress(proxy.host, proxy.port);
            javaProxy = null;
            _hx_tmp = proxy.type;
            if (_hx_tmp != null) {
                switch (_hx_tmp.hashCode()) {
                    case -1843718906: {
                        if (_hx_tmp.equals("SOCKS5")) break;
                        ** break;
                    }
                    case -1843718907: {
                        if (_hx_tmp.equals("SOCKS4")) break;
                        ** break;
                    }
                    case 0x220088: {
                        if (!_hx_tmp.equals("HTTP")) ** break;
                        javaProxy = Proxy.Type.HTTP;
                        ** break;
                    }
                }
                javaProxy = Proxy.Type.SOCKS;
                ** break;
            }
lbl43:
            // 8 sources

            javaProxy = new Proxy(javaProxy, inet);
            clientBuilder.proxy(javaProxy).proxyAuthenticator(this);
        }
        if (trustManagerFactory != null) {
            trustManagers = trustManagerFactory.getTrustManagers();
            x509TrustManager = null;
            tmp = false;
            if (trustManagers.length == 1) {
                value = trustManagers[0];
                x509TrustManager = Std.isOfType(value, X509TrustManager.class) != false ? (X509TrustManager)value : null;
                tmp = x509TrustManager == null;
            } else {
                tmp = true;
            }
            if (tmp) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
            sslSocketFactory = sslContext.getSocketFactory();
            clientBuilder.sslSocketFactory(sslSocketFactory, x509TrustManager);
        }
        this.call = clientBuilder.build().newCall(request);
        this.call.enqueue(this);
    }

    public /* synthetic */ HttpClient(EmptyConstructor _) {
    }
}

