/*
 * Decompiled with CFR 0.152.
 */
package haxe;

import haxe.CallStack;
import haxe.NativeStackTrace;
import haxe.StackItem;
import haxe.ValueException;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Std;
import java.util.Arrays;

@ClassReflectionInformation(hasSuperClass=true)
public class Exception
extends RuntimeException {
    public Array<StackItem> __exceptionStack;
    public Throwable __nativeException;
    public Exception __previousException;

    public static Exception caught(Object value) {
        if (Std.isOfType(value, Exception.class)) {
            return (Exception)value;
        }
        if (Std.isOfType(value, Throwable.class)) {
            return new Exception(((Throwable)value).getMessage(), null, value);
        }
        return new ValueException(value, null, value);
    }

    public static Object thrown(Object value) {
        if (Std.isOfType(value, Exception.class)) {
            Throwable throwable = ((Exception)value).__nativeException;
            if (Std.isOfType(throwable, RuntimeException.class)) {
                return throwable;
            }
            return value;
        }
        if (Std.isOfType(value, RuntimeException.class)) {
            return value;
        }
        if (Std.isOfType(value, Throwable.class)) {
            return new Exception(((Throwable)value).getMessage(), null, value);
        }
        ValueException e = new ValueException(value, null, null);
        StackTraceElement[] stack = e.getStackTrace();
        if (stack.length > 1) {
            e.setStackTrace((StackTraceElement[])Arrays.copyOfRange((Object[])stack, 1, stack.length));
        }
        return e;
    }

    public Object unwrap() {
        return this.__nativeException;
    }

    @Override
    public String toString() {
        return this.get_message();
    }

    public String details() {
        if (this.get_previous() == null) {
            String tmp = "Exception: " + this.toString();
            Array tmp1 = this.get_stack();
            return tmp + (tmp1 == null ? "null" : CallStack.CallStack_Impl_.toString(tmp1));
        }
        String result = "";
        Exception prev = null;
        for (Exception e = this; e != null; e = e.get_previous()) {
            if (prev == null) {
                String result1 = "Exception: " + e.get_message();
                Array tmp = e.get_stack();
                result = result1 + (tmp == null ? "null" : CallStack.CallStack_Impl_.toString(tmp)) + result;
            } else {
                Array prevStack = CallStack.CallStack_Impl_.subtract(e.get_stack(), prev.get_stack());
                result = "Exception: " + e.get_message() + (prevStack == null ? "null" : CallStack.CallStack_Impl_.toString(prevStack)) + "\n\nNext " + result;
            }
            prev = e;
        }
        return result;
    }

    public String get_message() {
        return this.getMessage();
    }

    public Exception get_previous() {
        return this.__previousException;
    }

    public Array get_stack() {
        Array<StackItem> _g = this.__exceptionStack;
        if (_g == null) {
            this.__exceptionStack = NativeStackTrace.toHaxe(this.__nativeException.getStackTrace(), null);
            return this.__exceptionStack;
        }
        return _g;
    }

    public Exception(String message, Exception previous, Object object) {
        super(message, previous == null ? null : previous);
        this.__previousException = previous;
        if (object != null && Std.isOfType(object, Throwable.class)) {
            this.__nativeException = (Throwable)object;
            this.setStackTrace(this.__nativeException.getStackTrace());
            return;
        }
        this.__nativeException = this;
    }

    public /* synthetic */ Exception(EmptyConstructor _) {
        super(_);
    }
}

