/*
 * Decompiled with CFR 0.152.
 */
package me.chillywilly.issosd.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import me.chillywilly.issosd.client.IssosdClient;
import net.minecraft.class_310;

public class ISSModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private double pos_x;
    private double pos_y;
    private String sound_namespace;
    private String sound_id;
    public boolean mod_enabled;
    public boolean sound_enabled;

    public void load() {
        File folder = new File(class_310.method_1551().field_1697, "config");
        File file = new File(folder, "issPiss.json");
        if (!file.exists()) {
            this.reset();
            return;
        }
        try (FileReader fr = new FileReader(file);){
            ISSModConfig obj = (ISSModConfig)GSON.fromJson((Reader)fr, ISSModConfig.class);
            this.setX(obj.getX());
            this.setY(obj.getY());
            this.setSoundNamespace(obj.getSoundNamespace());
            this.setSoundID(obj.getSoundID());
            this.setEnabled(obj.getEnabled());
            this.setSoundEnabled(obj.getSoundEnabled());
            this.check();
        }
        catch (Exception e) {
            IssosdClient.LOGGER.error("Failed to read file {}", (Object)file.getName(), (Object)e);
        }
    }

    public void save() {
        File folder = new File(class_310.method_1551().field_1697, "config");
        if (!folder.isDirectory() && !folder.mkdirs()) {
            IssosdClient.LOGGER.error("Failed to create missing config folder");
            return;
        }
        File file = new File(folder, "issPiss.json");
        try (FileWriter fw = new FileWriter(file);){
            GSON.toJson((Object)this, ISSModConfig.class, (Appendable)fw);
            IssosdClient.LOGGER.info("Saved Config");
        }
        catch (Exception e) {
            IssosdClient.LOGGER.error("Failed to write file {}", (Object)file.getName(), (Object)e);
        }
    }

    public void reset() {
        this.pos_x = 0.5;
        this.pos_y = 0.0;
        this.sound_namespace = "minecraft";
        this.sound_id = "block.note_block.harp";
        this.mod_enabled = true;
        this.sound_enabled = true;
    }

    public void check() {
        boolean save = false;
        if (this.sound_namespace == null) {
            this.sound_namespace = "minecraft";
            save = true;
        }
        if (this.sound_id == null) {
            this.sound_id = "block.note_block.harp";
            save = true;
        }
        if (save) {
            this.save();
        }
    }

    public double getX() {
        return this.pos_x;
    }

    public double getY() {
        return this.pos_y;
    }

    public void setX(double pos_x) {
        this.pos_x = pos_x;
    }

    public void setY(double pos_y) {
        this.pos_y = pos_y;
    }

    public String getSoundNamespace() {
        if (this.sound_namespace != null) {
            this.sound_namespace = "minecraft";
            return this.sound_namespace;
        }
        return this.sound_namespace;
    }

    public String getSoundID() {
        if (this.sound_id != null) {
            this.sound_id = "block.note_block.harp";
            return this.sound_id;
        }
        return this.sound_id;
    }

    public void setSoundNamespace(String namespace) {
        this.sound_namespace = namespace;
    }

    public void setSoundID(String ID) {
        this.sound_id = ID;
    }

    public boolean getEnabled() {
        return this.mod_enabled;
    }

    public boolean getSoundEnabled() {
        return this.sound_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.mod_enabled = enabled;
    }

    public void setSoundEnabled(boolean enabled) {
        this.sound_enabled = enabled;
    }
}

