/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client.internal;

import com.lightstreamer.client.ClientMessageListener;
import com.lightstreamer.client.internal.ClientMachine;
import com.lightstreamer.client.internal.Encodable;
import com.lightstreamer.client.internal.MessageEventDispatcher;
import com.lightstreamer.internal.InfoMap;
import com.lightstreamer.internal.RequestBuilder;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Jvm;
import haxe.jvm.Object;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Std;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ClassReflectionInformation(hasSuperClass=false)
public class MessageManager
extends Object
implements Encodable {
    public MessageEventDispatcher eventDispatcher;
    public String txt;
    public String sequence;
    public int prog;
    public int maxWait;
    public ClientMessageListener delegate;
    public boolean enqueueWhileDisconnected;
    public ClientMachine client;
    public Integer lastReqId;
    public int s_m;

    public void finalize() {
        this.client.unrelateMsgManager(this);
    }

    public void evtExtSendMessage() {
        this.traceEvent("sendMessage");
        switch (this.s_m) {
            default: {
                return;
            }
            case 10: {
                this.goto(11);
                this.client.evtSendMessage(this);
                return;
            }
            case 20: {
                this.goto(21);
                this.client.evtSendMessage(this);
                return;
            }
            case 30: 
        }
        this.goto(31);
        this.client.evtSendMessage(this);
    }

    public void evtMSGFAIL(int code, String msg) {
        this.traceEvent("MSGFAIL");
        switch (this.s_m) {
            default: {
                return;
            }
            case 10: {
                this.finalize();
                this.goto(13);
                return;
            }
            case 11: {
                this.doMSGFAIL(code, msg);
                this.finalize();
                this.goto(14);
                return;
            }
            case 12: 
        }
        this.doMSGFAIL(code, msg);
        this.finalize();
        this.goto(14);
    }

    public void evtMSGDONE(String response) {
        this.traceEvent("MSGDONE");
        switch (this.s_m) {
            default: {
                return;
            }
            case 10: {
                this.finalize();
                this.goto(13);
                return;
            }
            case 11: {
                this.doMSGDONE(response);
                this.finalize();
                this.goto(13);
                return;
            }
            case 12: 
        }
        this.doMSGDONE(response);
        this.finalize();
        this.goto(13);
    }

    public void evtREQOK(int reqId) {
        this.traceEvent("REQOK");
        switch (this.s_m) {
            default: {
                return;
            }
            case 11: {
                Integer n = this.lastReqId;
                if (!(n == null ? false : reqId == Jvm.toInt(n))) break;
                this.goto(12);
                break;
            }
            case 21: {
                Integer n = this.lastReqId;
                if (!(n == null ? false : reqId == Jvm.toInt(n))) break;
                this.finalize();
                this.goto(22);
                break;
            }
            case 31: {
                Integer n = this.lastReqId;
                if (!(n == null ? false : reqId == Jvm.toInt(n))) break;
                this.finalize();
                this.goto(33);
            }
        }
    }

    public void evtREQERR(int reqId, int code, String msg) {
        this.traceEvent("REQERR");
        switch (this.s_m) {
            default: {
                return;
            }
            case 11: {
                Integer n = this.lastReqId;
                if (!(n == null ? false : reqId == Jvm.toInt(n))) break;
                this.doREQERR(code, msg);
                this.finalize();
                this.goto(14);
                break;
            }
            case 21: {
                Integer n = this.lastReqId;
                if (!(n == null ? false : reqId == Jvm.toInt(n))) break;
                this.finalize();
                this.goto(23);
                break;
            }
            case 31: {
                Integer n = this.lastReqId;
                if (!(n == null ? false : reqId == Jvm.toInt(n))) break;
                this.finalize();
                this.goto(34);
            }
        }
    }

    public void evtAbort() {
        this.traceEvent("abort");
        switch (this.s_m) {
            default: {
                return;
            }
            case 11: {
                this.doAbort();
                this.finalize();
                this.goto(15);
                return;
            }
            case 12: {
                this.doAbort();
                this.finalize();
                this.goto(15);
                return;
            }
            case 21: {
                if (LoggerTools_Fields_.messageLogger.isWarnEnabled()) {
                    LoggerTools_Fields_.messageLogger.warn("Message " + this.sequence + ":" + this.prog + " aborted", null);
                }
                this.finalize();
                this.goto(24);
                return;
            }
            case 31: 
        }
        if (LoggerTools_Fields_.messageLogger.isWarnEnabled()) {
            LoggerTools_Fields_.messageLogger.warn("Message " + this.sequence + ":" + this.prog + " aborted", null);
        }
        this.finalize();
        this.goto(35);
    }

    public void evtWSSent() {
        this.traceEvent("ws.sent");
        if (this.s_m == 31) {
            this.finalize();
            this.goto(32);
        }
    }

    @Override
    public boolean isPending() {
        if (this.s_m != 11 && this.s_m != 21) {
            return this.s_m == 31;
        }
        return true;
    }

    @Override
    public String encode(boolean isWS) {
        return this.encodeMsg(isWS);
    }

    @Override
    public String encodeWS() {
        return "msg\r\n" + this.encode(true);
    }

    public void doMSGDONE(String response) {
        this.fireOnProcessed(response);
    }

    public void doMSGFAIL(int code, String msg) {
        if (code == 38 || code == 39) {
            this.fireOnDiscarded();
            return;
        }
        if (code <= 0) {
            this.fireOnDeny(code, msg);
            return;
        }
        if (code != 32 && code != 33) {
            this.fireOnError();
        }
    }

    public void doREQERR(int code, String msg) {
        if (code != 32 && code != 33) {
            this.fireOnError();
        }
    }

    public void doAbort() {
        this.fireOnAbort();
    }

    public String encodeMsg(boolean isWS) {
        boolean isOrdered = Jvm.stringCompare(this.sequence, "UNORDERED_MESSAGES") != 0;
        boolean hasListener = this.delegate != null;
        RequestBuilder req = new RequestBuilder();
        this.lastReqId = this.client.generateFreshReqId();
        req.LS_reqId(Jvm.toInt(this.lastReqId));
        req.LS_message(this.txt);
        if (isOrdered && hasListener) {
            req.LS_sequence(this.sequence);
            req.LS_msg_prog(this.prog);
            if (this.maxWait >= 0) {
                req.LS_max_wait(this.maxWait);
            }
        } else if (!isOrdered && hasListener) {
            req.LS_msg_prog(this.prog);
        } else if (isOrdered && !hasListener) {
            req.LS_outcome(false);
            req.LS_sequence(this.sequence);
            req.LS_msg_prog(this.prog);
            if (this.maxWait >= 0) {
                req.LS_max_wait(this.maxWait);
            }
        } else if (!isOrdered && !hasListener) {
            req.LS_outcome(false);
            if (isWS) {
                req.LS_ack(false);
            }
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending message: " + Std.string(req), null);
        }
        return req.getEncodedString();
    }

    public void fireOnProcessed(String response) {
        if (LoggerTools_Fields_.messageLogger.isInfoEnabled()) {
            LoggerTools_Fields_.messageLogger.info("Message " + this.sequence + ":" + this.prog + " processed", null);
        }
        this.eventDispatcher.onProcessed(this.txt, response);
    }

    public void fireOnDiscarded() {
        if (LoggerTools_Fields_.messageLogger.isWarnEnabled()) {
            LoggerTools_Fields_.messageLogger.warn("Message " + this.sequence + ":" + this.prog + " discarded", null);
        }
        this.eventDispatcher.onDiscarded(this.txt);
    }

    public void fireOnDeny(int code, String msg) {
        if (LoggerTools_Fields_.messageLogger.isWarnEnabled()) {
            LoggerTools_Fields_.messageLogger.warn("Message " + this.sequence + ":" + this.prog + " denied: " + code + " - " + msg, null);
        }
        this.eventDispatcher.onDeny(this.txt, code, msg);
    }

    public void fireOnError() {
        if (LoggerTools_Fields_.messageLogger.isWarnEnabled()) {
            LoggerTools_Fields_.messageLogger.warn("Message " + this.sequence + ":" + this.prog + " failed", null);
        }
        this.eventDispatcher.onError(this.txt);
    }

    public void fireOnAbort() {
        if (LoggerTools_Fields_.messageLogger.isWarnEnabled()) {
            LoggerTools_Fields_.messageLogger.warn("Message " + this.sequence + ":" + this.prog + " aborted", null);
        }
        this.eventDispatcher.onAbort(this.txt, false);
    }

    public void traceEvent(String evt) {
        if (LoggerTools_Fields_.internalLogger.isTraceEnabled()) {
            LoggerTools_Fields_.internalLogger.trace("msg#" + evt + "(" + this.sequence + ":" + this.prog + ") in " + this.s_m, null);
        }
    }

    public void goto(int target) {
        this.s_m = target;
        if (LoggerTools_Fields_.internalLogger.isTraceEnabled()) {
            LoggerTools_Fields_.internalLogger.trace("msg#goto(" + this.sequence + ":" + this.prog + ") " + this.s_m, null);
        }
    }

    public String toString() {
        StringMap map = InfoMap.InfoMap_Impl_._new();
        InfoMap.InfoMap_Impl_.set(map, "text", this.txt);
        InfoMap.InfoMap_Impl_.set(map, "sequence", this.sequence);
        InfoMap.InfoMap_Impl_.set(map, "prog", this.prog);
        InfoMap.InfoMap_Impl_.set(map, "timeout", this.maxWait);
        InfoMap.InfoMap_Impl_.set(map, "enqueueWhileDisconnected", this.enqueueWhileDisconnected);
        return map.toString();
    }

    public MessageManager(String txt, String sequence2, int maxWait, ClientMessageListener delegate, boolean enqueueWhileDisconnected, ClientMachine client) {
        this.eventDispatcher = new MessageEventDispatcher();
        this.txt = txt;
        this.sequence = sequence2;
        boolean isOrdered = Jvm.stringCompare(sequence2, "UNORDERED_MESSAGES") != 0;
        boolean hasListener = delegate != null;
        this.prog = isOrdered || hasListener ? client.getAndSetNextMsgProg(sequence2) : -1;
        this.maxWait = maxWait;
        this.delegate = delegate;
        if (delegate != null) {
            this.eventDispatcher.addListener(delegate);
        }
        this.enqueueWhileDisconnected = enqueueWhileDisconnected;
        this.client = client;
        this.s_m = delegate != null ? 10 : (Jvm.stringCompare(sequence2, "UNORDERED_MESSAGES") != 0 ? 20 : 30);
        client.relateMsgManager(this);
    }

    public /* synthetic */ MessageManager(EmptyConstructor _) {
    }
}

