/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.internal;

import haxe.jvm.EmptyConstructor;
import haxe.jvm.Jvm;
import haxe.jvm.StringExt;
import haxe.jvm.annotation.ClassReflectionInformation;

@ClassReflectionInformation(hasSuperClass=false)
public class Url
extends haxe.jvm.Object {
    public String _protocol;
    public String _hostname;
    public String _port;
    public String _pathname;

    public static String build(String base, String path) {
        if (path != null) {
            boolean baseEndsWithSlash = base.endsWith("/");
            boolean pathStartsWithSlash = path.startsWith("/");
            if (!baseEndsWithSlash) {
                base = !pathStartsWithSlash ? Jvm.stringConcat(base, "/" + path) : Jvm.stringConcat(base, path);
            } else if (!pathStartsWithSlash) {
                base = Jvm.stringConcat(base, path);
            } else {
                Integer endIndex = null;
                base = Jvm.stringConcat(base, StringExt.substring(path, 1, endIndex));
            }
        }
        return base;
    }

    public static String completeControlLink(String clink, String baseAddress) {
        Url baseUrl = new Url(baseAddress, null);
        Url clUrl = new Url(clink, null);
        if (Jvm.stringCompare(clUrl.get_protocol(), "") == 0) {
            clUrl.set_protocol(baseUrl.get_protocol());
        }
        if (Jvm.stringCompare(clUrl.get_port(), "") == 0) {
            clUrl.set_port(baseUrl.get_port());
        }
        return clUrl.get_href();
    }

    public String get_protocol() {
        return this._protocol;
    }

    public String set_protocol(String newValue) {
        if (Jvm.stringCompare(newValue, "") != 0 && !newValue.endsWith(":")) {
            newValue = Jvm.stringConcat(newValue, ":");
        }
        this._protocol = newValue;
        return this._protocol;
    }

    public String get_hostname() {
        return this._hostname;
    }

    public String set_hostname(String newValue) {
        this._hostname = newValue;
        return this._hostname;
    }

    public String get_port() {
        return this._port;
    }

    public String set_port(String newValue) {
        this._port = newValue;
        return this._port;
    }

    public String get_pathname() {
        return this._pathname;
    }

    public String set_pathname(String newValue) {
        if (!newValue.startsWith("/")) {
            newValue = "/" + newValue;
        }
        this._pathname = newValue;
        return this._pathname;
    }

    public String get_href() {
        String url = this._hostname;
        if (Jvm.stringCompare(this._protocol, "") != 0) {
            url = this._protocol + "//" + url;
        }
        if (Jvm.stringCompare(this._port, "") != 0) {
            url = Jvm.stringConcat(url, ":" + this._port);
        }
        if (Jvm.stringCompare(this.get_pathname(), "") != 0) {
            url = Jvm.stringConcat(url, this._pathname);
        }
        return url;
    }

    public String toString() {
        return this.get_href();
    }

    public int extractPortStart(String address) {
        Integer startIndex = null;
        int portStarts = StringExt.indexOf(address, ":", startIndex);
        if (portStarts <= -1) {
            return -1;
        }
        Integer startIndex2 = null;
        if (StringExt.indexOf(address, "]", startIndex2) > -1) {
            Integer startIndex3 = null;
            portStarts = StringExt.indexOf(address, "]:", startIndex3);
            if (portStarts <= -1) {
                return -1;
            }
            return portStarts + 2;
        }
        Integer startIndex4 = null;
        if (portStarts != StringExt.lastIndexOf(address, ":", startIndex4)) {
            return -1;
        }
        return portStarts + 1;
    }

    public Url(String url, String path) {
        Integer startIndex = null;
        int schemaEnd = StringExt.indexOf(url, "://", startIndex);
        if (schemaEnd != -1) {
            this._protocol = StringExt.substring(url, 0, schemaEnd) + ":";
            Integer endIndex = null;
            url = StringExt.substring(url, schemaEnd + 3, endIndex);
        } else {
            this._protocol = "";
        }
        Integer startIndex2 = null;
        int pathStart = StringExt.indexOf(url, "/", startIndex2);
        if (pathStart != -1) {
            Integer endIndex = null;
            this._pathname = StringExt.substring(url, pathStart, endIndex);
            url = StringExt.substring(url, 0, pathStart);
        } else {
            this._pathname = "/";
        }
        int portStart = this.extractPortStart(url);
        if (portStart != -1) {
            Integer endIndex = null;
            this._port = StringExt.substring(url, portStart, endIndex);
            this._hostname = StringExt.substring(url, 0, portStart - 1);
        } else {
            this._port = "";
            this._hostname = url;
        }
        if (path != null) {
            this.set_pathname(path);
        }
    }

    public /* synthetic */ Url(EmptyConstructor _) {
    }
}

