/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client;

import com.lightstreamer.client.ClientListener;
import com.lightstreamer.client.ClientMessageListener;
import com.lightstreamer.client.ConnectionDetails;
import com.lightstreamer.client.ConnectionOptions;
import com.lightstreamer.client.LSLightstreamerClient;
import com.lightstreamer.client.Subscription;
import com.lightstreamer.log.LoggerProvider;
import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;

public class LightstreamerClient {
    final LSLightstreamerClient delegate;
    @Nonnull
    public static final String LIB_NAME = LSLightstreamerClient.LIB_NAME;
    @Nonnull
    public static final String LIB_VERSION = LSLightstreamerClient.LIB_VERSION;
    @Nonnull
    public final ConnectionOptions connectionOptions;
    @Nonnull
    public final ConnectionDetails connectionDetails;

    public static void setLoggerProvider(@Nullable LoggerProvider loggerProvider) {
        LSLightstreamerClient.setLoggerProvider(loggerProvider);
    }

    public LightstreamerClient(@Nullable String string, @Nullable String string2) {
        this.delegate = new LSLightstreamerClient(string, string2);
        this.connectionOptions = new ConnectionOptions(this.delegate.connectionOptions);
        this.connectionDetails = new ConnectionDetails(this.delegate.connectionDetails);
    }

    public void addListener(@Nonnull ClientListener clientListener) {
        this.delegate.addListener(clientListener);
    }

    public void removeListener(@Nonnull ClientListener clientListener) {
        this.delegate.removeListener(clientListener);
    }

    @Nonnull
    public List<ClientListener> getListeners() {
        return this.delegate.getListeners();
    }

    public void connect() {
        this.delegate.connect();
    }

    public void disconnect() {
        this.delegate.disconnect();
    }

    @Nonnull
    public Future<Void> disconnectFuture() {
        return this.delegate.disconnectFuture();
    }

    @Nonnull
    public String getStatus() {
        return this.delegate.getStatus();
    }

    public void subscribe(@Nonnull Subscription subscription) {
        this.delegate.subscribe(subscription.delegate);
    }

    public void unsubscribe(@Nonnull Subscription subscription) {
        this.delegate.unsubscribe(subscription.delegate);
    }

    @Nonnull
    public List<Subscription> getSubscriptions() {
        return this.delegate.getSubscriptionWrappers();
    }

    public void sendMessage(@Nonnull String string) {
        this.delegate.sendMessage(string);
    }

    public void sendMessage(@Nonnull String string, @Nullable String string2, int n, @Nullable ClientMessageListener clientMessageListener, boolean bl) {
        this.delegate.sendMessage(string, string2, n, clientMessageListener, bl);
    }

    public static void addCookies(@Nonnull URI uRI, @Nonnull List<HttpCookie> list) {
        LSLightstreamerClient.addCookies(uRI, list);
    }

    @Nonnull
    public static List<HttpCookie> getCookies(@Nullable URI uRI) {
        return LSLightstreamerClient.getCookies(uRI);
    }

    public static void setTrustManagerFactory(@Nonnull TrustManagerFactory trustManagerFactory) {
        LSLightstreamerClient.setTrustManagerFactory(trustManagerFactory);
    }
}

