/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client.internal.update;

import com.fasterxml.jackson.databind.JsonNode;
import com.lightstreamer.client.LSSubscription;
import com.lightstreamer.client.internal.update.AbstractItemUpdate;
import com.lightstreamer.client.internal.update.CurrFieldVal;
import com.lightstreamer.client.internal.update.CurrFieldValTools;
import com.lightstreamer.client.internal.update._UpdateUtils.UpdateUtils_Fields_;
import com.lightstreamer.internal.NullTools;
import com.lightstreamer.internal.Set;
import com.lightstreamer.internal._NativeTypes.NativeIntMap_Impl_;
import com.lightstreamer.internal._NativeTypes.NativeStringMap_Impl_;
import com.lightstreamer.internal.patch.Json;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.IMap;
import haxe.ds.IntMap;
import haxe.ds.StringMap;
import haxe.iterators.ArrayIterator;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Std;
import haxe.root.StringBuf;
import java.util.Iterator;
import java.util.Map;

@ClassReflectionInformation(hasSuperClass=true)
public class ItemUpdateBase
extends AbstractItemUpdate {
    public int m_itemIdx;
    public IntMap<String> m_items;
    public int m_nFields;
    public IntMap<String> m_fields;
    public IntMap<CurrFieldVal> m_newValues;
    public Set<Integer> m_changedFields;
    public boolean m_isSnapshot;
    public IntMap<JsonNode> m_jsonPatches;

    @Override
    public String getItemName() {
        if (this.m_items != null) {
            return (String)((IntMap)((IMap)this.m_items)).get(this.m_itemIdx);
        }
        return null;
    }

    @Override
    public int getItemPos() {
        return this.m_itemIdx;
    }

    @Override
    public boolean isSnapshot() {
        return this.m_isSnapshot;
    }

    @Override
    public String getValue(int fieldPos) {
        return this.getValuePos(fieldPos);
    }

    @Override
    public String getValue(String fieldName) {
        return this.getValueName(fieldName);
    }

    @Override
    public boolean isValueChanged(int fieldPos) {
        return this.isValueChangedPos(fieldPos);
    }

    @Override
    public boolean isValueChanged(String fieldName) {
        return this.isValueChangedName(fieldName);
    }

    @Override
    public String getValueAsJSONPatchIfAvailable(String fieldName) {
        int fieldPos = this.getFieldIdxFromName(fieldName);
        JsonNode val = (JsonNode)((IntMap)((IMap)this.m_jsonPatches)).get(fieldPos);
        if (val != null) {
            return Json.Json_Impl_.toString(val);
        }
        return null;
    }

    @Override
    public String getValueAsJSONPatchIfAvailable(int fieldPos) {
        JsonNode val = (JsonNode)((IntMap)((IMap)this.m_jsonPatches)).get(fieldPos);
        if (val != null) {
            return Json.Json_Impl_.toString(val);
        }
        return null;
    }

    @Override
    public Map getChangedFields() throws IllegalStateException {
        if (this.m_fields == null) {
            throw new IllegalStateException(ItemUpdateBase_Fields_.NO_FIELDS);
        }
        StringMap<String> res = new StringMap<String>();
        Iterator _g = this.m_changedFields.iterator();
        while (((ArrayIterator)_g).current < ((ArrayIterator)_g).array.length) {
            int fieldPos;
            String fieldName;
            if ((fieldName = (String)((IntMap)((IMap)this.m_fields)).get(fieldPos = Jvm.toInt(((ArrayIterator)_g).array.__get(((ArrayIterator)_g).current++)))) == null) continue;
            String v = CurrFieldValTools.toString((CurrFieldVal)((Object)((IntMap)((IMap)this.m_newValues)).get(fieldPos)));
            res.set(fieldName, v);
        }
        return NativeStringMap_Impl_._new(res);
    }

    @Override
    public Map getChangedFieldsByPosition() {
        IntMap<String> res = new IntMap<String>();
        Iterator _g = this.m_changedFields.iterator();
        while (((ArrayIterator)_g).current < ((ArrayIterator)_g).array.length) {
            int fieldPos = Jvm.toInt(((ArrayIterator)_g).array.__get(((ArrayIterator)_g).current++));
            String v = CurrFieldValTools.toString((CurrFieldVal)((Object)((IntMap)((IMap)this.m_newValues)).get(fieldPos)));
            res.set(fieldPos, v);
        }
        return NativeIntMap_Impl_._new(res);
    }

    @Override
    public Map getFields() throws IllegalStateException {
        if (this.m_fields == null) {
            throw new IllegalStateException(ItemUpdateBase_Fields_.NO_FIELDS);
        }
        StringMap<String> res = new StringMap<String>();
        IMap this1 = this.m_fields;
        Iterator _g_keys = this1.keys();
        while (_g_keys.hasNext()) {
            int key = Jvm.toInt(_g_keys.next());
            String _g_value = (String)this1.get(key);
            String v = CurrFieldValTools.toString((CurrFieldVal)((Object)((IntMap)((IMap)this.m_newValues)).get(key)));
            res.set(_g_value, v);
        }
        return NativeStringMap_Impl_._new(res);
    }

    @Override
    public Map getFieldsByPosition() {
        IntMap<String> _g = new IntMap<String>();
        IMap this1 = this.m_newValues;
        Iterator _g_keys = this1.keys();
        while (_g_keys.hasNext()) {
            int key = Jvm.toInt(_g_keys.next());
            CurrFieldVal _g_value = (CurrFieldVal)((Object)this1.get(key));
            _g.set(key, CurrFieldValTools.toString(_g_value));
        }
        return NativeIntMap_Impl_._new(_g);
    }

    public String getValuePos(int fieldPos) throws IllegalArgumentException {
        if (1 > fieldPos || fieldPos > this.m_nFields) {
            throw new IllegalArgumentException(ItemUpdateBase_Fields_.POS_OUT_BOUNDS);
        }
        return CurrFieldValTools.toString((CurrFieldVal)((Object)((IntMap)((IMap)this.m_newValues)).get(fieldPos)));
    }

    public String getValueName(String fieldName) {
        int fieldPos = this.getFieldIdxFromName(fieldName);
        return CurrFieldValTools.toString((CurrFieldVal)((Object)((IntMap)((IMap)this.m_newValues)).get(fieldPos)));
    }

    public boolean isValueChangedPos(int fieldPos) throws IllegalArgumentException {
        if (1 > fieldPos || fieldPos > this.m_nFields) {
            throw new IllegalArgumentException(ItemUpdateBase_Fields_.POS_OUT_BOUNDS);
        }
        return this.m_changedFields.contains(fieldPos);
    }

    public boolean isValueChangedName(String fieldName) {
        int fieldPos = this.getFieldIdxFromName(fieldName);
        return this.m_changedFields.contains(fieldPos);
    }

    public String getFieldNameOrNullFromIdx(int fieldIdx) {
        if (this.m_fields != null) {
            return (String)((IntMap)((IMap)this.m_fields)).get(fieldIdx);
        }
        return null;
    }

    public int getFieldIdxFromName(String fieldName) throws IllegalStateException, IllegalArgumentException {
        if (this.m_fields == null) {
            throw new IllegalStateException(ItemUpdateBase_Fields_.NO_FIELDS);
        }
        Integer fieldPos = UpdateUtils_Fields_.findFirstIndex(this.m_fields, fieldName);
        if (fieldPos == null) {
            throw new IllegalArgumentException(ItemUpdateBase_Fields_.UNKNOWN_FIELD_NAME);
        }
        return Jvm.toInt(fieldPos);
    }

    public String toString() {
        StringBuf s = new StringBuf();
        s.add("[");
        IMap this1 = this.m_newValues;
        Iterator _g_keys = this1.keys();
        while (_g_keys.hasNext()) {
            int key = Jvm.toInt(_g_keys.next());
            CurrFieldVal _g_value = (CurrFieldVal)((Object)this1.get(key));
            String tmp = this.getFieldNameOrNullFromIdx(key);
            String fieldName = tmp != null ? tmp : Std.string(key);
            String fieldVal = Std.string((Object)_g_value);
            if (key > 1) {
                s.add(",");
            }
            s.add(fieldName);
            s.add(":");
            s.add(fieldVal);
        }
        s.add("]");
        return s.toString();
    }

    public ItemUpdateBase(int itemIdx, LSSubscription sub, IntMap newValues, Set changedFields, boolean isSnapshot, IntMap jsonPatches) {
        super(null);
        Array items = sub.fetch_items();
        Array fields = sub.fetch_fields();
        this.m_itemIdx = itemIdx;
        this.m_items = UpdateUtils_Fields_.toMap(items);
        this.m_nFields = Jvm.toInt(NullTools.sure(sub.fetch_nFields()));
        this.m_fields = UpdateUtils_Fields_.toMap(fields);
        if (fields != null && fields.length != this.m_nFields && LoggerTools_Fields_.subscriptionLogger.isErrorEnabled()) {
            LoggerTools_Fields_.subscriptionLogger.error("Expected " + this.m_nFields + " field names but got " + fields.length + ": " + Std.string(fields), null);
        }
        this.m_newValues = (IntMap)((IMap)newValues.copy());
        this.m_changedFields = changedFields.copy();
        this.m_isSnapshot = isSnapshot;
        this.m_jsonPatches = jsonPatches;
    }

    public /* synthetic */ ItemUpdateBase(EmptyConstructor _) {
        super(_);
    }

    @ClassReflectionInformation(hasSuperClass=false)
    public static final class ItemUpdateBase_Fields_
    extends haxe.jvm.Object {
        public static String NO_FIELDS = "The Subscription was initiated using a Field Schema: the field names are not available";
        public static String POS_OUT_BOUNDS = "The field position is out of bounds";
        public static String UNKNOWN_FIELD_NAME = "The field name is unknown";

        public /* synthetic */ ItemUpdateBase_Fields_(EmptyConstructor _) {
        }
    }
}

