/*
 * Decompiled with CFR 0.152.
 */
package me.chillywilly.issosd.client;

import com.lightstreamer.client.LightstreamerClient;
import com.lightstreamer.client.Subscription;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import me.chillywilly.issosd.client.ISSModConfig;
import me.chillywilly.issosd.client.ISSSubListener;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1921;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssosdClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"issosd");
    public static final ISSModConfig config = new ISSModConfig();
    LightstreamerClient client;
    private float value = 0.0f;
    public static IssosdClient instance;
    public boolean animate = false;
    public static class_2960 texture;
    public static class_2960 normal_texture;
    public static class_2960 notif_texture;
    private static final class_2960 RENDER_LAYER;

    public void onInitializeClient() {
        config.load();
        instance = this;
        this.client = new LightstreamerClient("https://push.lightstreamer.com", "ISSLIVE");
        this.client.connect();
        String[] items = new String[]{"NODE3000005"};
        String[] fields = new String[]{"Value"};
        Subscription sub = new Subscription("MERGE", items, fields);
        sub.setRequestedSnapshot("yes");
        this.client.subscribe(sub);
        sub.addListener(new ISSSubListener());
        texture = normal_texture;
        HudLayerRegistrationCallback.EVENT.register(layeredDrawer -> layeredDrawer.attachLayerBefore(IdentifiedLayer.CHAT, RENDER_LAYER, IssosdClient::render));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"issosd").then(class_2170.method_9244((String)"display_num", (ArgumentType)IntegerArgumentType.integer()).executes(IssosdClient::executeCommandWithArg))));
    }

    private static int executeCommandWithArg(CommandContext<class_2168> context) {
        int value = IntegerArgumentType.getInteger(context, (String)"display_num");
        instance.update(String.valueOf(value));
        return 1;
    }

    private static void render(class_332 context, class_9779 counter) {
        if (!config.getEnabled()) {
            return;
        }
        int color = -5738190;
        int x_start = (int)((double)context.method_51421() * config.getX());
        int y_start = (int)((double)context.method_51443() * config.getY());
        context.method_25290(class_1921::method_62277, texture, x_start, y_start, 0.0f, 0.0f, 16, 16, 16, 16);
        context.method_51433(class_310.method_1551().field_1772, IssosdClient.instance.value + "%", x_start + 20, y_start + 4, color, true);
    }

    public void update(String newValue) {
        try {
            final float val = Float.parseFloat(newValue);
            final float old_value = this.value;
            this.value = val;
            LOGGER.info("Received New Value: {}", (Object)newValue);
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                        if (val == old_value) {
                            return;
                        }
                        if (val > old_value && IssosdClient.this.checkUpSound()) {
                            IssosdClient.this.playSoundToPlayer(config.getUpSound(), config.getUpSoundPitch());
                        }
                        if (val < old_value && IssosdClient.this.checkDownSound()) {
                            IssosdClient.this.playSoundToPlayer(config.getDownSound(), config.getDownSoundPitch());
                        }
                        texture = notif_texture;
                        Thread.sleep(5000L);
                        texture = normal_texture;
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }.start();
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Number provided is not a number: {}", (Object)newValue);
        }
    }

    private void playSoundToPlayer(class_2960 sound, float pitch) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            LOGGER.warn("Player is null, you may not be on a world");
            return;
        }
        player.method_17356(class_3414.method_47908((class_2960)sound), class_3419.field_15254, 1.0f, pitch);
    }

    public boolean checkUpSound() {
        return this.checkMod() && config.getUpSoundEnabled();
    }

    public boolean checkDownSound() {
        return this.checkMod() && config.getDownSoundEnabled();
    }

    public boolean checkMod() {
        return config.getEnabled();
    }

    static {
        normal_texture = class_2960.method_60655((String)"issosd", (String)"textures/gui/piss_icon.png");
        notif_texture = class_2960.method_60655((String)"issosd", (String)"textures/gui/piss_icon_notif.png");
        RENDER_LAYER = class_2960.method_60655((String)"issosd", (String)"piss-display-hud-icon");
    }
}

