/*
 * Decompiled with CFR 0.152.
 */
package haxe.jvm;

import haxe.Exception;
import haxe.ds.Option;
import haxe.jvm.ClosureDispatch;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

@ClassReflectionInformation(hasSuperClass=true)
public class Closure
extends ClosureDispatch {
    public Object context;
    public Method method;
    public boolean isStatic;
    public Class<Object>[] params;

    public Closure bindTo(Object context) {
        return new Closure(context, this.method);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Closure)) {
            return false;
        }
        Closure other2 = (Closure)other;
        if (Jvm.compare(this.context, other2.context) == 0) {
            return this.method == other2.method;
        }
        return false;
    }

    @Override
    public Object invokeDynamic(Object[] args2) throws Object {
        if (this.isStatic && this.context != null) {
            Object[] newArgs = new Object[args2.length + 1];
            System.arraycopy(args2, 0, newArgs, 1, args2.length);
            newArgs[0] = this.context;
            args2 = newArgs;
        }
        Object[] args1 = null;
        Option _g = Jvm.unifyCallArguments(args2, this.params, true);
        switch (_g.ordinal()) {
            case 0: {
                args1 = (Object[])((Option.Some)_g).v;
                break;
            }
            case 1: {
                args1 = args2;
            }
        }
        try {
            return this.method.invoke(this.context, args1);
        }
        catch (InvocationTargetException e) {
            throw (RuntimeException)Exception.thrown(e.getCause());
        }
    }

    public Closure(Object context, Method method) {
        this.context = context;
        this.method = method;
        this.isStatic = (method.getModifiers() & Modifier.STATIC) != 0;
        this.params = method.getParameterTypes();
    }

    public /* synthetic */ Closure(EmptyConstructor _) {
        super(_);
    }
}

