/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client;

import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.util.Named;
import com.lightstreamer.client.ItemUpdate;
import com.lightstreamer.client.SubscriptionListener;
import com.lightstreamer.client._Subscription.SubscriptionEventDispatcher;
import com.lightstreamer.client._Subscription.SubscriptionState;
import com.lightstreamer.client.internal.SubscriptionManagerLiving;
import com.lightstreamer.internal.InfoMap;
import com.lightstreamer.internal.RLock;
import com.lightstreamer.internal.RealMaxFrequency;
import com.lightstreamer.internal.RequestedBufferSize;
import com.lightstreamer.internal.RequestedBufferSizeTools;
import com.lightstreamer.internal.RequestedMaxFrequency;
import com.lightstreamer.internal.RequestedMaxFrequencyTools;
import com.lightstreamer.internal.RequestedSnapshot;
import com.lightstreamer.internal.RequestedSnapshotTools;
import com.lightstreamer.internal._NativeTypes.NativeArray_Impl_;
import com.lightstreamer.internal._NativeTypes.NativeList_Impl_;
import com.lightstreamer.internal._Types.Fields_Impl_;
import com.lightstreamer.internal._Types.Items_Impl_;
import com.lightstreamer.internal._Types.Name_Impl_;
import com.lightstreamer.internal._Types.SubscriptionMode_Impl_;
import com.lightstreamer.internal._Types.Types_Fields_;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.jvm.annotation.EnumReflectionInformation;
import haxe.jvm.annotation.EnumValueReflectionInformation;
import haxe.root.Array;
import haxe.root.Std;
import java.net.ProtocolFamily;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.AttributeView;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;

@ClassReflectionInformation(hasSuperClass=false)
public class LSSubscription
extends haxe.jvm.Object {
    public SubscriptionEventDispatcher eventDispatcher;
    public String mode;
    public Array<String> items;
    public Array<String> fields;
    public String group;
    public String schema;
    public String dataAdapter;
    public RequestedBufferSize bufferSize;
    public RequestedSnapshot snapshot;
    public RequestedMaxFrequency requestedMaxFrequency;
    public String selector;
    public String dataAdapter2;
    public Array<String> fields2;
    public String schema2;
    public SubscriptionState state;
    public Integer subId;
    public Integer cmdIdx;
    public Integer keyIdx;
    public Integer nItems;
    public Integer nFields;
    public boolean m_internal;
    public SubscriptionManagerLiving manager;
    public Object wrapper;
    public RLock lock;

    public void initSnapshot() {
        this.snapshot = Jvm.stringCompare(this.mode, "RAW") == 0 ? null : RequestedSnapshot.SnpYes;
    }

    public void initItemsAndFields(String[] items, String[] fields) throws IllegalArgumentException {
        if (items != null) {
            if (fields == null) {
                throw new IllegalArgumentException("Please specify a valid field list");
            }
            this.items = Items_Impl_.fromArray(NativeArray_Impl_.toHaxe(items));
            this.fields = Fields_Impl_.fromArray(NativeArray_Impl_.toHaxe(fields));
            if (Jvm.stringCompare(this.mode, "COMMAND") == 0 && !this.fields.contains("key")) {
                throw new IllegalArgumentException("Field 'key' is missing");
            }
            if (Jvm.stringCompare(this.mode, "COMMAND") == 0 && !this.fields.contains("command")) {
                throw new IllegalArgumentException("Field 'command' is missing");
            }
            return;
        }
        if (fields != null) {
            throw new IllegalArgumentException("Please specify a valid item or item list");
        }
    }

    public void addListener(SubscriptionListener listener) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_addListener_0(_gthis, listener));
    }

    public void removeListener(SubscriptionListener listener) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_removeListener_0(_gthis, listener));
    }

    public List getListeners() {
        LSSubscription _gthis = this;
        return (List)this.lock.synchronized(new Closure_getListeners_0(_gthis));
    }

    public boolean isActive() {
        LSSubscription _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_isActive_0(_gthis)));
    }

    public boolean isSubscribed() {
        LSSubscription _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_isSubscribed_0(_gthis)));
    }

    public String getDataAdapter() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getDataAdapter_0(_gthis));
    }

    public void setDataAdapter(String dataAdapter) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setDataAdapter_0(_gthis, dataAdapter));
    }

    public String getMode() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getMode_0(_gthis));
    }

    public String[] getItems() {
        LSSubscription _gthis = this;
        return (String[])this.lock.synchronized(new Closure_getItems_0(_gthis));
    }

    public Array fetchItems() {
        LSSubscription _gthis = this;
        return (Array)this.lock.synchronized(new Closure_fetchItems_0(_gthis));
    }

    public void setItems(String[] items) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setItems_0(_gthis, items));
    }

    public String getItemGroup() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getItemGroup_0(_gthis));
    }

    public void setItemGroup(String group) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setItemGroup_0(_gthis, group));
    }

    public String[] getFields() {
        LSSubscription _gthis = this;
        return (String[])this.lock.synchronized(new Closure_getFields_0(_gthis));
    }

    public Array fetchFields() {
        LSSubscription _gthis = this;
        return (Array)this.lock.synchronized(new Closure_fetchFields_0(_gthis));
    }

    public void setFields(String[] fields) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setFields_0(_gthis, fields));
    }

    public String getFieldSchema() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getFieldSchema_0(_gthis));
    }

    public void setFieldSchema(String schema) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setFieldSchema_0(_gthis, schema));
    }

    public String getRequestedBufferSize() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getRequestedBufferSize_0(_gthis));
    }

    public void setRequestedBufferSize(String size) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setRequestedBufferSize_0(_gthis, size));
    }

    public String getRequestedSnapshot() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getRequestedSnapshot_0(_gthis));
    }

    public void setRequestedSnapshot(String snapshot) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setRequestedSnapshot_0(_gthis, snapshot));
    }

    public String getRequestedMaxFrequency() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getRequestedMaxFrequency_0(_gthis));
    }

    public void setRequestedMaxFrequency(String freq) {
        SubscriptionManagerLiving[] _manager = new SubscriptionManagerLiving[1];
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setRequestedMaxFrequency_0(freq, _gthis, _manager));
        if (_manager[0] != null) {
            _manager[0].evtExtConfigure();
        }
    }

    public String getSelector() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getSelector_0(_gthis));
    }

    public void setSelector(String selector) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setSelector_0(_gthis, selector));
    }

    public int getCommandPosition() {
        LSSubscription _gthis = this;
        return Jvm.toInt(this.lock.synchronized(new Closure_getCommandPosition_0(_gthis)));
    }

    public int getKeyPosition() {
        LSSubscription _gthis = this;
        return Jvm.toInt(this.lock.synchronized(new Closure_getKeyPosition_0(_gthis)));
    }

    public String getCommandSecondLevelDataAdapter() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getCommandSecondLevelDataAdapter_0(_gthis));
    }

    public void setCommandSecondLevelDataAdapter(String dataAdapter) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setCommandSecondLevelDataAdapter_0(_gthis, dataAdapter));
    }

    public String[] getCommandSecondLevelFields() {
        LSSubscription _gthis = this;
        return (String[])this.lock.synchronized(new Closure_getCommandSecondLevelFields_0(_gthis));
    }

    public void setCommandSecondLevelFields(String[] fields) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setCommandSecondLevelFields_0(_gthis, fields));
    }

    public String getCommandSecondLevelFieldSchema() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getCommandSecondLevelFieldSchema_0(_gthis));
    }

    public void setCommandSecondLevelFieldSchema(String schema) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setCommandSecondLevelFieldSchema_0(_gthis, schema));
    }

    public String getValue(int itemPos, int fieldPos) throws IllegalArgumentException {
        if (itemPos < 1 || fieldPos < 1) {
            throw new IllegalArgumentException("The specified position is out of bounds");
        }
        SubscriptionManagerLiving[] _manager = new SubscriptionManagerLiving[1];
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_getValue_0(_manager, _gthis));
        if (_manager[0] != null) {
            return _manager[0].getValue(itemPos, fieldPos);
        }
        return null;
    }

    public String getValue(String itemName, String fieldName) {
        LSSubscription _gthis = this;
        int itemPos = Jvm.toInt(this.lock.synchronized(new Closure_getValue_1(_gthis, itemName)));
        int fieldPos = Jvm.toInt(this.lock.synchronized(new Closure_getValue_2(_gthis, fieldName)));
        return this.getValue(itemPos, fieldPos);
    }

    public String getValue(String itemName, int fieldPos) {
        LSSubscription _gthis = this;
        int itemPos = Jvm.toInt(this.lock.synchronized(new Closure_getValue_3(_gthis, itemName)));
        return this.getValue(itemPos, fieldPos);
    }

    public String getValue(int itemPos, String fieldName) {
        LSSubscription _gthis = this;
        int fieldPos = Jvm.toInt(this.lock.synchronized(new Closure_getValue_4(_gthis, fieldName)));
        return this.getValue(itemPos, fieldPos);
    }

    public String getCommandValue(int itemPos, String keyValue, int fieldPos) throws IllegalArgumentException {
        this.checkCommand();
        if (itemPos < 1 || fieldPos < 1) {
            throw new IllegalArgumentException("The specified position is out of bounds");
        }
        SubscriptionManagerLiving[] _manager = new SubscriptionManagerLiving[1];
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_getCommandValue_0(_manager, _gthis));
        if (_manager[0] != null) {
            return _manager[0].getCommandValue(itemPos, keyValue, fieldPos);
        }
        return null;
    }

    public String getCommandValue(String itemName, String keyValue, String fieldName) {
        LSSubscription _gthis = this;
        int itemPos = Jvm.toInt(this.lock.synchronized(new Closure_getCommandValue_1(_gthis, itemName)));
        int fieldPos = Jvm.toInt(this.lock.synchronized(new Closure_getCommandValue_2(_gthis, fieldName)));
        return this.getCommandValue(itemPos, keyValue, fieldPos);
    }

    public String getCommandValue(String itemName, String keyValue, int fieldPos) {
        LSSubscription _gthis = this;
        int itemPos = Jvm.toInt(this.lock.synchronized(new Closure_getCommandValue_3(_gthis, itemName)));
        return this.getCommandValue(itemPos, keyValue, fieldPos);
    }

    public String getCommandValue(int itemPos, String keyValue, String fieldName) {
        LSSubscription _gthis = this;
        int fieldPos = Jvm.toInt(this.lock.synchronized(new Closure_getCommandValue_4(_gthis, fieldName)));
        return this.getCommandValue(itemPos, keyValue, fieldPos);
    }

    public int getItemPos(String itemName) throws IllegalArgumentException {
        int itemPos = 0;
        boolean tmp = false;
        tmp = this.items != null ? (itemPos = Items_Impl_.getPos(this.items, itemName)) == -1 : true;
        if (tmp) {
            throw new IllegalArgumentException("Unknown item name");
        }
        return itemPos;
    }

    public int getFieldPos(String fieldName) throws IllegalArgumentException {
        int fieldPos = 0;
        boolean tmp = false;
        tmp = this.fields != null ? (fieldPos = Fields_Impl_.getPos(this.fields, fieldName)) == -1 : true;
        if (tmp) {
            throw new IllegalArgumentException("Unknown field name");
        }
        return fieldPos;
    }

    public void checkActive() throws IllegalStateException {
        if (this.isActive()) {
            throw new IllegalStateException("Cannot modify an active Subscription. Please unsubscribe before applying any change");
        }
    }

    public void checkCommand() throws IllegalStateException {
        if (Jvm.stringCompare(this.mode, "COMMAND") != 0) {
            throw new IllegalStateException("This method can only be used on COMMAND subscriptions");
        }
    }

    public Array fetch_items() {
        LSSubscription _gthis = this;
        return (Array)this.lock.synchronized(new Closure_fetch_items_0(_gthis));
    }

    public Array fetch_fields() {
        LSSubscription _gthis = this;
        return (Array)this.lock.synchronized(new Closure_fetch_fields_0(_gthis));
    }

    public Array fetch_fields2() {
        LSSubscription _gthis = this;
        return (Array)this.lock.synchronized(new Closure_fetch_fields2_0(_gthis));
    }

    public String fetch_mode() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_fetch_mode_0(_gthis));
    }

    public RequestedBufferSize fetch_requestedBufferSize() {
        LSSubscription _gthis = this;
        return (RequestedBufferSize)((Object)this.lock.synchronized(new Closure_fetch_requestedBufferSize_0(_gthis)));
    }

    public RequestedSnapshot fetch_requestedSnapshot() {
        LSSubscription _gthis = this;
        return (RequestedSnapshot)((Object)this.lock.synchronized(new Closure_fetch_requestedSnapshot_0(_gthis)));
    }

    public RequestedMaxFrequency fetch_requestedMaxFrequency() {
        LSSubscription _gthis = this;
        return (RequestedMaxFrequency)((Object)this.lock.synchronized(new Closure_fetch_requestedMaxFrequency_0(_gthis)));
    }

    public Integer fetch_nItems() {
        LSSubscription _gthis = this;
        return Jvm.dynamicToInteger(this.lock.synchronized(new Closure_fetch_nItems_0(_gthis)));
    }

    public SubscriptionManagerLiving fetch_subManager() {
        LSSubscription _gthis = this;
        return (SubscriptionManagerLiving)this.lock.synchronized(new Closure_fetch_subManager_0(_gthis));
    }

    public void setActive() {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setActive_0(_gthis));
    }

    public void setInactive() {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setInactive_0(_gthis));
    }

    public void setSubscribed(int subId, int nItems, int nFields) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setSubscribed_0(_gthis, subId, nItems, nFields));
    }

    public void setSubscribedCMD(int subId, int nItems, int nFields, int cmdIdx, int keyIdx) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setSubscribedCMD_0(_gthis, subId, cmdIdx, keyIdx, nItems, nFields));
    }

    public Integer fetch_nFields() {
        LSSubscription _gthis = this;
        return Jvm.dynamicToInteger(this.lock.synchronized(new Closure_fetch_nFields_0(_gthis)));
    }

    public boolean isInternal() {
        LSSubscription _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_isInternal_0(_gthis)));
    }

    public void setInternal() {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_setInternal_0(_gthis));
    }

    public String getItemName(int itemIdx) {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_getItemName_0(_gthis, itemIdx));
    }

    public void relate(SubscriptionManagerLiving manager) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_relate_0(_gthis, manager));
    }

    public void unrelate(SubscriptionManagerLiving manager) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_unrelate_0(_gthis, manager));
    }

    public boolean hasSnapshot() {
        LSSubscription _gthis = this;
        return Jvm.toBoolean(this.lock.synchronized(new Closure_hasSnapshot_0(_gthis)));
    }

    public String getItemNameOrPos(int itemIdx) {
        if (this.items != null) {
            return this.items.__get(itemIdx - 1);
        }
        return "" + itemIdx;
    }

    public void fireOnSubscription(int subId) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnSubscription_0(subId, _gthis));
    }

    public void fireOnUnsubscription(int subId) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnUnsubscription_0(subId, _gthis));
    }

    public void fireOnSubscriptionError(int subId, int code, String msg) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnSubscriptionError_0(subId, code, msg, _gthis));
    }

    public void fireOnEndOfSnapshot(int itemIdx, int subId) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnEndOfSnapshot_0(subId, _gthis, itemIdx));
    }

    public void fireOnClearSnapshot(int itemIdx, int subId) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnClearSnapshot_0(subId, _gthis, itemIdx));
    }

    public void fireOnLostUpdates(int itemIdx, int lostUpdates, int subId) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnLostUpdates_0(subId, _gthis, itemIdx, lostUpdates));
    }

    public void fireOnItemUpdate(ItemUpdate update, int subId) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnItemUpdate_0(subId, _gthis, update));
    }

    public void fireOnRealMaxFrequency(RealMaxFrequency freq, int subId) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnRealMaxFrequency_0(subId, freq, _gthis));
    }

    public void fireOnSubscriptionError2Level(String keyName, int code, String msg, int subId, int itemIdx) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnSubscriptionError2Level_0(subId, _gthis, itemIdx, keyName, code, msg));
    }

    public void fireOnLostUpdates2Level(String keyName, int lostUpdates, int subId, int itemIdx) {
        LSSubscription _gthis = this;
        this.lock.synchronized(new Closure_fireOnLostUpdates2Level_0(subId, _gthis, itemIdx, keyName, lostUpdates));
    }

    public String toString() {
        LSSubscription _gthis = this;
        return (String)this.lock.synchronized(new Closure_toString_0(_gthis));
    }

    public LSSubscription(String mode, String[] items, String[] fields, Object wrapper) {
        this.eventDispatcher = new SubscriptionEventDispatcher();
        this.state = SubscriptionState.Inactive;
        this.m_internal = false;
        this.lock = new RLock();
        this.wrapper = wrapper;
        this.mode = SubscriptionMode_Impl_.fromString(mode);
        this.initSnapshot();
        this.initItemsAndFields(items, fields);
    }

    public LSSubscription(String mode, String item, String[] fields, Object wrapper) {
        this.eventDispatcher = new SubscriptionEventDispatcher();
        this.state = SubscriptionState.Inactive;
        this.m_internal = false;
        this.lock = new RLock();
        this.wrapper = wrapper;
        this.mode = SubscriptionMode_Impl_.fromString(mode);
        this.initSnapshot();
        Array<String> a = Array.ofNative(new String[]{item});
        String[] ret = new String[a.length];
        int _g = 0;
        int _g1 = a.length;
        while (_g < _g1) {
            int i = _g++;
            ret[i] = a.__get(i);
        }
        this.initItemsAndFields(ret, fields);
    }

    public LSSubscription(String mode, Object wrapper) {
        this.eventDispatcher = new SubscriptionEventDispatcher();
        this.state = SubscriptionState.Inactive;
        this.m_internal = false;
        this.lock = new RLock();
        this.wrapper = wrapper;
        this.mode = SubscriptionMode_Impl_.fromString(mode);
        this.initSnapshot();
    }

    public /* synthetic */ LSSubscription(EmptyConstructor _) {
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getMode_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getMode_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.mode;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getCommandSecondLevelFields_0
    extends Function
    implements JsonIncludeProperties,
    PrivilegedAction<String[]>,
    PrivilegedExceptionAction<String[]>,
    Callable<String[]>,
    Supplier<String[]>,
    EnumReflectionInformation,
    EnumValueReflectionInformation,
    Function0<String[]> {
        public final LSSubscription _gthis;

        public Closure_getCommandSecondLevelFields_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String[] invoke() {
            if (this._gthis.fields2 == null) {
                return null;
            }
            Array<String> a = this._gthis.fields2;
            String[] ret = new String[a.length];
            int _g = 0;
            int _g1 = a.length;
            while (_g < _g1) {
                int i = _g++;
                ret[i] = a.__get(i);
            }
            return ret;
        }

        @Override
        public String[] argumentNames() {
            return this.invoke();
        }

        @Override
        public String[] constructorNames() {
            return this.invoke();
        }

        @Override
        public String[] get() {
            return this.invoke();
        }

        @Override
        public String[] call() {
            return this.invoke();
        }

        @Override
        public String[] run() {
            return this.invoke();
        }

        @Override
        public String[] value() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_fields2_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSSubscription _gthis;

        public Closure_fetch_fields2_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public Array invoke() {
            return this._gthis.fields2;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_requestedSnapshot_0
    extends Function
    implements PrivilegedAction<RequestedSnapshot>,
    PrivilegedExceptionAction<RequestedSnapshot>,
    Callable<RequestedSnapshot>,
    Supplier<RequestedSnapshot>,
    Function0<RequestedSnapshot> {
        public final LSSubscription _gthis;

        public Closure_fetch_requestedSnapshot_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public RequestedSnapshot invoke() {
            return this._gthis.snapshot;
        }

        @Override
        public RequestedSnapshot get() {
            return this.invoke();
        }

        @Override
        public RequestedSnapshot call() {
            return this.invoke();
        }

        @Override
        public RequestedSnapshot run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_isActive_0
    extends Function
    implements PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final LSSubscription _gthis;

        public Closure_isActive_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis.state != SubscriptionState.Inactive;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnSubscription_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final LSSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnSubscription_0(int subId, LSSubscription lSSubscription) {
            void _gthis;
            this.subId = subId;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.info("Subscription " + this.subId + " added", null);
            }
            this._gthis.eventDispatcher.onSubscription();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnLostUpdates_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final LSSubscription _gthis;
        public final int itemIdx;
        public final int lostUpdates;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnLostUpdates_0(int subId, LSSubscription lSSubscription, int n, int n2) {
            void lostUpdates;
            void itemIdx;
            void _gthis;
            this.subId = subId;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
            this.lostUpdates = lostUpdates;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isDebugEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.debug("Subscription " + this.subId + ":" + this._gthis.getItemNameOrPos(this.itemIdx) + ": lost " + this.lostUpdates + " updates", null);
            }
            this._gthis.eventDispatcher.onItemLostUpdates(this._gthis.getItemName(this.itemIdx), this.itemIdx, this.lostUpdates);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getValue_3
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final String itemName;

        /*
         * WARNING - void declaration
         */
        public Closure_getValue_3(LSSubscription _gthis, String string) {
            void itemName;
            this._gthis = _gthis;
            this.itemName = itemName;
        }

        @Override
        public int invoke() {
            return this._gthis.getItemPos(this.itemName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetchFields_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSSubscription _gthis;

        public Closure_fetchFields_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public Array invoke() {
            return this._gthis.fields;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setCommandSecondLevelFields_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;
        public final String[] fields;

        /*
         * WARNING - void declaration
         */
        public Closure_setCommandSecondLevelFields_0(LSSubscription _gthis, String[] stringArray) {
            void fields;
            this._gthis = _gthis;
            this.fields = fields;
        }

        @Override
        public String invoke() {
            Array newValue;
            this._gthis.checkActive();
            this._gthis.checkCommand();
            this._gthis.fields2 = newValue = Fields_Impl_.fromArray(this.fields == null ? null : NativeArray_Impl_.toHaxe(this.fields));
            this._gthis.schema2 = null;
            return null;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_relate_0
    extends Function
    implements PrivilegedAction<SubscriptionManagerLiving>,
    PrivilegedExceptionAction<SubscriptionManagerLiving>,
    Callable<SubscriptionManagerLiving>,
    Supplier<SubscriptionManagerLiving>,
    Function0<SubscriptionManagerLiving> {
        public final LSSubscription _gthis;
        public final SubscriptionManagerLiving manager;

        /*
         * WARNING - void declaration
         */
        public Closure_relate_0(LSSubscription _gthis, SubscriptionManagerLiving subscriptionManagerLiving) {
            void manager;
            this._gthis = _gthis;
            this.manager = manager;
        }

        @Override
        public SubscriptionManagerLiving invoke() {
            this._gthis.manager = this.manager;
            return this._gthis.manager;
        }

        @Override
        public SubscriptionManagerLiving get() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving call() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnEndOfSnapshot_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final LSSubscription _gthis;
        public final int itemIdx;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnEndOfSnapshot_0(int subId, LSSubscription lSSubscription, int n) {
            void itemIdx;
            void _gthis;
            this.subId = subId;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isDebugEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.debug("Subscription " + this.subId + ":" + this._gthis.getItemNameOrPos(this.itemIdx) + ": snapshot ended", null);
            }
            this._gthis.eventDispatcher.onEndOfSnapshot(this._gthis.getItemName(this.itemIdx), this.itemIdx);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setRequestedMaxFrequency_0
    extends Function
    implements PrivilegedAction<SubscriptionManagerLiving>,
    PrivilegedExceptionAction<SubscriptionManagerLiving>,
    Callable<SubscriptionManagerLiving>,
    Supplier<SubscriptionManagerLiving>,
    Function0<SubscriptionManagerLiving> {
        public final String freq;
        public final LSSubscription _gthis;
        public final SubscriptionManagerLiving[] _manager;

        /*
         * WARNING - void declaration
         */
        public Closure_setRequestedMaxFrequency_0(String freq, LSSubscription lSSubscription, SubscriptionManagerLiving[] subscriptionManagerLivingArray) {
            void _manager;
            void _gthis;
            this.freq = freq;
            this._gthis = _gthis;
            this._manager = _manager;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SubscriptionManagerLiving invoke() throws IllegalArgumentException {
            RequestedMaxFrequency newValue = RequestedMaxFrequencyTools.fromString(this.freq);
            String _hx_tmp = this._gthis.mode;
            if (_hx_tmp == null) throw new IllegalArgumentException("The operation in only available on MERGE, DISTINCT and COMMAND Subscripitons");
            int n = -1;
            switch (_hx_tmp.hashCode()) {
                case 73247768: {
                    if (_hx_tmp.equals("MERGE")) {
                        n = 1;
                    }
                    break;
                }
                case 1071324924: {
                    if (_hx_tmp.equals("DISTINCT")) {
                        n = 1;
                    }
                    break;
                }
                case 1668377387: {
                    if (_hx_tmp.equals("COMMAND")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The operation in only available on MERGE, DISTINCT and COMMAND Subscripitons");
                }
            }
            if (this._gthis.isActive() && (newValue == null || newValue == RequestedMaxFrequency.FreqUnfiltered || this._gthis.requestedMaxFrequency == RequestedMaxFrequency.FreqUnfiltered)) {
                throw new IllegalArgumentException("Cannot change the frequency from/to 'unfiltered' or to null while the Subscription is active");
            }
            if (this._gthis.subId != null && LoggerTools_Fields_.subscriptionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.info("Subscription " + this._gthis.subId + " requested max frequency changed: " + this.freq, null);
            }
            this._gthis.requestedMaxFrequency = newValue;
            this._manager[0] = this._gthis.manager;
            return this._manager[0];
        }

        @Override
        public SubscriptionManagerLiving get() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving call() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getValue_2
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final String fieldName;

        /*
         * WARNING - void declaration
         */
        public Closure_getValue_2(LSSubscription _gthis, String string) {
            void fieldName;
            this._gthis = _gthis;
            this.fieldName = fieldName;
        }

        @Override
        public int invoke() {
            return this._gthis.getFieldPos(this.fieldName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setInactive_0
    extends Function
    implements PrivilegedAction<Integer>,
    PrivilegedExceptionAction<Integer>,
    Callable<Integer>,
    Supplier<Integer>,
    Function0<Integer> {
        public final LSSubscription _gthis;

        public Closure_setInactive_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public Integer invoke() {
            this._gthis.state = SubscriptionState.Inactive;
            this._gthis.subId = null;
            this._gthis.cmdIdx = null;
            this._gthis.keyIdx = null;
            this._gthis.nItems = null;
            this._gthis.nFields = null;
            return this._gthis.nFields;
        }

        @Override
        public Integer get() {
            return this.invoke();
        }

        @Override
        public Integer call() {
            return this.invoke();
        }

        @Override
        public Integer run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_fields_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSSubscription _gthis;

        public Closure_fetch_fields_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public Array invoke() {
            return this._gthis.fields;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getListeners_0
    extends Function
    implements PrivilegedAction<List<SubscriptionListener>>,
    PrivilegedExceptionAction<List<SubscriptionListener>>,
    Callable<List<SubscriptionListener>>,
    Supplier<List<SubscriptionListener>>,
    Function0<List<SubscriptionListener>> {
        public final LSSubscription _gthis;

        public Closure_getListeners_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public List invoke() {
            return NativeList_Impl_._new(this._gthis.eventDispatcher.getListeners());
        }

        @Override
        public List get() {
            return this.invoke();
        }

        @Override
        public List call() {
            return this.invoke();
        }

        @Override
        public List run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_subManager_0
    extends Function
    implements PrivilegedAction<SubscriptionManagerLiving>,
    PrivilegedExceptionAction<SubscriptionManagerLiving>,
    Callable<SubscriptionManagerLiving>,
    Supplier<SubscriptionManagerLiving>,
    Function0<SubscriptionManagerLiving> {
        public final LSSubscription _gthis;

        public Closure_fetch_subManager_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public SubscriptionManagerLiving invoke() {
            return this._gthis.manager;
        }

        @Override
        public SubscriptionManagerLiving get() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving call() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_nItems_0
    extends Function
    implements PrivilegedAction<Integer>,
    PrivilegedExceptionAction<Integer>,
    Callable<Integer>,
    Supplier<Integer>,
    Function0<Integer> {
        public final LSSubscription _gthis;

        public Closure_fetch_nItems_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public Integer invoke() {
            return this._gthis.nItems;
        }

        @Override
        public Integer get() {
            return this.invoke();
        }

        @Override
        public Integer call() {
            return this.invoke();
        }

        @Override
        public Integer run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getCommandValue_2
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final String fieldName;

        /*
         * WARNING - void declaration
         */
        public Closure_getCommandValue_2(LSSubscription _gthis, String string) {
            void fieldName;
            this._gthis = _gthis;
            this.fieldName = fieldName;
        }

        @Override
        public int invoke() {
            return this._gthis.getFieldPos(this.fieldName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setRequestedSnapshot_0
    extends Function
    implements PrivilegedAction<RequestedSnapshot>,
    PrivilegedExceptionAction<RequestedSnapshot>,
    Callable<RequestedSnapshot>,
    Supplier<RequestedSnapshot>,
    Function0<RequestedSnapshot> {
        public final LSSubscription _gthis;
        public final String snapshot;

        /*
         * WARNING - void declaration
         */
        public Closure_setRequestedSnapshot_0(LSSubscription _gthis, String string) {
            void snapshot;
            this._gthis = _gthis;
            this.snapshot = snapshot;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public RequestedSnapshot invoke() throws IllegalArgumentException {
            block13: {
                this._gthis.checkActive();
                newValue = RequestedSnapshotTools.fromString(this.snapshot);
                _hx_tmp = this._gthis.mode;
                if (_hx_tmp == null) break block13;
                switch (_hx_tmp.hashCode()) {
                    case 80904: {
                        if (!_hx_tmp.equals("RAW") || newValue == null) break;
                        throw new IllegalArgumentException("Snapshot is not permitted if RAW was specified as mode");
                    }
                    case 73247768: {
                        if (!_hx_tmp.equals("MERGE")) {
                            break;
                        }
                        ** GOTO lbl15
                    }
                    case 1668377387: {
                        if (!_hx_tmp.equals("COMMAND")) break;
lbl15:
                        // 2 sources

                        tmp = false;
                        if (newValue != null) {
                            if (newValue == null) {
                                tmp = false;
                            } else {
                                switch (newValue.ordinal()) {
                                    default: {
                                        tmp = false;
                                        break;
                                    }
                                    case 2: {
                                        tmp = true;
                                    }
                                }
                            }
                        } else {
                            tmp = false;
                        }
                        if (!tmp) break;
                        throw new IllegalArgumentException("Snapshot length is not permitted if MERGE or COMMAND was specified as mode");
                    }
                }
            }
            this._gthis.snapshot = newValue;
            return this._gthis.snapshot;
        }

        @Override
        public RequestedSnapshot get() {
            return this.invoke();
        }

        @Override
        public RequestedSnapshot call() {
            return this.invoke();
        }

        @Override
        public RequestedSnapshot run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_hasSnapshot_0
    extends Function
    implements PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final LSSubscription _gthis;

        public Closure_hasSnapshot_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis.snapshot != null && this._gthis.snapshot != RequestedSnapshot.SnpNo;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnClearSnapshot_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final LSSubscription _gthis;
        public final int itemIdx;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnClearSnapshot_0(int subId, LSSubscription lSSubscription, int n) {
            void itemIdx;
            void _gthis;
            this.subId = subId;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isDebugEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.debug("Subscription " + this.subId + ":" + this._gthis.getItemNameOrPos(this.itemIdx) + ": snapshot cleared", null);
            }
            this._gthis.eventDispatcher.onClearSnapshot(this._gthis.getItemName(this.itemIdx), this.itemIdx);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getRequestedMaxFrequency_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getRequestedMaxFrequency_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return RequestedMaxFrequencyTools.toString(this._gthis.requestedMaxFrequency);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getCommandSecondLevelDataAdapter_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getCommandSecondLevelDataAdapter_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.dataAdapter2;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_removeListener_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final SubscriptionListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_removeListener_0(LSSubscription _gthis, SubscriptionListener subscriptionListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.removeListenerAndFireOnListenEnd(this.listener);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setItemGroup_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSSubscription _gthis;
        public final String group;

        /*
         * WARNING - void declaration
         */
        public Closure_setItemGroup_0(LSSubscription _gthis, String string) {
            void group;
            this._gthis = _gthis;
            this.group = group;
        }

        @Override
        public Array invoke() {
            this._gthis.checkActive();
            this._gthis.group = Name_Impl_.fromString(this.group);
            this._gthis.items = null;
            return null;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setCommandSecondLevelDataAdapter_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;
        public final String dataAdapter;

        /*
         * WARNING - void declaration
         */
        public Closure_setCommandSecondLevelDataAdapter_0(LSSubscription _gthis, String string) {
            void dataAdapter;
            this._gthis = _gthis;
            this.dataAdapter = dataAdapter;
        }

        @Override
        public String invoke() {
            this._gthis.checkActive();
            this._gthis.checkCommand();
            this._gthis.dataAdapter2 = Name_Impl_.fromString(this.dataAdapter);
            return this._gthis.dataAdapter2;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getValue_1
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final String itemName;

        /*
         * WARNING - void declaration
         */
        public Closure_getValue_1(LSSubscription _gthis, String string) {
            void itemName;
            this._gthis = _gthis;
            this.itemName = itemName;
        }

        @Override
        public int invoke() {
            return this._gthis.getItemPos(this.itemName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_items_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSSubscription _gthis;

        public Closure_fetch_items_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public Array invoke() {
            return this._gthis.items;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnItemUpdate_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final LSSubscription _gthis;
        public final ItemUpdate update;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnItemUpdate_0(int subId, LSSubscription lSSubscription, ItemUpdate itemUpdate) {
            void update;
            void _gthis;
            this.subId = subId;
            this._gthis = _gthis;
            this.update = update;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isDebugEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.debug("Subscription " + this.subId + ":" + this._gthis.getItemNameOrPos(this.update.getItemPos()) + " update: " + Std.string(this.update), null);
            }
            this._gthis.eventDispatcher.onItemUpdate(this.update);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getFieldSchema_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getFieldSchema_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.schema;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_requestedMaxFrequency_0
    extends Function
    implements PrivilegedAction<RequestedMaxFrequency>,
    PrivilegedExceptionAction<RequestedMaxFrequency>,
    Callable<RequestedMaxFrequency>,
    Supplier<RequestedMaxFrequency>,
    Function0<RequestedMaxFrequency> {
        public final LSSubscription _gthis;

        public Closure_fetch_requestedMaxFrequency_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public RequestedMaxFrequency invoke() {
            return this._gthis.requestedMaxFrequency;
        }

        @Override
        public RequestedMaxFrequency get() {
            return this.invoke();
        }

        @Override
        public RequestedMaxFrequency call() {
            return this.invoke();
        }

        @Override
        public RequestedMaxFrequency run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_requestedBufferSize_0
    extends Function
    implements PrivilegedAction<RequestedBufferSize>,
    PrivilegedExceptionAction<RequestedBufferSize>,
    Callable<RequestedBufferSize>,
    Supplier<RequestedBufferSize>,
    Function0<RequestedBufferSize> {
        public final LSSubscription _gthis;

        public Closure_fetch_requestedBufferSize_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public RequestedBufferSize invoke() {
            return this._gthis.bufferSize;
        }

        @Override
        public RequestedBufferSize get() {
            return this.invoke();
        }

        @Override
        public RequestedBufferSize call() {
            return this.invoke();
        }

        @Override
        public RequestedBufferSize run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setSubscribed_0
    extends Function
    implements PrivilegedAction<Integer>,
    PrivilegedExceptionAction<Integer>,
    Callable<Integer>,
    Supplier<Integer>,
    Function0<Integer> {
        public final LSSubscription _gthis;
        public final int subId;
        public final int nItems;
        public final int nFields;

        /*
         * WARNING - void declaration
         */
        public Closure_setSubscribed_0(LSSubscription _gthis, int n, int n2, int n3) {
            void nFields;
            void nItems;
            void subId;
            this._gthis = _gthis;
            this.subId = subId;
            this.nItems = nItems;
            this.nFields = nFields;
        }

        @Override
        public Integer invoke() {
            this._gthis.state = SubscriptionState.Subscribed;
            this._gthis.subId = this.subId;
            this._gthis.nItems = this.nItems;
            this._gthis.nFields = this.nFields;
            return this._gthis.nFields;
        }

        @Override
        public Integer get() {
            return this.invoke();
        }

        @Override
        public Integer call() {
            return this.invoke();
        }

        @Override
        public Integer run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnSubscriptionError2Level_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final LSSubscription _gthis;
        public final int itemIdx;
        public final String keyName;
        public final int code;
        public final String msg;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnSubscriptionError2Level_0(int subId, LSSubscription lSSubscription, int n, String string, int n2, String string2) {
            void msg;
            void code;
            void keyName;
            void itemIdx;
            void _gthis;
            this.subId = subId;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
            this.keyName = keyName;
            this.code = code;
            this.msg = msg;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isWarnEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.warn("Subscription " + this.subId + ":" + this._gthis.getItemNameOrPos(this.itemIdx) + ":" + this.keyName + " failed: " + this.code + " - " + this.msg, null);
            }
            this._gthis.eventDispatcher.onCommandSecondLevelSubscriptionError(this.code, this.msg, this.keyName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnSubscriptionError_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final int code;
        public final String msg;
        public final LSSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnSubscriptionError_0(int subId, int n, String string, LSSubscription lSSubscription) {
            void _gthis;
            void msg;
            void code;
            this.subId = subId;
            this.code = code;
            this.msg = msg;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isWarnEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.warn("Subscription " + this.subId + " failed: " + this.code + " - " + this.msg, null);
            }
            this._gthis.eventDispatcher.onSubscriptionError(this.code, this.msg);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_nFields_0
    extends Function
    implements PrivilegedAction<Integer>,
    PrivilegedExceptionAction<Integer>,
    Callable<Integer>,
    Supplier<Integer>,
    Function0<Integer> {
        public final LSSubscription _gthis;

        public Closure_fetch_nFields_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public Integer invoke() {
            return this._gthis.nFields;
        }

        @Override
        public Integer get() {
            return this.invoke();
        }

        @Override
        public Integer call() {
            return this.invoke();
        }

        @Override
        public Integer run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getItems_0
    extends Function
    implements JsonIncludeProperties,
    PrivilegedAction<String[]>,
    PrivilegedExceptionAction<String[]>,
    Callable<String[]>,
    Supplier<String[]>,
    EnumReflectionInformation,
    EnumValueReflectionInformation,
    Function0<String[]> {
        public final LSSubscription _gthis;

        public Closure_getItems_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String[] invoke() {
            if (this._gthis.items == null) {
                return null;
            }
            Array<String> a = this._gthis.items;
            String[] ret = new String[a.length];
            int _g = 0;
            int _g1 = a.length;
            while (_g < _g1) {
                int i = _g++;
                ret[i] = a.__get(i);
            }
            return ret;
        }

        @Override
        public String[] argumentNames() {
            return this.invoke();
        }

        @Override
        public String[] constructorNames() {
            return this.invoke();
        }

        @Override
        public String[] get() {
            return this.invoke();
        }

        @Override
        public String[] call() {
            return this.invoke();
        }

        @Override
        public String[] run() {
            return this.invoke();
        }

        @Override
        public String[] value() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setCommandSecondLevelFieldSchema_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSSubscription _gthis;
        public final String schema;

        /*
         * WARNING - void declaration
         */
        public Closure_setCommandSecondLevelFieldSchema_0(LSSubscription _gthis, String string) {
            void schema;
            this._gthis = _gthis;
            this.schema = schema;
        }

        @Override
        public Array invoke() {
            this._gthis.checkActive();
            this._gthis.checkCommand();
            this._gthis.schema2 = Name_Impl_.fromString(this.schema);
            this._gthis.fields2 = null;
            return null;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getValue_0
    extends Function
    implements PrivilegedAction<SubscriptionManagerLiving>,
    PrivilegedExceptionAction<SubscriptionManagerLiving>,
    Callable<SubscriptionManagerLiving>,
    Supplier<SubscriptionManagerLiving>,
    Function0<SubscriptionManagerLiving> {
        public final SubscriptionManagerLiving[] _manager;
        public final LSSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_getValue_0(SubscriptionManagerLiving[] _manager, LSSubscription lSSubscription) {
            void _gthis;
            this._manager = _manager;
            this._gthis = _gthis;
        }

        @Override
        public SubscriptionManagerLiving invoke() {
            this._manager[0] = this._gthis.manager;
            return this._manager[0];
        }

        @Override
        public SubscriptionManagerLiving get() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving call() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setActive_0
    extends Function
    implements PrivilegedAction<SubscriptionState>,
    PrivilegedExceptionAction<SubscriptionState>,
    Callable<SubscriptionState>,
    Supplier<SubscriptionState>,
    Function0<SubscriptionState> {
        public final LSSubscription _gthis;

        public Closure_setActive_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public SubscriptionState invoke() {
            this._gthis.state = SubscriptionState.Active;
            return this._gthis.state;
        }

        @Override
        public SubscriptionState get() {
            return this.invoke();
        }

        @Override
        public SubscriptionState call() {
            return this.invoke();
        }

        @Override
        public SubscriptionState run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getItemName_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;
        public final int itemIdx;

        /*
         * WARNING - void declaration
         */
        public Closure_getItemName_0(LSSubscription _gthis, int n) {
            void itemIdx;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
        }

        @Override
        public String invoke() {
            if (this._gthis.items != null) {
                return this._gthis.items.__get(this.itemIdx - 1);
            }
            return null;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getCommandValue_1
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final String itemName;

        /*
         * WARNING - void declaration
         */
        public Closure_getCommandValue_1(LSSubscription _gthis, String string) {
            void itemName;
            this._gthis = _gthis;
            this.itemName = itemName;
        }

        @Override
        public int invoke() {
            return this._gthis.getItemPos(this.itemName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getFields_0
    extends Function
    implements JsonIncludeProperties,
    PrivilegedAction<String[]>,
    PrivilegedExceptionAction<String[]>,
    Callable<String[]>,
    Supplier<String[]>,
    EnumReflectionInformation,
    EnumValueReflectionInformation,
    Function0<String[]> {
        public final LSSubscription _gthis;

        public Closure_getFields_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String[] invoke() {
            if (this._gthis.fields == null) {
                return null;
            }
            Array<String> a = this._gthis.fields;
            String[] ret = new String[a.length];
            int _g = 0;
            int _g1 = a.length;
            while (_g < _g1) {
                int i = _g++;
                ret[i] = a.__get(i);
            }
            return ret;
        }

        @Override
        public String[] argumentNames() {
            return this.invoke();
        }

        @Override
        public String[] constructorNames() {
            return this.invoke();
        }

        @Override
        public String[] get() {
            return this.invoke();
        }

        @Override
        public String[] call() {
            return this.invoke();
        }

        @Override
        public String[] run() {
            return this.invoke();
        }

        @Override
        public String[] value() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getCommandValue_4
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final String fieldName;

        /*
         * WARNING - void declaration
         */
        public Closure_getCommandValue_4(LSSubscription _gthis, String string) {
            void fieldName;
            this._gthis = _gthis;
            this.fieldName = fieldName;
        }

        @Override
        public int invoke() {
            return this._gthis.getFieldPos(this.fieldName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_isInternal_0
    extends Function
    implements PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final LSSubscription _gthis;

        public Closure_isInternal_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis.m_internal;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetch_mode_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_fetch_mode_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.mode;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setSubscribedCMD_0
    extends Function
    implements PrivilegedAction<Integer>,
    PrivilegedExceptionAction<Integer>,
    Callable<Integer>,
    Supplier<Integer>,
    Function0<Integer> {
        public final LSSubscription _gthis;
        public final int subId;
        public final int cmdIdx;
        public final int keyIdx;
        public final int nItems;
        public final int nFields;

        /*
         * WARNING - void declaration
         */
        public Closure_setSubscribedCMD_0(LSSubscription _gthis, int n, int n2, int n3, int n4, int n5) {
            void nFields;
            void nItems;
            void keyIdx;
            void cmdIdx;
            void subId;
            this._gthis = _gthis;
            this.subId = subId;
            this.cmdIdx = cmdIdx;
            this.keyIdx = keyIdx;
            this.nItems = nItems;
            this.nFields = nFields;
        }

        @Override
        public Integer invoke() {
            this._gthis.state = SubscriptionState.Subscribed;
            this._gthis.subId = this.subId;
            this._gthis.cmdIdx = this.cmdIdx;
            this._gthis.keyIdx = this.keyIdx;
            this._gthis.nItems = this.nItems;
            this._gthis.nFields = this.nFields;
            return this._gthis.nFields;
        }

        @Override
        public Integer get() {
            return this.invoke();
        }

        @Override
        public Integer call() {
            return this.invoke();
        }

        @Override
        public Integer run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnRealMaxFrequency_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final RealMaxFrequency freq;
        public final LSSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnRealMaxFrequency_0(int subId, RealMaxFrequency realMaxFrequency, LSSubscription lSSubscription) {
            void _gthis;
            void freq;
            this.subId = subId;
            this.freq = freq;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isDebugEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.debug("Subscription " + this.subId + " real max frequency changed: " + Std.string((Object)this.freq), null);
            }
            this._gthis.eventDispatcher.onRealMaxFrequency(Types_Fields_.realFrequencyAsString(this.freq));
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setInternal_0
    extends Function
    implements PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final LSSubscription _gthis;

        public Closure_setInternal_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            this._gthis.m_internal = true;
            return true;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setFields_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;
        public final String[] fields;

        /*
         * WARNING - void declaration
         */
        public Closure_setFields_0(LSSubscription _gthis, String[] stringArray) {
            void fields;
            this._gthis = _gthis;
            this.fields = fields;
        }

        @Override
        public String invoke() throws IllegalArgumentException {
            this._gthis.checkActive();
            Array newValue = Fields_Impl_.fromArray(this.fields == null ? null : NativeArray_Impl_.toHaxe(this.fields));
            if (Jvm.stringCompare(this._gthis.mode, "COMMAND") == 0 && newValue != null) {
                if (!newValue.contains("command")) {
                    throw new IllegalArgumentException("Field 'command' is missing");
                }
                if (!newValue.contains("key")) {
                    throw new IllegalArgumentException("Field 'key' is missing");
                }
            }
            this._gthis.fields = newValue;
            this._gthis.schema = null;
            return null;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getCommandValue_0
    extends Function
    implements PrivilegedAction<SubscriptionManagerLiving>,
    PrivilegedExceptionAction<SubscriptionManagerLiving>,
    Callable<SubscriptionManagerLiving>,
    Supplier<SubscriptionManagerLiving>,
    Function0<SubscriptionManagerLiving> {
        public final SubscriptionManagerLiving[] _manager;
        public final LSSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_getCommandValue_0(SubscriptionManagerLiving[] _manager, LSSubscription lSSubscription) {
            void _gthis;
            this._manager = _manager;
            this._gthis = _gthis;
        }

        @Override
        public SubscriptionManagerLiving invoke() {
            this._manager[0] = this._gthis.manager;
            return this._manager[0];
        }

        @Override
        public SubscriptionManagerLiving get() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving call() {
            return this.invoke();
        }

        @Override
        public SubscriptionManagerLiving run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getCommandSecondLevelFieldSchema_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getCommandSecondLevelFieldSchema_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.schema2;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getItemGroup_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getItemGroup_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.group;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_isSubscribed_0
    extends Function
    implements PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final LSSubscription _gthis;

        public Closure_isSubscribed_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public boolean invoke() {
            return this._gthis.state == SubscriptionState.Subscribed;
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getValue_4
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final String fieldName;

        /*
         * WARNING - void declaration
         */
        public Closure_getValue_4(LSSubscription _gthis, String string) {
            void fieldName;
            this._gthis = _gthis;
            this.fieldName = fieldName;
        }

        @Override
        public int invoke() {
            return this._gthis.getFieldPos(this.fieldName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnLostUpdates2Level_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final LSSubscription _gthis;
        public final int itemIdx;
        public final String keyName;
        public final int lostUpdates;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnLostUpdates2Level_0(int subId, LSSubscription lSSubscription, int n, String string, int n2) {
            void lostUpdates;
            void keyName;
            void itemIdx;
            void _gthis;
            this.subId = subId;
            this._gthis = _gthis;
            this.itemIdx = itemIdx;
            this.keyName = keyName;
            this.lostUpdates = lostUpdates;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isDebugEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.debug("Subscription " + this.subId + ":" + this._gthis.getItemNameOrPos(this.itemIdx) + ":" + this.keyName + ": lost " + this.lostUpdates + " updates", null);
            }
            this._gthis.eventDispatcher.onCommandSecondLevelItemLostUpdates(this.lostUpdates, this.keyName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setDataAdapter_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;
        public final String dataAdapter;

        /*
         * WARNING - void declaration
         */
        public Closure_setDataAdapter_0(LSSubscription _gthis, String string) {
            void dataAdapter;
            this._gthis = _gthis;
            this.dataAdapter = dataAdapter;
        }

        @Override
        public String invoke() {
            this._gthis.checkActive();
            this._gthis.dataAdapter = Name_Impl_.fromString(this.dataAdapter);
            return this._gthis.dataAdapter;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setSelector_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;
        public final String selector;

        /*
         * WARNING - void declaration
         */
        public Closure_setSelector_0(LSSubscription _gthis, String string) {
            void selector;
            this._gthis = _gthis;
            this.selector = selector;
        }

        @Override
        public String invoke() {
            this._gthis.checkActive();
            this._gthis.selector = Name_Impl_.fromString(this.selector);
            return this._gthis.selector;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setFieldSchema_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSSubscription _gthis;
        public final String schema;

        /*
         * WARNING - void declaration
         */
        public Closure_setFieldSchema_0(LSSubscription _gthis, String string) {
            void schema;
            this._gthis = _gthis;
            this.schema = schema;
        }

        @Override
        public Array invoke() {
            this._gthis.checkActive();
            this._gthis.schema = Name_Impl_.fromString(this.schema);
            this._gthis.fields = null;
            return null;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getRequestedBufferSize_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getRequestedBufferSize_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return RequestedBufferSizeTools.toString(this._gthis.bufferSize);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getRequestedSnapshot_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getRequestedSnapshot_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return RequestedSnapshotTools.toString(this._gthis.snapshot);
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getSelector_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getSelector_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.selector;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getDataAdapter_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_getDataAdapter_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.dataAdapter;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_addListener_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final SubscriptionListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_addListener_0(LSSubscription _gthis, SubscriptionListener subscriptionListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.addListenerAndFireOnListenStart(this.listener);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setRequestedBufferSize_0
    extends Function
    implements PrivilegedAction<RequestedBufferSize>,
    PrivilegedExceptionAction<RequestedBufferSize>,
    Callable<RequestedBufferSize>,
    Supplier<RequestedBufferSize>,
    Function0<RequestedBufferSize> {
        public final LSSubscription _gthis;
        public final String size;

        /*
         * WARNING - void declaration
         */
        public Closure_setRequestedBufferSize_0(LSSubscription _gthis, String string) {
            void size;
            this._gthis = _gthis;
            this.size = size;
        }

        @Override
        public RequestedBufferSize invoke() {
            this._gthis.checkActive();
            this._gthis.bufferSize = RequestedBufferSizeTools.fromString(this.size);
            return this._gthis.bufferSize;
        }

        @Override
        public RequestedBufferSize get() {
            return this.invoke();
        }

        @Override
        public RequestedBufferSize call() {
            return this.invoke();
        }

        @Override
        public RequestedBufferSize run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_fireOnUnsubscription_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final int subId;
        public final LSSubscription _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_fireOnUnsubscription_0(int subId, LSSubscription lSSubscription) {
            void _gthis;
            this.subId = subId;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.subscriptionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.subscriptionLogger.info("Subscription " + this.subId + " deleted", null);
            }
            this._gthis.eventDispatcher.onUnsubscription();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_setItems_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;
        public final String[] items;

        /*
         * WARNING - void declaration
         */
        public Closure_setItems_0(LSSubscription _gthis, String[] stringArray) {
            void items;
            this._gthis = _gthis;
            this.items = items;
        }

        @Override
        public String invoke() {
            this._gthis.checkActive();
            Array tmp = this.items == null ? null : NativeArray_Impl_.toHaxe(this.items);
            this._gthis.items = Items_Impl_.fromArray(tmp);
            this._gthis.group = null;
            return null;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_unrelate_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final SubscriptionManagerLiving manager;

        /*
         * WARNING - void declaration
         */
        public Closure_unrelate_0(LSSubscription _gthis, SubscriptionManagerLiving subscriptionManagerLiving) {
            void manager;
            this._gthis = _gthis;
            this.manager = manager;
        }

        @Override
        public void invoke() {
            if (this._gthis.manager != this.manager) {
                return;
            }
            this._gthis.manager = null;
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getKeyPosition_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;

        public Closure_getKeyPosition_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public int invoke() throws IllegalStateException {
            this._gthis.checkCommand();
            if (this._gthis.keyIdx == null) {
                throw new IllegalStateException("The position of the key field is currently unknown");
            }
            return Jvm.toInt(this._gthis.keyIdx);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getCommandPosition_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;

        public Closure_getCommandPosition_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public int invoke() throws IllegalStateException {
            this._gthis.checkCommand();
            if (this._gthis.cmdIdx == null) {
                throw new IllegalStateException("The position of the command field is currently unknown");
            }
            return Jvm.toInt(this._gthis.cmdIdx);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_getCommandValue_3
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription _gthis;
        public final String itemName;

        /*
         * WARNING - void declaration
         */
        public Closure_getCommandValue_3(LSSubscription _gthis, String string) {
            void itemName;
            this._gthis = _gthis;
            this.itemName = itemName;
        }

        @Override
        public int invoke() {
            return this._gthis.getItemPos(this.itemName);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_toString_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSSubscription _gthis;

        public Closure_toString_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            StringMap map = InfoMap.InfoMap_Impl_._new();
            InfoMap.InfoMap_Impl_.set(map, "mode", this._gthis.mode);
            InfoMap.InfoMap_Impl_.set(map, "items", this._gthis.items != null ? Std.string(this._gthis.items) : this._gthis.group);
            InfoMap.InfoMap_Impl_.set(map, "fields", this._gthis.fields != null ? Std.string(this._gthis.fields) : this._gthis.schema);
            InfoMap.InfoMap_Impl_.set(map, "dataAdapter", this._gthis.dataAdapter);
            InfoMap.InfoMap_Impl_.set(map, "requestedBufferSize", (Object)this._gthis.bufferSize);
            InfoMap.InfoMap_Impl_.set(map, "requestedSnapshot", (Object)this._gthis.snapshot);
            InfoMap.InfoMap_Impl_.set(map, "requestedMaxFrequency", (Object)this._gthis.requestedMaxFrequency);
            InfoMap.InfoMap_Impl_.set(map, "selector", this._gthis.selector);
            InfoMap.InfoMap_Impl_.set(map, "secondLevelFields", this._gthis.fields2 != null ? Std.string(this._gthis.fields2) : this._gthis.schema2);
            InfoMap.InfoMap_Impl_.set(map, "secondLevelDataAdapter", this._gthis.dataAdapter2);
            return map.toString();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_fetchItems_0
    extends Function
    implements PrivilegedAction<Array<String>>,
    PrivilegedExceptionAction<Array<String>>,
    Callable<Array<String>>,
    Supplier<Array<String>>,
    Function0<Array<String>> {
        public final LSSubscription _gthis;

        public Closure_fetchItems_0(LSSubscription _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public Array invoke() {
            return this._gthis.items;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }
}

