/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client.internal;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.util.Named;
import com.lightstreamer.client.ClientEventDispatcher;
import com.lightstreamer.client.ClientMessageListener;
import com.lightstreamer.client.LSConnectionDetails;
import com.lightstreamer.client.LSConnectionOptions;
import com.lightstreamer.client.LSLightstreamerClient;
import com.lightstreamer.client.LSSubscription;
import com.lightstreamer.client.internal.ConstrainRequest;
import com.lightstreamer.client.internal.Encodable;
import com.lightstreamer.client.internal.MessageEventDispatcher;
import com.lightstreamer.client.internal.MessageManager;
import com.lightstreamer.client.internal.Request;
import com.lightstreamer.client.internal.RetryDelayCounter;
import com.lightstreamer.client.internal.State;
import com.lightstreamer.client.internal.StateVar_hp;
import com.lightstreamer.client.internal.StateVar_hs;
import com.lightstreamer.client.internal.StateVar_w;
import com.lightstreamer.client.internal.StateVar_wp;
import com.lightstreamer.client.internal.StateVar_ws;
import com.lightstreamer.client.internal.SubscriptionManager;
import com.lightstreamer.client.internal.SubscriptionManagerLiving;
import com.lightstreamer.client.internal.SubscriptionManagerZombie;
import com.lightstreamer.client.internal.SwitchRequest;
import com.lightstreamer.client.internal.UpdateInfo;
import com.lightstreamer.client.internal._ParseTools.ParseTools_Fields_;
import com.lightstreamer.internal.Globals;
import com.lightstreamer.internal.IFactory;
import com.lightstreamer.internal.IHttpClient;
import com.lightstreamer.internal.IPageLifecycle;
import com.lightstreamer.internal.IReachability;
import com.lightstreamer.internal.ITimer;
import com.lightstreamer.internal.IWsClient;
import com.lightstreamer.internal.MyArray;
import com.lightstreamer.internal.NullTools;
import com.lightstreamer.internal.OrderedIntMapImpl;
import com.lightstreamer.internal.PageLifecycle;
import com.lightstreamer.internal.PageState;
import com.lightstreamer.internal.RLock;
import com.lightstreamer.internal.ReachabilityStatus;
import com.lightstreamer.internal.RealMaxBandwidth;
import com.lightstreamer.internal.RealMaxFrequency;
import com.lightstreamer.internal.RequestBuilder;
import com.lightstreamer.internal.RequestedMaxBandwidth;
import com.lightstreamer.internal.Set;
import com.lightstreamer.internal.Timer;
import com.lightstreamer.internal.Url;
import com.lightstreamer.internal._Constants.Constants_Fields_;
import com.lightstreamer.internal._Threads.Threads_Fields_;
import com.lightstreamer.internal._Types.Millis_Impl_;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.Exception;
import haxe.IMap;
import haxe.ds.IntMap;
import haxe.ds.StringMap;
import haxe.jvm.CompiledPattern;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Enum;
import haxe.jvm.Jvm;
import haxe.jvm.StringExt;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.jvm.annotation.EnumReflectionInformation;
import haxe.jvm.annotation.EnumValueReflectionInformation;
import haxe.root.Array;
import haxe.root.EReg;
import haxe.root.Iterable;
import haxe.root.Lambda;
import haxe.root.Std;
import haxe.root.Sys;
import java.net.ProtocolFamily;
import java.nio.file.DirectoryStream;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.AttributeView;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;

@ClassReflectionInformation(hasSuperClass=false)
public class ClientMachine
extends haxe.jvm.Object {
    public static IPageLifecycle frz_globalPageLifecycle = PageLifecycle.newLoggingInstance();
    public LSLightstreamerClient client;
    public LSConnectionDetails details;
    public LSConnectionOptions options;
    public RLock lock;
    public ClientEventDispatcher clientEventDispatcher;
    public State state;
    public haxe.jvm.Function wsFactory;
    public haxe.jvm.Function httpFactory;
    public haxe.jvm.Function ctrlFactory;
    public haxe.jvm.Function timerFactory;
    public haxe.jvm.Function randomGenerator;
    public RetryDelayCounter delayCounter;
    public String m_status;
    public int m_nextReqId;
    public int m_nextSubId;
    public String defaultServerAddress;
    public Integer requestLimit;
    public Long keepaliveInterval;
    public Long idleTimeout;
    public String sessionId;
    public String serverInstanceAddress;
    public String lastKnownClientIp;
    public String cause;
    public double connectTs;
    public double recoverTs;
    public double ctrl_connectTs;
    public Set<String> suspendedTransports;
    public Set<String> disabledTransports;
    public StringMap<Integer> sequenceMap;
    public MyArray<MessageManager> messageManagers;
    public OrderedIntMapImpl<SubscriptionManager> subscriptionManagers;
    public SwitchRequest switchRequest;
    public ConstrainRequest constrainRequest;
    public Integer swt_lastReqId;
    public Long rhb_grantedInterval;
    public Long rhb_currentInterval;
    public RequestedMaxBandwidth bw_requestedMaxBandwidth;
    public Integer bw_lastReqId;
    public haxe.jvm.Function reachabilityFactory;
    public IReachability nr_reachabilityManager;
    public haxe.jvm.Function frz_pageLifecycleFactory;
    public IPageLifecycle frz_pageLifecycle;
    public int rec_serverProg;
    public int rec_clientProg;
    public double slw_refTime;
    public double slw_avgDelayMs;
    public double slw_maxAvgDelayMs;
    public double slw_hugeDelayMs;
    public double slw_m;
    public IWsClient ws;
    public IHttpClient http;
    public IHttpClient ctrl_http;
    public ITimer transportTimer;
    public ITimer retryTimer;
    public ITimer keepaliveTimer;
    public ITimer stalledTimer;
    public ITimer reconnectTimer;
    public ITimer rhbTimer;
    public ITimer recoveryTimer;
    public ITimer idleTimer;
    public ITimer pollingTimer;
    public ITimer ctrlTimer;

    public void disposeSession() {
        this.disposeWS();
        this.disposeHTTP();
        this.disposeCtrl();
        this.details.setServerInstanceAddress(null);
        this.details.setSessionId(null);
        this.details.setServerSocketName(null);
        this.details.setClientIp(null);
        this.options.setRealMaxBandwidth(null);
        this.lastKnownClientIp = null;
        this.resetSequenceMap();
        this.rec_serverProg = 0;
        this.rec_clientProg = 0;
        this.bw_lastReqId = null;
        this.bw_requestedMaxBandwidth = null;
        this.swt_lastReqId = null;
    }

    public void disposeClient() {
        this.sessionId = null;
        this.enableAllTransports();
        this.resetCurrentRetryDelay();
        this.resetSequenceMap();
        this.cause = null;
    }

    public void evtExtConnect() {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_evtExtConnect_0(_gthis));
    }

    public boolean evtExtConnect_NextRegion() {
        return this.evtExtConnect_NetworkReachabilityRegion();
    }

    public boolean evtExtConnect_NetworkReachabilityRegion() {
        ClientMachine _gthis = this;
        if (this.state.s_nr == 1400) {
            String hostAddress = new Url(this.getServerAddress(), null).get_hostname();
            this.nr_reachabilityManager = (IReachability)this.reachabilityFactory.invoke(hostAddress);
            this.state.s_nr = 1410;
            this.state.traceState();
            this.nr_reachabilityManager.startListening(new Closure_evtExtConnect_NetworkReachabilityRegion_0(_gthis, hostAddress));
        }
        return false;
    }

    public void doInstallPageLifecycle() {
        ClientMachine _gthis = this;
        this.frz_pageLifecycle = (IPageLifecycle)this.frz_pageLifecycleFactory.invoke(new Closure_doInstallPageLifecycle_0(_gthis));
    }

    public void doUnistallPageLifecycle() {
        IPageLifecycle tmp = this.frz_pageLifecycle;
        if (tmp != null) {
            tmp.stopListening();
        }
        this.frz_pageLifecycle = null;
    }

    public void evtPageFrozen() {
        this.traceEvent("page.frozen");
        switch (this.state.s_m) {
            default: {
                return;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "page.frozen";
                this.state.s_m = 117;
                this.state.traceState();
                this.cancel_evtRetryTimeout();
                return;
            }
            case 120: 
            case 121: 
            case 122: {
                this.disposeWS();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "page.frozen";
                this.state.s_m = 117;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.evtRetry(RetryCause.page_frozen, null);
                return;
            }
            case 130: {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "page.frozen";
                this.state.s_m = 117;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.evtRetry(RetryCause.page_frozen, null);
                return;
            }
            case 140: {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "page.frozen";
                this.state.s_m = 117;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.evtRetry(RetryCause.page_frozen, null);
                return;
            }
            case 150: 
        }
        Integer _g = this.state.s_tr;
        if (_g != null) {
            switch (Jvm.toInt(_g)) {
                default: {
                    break;
                }
                case 210: {
                    this.sendDestroyWS("page.frozen");
                    this.closeWS();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "page.frozen";
                    this.state.clear_w();
                    this.state.goto_m_from_session(117);
                    this.exit_w();
                    this.evtEndSession();
                    this.evtRetry(RetryCause.page_frozen, null);
                    break;
                }
                case 220: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "page.frozen";
                    this.state.goto_m_from_session(117);
                    this.cancel_evtTransportTimeout();
                    this.evtEndSession();
                    this.evtRetry(RetryCause.page_frozen, null);
                    break;
                }
                case 230: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "page.frozen";
                    this.state.goto_m_from_session(117);
                    this.cancel_evtTransportTimeout();
                    this.evtEndSession();
                    this.evtRetry(RetryCause.page_frozen, null);
                    break;
                }
                case 240: {
                    StateVar_ws tmp = this.state.s_ws;
                    Integer n = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
                    if (n == null ? false : Jvm.toInt(n) == 500) {
                        this.disposeWS();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "page.frozen";
                        this.state.goto_m_from_ws(117);
                        this.exit_ws_to_m();
                        this.evtRetry(RetryCause.page_frozen, null);
                        break;
                    }
                    boolean tmp2 = false;
                    boolean tmp1 = false;
                    StateVar_ws tmp22 = this.state.s_ws;
                    Integer n2 = tmp22 != null ? Integer.valueOf(tmp22.m) : (Integer)null;
                    if (n2 == null ? true : Jvm.toInt(n2) != 501) {
                        StateVar_ws tmp3 = this.state.s_ws;
                        Integer n3 = tmp3 != null ? Integer.valueOf(tmp3.m) : (Integer)null;
                        tmp1 = n3 == null ? false : Jvm.toInt(n3) == 502;
                    } else {
                        tmp1 = true;
                    }
                    if (!tmp1) {
                        StateVar_ws tmp12 = this.state.s_ws;
                        Integer n4 = tmp12 != null ? Integer.valueOf(tmp12.m) : (Integer)null;
                        tmp2 = n4 == null ? false : Jvm.toInt(n4) == 503;
                    } else {
                        tmp2 = true;
                    }
                    if (!tmp2) break;
                    this.sendDestroyWS("page.frozen");
                    this.closeWS();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "page.frozen";
                    this.state.goto_m_from_ws(117);
                    this.exit_ws_to_m();
                    this.evtRetry(RetryCause.page_frozen, null);
                    break;
                }
                case 250: {
                    boolean tmp = false;
                    StateVar_wp tmp1 = this.state.s_wp;
                    Integer n = tmp1 != null ? Integer.valueOf(tmp1.m) : (Integer)null;
                    if (n == null ? true : Jvm.toInt(n) != 600) {
                        StateVar_wp tmp13 = this.state.s_wp;
                        Integer n5 = tmp13 != null ? Integer.valueOf(tmp13.m) : (Integer)null;
                        tmp = n5 == null ? false : Jvm.toInt(n5) == 601;
                    } else {
                        tmp = true;
                    }
                    if (tmp) {
                        this.disposeWS();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "page.frozen";
                        this.state.goto_m_from_wp(117);
                        this.exit_ws_to_m();
                        this.evtRetry(RetryCause.page_frozen, null);
                        break;
                    }
                    StateVar_wp tmp4 = this.state.s_wp;
                    Integer n6 = tmp4 != null ? Integer.valueOf(tmp4.m) : (Integer)null;
                    if (!(n6 == null ? false : Jvm.toInt(n6) == 602)) break;
                    this.sendDestroyWS("page.frozen");
                    this.closeWS();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "page.frozen";
                    this.state.goto_m_from_wp(117);
                    this.exit_wp_to_m();
                    this.evtRetry(RetryCause.page_frozen, null);
                    break;
                }
                case 260: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "page.frozen";
                    this.state.goto_m_from_rec(117);
                    this.exit_rec_to_m();
                    this.evtRetry(RetryCause.page_frozen, null);
                    break;
                }
                case 270: {
                    Integer n = this.state.s_h;
                    if (n == null ? false : Jvm.toInt(n) == 710) {
                        this.disposeHTTP();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "page.frozen";
                        this.state.goto_m_from_hs(117);
                        this.exit_hs_to_m();
                        this.evtRetry(RetryCause.page_frozen, null);
                        break;
                    }
                    Integer n7 = this.state.s_h;
                    if (!(n7 == null ? false : Jvm.toInt(n7) == 720)) break;
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "page.frozen";
                    this.state.goto_m_from_hp(117);
                    this.exit_hp_to_m();
                    this.evtRetry(RetryCause.page_frozen, null);
                }
            }
        }
    }

    public void evtPageResumed() {
        this.traceEvent("page.resumed");
        if (this.state.s_m == 117) {
            this.state.s_m = 116;
            this.state.traceState();
            this.evtSelectCreate();
        }
    }

    public void evtNetworkNotReachable(String host) {
        if (LoggerTools_Fields_.reachabilityLogger.isInfoEnabled()) {
            LoggerTools_Fields_.reachabilityLogger.info("" + host + " is NOT reachable", null);
        }
        this.traceEvent("nr:network.not.reachable");
        if (this.state.s_nr == 1410) {
            this.state.s_nr = 1411;
            this.state.traceState();
            return;
        }
        if (this.state.s_nr == 1412) {
            this.state.s_nr = 1411;
            this.state.traceState();
        }
    }

    public void evtNetworkReachable(String host) {
        if (LoggerTools_Fields_.reachabilityLogger.isInfoEnabled()) {
            LoggerTools_Fields_.reachabilityLogger.info("" + host + " is reachable", null);
        }
        this.traceEvent("nr:network.reachable");
        if (this.state.s_nr == 1410) {
            this.state.s_nr = 1412;
            this.state.traceState();
            return;
        }
        if (this.state.s_nr == 1411) {
            this.state.s_nr = 1412;
            this.state.traceState();
            this.evtOnlineAgain();
        }
    }

    public void evtOnlineAgain() {
        this.traceEvent("online.again");
        if (this.state.s_m == 112) {
            this.state.s_m = 116;
            this.state.traceState();
            this.cancel_evtRetryTimeout();
            this.evtSelectCreate();
            return;
        }
        Integer n = this.state.s_rec;
        if (n == null ? false : Jvm.toInt(n) == 1003) {
            this.sendRecovery();
            this.state.s_rec = 1001;
            this.state.traceState();
            this.cancel_evtRetryTimeout();
            this.schedule_evtTransportTimeout(this.options.retryDelay);
        }
    }

    public void evtServerAddressChanged() {
        this.traceEvent("nr:serverAddress.changed");
        ClientMachine _gthis = this;
        switch (this.state.s_nr) {
            default: {
                return;
            }
            case 1410: 
            case 1411: 
            case 1412: 
        }
        IReachability oldManager = this.nr_reachabilityManager;
        String hostAddress = new Url(this.getServerAddress(), null).get_hostname();
        this.nr_reachabilityManager = (IReachability)this.reachabilityFactory.invoke(hostAddress);
        this.state.s_nr = 1410;
        this.state.traceState();
        if (oldManager != null) {
            oldManager.stopListening();
        }
        this.nr_reachabilityManager.startListening(new Closure_evtServerAddressChanged_0(_gthis, hostAddress));
    }

    public void evtExtDisconnect(TerminationCause terminationCause) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_evtExtDisconnect_0(_gthis, terminationCause));
    }

    public void evtSelectCreate() {
        this.traceEvent("select.create");
        if (this.state.s_m == 101 || this.state.s_m == 116) {
            switch (this.getBestForCreating().ordinal()) {
                case 0: {
                    this.notifyStatus("CONNECTING");
                    this.openWS_Create();
                    this.state.s_m = 120;
                    this.state.traceState();
                    this.evtCreate();
                    this.schedule_evtTransportTimeout(this.delayCounter.get_currentRetryDelay());
                    break;
                }
                case 1: {
                    this.notifyStatus("CONNECTING");
                    this.sendCreateHTTP();
                    this.state.s_m = 130;
                    this.state.traceState();
                    this.evtCreate();
                    this.schedule_evtTransportTimeout(this.delayCounter.get_currentRetryDelay());
                    break;
                }
                case 2: {
                    this.notifyStatus("DISCONNECTED");
                    this.state.s_m = 100;
                    this.state.traceState();
                    this.evtTerminate(TerminationCause.TC_otherError("Unable to select a transport"));
                }
            }
        }
    }

    public void evtWSOpen() {
        this.traceEvent("ws.open");
        if (this.state.s_m == 120) {
            this.sendCreateWS();
            this.state.s_m = 121;
            this.state.traceState();
            return;
        }
        StateVar_ws tmp = this.state.s_ws;
        Integer n = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 500) {
            this.sendBindWS_Streaming();
            this.state.s_ws.m = 501;
            this.state.traceState();
            return;
        }
        StateVar_wp tmp2 = this.state.s_wp;
        Integer n2 = tmp2 != null ? Integer.valueOf(tmp2.m) : (Integer)null;
        if (n2 == null ? false : Jvm.toInt(n2) == 600) {
            NullTools.sure(this.ws).send("wsok");
            this.state.s_wp.m = 601;
            this.state.traceState();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean evtMessage(String line) {
        boolean matched = true;
        if (line.startsWith("U,")) {
            UpdateInfo update = ParseTools_Fields_.parseUpdate(line);
            this.evtU(update.subId, update.itemIdx, update.values, line);
            return matched;
        }
        if (line.startsWith("REQOK")) {
            if (Jvm.stringCompare(line, "REQOK") == 0) {
                this.evtREQOK_withoutReqId();
                return matched;
            }
            Array args2 = StringExt.split(line, ",");
            int reqId = ParseTools_Fields_.parseInt((String)args2.__get(1));
            this.evtREQOK(reqId);
            return matched;
        }
        if (line.startsWith("PROBE")) {
            this.evtPROBE();
            return matched;
        }
        if (line.startsWith("LOOP")) {
            Array args3 = StringExt.split(line, ",");
            long pollingMs = ParseTools_Fields_.parseInt((String)args3.__get(1));
            this.evtLOOP(pollingMs);
            return matched;
        }
        if (line.startsWith("CONOK")) {
            Array args4 = StringExt.split(line, ",");
            String sessionId = (String)args4.__get(1);
            int reqLimit = ParseTools_Fields_.parseInt((String)args4.__get(2));
            long keepalive = ParseTools_Fields_.parseInt((String)args4.__get(3));
            String clink = (String)args4.__get(4);
            this.evtCONOK(sessionId, reqLimit, keepalive, clink);
            return matched;
        }
        if (line.startsWith("WSOK")) {
            this.evtWSOK();
            return matched;
        }
        if (line.startsWith("SERVNAME")) {
            Array args5 = StringExt.split(line, ",");
            String serverName = (String)args5.__get(1);
            this.evtSERVNAME(serverName);
            return matched;
        }
        if (line.startsWith("CLIENTIP")) {
            Array args6 = StringExt.split(line, ",");
            String ip = (String)args6.__get(1);
            this.evtCLIENTIP(ip);
            return matched;
        }
        if (line.startsWith("CONS")) {
            Array args7 = StringExt.split(line, ",");
            String bw = (String)args7.__get(1);
            String _hx_tmp = bw;
            if (_hx_tmp != null) {
                switch (_hx_tmp.hashCode()) {
                    case -1747905818: {
                        if (!_hx_tmp.equals("unmanaged")) break;
                        this.evtCONS(RealMaxBandwidth.BWUnmanaged);
                        return matched;
                    }
                    case 1887918305: {
                        if (!_hx_tmp.equals("unlimited")) break;
                        this.evtCONS(RealMaxBandwidth.BWUnlimited);
                        return matched;
                    }
                }
            }
            double n = ParseTools_Fields_.parseFloat(bw);
            this.evtCONS(RealMaxBandwidth.BWLimited(n));
            return matched;
        }
        if (line.startsWith("MSGDONE")) {
            Array args8 = StringExt.split(line, ",");
            String seq = (String)args8.__get(1);
            if (Jvm.stringCompare(seq, "*") == 0) {
                seq = "UNORDERED_MESSAGES";
            }
            int prog = ParseTools_Fields_.parseInt((String)args8.__get(2));
            String rawResp = (String)args8.__get(3);
            String resp = Jvm.stringCompare(rawResp, "") == 0 ? "" : ParseTools_Fields_.unquote(rawResp);
            this.evtMSGDONE(seq, prog, resp);
            return matched;
        }
        if (line.startsWith("MSGFAIL")) {
            Array args9 = StringExt.split(line, ",");
            String seq = (String)args9.__get(1);
            if (Jvm.stringCompare(seq, "*") == 0) {
                seq = "UNORDERED_MESSAGES";
            }
            int prog = ParseTools_Fields_.parseInt((String)args9.__get(2));
            int errorCode = ParseTools_Fields_.parseInt((String)args9.__get(3));
            String errorMsg = ParseTools_Fields_.unquote((String)args9.__get(4));
            this.evtMSGFAIL(seq, prog, errorCode, errorMsg);
            return matched;
        }
        if (line.startsWith("REQERR")) {
            Array args10 = StringExt.split(line, ",");
            int reqId = ParseTools_Fields_.parseInt((String)args10.__get(1));
            int code = ParseTools_Fields_.parseInt((String)args10.__get(2));
            String msg = ParseTools_Fields_.unquote((String)args10.__get(3));
            this.evtREQERR(reqId, code, msg);
            return matched;
        }
        if (line.startsWith("PROG")) {
            Array args11 = StringExt.split(line, ",");
            int prog = ParseTools_Fields_.parseInt((String)args11.__get(1));
            this.evtPROG(prog);
            return matched;
        }
        if (line.startsWith("SUBOK")) {
            Array args12 = StringExt.split(line, ",");
            int subId = ParseTools_Fields_.parseInt((String)args12.__get(1));
            int nItems = ParseTools_Fields_.parseInt((String)args12.__get(2));
            int nFields = ParseTools_Fields_.parseInt((String)args12.__get(3));
            this.evtSUBOK(subId, nItems, nFields);
            return matched;
        }
        if (line.startsWith("SUBCMD")) {
            Array args13 = StringExt.split(line, ",");
            int subId = ParseTools_Fields_.parseInt((String)args13.__get(1));
            int nItems = ParseTools_Fields_.parseInt((String)args13.__get(2));
            int nFields = ParseTools_Fields_.parseInt((String)args13.__get(3));
            int keyIdx = ParseTools_Fields_.parseInt((String)args13.__get(4));
            int cmdIdx = ParseTools_Fields_.parseInt((String)args13.__get(5));
            this.evtSUBCMD(subId, nItems, nFields, keyIdx, cmdIdx);
            return matched;
        }
        if (line.startsWith("UNSUB")) {
            Array args14 = StringExt.split(line, ",");
            int subId = ParseTools_Fields_.parseInt((String)args14.__get(1));
            this.evtUNSUB(subId);
            return matched;
        }
        if (line.startsWith("CONF")) {
            Array args15 = StringExt.split(line, ",");
            int subId = ParseTools_Fields_.parseInt((String)args15.__get(1));
            if (Jvm.stringCompare((String)args15.__get(2), "unlimited") == 0) {
                this.evtCONF(subId, RealMaxFrequency.RFreqUnlimited);
                return matched;
            }
            double freq = ParseTools_Fields_.parseFloat((String)args15.__get(2));
            this.evtCONF(subId, RealMaxFrequency.RFreqLimited(freq));
            return matched;
        }
        if (line.startsWith("EOS")) {
            Array args16 = StringExt.split(line, ",");
            int subId = ParseTools_Fields_.parseInt((String)args16.__get(1));
            int itemIdx = ParseTools_Fields_.parseInt((String)args16.__get(2));
            this.evtEOS(subId, itemIdx);
            return matched;
        }
        if (line.startsWith("CS")) {
            Array args17 = StringExt.split(line, ",");
            int subId = ParseTools_Fields_.parseInt((String)args17.__get(1));
            int itemIdx = ParseTools_Fields_.parseInt((String)args17.__get(2));
            this.evtCS(subId, itemIdx);
            return matched;
        }
        if (line.startsWith("OV")) {
            Array args18 = StringExt.split(line, ",");
            int subId = ParseTools_Fields_.parseInt((String)args18.__get(1));
            int itemIdx = ParseTools_Fields_.parseInt((String)args18.__get(2));
            int lostUpdates = ParseTools_Fields_.parseInt((String)args18.__get(3));
            this.evtOV(subId, itemIdx, lostUpdates);
            return matched;
        }
        if (line.startsWith("NOOP")) {
            this.evtNOOP();
            return matched;
        }
        if (line.startsWith("CONERR")) {
            Array args19 = StringExt.split(line, ",");
            int code = ParseTools_Fields_.parseInt((String)args19.__get(1));
            String msg = ParseTools_Fields_.unquote((String)args19.__get(2));
            this.evtCONERR(code, msg);
            return matched;
        }
        if (line.startsWith("END")) {
            Array args20 = StringExt.split(line, ",");
            int code = ParseTools_Fields_.parseInt((String)args20.__get(1));
            String msg = ParseTools_Fields_.unquote((String)args20.__get(2));
            this.evtEND(code, msg);
            return matched;
        }
        if (line.startsWith("ERROR")) {
            Array args21 = StringExt.split(line, ",");
            int code = ParseTools_Fields_.parseInt((String)args21.__get(1));
            String msg = ParseTools_Fields_.unquote((String)args21.__get(2));
            this.evtERROR(code, msg);
            return matched;
        }
        if (!line.startsWith("SYNC")) return false;
        Array args22 = StringExt.split(line, ",");
        int seconds = ParseTools_Fields_.parseInt((String)args22.__get(1));
        this.evtSYNC(seconds);
        return matched;
    }

    public void evtCtrlMessage(String line) {
        if (line.startsWith("REQOK")) {
            if (Jvm.stringCompare(line, "REQOK") == 0) {
                this.evtREQOK_withoutReqId();
                return;
            }
            Array args2 = StringExt.split(line, ",");
            int reqId = ParseTools_Fields_.parseInt((String)args2.__get(1));
            this.evtREQOK(reqId);
            return;
        }
        if (line.startsWith("REQERR")) {
            Array args3 = StringExt.split(line, ",");
            int reqId = ParseTools_Fields_.parseInt((String)args3.__get(1));
            int code = ParseTools_Fields_.parseInt((String)args3.__get(2));
            String msg = ParseTools_Fields_.unquote((String)args3.__get(3));
            this.evtREQERR(reqId, code, msg);
            return;
        }
        if (line.startsWith("ERROR")) {
            Array args4 = StringExt.split(line, ",");
            int code = ParseTools_Fields_.parseInt((String)args4.__get(1));
            String msg = ParseTools_Fields_.unquote((String)args4.__get(2));
            this.evtERROR(code, msg);
        }
    }

    public void evtTransportTimeout() {
        this.traceEvent("transport.timeout");
        switch (this.state.s_m) {
            default: {
                return;
            }
            case 120: 
            case 121: {
                this.suspendWS_Streaming();
                this.disposeWS();
                this.cause = "ws.unavailable";
                this.state.s_m = 115;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.entry_m115(RetryCause.ws_unavailable);
                return;
            }
            case 122: {
                this.disposeWS();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "ws.timeout";
                this.state.s_m = 112;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.entry_m112(RetryCause.ws_timeout);
                return;
            }
            case 130: {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "http.timeout";
                this.state.s_m = 112;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.entry_m112(RetryCause.http_timeout);
                return;
            }
            case 140: {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "ttl.timeout";
                long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
                this.state.s_m = 111;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.entry_m111(RetryCause.http_error, pauseMs);
                return;
            }
            case 150: 
        }
        Integer _g = this.state.s_tr;
        if (_g != null) {
            block7 : switch (Jvm.toInt(_g)) {
                default: {
                    break;
                }
                case 220: {
                    if (this.options.sessionRecoveryTimeout == 0L) {
                        this.disposeHTTP();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "http.timeout";
                        this.state.goto_m_from_session(112);
                        this.cancel_evtTransportTimeout();
                        this.evtEndSession();
                        this.entry_m112(RetryCause.http_timeout);
                        break;
                    }
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                    this.cause = "http.timeout";
                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                    this.state.goto_rec();
                    this.cancel_evtTransportTimeout();
                    this.entry_rec(pauseMs, RetryCause.http_timeout);
                    break;
                }
                case 230: {
                    if (this.options.sessionRecoveryTimeout == 0L) {
                        this.disposeHTTP();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "ttl.timeout";
                        this.state.goto_m_from_session(112);
                        this.cancel_evtTransportTimeout();
                        this.evtEndSession();
                        this.entry_m112(RetryCause.http_timeout);
                        break;
                    }
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                    this.cause = "ttl.timeout";
                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                    this.state.goto_rec();
                    this.cancel_evtTransportTimeout();
                    this.entry_rec(pauseMs, RetryCause.http_error);
                    break;
                }
                case 240: {
                    Integer _g2;
                    StateVar_ws tmp = this.state.s_ws;
                    Integer n = _g2 = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
                    if (_g2 == null) break;
                    switch (Jvm.toInt(_g2)) {
                        default: {
                            break block7;
                        }
                        case 500: {
                            this.disableWS();
                            this.disposeWS();
                            this.cause = "ws.unavailable";
                            this.state.clear_ws();
                            this.state.s_tr = 200;
                            this.state.traceState();
                            this.cancel_evtTransportTimeout();
                            this.evtSwitchTransport();
                            break block7;
                        }
                        case 501: {
                            if (this.options.sessionRecoveryTimeout == 0L) {
                                this.disableWS();
                                this.disposeWS();
                                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                                this.cause = "ws.unavailable";
                                this.state.goto_m_from_ws(112);
                                this.exit_ws_to_m();
                                this.entry_m112(RetryCause.ws_unavailable);
                                break block7;
                            }
                            this.disableWS();
                            this.disposeWS();
                            this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                            this.cause = "ws.unavailable";
                            long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                            this.state.goto_rec_from_ws();
                            this.exit_ws();
                            this.entry_rec(pauseMs, RetryCause.ws_unavailable);
                            break block7;
                        }
                        case 502: 
                    }
                    if (this.options.sessionRecoveryTimeout == 0L) {
                        this.disposeWS();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "ws.timeout";
                        this.state.goto_m_from_ws(112);
                        this.exit_ws_to_m();
                        this.entry_m112(RetryCause.ws_timeout);
                        break;
                    }
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                    this.cause = "ws.timeout";
                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                    this.state.goto_rec_from_ws();
                    this.exit_ws();
                    this.entry_rec(pauseMs, RetryCause.ws_timeout);
                    break;
                }
                case 250: {
                    Integer _g3;
                    StateVar_wp tmp = this.state.s_wp;
                    Integer n = _g3 = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
                    if (_g3 == null) break;
                    switch (Jvm.toInt(_g3)) {
                        default: {
                            break block7;
                        }
                        case 600: 
                        case 601: 
                    }
                    this.disableWS();
                    this.disposeWS();
                    this.cause = "ws.unavailable";
                    this.state.clear_wp();
                    this.state.s_tr = 200;
                    this.state.traceState();
                    this.exit_wp();
                    this.evtSwitchTransport();
                    break;
                }
                case 260: {
                    Integer n = this.state.s_rec;
                    if (!(n == null ? false : Jvm.toInt(n) == 1001)) break;
                    this.disposeHTTP();
                    this.state.s_rec = 1002;
                    this.state.traceState();
                    this.cancel_evtTransportTimeout();
                    this.evtCheckRecoveryTimeout(RecoveryRetryCause.RRC_transport_timeout);
                    break;
                }
                case 270: {
                    Integer _g4;
                    Integer _g5 = this.state.s_h;
                    if (_g5 == null) break;
                    switch (Jvm.toInt(_g5)) {
                        default: {
                            break block7;
                        }
                        case 710: 
                    }
                    StateVar_hs tmp = this.state.s_hs;
                    Integer n = _g4 = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
                    if (_g4 == null) break;
                    switch (Jvm.toInt(_g4)) {
                        default: {
                            break block7;
                        }
                        case 800: {
                            this.disableHTTP_Streaming();
                            this.cause = "http.streaming.unavailable";
                            this.state.s_hs.m = 801;
                            this.state.traceState();
                            this.cancel_evtTransportTimeout();
                            this.evtForcePolling();
                            this.schedule_evtTransportTimeout(this.options.retryDelay);
                            break block7;
                        }
                        case 801: 
                    }
                    if (this.options.sessionRecoveryTimeout == 0L) {
                        this.disposeHTTP();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "http.timeout";
                        this.state.goto_m_from_hs(112);
                        this.exit_hs_to_m();
                        this.entry_m112(RetryCause.http_timeout);
                        break;
                    }
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                    this.cause = "http.timeout";
                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                    this.state.goto_rec_from_hs();
                    this.exit_hs_to_rec();
                    this.entry_rec(pauseMs, RetryCause.http_timeout);
                }
            }
        }
    }

    public void evtTransportError() {
        this.traceEvent("transport.error");
        switch (this.state.s_m) {
            default: {
                return;
            }
            case 120: 
            case 121: {
                this.suspendWS_Streaming();
                this.disposeWS();
                this.cause = "ws.unavailable";
                this.state.s_m = 115;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.evtRetry(RetryCause.ws_unavailable, null);
                this.evtRetryTimeout();
                return;
            }
            case 122: {
                this.disposeWS();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "ws.error";
                long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
                this.state.s_m = 112;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.evtRetry(RetryCause.ws_error, pauseMs);
                this.schedule_evtRetryTimeout(pauseMs);
                return;
            }
            case 130: {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "http.error";
                long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
                this.state.s_m = 112;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.evtRetry(RetryCause.http_error, pauseMs);
                this.schedule_evtRetryTimeout(pauseMs);
                return;
            }
            case 140: {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "ttl.error";
                long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
                this.state.s_m = 111;
                this.state.traceState();
                this.cancel_evtTransportTimeout();
                this.evtRetry(RetryCause.http_error, pauseMs);
                this.schedule_evtRetryTimeout(pauseMs);
                return;
            }
            case 150: 
        }
        Integer _g = this.state.s_tr;
        if (_g != null) {
            block7 : switch (Jvm.toInt(_g)) {
                default: {
                    break;
                }
                case 210: {
                    if (this.options.sessionRecoveryTimeout == 0L) {
                        this.disposeWS();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "ws.error";
                        this.state.clear_w();
                        this.state.goto_m_from_session(113);
                        this.exit_w();
                        this.evtEndSession();
                        this.entry_m113(RetryCause.ws_error);
                        break;
                    }
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                    this.cause = "ws.error";
                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                    this.state.clear_w();
                    this.state.s_tr = 260;
                    this.state.s_rec = 1000;
                    this.state.traceState();
                    this.exit_w();
                    this.entry_rec(pauseMs, RetryCause.ws_error);
                    break;
                }
                case 220: {
                    if (this.options.sessionRecoveryTimeout == 0L) {
                        this.disposeHTTP();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "http.error";
                        long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
                        this.state.goto_m_from_session(112);
                        this.cancel_evtTransportTimeout();
                        this.evtEndSession();
                        this.evtRetry(RetryCause.http_error, pauseMs);
                        this.schedule_evtRetryTimeout(pauseMs);
                        break;
                    }
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                    this.cause = "http.error";
                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                    this.state.goto_rec();
                    this.cancel_evtTransportTimeout();
                    this.entry_rec(pauseMs, RetryCause.http_error);
                    break;
                }
                case 230: {
                    if (this.options.sessionRecoveryTimeout == 0L) {
                        this.disposeHTTP();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "ttl.error";
                        long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
                        this.state.goto_m_from_session(112);
                        this.cancel_evtTransportTimeout();
                        this.evtEndSession();
                        this.evtRetry(RetryCause.http_error, pauseMs);
                        this.schedule_evtRetryTimeout(pauseMs);
                        break;
                    }
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                    this.cause = "ttl.error";
                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                    this.state.goto_rec();
                    this.cancel_evtTransportTimeout();
                    this.entry_rec(pauseMs, RetryCause.http_error);
                    break;
                }
                case 240: {
                    switch (NullTools.sure(this.state.s_ws).m) {
                        case 500: {
                            this.disableWS();
                            this.disposeWS();
                            this.cause = "ws.unavailable";
                            this.state.clear_ws();
                            this.state.s_tr = 200;
                            this.state.traceState();
                            this.cancel_evtTransportTimeout();
                            this.evtSwitchTransport();
                            break;
                        }
                        case 501: {
                            if (this.options.sessionRecoveryTimeout == 0L) {
                                this.disableWS();
                                this.disposeWS();
                                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                                this.cause = "ws.unavailable";
                                this.state.goto_m_from_ws(112);
                                this.exit_ws_to_m();
                                this.entry_m112(RetryCause.ws_unavailable);
                                break;
                            }
                            this.disableWS();
                            this.disposeWS();
                            this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                            this.cause = "ws.unavailable";
                            long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                            this.state.goto_rec_from_ws();
                            this.exit_ws();
                            this.entry_rec(pauseMs, RetryCause.ws_unavailable);
                            break;
                        }
                        case 502: {
                            if (this.options.sessionRecoveryTimeout == 0L) {
                                this.disposeWS();
                                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                                this.cause = "ws.error";
                                this.state.goto_m_from_ws(112);
                                this.exit_ws_to_m();
                                this.entry_m112(RetryCause.ws_error);
                                break;
                            }
                            this.disposeWS();
                            this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                            this.cause = "ws.error";
                            long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                            this.state.goto_rec_from_ws();
                            this.cancel_evtTransportTimeout();
                            this.entry_rec(pauseMs, RetryCause.ws_error);
                            break;
                        }
                        case 503: {
                            if (this.options.sessionRecoveryTimeout == 0L) {
                                this.disposeWS();
                                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                                this.cause = "ws.error";
                                this.state.goto_m_from_ws(113);
                                this.exit_ws_to_m();
                                this.entry_m113(RetryCause.ws_error);
                                break;
                            }
                            this.disposeWS();
                            this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                            this.cause = "ws.error";
                            long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                            this.state.goto_rec_from_ws();
                            this.exit_ws();
                            this.entry_rec(pauseMs, RetryCause.ws_error);
                        }
                    }
                    break;
                }
                case 250: {
                    switch (NullTools.sure(this.state.s_wp).m) {
                        case 600: 
                        case 601: {
                            this.disableWS();
                            this.disposeWS();
                            this.cause = "ws.unavailable";
                            this.state.clear_wp();
                            this.state.s_tr = 200;
                            this.state.traceState();
                            this.cancel_evtTransportTimeout();
                            this.evtSwitchTransport();
                            break;
                        }
                        case 602: {
                            if (this.options.sessionRecoveryTimeout == 0L) {
                                this.disposeWS();
                                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                                this.cause = "ws.error";
                                this.state.goto_m_from_wp(113);
                                this.exit_wp_to_m();
                                this.entry_m113(RetryCause.ws_error);
                                break;
                            }
                            this.disposeWS();
                            this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                            this.cause = "ws.error";
                            long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                            this.state.goto_rec_from_wp();
                            this.exit_wp();
                            this.entry_rec(pauseMs, RetryCause.ws_error);
                        }
                    }
                    break;
                }
                case 260: {
                    Integer n = this.state.s_rec;
                    if (!(n == null ? false : Jvm.toInt(n) == 1001)) break;
                    this.disposeHTTP();
                    this.state.s_rec = 1002;
                    this.state.traceState();
                    this.cancel_evtTransportTimeout();
                    this.evtCheckRecoveryTimeout(RecoveryRetryCause.RRC_transport_error);
                    break;
                }
                case 270: {
                    switch (Jvm.toInt(NullTools.sure(this.state.s_h))) {
                        case 710: {
                            switch (NullTools.sure(this.state.s_hs).m) {
                                case 800: 
                                case 801: {
                                    if (this.options.sessionRecoveryTimeout == 0L) {
                                        this.disposeHTTP();
                                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                                        this.cause = "http.error";
                                        this.state.goto_m_from_hs(112);
                                        this.exit_hs_to_m();
                                        this.entry_m112(RetryCause.http_error);
                                        break;
                                    }
                                    this.disposeHTTP();
                                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                                    this.cause = "http.error";
                                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                                    this.state.goto_rec_from_hs();
                                    this.exit_hs_to_rec();
                                    this.entry_rec(pauseMs, RetryCause.http_error);
                                    break;
                                }
                                case 802: {
                                    if (this.options.sessionRecoveryTimeout == 0L) {
                                        this.disposeHTTP();
                                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                                        this.cause = "http.error";
                                        this.state.goto_m_from_hs(113);
                                        this.exit_hs_to_m();
                                        this.entry_m113(RetryCause.http_error);
                                        break;
                                    }
                                    this.disposeHTTP();
                                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                                    this.cause = "http.error";
                                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                                    this.state.goto_rec_from_hs();
                                    this.exit_hs_to_rec();
                                    this.entry_rec(pauseMs, RetryCause.http_error);
                                }
                            }
                            break block7;
                        }
                        case 720: {
                            switch (NullTools.sure(this.state.s_hp).m) {
                                case 900: 
                                case 901: 
                                case 902: 
                                case 903: 
                                case 904: {
                                    if (this.options.sessionRecoveryTimeout == 0L) {
                                        this.disposeHTTP();
                                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                                        this.cause = "http.error";
                                        this.state.goto_m_from_hp(112);
                                        this.exit_hp_to_m();
                                        this.entry_m112(RetryCause.http_error);
                                        break block7;
                                    }
                                    this.disposeHTTP();
                                    this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                                    this.cause = "http.error";
                                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                                    this.state.goto_rec_from_hp();
                                    this.exit_hp_to_rec();
                                    this.entry_rec(pauseMs, RetryCause.http_error);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void evtIdleTimeout() {
        Integer _g;
        Integer _g2;
        this.traceEvent("idle.timeout");
        boolean tmp = false;
        StateVar_wp tmp1 = this.state.s_wp;
        Integer n = _g2 = tmp1 != null ? tmp1.p : (Integer)null;
        if (_g2 == null) {
            tmp = false;
        } else {
            switch (Jvm.toInt(_g2)) {
                default: {
                    tmp = false;
                    break;
                }
                case 610: 
                case 611: 
                case 613: {
                    tmp = true;
                }
            }
        }
        if (tmp) {
            if (this.options.sessionRecoveryTimeout == 0L) {
                this.disposeWS();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "ws.idle.timeout";
                this.state.goto_m_from_wp(113);
                this.exit_wp_to_m();
                this.entry_m113(RetryCause.idle_timeout);
                return;
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
            this.cause = "ws.idle.timeout";
            long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
            this.state.goto_rec_from_wp();
            this.exit_wp();
            this.entry_rec(pauseMs, RetryCause.idle_timeout);
            return;
        }
        boolean tmp2 = false;
        StateVar_hp tmp12 = this.state.s_hp;
        Integer n2 = _g = tmp12 != null ? Integer.valueOf(tmp12.m) : (Integer)null;
        if (_g == null) {
            tmp2 = false;
        } else {
            switch (Jvm.toInt(_g)) {
                default: {
                    tmp2 = false;
                    break;
                }
                case 900: 
                case 901: 
                case 903: {
                    tmp2 = true;
                }
            }
        }
        if (tmp2) {
            if (this.options.sessionRecoveryTimeout == 0L) {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "http.idle.timeout";
                this.state.goto_m_from_hp(112);
                this.exit_hp_to_m();
                this.entry_m112(RetryCause.idle_timeout);
            } else {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                this.cause = "http.idle.timeout";
                long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                this.state.goto_rec_from_hp();
                this.exit_hp_to_rec();
                this.entry_rec(pauseMs, RetryCause.idle_timeout);
            }
        }
    }

    public void evtPollingTimeout() {
        this.traceEvent("polling.timeout");
        StateVar_wp tmp = this.state.s_wp;
        Integer n = tmp != null ? tmp.p : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 612) {
            this.sendBindWS_Polling();
            this.state.s_wp.p = 613;
            this.state.traceState();
            this.cancel_evtPollingTimeout();
            this.schedule_evtIdleTimeout(Millis_Impl_.plus(Jvm.toLong(NullTools.sure(this.idleTimeout)), this.options.retryDelay));
            return;
        }
        StateVar_hp tmp2 = this.state.s_hp;
        Integer n2 = tmp2 != null ? Integer.valueOf(tmp2.m) : (Integer)null;
        if (n2 == null ? false : Jvm.toInt(n2) == 902) {
            this.sendBindHTTP_Polling();
            this.state.s_hp.m = 903;
            this.state.traceState();
            this.cancel_evtPollingTimeout();
            this.schedule_evtIdleTimeout(Millis_Impl_.plus(Jvm.toLong(NullTools.sure(this.idleTimeout)), this.options.retryDelay));
        }
    }

    public void evtKeepaliveTimeout() {
        this.traceEvent("keepalive.timeout");
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.k) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 310) {
            this.state.s_w.k = 311;
            this.state.traceState();
            this.cancel_evtKeepaliveTimeout();
            this.schedule_evtStalledTimeout(this.options.stalledTimeout);
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n2 = tmp2 != null ? tmp2.k : (Integer)null;
        if (n2 == null ? false : Jvm.toInt(n2) == 520) {
            this.state.s_ws.k = 521;
            this.state.traceState();
            this.cancel_evtKeepaliveTimeout();
            this.schedule_evtStalledTimeout(this.options.stalledTimeout);
            return;
        }
        StateVar_hs tmp3 = this.state.s_hs;
        Integer n3 = tmp3 != null ? tmp3.k : (Integer)null;
        if (n3 == null ? false : Jvm.toInt(n3) == 820) {
            this.state.s_hs.k = 821;
            this.state.traceState();
            this.cancel_evtKeepaliveTimeout();
            this.schedule_evtStalledTimeout(this.options.stalledTimeout);
        }
    }

    public void evtStalledTimeout() {
        this.traceEvent("stalled.timeout");
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.k) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 311) {
            this.state.s_w.k = 312;
            this.state.traceState();
            this.cancel_evtStalledTimeout();
            this.schedule_evtReconnectTimeout(this.options.reconnectTimeout);
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n2 = tmp2 != null ? tmp2.k : (Integer)null;
        if (n2 == null ? false : Jvm.toInt(n2) == 521) {
            this.state.s_ws.k = 522;
            this.state.traceState();
            this.cancel_evtStalledTimeout();
            this.schedule_evtReconnectTimeout(this.options.reconnectTimeout);
            return;
        }
        StateVar_hs tmp3 = this.state.s_hs;
        Integer n3 = tmp3 != null ? tmp3.k : (Integer)null;
        if (n3 == null ? false : Jvm.toInt(n3) == 821) {
            this.state.s_hs.k = 822;
            this.state.traceState();
            this.cancel_evtStalledTimeout();
            this.schedule_evtReconnectTimeout(this.options.reconnectTimeout);
        }
    }

    public void evtReconnectTimeout() {
        this.traceEvent("reconnect.timeout");
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.k) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 312) {
            if (this.options.sessionRecoveryTimeout == 0L) {
                this.disposeWS();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "ws.stalled";
                this.state.goto_m_from_w(113);
                this.exit_w_to_m();
                this.entry_m113(RetryCause.stalled_timeout);
                return;
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
            this.cause = "ws.stalled";
            long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
            this.state.goto_rec_from_w();
            this.exit_w();
            this.entry_rec(pauseMs, RetryCause.stalled_timeout);
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n2 = tmp2 != null ? tmp2.k : (Integer)null;
        if (n2 == null ? false : Jvm.toInt(n2) == 522) {
            if (this.options.sessionRecoveryTimeout == 0L) {
                this.disposeWS();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "ws.stalled";
                this.state.goto_m_from_ws(113);
                this.exit_ws_to_m();
                this.entry_m113(RetryCause.stalled_timeout);
                return;
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
            this.cause = "ws.stalled";
            long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
            this.state.goto_rec_from_ws();
            this.exit_ws();
            this.entry_rec(pauseMs, RetryCause.stalled_timeout);
            return;
        }
        StateVar_hs tmp3 = this.state.s_hs;
        Integer n3 = tmp3 != null ? tmp3.k : (Integer)null;
        if (n3 == null ? false : Jvm.toInt(n3) == 822) {
            if (this.options.sessionRecoveryTimeout == 0L) {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "http.stalled";
                this.state.goto_m_from_hs(113);
                this.exit_hs_to_m();
                this.entry_m113(RetryCause.stalled_timeout);
            } else {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:TRYING-RECOVERY");
                this.cause = "http.stalled";
                long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                this.state.goto_rec_from_hs();
                this.exit_hs_to_rec();
                this.entry_rec(pauseMs, RetryCause.stalled_timeout);
            }
        }
    }

    public void evtRestartKeepalive() {
        this.traceEvent("restart.keepalive");
        StateVar_w tmp = this.state.s_w;
        if ((tmp != null ? Integer.valueOf(tmp.k) : (Integer)null) != null) {
            this.state.s_w.k = 310;
            this.state.traceState();
            this.exit_keepalive_unit();
            this.schedule_evtKeepaliveTimeout(Jvm.toLong(NullTools.sure(this.keepaliveInterval)));
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        if ((tmp2 != null ? tmp2.k : (Integer)null) != null) {
            this.state.s_ws.k = 520;
            this.state.traceState();
            this.exit_keepalive_unit();
            this.schedule_evtKeepaliveTimeout(Jvm.toLong(NullTools.sure(this.keepaliveInterval)));
            return;
        }
        StateVar_hs tmp3 = this.state.s_hs;
        if ((tmp3 != null ? tmp3.k : (Integer)null) != null) {
            this.state.s_hs.k = 820;
            this.state.traceState();
            this.exit_keepalive_unit();
            this.schedule_evtKeepaliveTimeout(Jvm.toLong(NullTools.sure(this.keepaliveInterval)));
        }
    }

    public void evtWSOK() {
        this.traceEvent("WSOK");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("WSOK", null);
        }
        switch (this.state.s_m) {
            default: {
                return;
            }
            case 121: {
                this.state.s_m = 122;
                this.state.traceState();
                return;
            }
            case 150: 
        }
        Integer _g = this.state.s_tr;
        if (_g != null) {
            block4 : switch (Jvm.toInt(_g)) {
                default: {
                    break;
                }
                case 240: {
                    Integer _g2;
                    StateVar_ws tmp = this.state.s_ws;
                    Integer n = _g2 = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
                    if (_g2 == null) break;
                    switch (Jvm.toInt(_g2)) {
                        default: {
                            break block4;
                        }
                        case 501: 
                    }
                    this.state.s_ws.m = 502;
                    this.state.traceState();
                    break;
                }
                case 250: {
                    Integer _g3;
                    StateVar_wp tmp = this.state.s_wp;
                    Integer n = _g3 = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
                    if (_g3 == null) break;
                    switch (Jvm.toInt(_g3)) {
                        default: {
                            break block4;
                        }
                        case 601: 
                    }
                    this.sendBindWS_FirstPolling();
                    this.state.s_wp.m = 602;
                    this.state.s_wp.p = 610;
                    this.state.s_wp.c = 620;
                    this.state.s_wp.s = 630;
                    this.state.traceState();
                    this.cancel_evtTransportTimeout();
                    this.evtSendPendingControls();
                    this.evtSendPendingMessages();
                    this.schedule_evtIdleTimeout(Millis_Impl_.plus(Jvm.toLong(NullTools.sure(this.idleTimeout)), this.options.retryDelay));
                }
            }
        }
    }

    public void evtCONERR(int code, String msg) {
        this.traceEvent("CONERR");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("CONERR " + code + " " + msg, null);
        }
        RetryCause retryCause = RetryCause.standardError(code, msg);
        TerminationCause terminationCause = TerminationCause.TC_standardError(code, msg);
        if (this.state.s_m == 122) {
            switch (code) {
                default: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_CONERR(code, msg);
                    this.state.s_m = 100;
                    this.state.traceState();
                    this.cancel_evtTransportTimeout();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 5: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "ws.conerr." + code;
                    this.state.s_m = 110;
                    this.state.traceState();
                    this.cancel_evtTransportTimeout();
                    this.evtRetry(retryCause, null);
                    this.evtRetryTimeout();
                    return;
                }
                case 4: 
                case 6: 
                case 20: 
                case 40: 
                case 41: 
                case 48: 
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "ws.conerr." + code;
            long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
            this.state.s_m = 112;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.evtRetry(retryCause, pauseMs);
            this.schedule_evtRetryTimeout(pauseMs);
            return;
        }
        if (this.state.s_m == 130) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_CONERR(code, msg);
                    this.state.s_m = 100;
                    this.state.traceState();
                    this.cancel_evtTransportTimeout();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 5: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "http.conerr." + code;
                    this.state.s_m = 110;
                    this.state.traceState();
                    this.cancel_evtTransportTimeout();
                    this.evtRetry(retryCause, null);
                    this.evtRetryTimeout();
                    return;
                }
                case 4: 
                case 6: 
                case 20: 
                case 40: 
                case 41: 
                case 48: 
            }
            this.disposeHTTP();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "http.conerr." + code;
            long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
            this.state.s_m = 112;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.evtRetry(retryCause, pauseMs);
            this.schedule_evtRetryTimeout(pauseMs);
            return;
        }
        if (this.state.s_m == 140) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_CONERR(code, msg);
                    this.state.s_m = 100;
                    this.state.traceState();
                    this.cancel_evtTransportTimeout();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 5: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "ttl.conerr." + code;
                    this.state.s_m = 110;
                    this.state.traceState();
                    this.cancel_evtTransportTimeout();
                    this.evtRetry(retryCause, null);
                    this.evtRetryTimeout();
                    return;
                }
                case 4: 
                case 6: 
                case 20: 
                case 40: 
                case 41: 
                case 48: 
            }
            this.disposeHTTP();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "ttl.conerr." + code;
            long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
            this.state.s_m = 112;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.evtRetry(retryCause, pauseMs);
            this.schedule_evtRetryTimeout(pauseMs);
            return;
        }
        StateVar_ws tmp = this.state.s_ws;
        Integer n = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 502) {
            switch (code) {
                default: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_CONERR(code, msg);
                    this.state.goto_m_from_ws(100);
                    this.exit_ws_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 4: 
                case 6: 
                case 20: 
                case 40: 
                case 41: 
                case 48: 
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "ws.conerr." + code;
            this.state.goto_m_from_ws(112);
            this.exit_ws_to_m();
            this.entry_m112(RetryCause.standardError(code, msg));
            return;
        }
        boolean tmp2 = false;
        StateVar_wp tmp1 = this.state.s_wp;
        Integer n2 = tmp1 != null ? tmp1.p : (Integer)null;
        if (n2 == null ? true : Jvm.toInt(n2) != 610) {
            StateVar_wp tmp12 = this.state.s_wp;
            Integer n3 = tmp12 != null ? tmp12.p : (Integer)null;
            tmp2 = n3 == null ? false : Jvm.toInt(n3) == 613;
        } else {
            tmp2 = true;
        }
        if (tmp2) {
            switch (code) {
                default: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_CONERR(code, msg);
                    this.state.goto_m_from_wp(100);
                    this.exit_wp_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 4: 
                case 6: 
                case 20: 
                case 40: 
                case 41: 
                case 48: 
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "ws.conerr." + code;
            this.state.goto_m_from_wp(112);
            this.exit_wp_to_m();
            this.entry_m112(RetryCause.standardError(code, msg));
            return;
        }
        boolean tmp3 = false;
        StateVar_hs tmp13 = this.state.s_hs;
        Integer n4 = tmp13 != null ? Integer.valueOf(tmp13.m) : (Integer)null;
        if (n4 == null ? true : Jvm.toInt(n4) != 800) {
            StateVar_hs tmp14 = this.state.s_hs;
            Integer n5 = tmp14 != null ? Integer.valueOf(tmp14.m) : (Integer)null;
            tmp3 = n5 == null ? false : Jvm.toInt(n5) == 801;
        } else {
            tmp3 = true;
        }
        if (tmp3) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_CONERR(code, msg);
                    this.state.goto_m_from_hs(100);
                    this.exit_hs_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 4: 
                case 6: 
                case 20: 
                case 40: 
                case 41: 
                case 48: 
            }
            this.disposeHTTP();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "http.conerr." + code;
            this.state.goto_m_from_hs(112);
            this.exit_hs_to_m();
            this.entry_m112(RetryCause.standardError(code, msg));
            return;
        }
        boolean tmp4 = false;
        StateVar_hp tmp15 = this.state.s_hp;
        Integer n6 = tmp15 != null ? Integer.valueOf(tmp15.m) : (Integer)null;
        if (n6 == null ? true : Jvm.toInt(n6) != 900) {
            StateVar_hp tmp16 = this.state.s_hp;
            Integer n7 = tmp16 != null ? Integer.valueOf(tmp16.m) : (Integer)null;
            tmp4 = n7 == null ? false : Jvm.toInt(n7) == 903;
        } else {
            tmp4 = true;
        }
        if (tmp4) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_CONERR(code, msg);
                    this.state.goto_m_from_hp(100);
                    this.exit_hp_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 4: 
                case 6: 
                case 20: 
                case 40: 
                case 41: 
                case 48: 
            }
            this.disposeHTTP();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "http.conerr." + code;
            this.state.goto_m_from_hp(112);
            this.exit_hp_to_m();
            this.entry_m112(RetryCause.standardError(code, msg));
            return;
        }
        Integer n8 = this.state.s_rec;
        if (n8 == null ? false : Jvm.toInt(n8) == 1001) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_CONERR(code, msg);
                    this.state.goto_m_from_rec(100);
                    this.exit_rec_to_m();
                    this.evtTerminate(terminationCause);
                    break;
                }
                case 4: 
                case 6: 
                case 20: 
                case 40: 
                case 41: 
                case 48: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "recovery.conerr." + code;
                    this.state.goto_m_from_rec(113);
                    this.exit_rec_to_m();
                    this.entry_m113(retryCause);
                }
            }
        }
    }

    public void evtEND(int code, String msg) {
        this.traceEvent("END");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("END " + code + " " + msg, null);
        }
        RetryCause retryCause = RetryCause.standardError(code, msg);
        TerminationCause terminationCause = TerminationCause.TC_standardError(code, msg);
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.p) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 300) {
            switch (code) {
                default: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.clear_w();
                    this.state.goto_m_from_session(100);
                    this.exit_w();
                    this.evtEndSession();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 41: 
                case 48: 
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "ws.end." + code;
            long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
            this.state.clear_w();
            this.state.goto_m_from_session(113);
            this.exit_w();
            this.evtEndSession();
            this.evtRetry(RetryCause.standardError(code, msg), pauseMs);
            this.schedule_evtRetryTimeout(pauseMs);
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n2 = tmp2 != null ? Integer.valueOf(tmp2.m) : (Integer)null;
        if (n2 == null ? false : Jvm.toInt(n2) == 502) {
            switch (code) {
                default: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.goto_m_from_ws(100);
                    this.exit_ws_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 41: 
                case 48: 
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "ws.end." + code;
            this.state.goto_m_from_ws(112);
            this.exit_ws_to_m();
            this.entry_m112(RetryCause.standardError(code, msg));
            return;
        }
        StateVar_ws tmp3 = this.state.s_ws;
        Integer n3 = tmp3 != null ? tmp3.p : (Integer)null;
        if (n3 == null ? false : Jvm.toInt(n3) == 510) {
            switch (code) {
                default: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.goto_m_from_ws(100);
                    this.exit_ws_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 41: 
                case 48: 
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "ws.end." + code;
            this.state.goto_m_from_ws(113);
            this.exit_ws_to_m();
            this.entry_m113(retryCause);
            return;
        }
        boolean tmp4 = false;
        StateVar_wp tmp1 = this.state.s_wp;
        Integer n4 = tmp1 != null ? tmp1.p : (Integer)null;
        if (n4 == null ? true : Jvm.toInt(n4) != 610) {
            StateVar_wp tmp12 = this.state.s_wp;
            Integer n5 = tmp12 != null ? tmp12.p : (Integer)null;
            tmp4 = n5 == null ? false : Jvm.toInt(n5) == 613;
        } else {
            tmp4 = true;
        }
        if (tmp4) {
            switch (code) {
                default: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.goto_m_from_wp(100);
                    this.exit_wp_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 41: 
                case 48: 
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "ws.end." + code;
            this.state.goto_m_from_wp(112);
            this.exit_wp_to_m();
            this.entry_m112(RetryCause.standardError(code, msg));
            return;
        }
        StateVar_wp tmp5 = this.state.s_wp;
        Integer n6 = tmp5 != null ? tmp5.p : (Integer)null;
        if (n6 == null ? false : Jvm.toInt(n6) == 611) {
            switch (code) {
                default: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.goto_m_from_wp(100);
                    this.exit_wp_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 41: 
                case 48: 
            }
            this.disposeWS();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "ws.end." + code;
            this.state.goto_m_from_wp(113);
            this.exit_wp_to_m();
            this.entry_m113(retryCause);
            return;
        }
        boolean tmp6 = false;
        StateVar_hs tmp13 = this.state.s_hs;
        Integer n7 = tmp13 != null ? Integer.valueOf(tmp13.m) : (Integer)null;
        if (n7 == null ? true : Jvm.toInt(n7) != 800) {
            StateVar_hs tmp14 = this.state.s_hs;
            Integer n8 = tmp14 != null ? Integer.valueOf(tmp14.m) : (Integer)null;
            tmp6 = n8 == null ? false : Jvm.toInt(n8) == 801;
        } else {
            tmp6 = true;
        }
        if (tmp6) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.goto_m_from_hs(100);
                    this.exit_hs_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 41: 
                case 48: 
            }
            this.disposeHTTP();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "http.end." + code;
            this.state.goto_m_from_hs(112);
            this.exit_hs_to_m();
            this.entry_m112(RetryCause.standardError(code, msg));
            return;
        }
        StateVar_hs tmp7 = this.state.s_hs;
        Integer n9 = tmp7 != null ? tmp7.p : (Integer)null;
        if (n9 == null ? false : Jvm.toInt(n9) == 810) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.goto_m_from_hs(100);
                    this.exit_hs_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 41: 
                case 48: 
            }
            this.disposeHTTP();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "http.end." + code;
            this.state.goto_m_from_hs(113);
            this.exit_hs_to_m();
            this.entry_m113(retryCause);
            return;
        }
        boolean tmp8 = false;
        StateVar_hp tmp15 = this.state.s_hp;
        Integer n10 = tmp15 != null ? Integer.valueOf(tmp15.m) : (Integer)null;
        if (n10 == null ? true : Jvm.toInt(n10) != 900) {
            StateVar_hp tmp16 = this.state.s_hp;
            Integer n11 = tmp16 != null ? Integer.valueOf(tmp16.m) : (Integer)null;
            tmp8 = n11 == null ? false : Jvm.toInt(n11) == 903;
        } else {
            tmp8 = true;
        }
        if (tmp8) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.goto_m_from_hp(100);
                    this.exit_hp_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 41: 
                case 48: 
            }
            this.disposeHTTP();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "http.end." + code;
            this.state.goto_m_from_hp(112);
            this.exit_hp_to_m();
            this.entry_m112(RetryCause.standardError(code, msg));
            return;
        }
        StateVar_hp tmp9 = this.state.s_hp;
        Integer n12 = tmp9 != null ? Integer.valueOf(tmp9.m) : (Integer)null;
        if (n12 == null ? false : Jvm.toInt(n12) == 901) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.goto_m_from_hp(100);
                    this.exit_hp_to_m();
                    this.evtTerminate(terminationCause);
                    return;
                }
                case 41: 
                case 48: 
            }
            this.disposeHTTP();
            this.notifyStatus("DISCONNECTED:WILL-RETRY");
            this.cause = "http.end." + code;
            this.state.goto_m_from_hp(113);
            this.exit_hp_to_m();
            this.entry_m113(retryCause);
            return;
        }
        Integer n13 = this.state.s_rec;
        if (n13 == null ? false : Jvm.toInt(n13) == 1001) {
            switch (code) {
                default: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_END(code, msg);
                    this.state.goto_m_from_rec(100);
                    this.exit_rec_to_m();
                    this.evtTerminate(terminationCause);
                    break;
                }
                case 41: 
                case 48: {
                    this.disposeHTTP();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "recovery.end." + code;
                    this.state.goto_m_from_rec(113);
                    this.exit_rec_to_m();
                    this.entry_m113(retryCause);
                }
            }
        }
    }

    public void evtERROR(int code, String msg) {
        this.traceEvent("ERROR");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("ERROR " + code + " " + msg, null);
        }
        TerminationCause terminationCause = TerminationCause.TC_standardError(code, msg);
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.p) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 300) {
            this.disposeWS();
            this.notifyStatus("DISCONNECTED");
            this.notifyServerError_ERROR(code, msg);
            this.state.clear_w();
            this.state.goto_m_from_session(100);
            this.exit_w();
            this.evtEndSession();
            this.evtTerminate(terminationCause);
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n2 = tmp2 != null ? tmp2.p : (Integer)null;
        if (n2 == null ? false : Jvm.toInt(n2) == 510) {
            this.disposeWS();
            this.notifyStatus("DISCONNECTED");
            this.notifyServerError_ERROR(code, msg);
            this.state.goto_m_from_ws(100);
            this.exit_ws_to_m();
            this.evtTerminate(terminationCause);
            return;
        }
        StateVar_wp tmp3 = this.state.s_wp;
        Integer n3 = tmp3 != null ? tmp3.c : (Integer)null;
        if (n3 == null ? false : Jvm.toInt(n3) == 620) {
            this.disposeWS();
            this.notifyStatus("DISCONNECTED");
            this.notifyServerError_ERROR(code, msg);
            this.state.goto_m_from_wp(100);
            this.exit_wp_to_m();
            this.evtTerminate(terminationCause);
            return;
        }
        Integer n4 = this.state.s_ctrl;
        if (n4 == null ? false : Jvm.toInt(n4) == 1102) {
            this.disposeHTTP();
            this.notifyStatus("DISCONNECTED");
            this.notifyServerError_ERROR(code, msg);
            this.state.goto_m_from_ctrl(100);
            this.exit_ctrl_to_m();
            this.evtTerminate(terminationCause);
        }
    }

    public void evtREQOK_withoutReqId() {
        this.traceEvent("REQOK");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("REQOK", null);
        }
        Integer n = this.state.s_ctrl;
        if (n == null ? false : Jvm.toInt(n) == 1102) {
            this.state.s_ctrl = 1102;
            this.state.traceState();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void evtREQOK(int reqId) {
        block5: {
            block4: {
                this.traceEvent("REQOK");
                if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
                    LoggerTools_Fields_.protocolLogger.debug("REQOK " + reqId, null);
                }
                forward = true;
                v0 = this.state.s_swt;
                if (!(v0 == null ? false : Jvm.toInt(v0) == 1302)) break block4;
                v1 = this.swt_lastReqId;
                if (!(v1 == null ? false : reqId == Jvm.toInt(v1))) break block4;
                this.state.s_swt = 1303;
                this.state.traceState();
                forward = this.evtREQOK_TransportRegion(reqId);
                break block5;
            }
            v2 = this.state.s_bw;
            if (!(v2 == null ? false : Jvm.toInt(v2) == 1202)) ** GOTO lbl-1000
            v3 = this.bw_lastReqId;
            if (v3 == null ? false : reqId == Jvm.toInt(v3)) {
                this.state.s_bw = 1200;
                this.state.traceState();
                forward = this.evtREQOK_TransportRegion(reqId);
                this.evtCheckBW();
            } else lbl-1000:
            // 2 sources

            {
                forward = this.evtREQOK_Forward(reqId);
            }
        }
        if (forward) {
            this.evtREQOK_TransportRegion(reqId);
        }
    }

    public boolean evtREQOK_Forward(int reqId) {
        return true;
    }

    public boolean evtREQOK_TransportRegion(int reqId) {
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.p) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 300) {
            this.state.s_w.p = 300;
            this.state.traceState();
            this.doREQOK(reqId);
            this.evtRestartKeepalive();
        } else {
            StateVar_ws tmp2 = this.state.s_ws;
            Integer n2 = tmp2 != null ? tmp2.p : (Integer)null;
            if (n2 == null ? false : Jvm.toInt(n2) == 510) {
                this.state.s_ws.p = 510;
                this.state.traceState();
                this.doREQOK(reqId);
                this.evtRestartKeepalive();
            } else {
                StateVar_wp tmp3 = this.state.s_wp;
                Integer n3 = tmp3 != null ? tmp3.c : (Integer)null;
                if (n3 == null ? false : Jvm.toInt(n3) == 620) {
                    this.state.s_wp.c = 620;
                    this.state.traceState();
                    this.doREQOK(reqId);
                } else {
                    Integer n4 = this.state.s_ctrl;
                    if (n4 == null ? false : Jvm.toInt(n4) == 1102) {
                        this.state.s_ctrl = 1102;
                        this.state.traceState();
                        this.doREQOK(reqId);
                    }
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void evtREQERR(int reqId, int code, String msg) {
        block5: {
            block4: {
                this.traceEvent("REQERR");
                if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
                    LoggerTools_Fields_.protocolLogger.debug("REQERR " + reqId + " " + code + " " + msg, null);
                }
                forward = true;
                v0 = this.state.s_swt;
                if (!(v0 == null ? false : Jvm.toInt(v0) == 1302)) break block4;
                v1 = this.swt_lastReqId;
                if (!(v1 == null ? false : reqId == Jvm.toInt(v1))) break block4;
                this.state.s_swt = 1301;
                this.state.traceState();
                forward = this.evtREQERR_TransportRegion(reqId, code, msg);
                break block5;
            }
            v2 = this.state.s_bw;
            if (!(v2 == null ? false : Jvm.toInt(v2) == 1202)) ** GOTO lbl-1000
            v3 = this.bw_lastReqId;
            if (v3 == null ? false : reqId == Jvm.toInt(v3)) {
                this.state.s_bw = 1200;
                this.state.traceState();
                forward = this.evtREQERR_TransportRegion(reqId, code, msg);
                this.evtCheckBW();
            } else lbl-1000:
            // 2 sources

            {
                forward = this.evtREQERR_Forward(reqId, code, msg);
            }
        }
        if (forward) {
            this.evtREQERR_TransportRegion(reqId, code, msg);
        }
    }

    public boolean evtREQERR_Forward(int reqId, int code, String msg) {
        return true;
    }

    public boolean evtREQERR_TransportRegion(int reqId, int code, String msg) {
        RetryCause retryCause = RetryCause.standardError(code, msg);
        TerminationCause terminationCause = TerminationCause.TC_standardError(code, msg);
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.p) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 300) {
            switch (code) {
                default: {
                    this.state.s_w.p = 300;
                    this.state.traceState();
                    this.doREQERR(reqId, code, msg);
                    this.evtRestartKeepalive();
                    break;
                }
                case 20: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED:WILL-RETRY");
                    this.cause = "ws.reqerr." + code;
                    long pauseMs = this.randomGenerator.invoke(this.options.firstRetryMaxDelay);
                    this.state.clear_w();
                    this.state.goto_m_from_session(113);
                    this.exit_w();
                    this.evtEndSession();
                    this.evtRetry(RetryCause.standardError(code, msg), pauseMs);
                    this.schedule_evtRetryTimeout(pauseMs);
                    break;
                }
                case 11: 
                case 65: 
                case 67: {
                    this.disposeWS();
                    this.notifyStatus("DISCONNECTED");
                    this.notifyServerError_REQERR(code, msg);
                    this.state.clear_w();
                    this.state.goto_m_from_session(100);
                    this.exit_w();
                    this.evtEndSession();
                    this.evtTerminate(terminationCause);
                    break;
                }
            }
        } else {
            StateVar_ws tmp2 = this.state.s_ws;
            Integer n2 = tmp2 != null ? tmp2.p : (Integer)null;
            if (n2 == null ? false : Jvm.toInt(n2) == 510) {
                switch (code) {
                    default: {
                        this.state.s_ws.p = 510;
                        this.state.traceState();
                        this.doREQERR(reqId, code, msg);
                        this.evtRestartKeepalive();
                        break;
                    }
                    case 20: {
                        this.disposeWS();
                        this.notifyStatus("DISCONNECTED:WILL-RETRY");
                        this.cause = "ws.reqerr." + code + ")";
                        this.state.goto_m_from_ws(113);
                        this.exit_ws_to_m();
                        this.entry_m113(retryCause);
                        break;
                    }
                    case 11: 
                    case 65: 
                    case 67: {
                        this.disposeWS();
                        this.notifyStatus("DISCONNECTED");
                        this.notifyServerError_REQERR(code, msg);
                        this.state.goto_m_from_ws(100);
                        this.exit_ws_to_m();
                        this.evtTerminate(terminationCause);
                        break;
                    }
                }
            } else {
                StateVar_wp tmp3 = this.state.s_wp;
                Integer n3 = tmp3 != null ? tmp3.c : (Integer)null;
                if (n3 == null ? false : Jvm.toInt(n3) == 620) {
                    switch (code) {
                        default: {
                            this.state.s_wp.c = 620;
                            this.state.traceState();
                            this.doREQERR(reqId, code, msg);
                            break;
                        }
                        case 20: {
                            this.disposeWS();
                            this.notifyStatus("DISCONNECTED:WILL-RETRY");
                            this.cause = "ws.reqerr." + code;
                            this.state.goto_m_from_wp(113);
                            this.exit_wp_to_m();
                            this.entry_m113(retryCause);
                            break;
                        }
                        case 11: 
                        case 65: 
                        case 67: {
                            this.disposeWS();
                            this.notifyStatus("DISCONNECTED");
                            this.notifyServerError_REQERR(code, msg);
                            this.state.goto_m_from_wp(100);
                            this.exit_wp_to_m();
                            this.evtTerminate(terminationCause);
                            break;
                        }
                    }
                } else {
                    Integer n4 = this.state.s_ctrl;
                    if (n4 == null ? false : Jvm.toInt(n4) == 1102) {
                        switch (code) {
                            default: {
                                this.state.s_ctrl = 1102;
                                this.state.traceState();
                                this.doREQERR(reqId, code, msg);
                                break;
                            }
                            case 20: {
                                this.disposeHTTP();
                                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                                this.cause = "http.reqerr." + code;
                                this.state.goto_m_from_ctrl(113);
                                this.exit_ctrl_to_m();
                                this.entry_m113(retryCause);
                                break;
                            }
                            case 11: 
                            case 65: 
                            case 67: {
                                this.disposeHTTP();
                                this.notifyStatus("DISCONNECTED");
                                this.notifyServerError_REQERR(code, msg);
                                this.state.goto_m_from_ctrl(100);
                                this.exit_ctrl_to_m();
                                this.evtTerminate(terminationCause);
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public void evtPROG(int prog) {
        StateVar_w tmp;
        this.traceEvent("PROG");
        RetryCause retryCause = RetryCause.prog_mismatch(this.rec_serverProg, prog);
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("PROG " + prog, null);
        }
        Integer n = (tmp = this.state.s_w) != null ? Integer.valueOf(tmp.p) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 300) {
            if (prog != this.rec_serverProg) {
                this.disposeWS();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "prog.mismatch." + prog + "." + this.rec_serverProg;
                this.state.clear_w();
                this.state.goto_m_from_session(113);
                this.exit_w();
                this.evtEndSession();
                this.entry_m113(retryCause);
                return;
            }
            this.state.s_w.p = 300;
            this.state.traceState();
            this.evtRestartKeepalive();
            return;
        }
        Integer n2 = this.state.s_tr;
        if (n2 == null ? false : Jvm.toInt(n2) == 220) {
            if (prog != this.rec_serverProg) {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "prog.mismatch." + prog + "." + this.rec_serverProg;
                this.state.goto_m_from_session(113);
                this.cancel_evtTransportTimeout();
                this.evtEndSession();
                this.entry_m113(retryCause);
                return;
            }
            this.state.s_tr = 220;
            this.state.traceState();
            return;
        }
        Integer n3 = this.state.s_tr;
        if (n3 == null ? false : Jvm.toInt(n3) == 230) {
            if (prog != this.rec_serverProg) {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "prog.mismatch." + prog + "." + this.rec_serverProg;
                this.state.goto_m_from_session(113);
                this.cancel_evtTransportTimeout();
                this.evtEndSession();
                this.entry_m113(retryCause);
                return;
            }
            this.state.s_tr = 230;
            this.state.traceState();
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n4 = tmp2 != null ? tmp2.p : (Integer)null;
        if (n4 == null ? false : Jvm.toInt(n4) == 510) {
            if (prog != this.rec_serverProg) {
                this.disposeWS();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "prog.mismatch." + prog + "." + this.rec_serverProg;
                this.state.goto_m_from_ws(113);
                this.exit_ws_to_m();
                this.entry_m113(retryCause);
                return;
            }
            this.state.s_ws.p = 510;
            this.state.traceState();
            this.evtRestartKeepalive();
            return;
        }
        StateVar_wp tmp3 = this.state.s_wp;
        Integer n5 = tmp3 != null ? tmp3.p : (Integer)null;
        if (n5 == null ? false : Jvm.toInt(n5) == 611) {
            if (prog != this.rec_serverProg) {
                this.disposeWS();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "prog.mismatch." + prog + "." + this.rec_serverProg;
                this.state.goto_m_from_wp(113);
                this.exit_wp_to_m();
                this.entry_m113(retryCause);
                return;
            }
            this.state.s_wp.p = 611;
            this.state.traceState();
            return;
        }
        StateVar_hs tmp4 = this.state.s_hs;
        Integer n6 = tmp4 != null ? tmp4.p : (Integer)null;
        if (n6 == null ? false : Jvm.toInt(n6) == 810) {
            if (prog != this.rec_serverProg) {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "prog.mismatch." + prog + "." + this.rec_serverProg;
                this.state.goto_m_from_hs(113);
                this.exit_hs_to_m();
                this.entry_m113(retryCause);
                return;
            }
            this.state.s_hs.p = 810;
            this.state.traceState();
            this.evtRestartKeepalive();
            return;
        }
        StateVar_hp tmp5 = this.state.s_hp;
        Integer n7 = tmp5 != null ? Integer.valueOf(tmp5.m) : (Integer)null;
        if (n7 == null ? false : Jvm.toInt(n7) == 901) {
            if (prog != this.rec_serverProg) {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "prog.mismatch." + prog + "." + this.rec_serverProg;
                this.state.goto_m_from_hp(113);
                this.exit_hp_to_m();
                this.entry_m113(retryCause);
                return;
            }
            this.state.s_hp.m = 901;
            this.state.traceState();
            return;
        }
        Integer n8 = this.state.s_rec;
        if (n8 == null ? false : Jvm.toInt(n8) == 1001) {
            if (prog > this.rec_clientProg) {
                this.disposeHTTP();
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "prog.mismatch." + prog + "." + this.rec_serverProg;
                this.state.goto_m_from_rec(113);
                this.exit_rec_to_m();
                this.entry_m113(retryCause);
            } else {
                this.state.s_rec = 1001;
                this.state.traceState();
                this.doPROG(prog);
            }
        }
    }

    public void evtLOOP(long pollingMs) {
        StateVar_w tmp;
        this.traceEvent("LOOP");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("LOOP " + Std.string(pollingMs), null);
        }
        Integer n = (tmp = this.state.s_w) != null ? Integer.valueOf(tmp.p) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 300) {
            this.closeWS();
            this.cause = "ws.loop";
            this.state.clear_w();
            this.state.s_tr = 200;
            this.state.traceState();
            this.exit_w();
            this.evtSwitchTransport();
            return;
        }
        Integer n2 = this.state.s_tr;
        if (n2 == null ? false : Jvm.toInt(n2) == 220) {
            this.closeHTTP();
            this.cause = "http.loop";
            this.state.s_tr = 200;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.evtSwitchTransport();
            return;
        }
        Integer n3 = this.state.s_tr;
        if (n3 == null ? false : Jvm.toInt(n3) == 230) {
            this.closeHTTP();
            this.cause = "ttl.loop";
            this.state.s_tr = 200;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.evtSwitchTransport();
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n4 = tmp2 != null ? tmp2.p : (Integer)null;
        if (n4 == null ? false : Jvm.toInt(n4) == 510) {
            this.closeWS();
            this.cause = "ws.loop";
            this.state.clear_ws();
            this.state.s_tr = 200;
            this.state.traceState();
            this.exit_ws();
            this.evtSwitchTransport();
            return;
        }
        StateVar_wp tmp3 = this.state.s_wp;
        Integer n5 = tmp3 != null ? tmp3.p : (Integer)null;
        if (n5 == null ? false : Jvm.toInt(n5) == 611) {
            if (this.isSwitching()) {
                this.closeWS();
                this.cause = "ws.loop";
                this.state.clear_wp();
                this.state.s_tr = 200;
                this.state.traceState();
                this.exit_wp();
                this.evtSwitchTransport();
                return;
            }
            this.doLOOP(pollingMs);
            this.state.s_wp.p = 612;
            this.state.traceState();
            this.cancel_evtIdleTimeout();
            this.schedule_evtPollingTimeout(this.options.pollingInterval);
            return;
        }
        StateVar_hs tmp4 = this.state.s_hs;
        Integer n6 = tmp4 != null ? tmp4.p : (Integer)null;
        if (n6 == null ? false : Jvm.toInt(n6) == 810) {
            this.closeHTTP();
            this.cause = "http.loop";
            this.state.s_hs.p = 811;
            this.state.traceState();
            this.evtSwitchTransport();
            return;
        }
        StateVar_hp tmp5 = this.state.s_hp;
        Integer n7 = tmp5 != null ? Integer.valueOf(tmp5.m) : (Integer)null;
        if (n7 == null ? false : Jvm.toInt(n7) == 901) {
            if (this.isSwitching()) {
                this.closeHTTP();
                this.state.s_hp.m = 904;
                this.state.traceState();
                this.cancel_evtIdleTimeout();
                this.evtSwitchTransport();
                return;
            }
            this.doLOOP(pollingMs);
            this.closeHTTP();
            this.state.s_hp.m = 902;
            this.state.traceState();
            this.cancel_evtIdleTimeout();
            this.schedule_evtPollingTimeout(this.options.pollingInterval);
            return;
        }
        Integer n8 = this.state.s_rec;
        if (n8 == null ? false : Jvm.toInt(n8) == 1001) {
            this.closeHTTP();
            this.cause = "recovery.loop";
            this.state.goto_200_from_rec();
            this.exit_rec();
            this.evtSwitchTransport();
        }
    }

    public void evtCONOK(String sessionId, int reqLimit, long keepalive, String clink) {
        this.traceEvent("CONOK");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("CONOK " + sessionId + " " + reqLimit + " " + Std.string(keepalive) + " " + clink, null);
        }
        if (this.state.s_m == 122) {
            this.doCONOK_CreateWS(sessionId, reqLimit, keepalive, clink);
            this.resetCurrentRetryDelay();
            this.notifyStatus("CONNECTED:WS-STREAMING");
            this.state.s_m = 150;
            this.state.s_tr = 210;
            this.state.s_w = new StateVar_w(300, 310, 340);
            this.state.s_rhb = 320;
            this.state.s_slw = 330;
            this.state.s_swt = 1300;
            this.state.s_bw = 1200;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.evtSendPendingControls();
            this.evtSendPendingMessages();
            this.evtStartSession();
            this.schedule_evtKeepaliveTimeout(Jvm.toLong(NullTools.sure(this.keepaliveInterval)));
            this.evtSelectRhb();
            this.evtCheckTransport();
            this.evtCheckBW();
            return;
        }
        if (this.state.s_m == 130) {
            this.doCONOK_CreateHTTP(sessionId, reqLimit, keepalive, clink);
            this.resetCurrentRetryDelay();
            this.notifyStatus("CONNECTED:STREAM-SENSING");
            this.state.s_m = 150;
            this.state.s_tr = 220;
            this.state.s_swt = 1300;
            this.state.s_bw = 1200;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.evtStartSession();
            this.schedule_evtTransportTimeout(this.options.retryDelay);
            this.evtCheckTransport();
            this.evtCheckBW();
            return;
        }
        if (this.state.s_m == 140) {
            this.doCONOK_CreateHTTP(sessionId, reqLimit, keepalive, clink);
            this.resetCurrentRetryDelay();
            this.notifyStatus("CONNECTED:STREAM-SENSING");
            this.state.s_m = 150;
            this.state.s_tr = 230;
            this.state.s_swt = 1300;
            this.state.s_bw = 1200;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.evtStartSession();
            this.schedule_evtTransportTimeout(this.options.retryDelay);
            this.evtCheckTransport();
            this.evtCheckBW();
            return;
        }
        StateVar_ws tmp = this.state.s_ws;
        Integer n = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 502) {
            this.doCONOK_BindWS_Streaming(sessionId, reqLimit, keepalive, clink);
            this.notifyStatus("CONNECTED:WS-STREAMING");
            this.state.s_ws.m = 503;
            this.state.s_ws.p = 510;
            this.state.s_ws.k = 520;
            this.state.s_ws.s = 550;
            this.state.s_rhb = 320;
            this.state.s_slw = 330;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.evtSendPendingControls();
            this.evtSendPendingMessages();
            this.schedule_evtKeepaliveTimeout(Jvm.toLong(NullTools.sure(this.keepaliveInterval)));
            this.evtSelectRhb();
            return;
        }
        StateVar_wp tmp2 = this.state.s_wp;
        Integer n2 = tmp2 != null ? tmp2.p : (Integer)null;
        if (n2 == null ? false : Jvm.toInt(n2) == 610) {
            this.doCONOK_BindWS_Polling(sessionId, reqLimit, keepalive, clink);
            this.notifyStatus("CONNECTED:WS-POLLING");
            this.state.s_wp.p = 611;
            this.state.traceState();
            return;
        }
        StateVar_wp tmp3 = this.state.s_wp;
        Integer n3 = tmp3 != null ? tmp3.p : (Integer)null;
        if (n3 == null ? false : Jvm.toInt(n3) == 613) {
            this.doCONOK_BindWS_Polling(sessionId, reqLimit, keepalive, clink);
            this.state.s_wp.p = 611;
            this.state.traceState();
            return;
        }
        StateVar_hs tmp4 = this.state.s_hs;
        Integer n4 = tmp4 != null ? Integer.valueOf(tmp4.m) : (Integer)null;
        if (n4 == null ? false : Jvm.toInt(n4) == 800) {
            this.doCONOK_BindHTTP_Streaming(sessionId, reqLimit, keepalive, clink);
            this.notifyStatus("CONNECTED:HTTP-STREAMING");
            this.state.s_hs.m = 802;
            this.state.s_hs.p = 810;
            this.state.s_hs.k = 820;
            this.state.s_rhb = 320;
            this.state.s_slw = 330;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.schedule_evtKeepaliveTimeout(Jvm.toLong(NullTools.sure(this.keepaliveInterval)));
            this.evtSelectRhb();
            return;
        }
        StateVar_hs tmp5 = this.state.s_hs;
        Integer n5 = tmp5 != null ? Integer.valueOf(tmp5.m) : (Integer)null;
        if (n5 == null ? false : Jvm.toInt(n5) == 801) {
            this.doCONOK_BindHTTP_Streaming(sessionId, reqLimit, keepalive, clink);
            this.notifyStatus("CONNECTED:HTTP-STREAMING");
            this.state.s_hs.m = 802;
            this.state.s_hs.p = 810;
            this.state.s_hs.k = 820;
            this.state.s_rhb = 320;
            this.state.s_slw = 330;
            this.state.traceState();
            this.cancel_evtTransportTimeout();
            this.schedule_evtKeepaliveTimeout(Jvm.toLong(NullTools.sure(this.keepaliveInterval)));
            this.evtSelectRhb();
            return;
        }
        StateVar_hp tmp6 = this.state.s_hp;
        Integer n6 = tmp6 != null ? Integer.valueOf(tmp6.m) : (Integer)null;
        if (n6 == null ? false : Jvm.toInt(n6) == 900) {
            this.doCONOK_BindHTTP_Polling(sessionId, reqLimit, keepalive, clink);
            this.notifyStatus("CONNECTED:HTTP-POLLING");
            this.state.s_hp.m = 901;
            this.state.traceState();
            return;
        }
        StateVar_hp tmp7 = this.state.s_hp;
        Integer n7 = tmp7 != null ? Integer.valueOf(tmp7.m) : (Integer)null;
        if (n7 == null ? false : Jvm.toInt(n7) == 903) {
            this.doCONOK_BindHTTP_Polling(sessionId, reqLimit, keepalive, clink);
            this.state.s_hp.m = 901;
            this.state.traceState();
        }
    }

    public void evtSERVNAME(String serverName) {
        this.traceEvent("SERVNAME");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("SERVNAME " + serverName, null);
        }
        if (this.state.inPushing()) {
            this.doSERVNAME(serverName);
            if (this.state.inStreaming()) {
                this.evtRestartKeepalive();
            }
        }
    }

    public void evtCLIENTIP(String clientIp) {
        this.traceEvent("CLIENTIP");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("CLIENTIP " + clientIp, null);
        }
        if (this.state.inPushing()) {
            this.doCLIENTIP(clientIp);
            if (this.state.inStreaming()) {
                this.evtRestartKeepalive();
            }
        }
    }

    public void evtCONS(RealMaxBandwidth bandwidth) {
        this.traceEvent("CONS");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("CONS " + Std.string((Object)bandwidth), null);
        }
        if (this.state.inPushing()) {
            this.doCONS(bandwidth);
            if (this.state.inStreaming()) {
                this.evtRestartKeepalive();
            }
        }
    }

    public void evtPROBE() {
        this.traceEvent("PROBE");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("PROBE", null);
        }
        if (this.state.inPushing() && this.state.inStreaming()) {
            this.evtRestartKeepalive();
        }
    }

    public void evtNOOP() {
        this.traceEvent("NOOP");
        if (this.state.inPushing() && this.state.inStreaming()) {
            this.evtRestartKeepalive();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void evtSYNC(long seconds) {
        block14: {
            block15: {
                block13: {
                    this.traceEvent("SYNC");
                    if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
                        LoggerTools_Fields_.protocolLogger.debug("SYNC " + Std.string(seconds), null);
                    }
                    forward = true;
                    tmp = false;
                    tmp1 = false;
                    tmp2 = this.state.s_w;
                    v0 = tmp2 != null ? Integer.valueOf(tmp2.p) : (Integer)null;
                    if (v0 == null ? true : Jvm.toInt(v0) != 300) {
                        tmp = this.state.s_ws;
                        v1 = tmp != null ? tmp.p : (Integer)null;
                        tmp1 = (v1 == null ? false : Jvm.toInt(v1) == 510) != false;
                    } else {
                        tmp1 = true;
                    }
                    if (!tmp1) {
                        tmp1 = this.state.s_hs;
                        v2 = tmp1 != null ? tmp1.p : (Integer)null;
                        tmp = (v2 == null ? false : Jvm.toInt(v2) == 810) != false;
                    } else {
                        tmp = true;
                    }
                    if (!tmp) break block13;
                    forward = this.evtSYNC_PushingRegion(seconds);
                    this.evtRestartKeepalive();
                    break block14;
                }
                tmp = false;
                tmp1 = false;
                v3 = this.state.s_tr;
                if (!(v3 == null ? true : Jvm.toInt(v3) != 220)) ** GOTO lbl-1000
                v4 = this.state.s_tr;
                if (v4 == null ? true : Jvm.toInt(v4) != 230) {
                    tmp = this.state.s_wp;
                    v5 = tmp != null ? tmp.p : (Integer)null;
                    tmp1 = (v5 == null ? false : Jvm.toInt(v5) == 611) != false;
                } else lbl-1000:
                // 2 sources

                {
                    tmp1 = true;
                }
                if (!tmp1) {
                    tmp1 = this.state.s_hp;
                    v6 = tmp1 != null ? Integer.valueOf(tmp1.m) : (Integer)null;
                    tmp = (v6 == null ? false : Jvm.toInt(v6) == 901) != false;
                } else {
                    tmp = true;
                }
                if (tmp) break block15;
                v7 = this.state.s_rec;
                if (!(v7 == null ? false : Jvm.toInt(v7) == 1001)) break block14;
            }
            forward = this.evtSYNC_PushingRegion(seconds);
        }
        if (forward) {
            this.evtSYNC_PushingRegion(seconds);
        }
    }

    public boolean evtSYNC_PushingRegion(long seconds) {
        Integer _g;
        double syncMs = seconds * 1000L;
        if (this.state.s_slw != null && (_g = this.state.s_slw) != null) {
            switch (Jvm.toInt(_g)) {
                default: {
                    break;
                }
                case 330: {
                    this.doSYNC(syncMs);
                    this.state.s_slw = 331;
                    this.state.traceState();
                    break;
                }
                case 331: {
                    SyncCheckResult result = this.doSYNC_G(syncMs);
                    this.state.s_slw = 332;
                    this.state.traceState();
                    this.evtCheckAvg(result);
                    break;
                }
                case 333: {
                    SyncCheckResult result = this.doSYNC_NG(syncMs);
                    this.state.s_slw = 332;
                    this.state.traceState();
                    this.evtCheckAvg(result);
                }
            }
        }
        return false;
    }

    public void evtMSGDONE(String sequence2, int prog, String response) {
        this.traceEvent("MSGDONE");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("MSGDONE " + sequence2 + " " + prog + " " + response, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doMSGDONE(sequence2, prog, response);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtMSGFAIL(String sequence2, int prog, int errorCode, String errorMsg) {
        this.traceEvent("MSGFAIL");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("MSGFAIL " + sequence2 + " " + prog + " " + errorCode + " " + errorMsg, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doMSGFAIL(sequence2, prog, errorCode, errorMsg);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtU(int subId, int itemIdx, IntMap values2, String rawValue) {
        this.traceEvent("U");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("" + rawValue, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doU(subId, itemIdx, values2);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtSUBOK(int subId, int nItems, int nFields) {
        this.traceEvent("SUBOK");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("SUBOK " + subId + " " + nItems + " " + nFields, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doSUBOK(subId, nItems, nFields);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtSUBCMD(int subId, int nItems, int nFields, int keyIdx, int cmdIdx) {
        this.traceEvent("SUBCMD");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("SUBCMD " + subId + " " + nItems + " " + nFields + " " + keyIdx + " " + cmdIdx, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doSUBCMD(subId, nItems, nFields, keyIdx, cmdIdx);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtUNSUB(int subId) {
        this.traceEvent("UNSUB");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("UNSUB " + subId, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doUNSUB(subId);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtEOS(int subId, int itemIdx) {
        this.traceEvent("EOS");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("EOS " + subId + " " + itemIdx, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doEOS(subId, itemIdx);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtCS(int subId, int itemIdx) {
        this.traceEvent("CS");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("CS " + subId + " " + itemIdx, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doCS(subId, itemIdx);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtOV(int subId, int itemIdx, int lostUpdates) {
        this.traceEvent("OV");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("OV " + subId + " " + itemIdx + " " + lostUpdates, null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doOV(subId, itemIdx, lostUpdates);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtCONF(int subId, RealMaxFrequency freq) {
        this.traceEvent("CONF");
        if (LoggerTools_Fields_.protocolLogger.isDebugEnabled()) {
            LoggerTools_Fields_.protocolLogger.debug("CONF " + subId + " " + Std.string((Object)freq), null);
        }
        if (this.state.inPushing()) {
            if (this.isFreshData()) {
                this.doCONF(subId, freq);
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            } else {
                this.onStaleData();
                if (this.state.inStreaming()) {
                    this.evtRestartKeepalive();
                }
            }
        }
    }

    public void evtCheckAvg(SyncCheckResult result) {
        this.traceEvent("check.avg");
        Integer n = this.state.s_slw;
        if (n == null ? false : Jvm.toInt(n) == 332) {
            switch (result.ordinal()) {
                case 0: {
                    this.state.s_slw = 331;
                    this.state.traceState();
                    break;
                }
                case 1: {
                    this.state.s_slw = 333;
                    this.state.traceState();
                    break;
                }
                case 2: {
                    this.disableStreaming();
                    this.cause = "slow";
                    this.state.s_slw = 334;
                    this.state.traceState();
                    this.evtForcePolling();
                }
            }
        }
    }

    public void evtSendPendingControls() {
        this.traceEvent("send.pending.controls");
        Array controls = this.getPendingControls();
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.s) : (Integer)null;
        if ((n == null ? false : Jvm.toInt(n) == 340) && !Lambda.empty(controls)) {
            this.sendPengingControlsWS(controls);
            this.state.s_w.s = 340;
            this.state.traceState();
            this.evtRestartHeartbeat();
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n2 = tmp2 != null ? tmp2.s : (Integer)null;
        if ((n2 == null ? false : Jvm.toInt(n2) == 550) && !Lambda.empty(controls)) {
            this.sendPengingControlsWS(controls);
            this.state.s_ws.s = 550;
            this.state.traceState();
            this.evtRestartHeartbeat();
            return;
        }
        StateVar_wp tmp3 = this.state.s_wp;
        Integer n3 = tmp3 != null ? tmp3.s : (Integer)null;
        if ((n3 == null ? false : Jvm.toInt(n3) == 630) && !Lambda.empty(controls)) {
            this.sendPengingControlsWS(controls);
            this.state.s_wp.s = 630;
            this.state.traceState();
        }
    }

    public void evtSendPendingMessages() {
        this.traceEvent("send.pending.messages");
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.s) : (Integer)null;
        if ((n == null ? false : Jvm.toInt(n) == 340) && Lambda.exists(this.messageManagers, Closure_evtSendPendingMessages_0.ClientMachine$Closure_evtSendPendingMessages_0)) {
            this.sendPendingMessagesWS();
            this.state.s_w.s = 340;
            this.state.traceState();
            this.genAckMessagesWS();
            this.evtRestartHeartbeat();
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n2 = tmp2 != null ? tmp2.s : (Integer)null;
        if ((n2 == null ? false : Jvm.toInt(n2) == 550) && Lambda.exists(this.messageManagers, Closure_evtSendPendingMessages_1.ClientMachine$Closure_evtSendPendingMessages_1)) {
            this.sendPendingMessagesWS();
            this.state.s_ws.s = 550;
            this.state.traceState();
            this.genAckMessagesWS();
            this.evtRestartHeartbeat();
            return;
        }
        StateVar_wp tmp3 = this.state.s_wp;
        Integer n3 = tmp3 != null ? tmp3.s : (Integer)null;
        if ((n3 == null ? false : Jvm.toInt(n3) == 630) && Lambda.exists(this.messageManagers, Closure_evtSendPendingMessages_2.ClientMachine$Closure_evtSendPendingMessages_2)) {
            this.sendPendingMessagesWS();
            this.state.s_wp.s = 630;
            this.state.traceState();
            this.genAckMessagesWS();
        }
    }

    public void evtSelectRhb() {
        this.traceEvent("select.rhb");
        Integer n = this.state.s_rhb;
        if (n == null ? false : Jvm.toInt(n) == 320) {
            Long l = this.rhb_grantedInterval;
            if (l == null ? false : Jvm.toInt(l) == 0) {
                if (this.options.reverseHeartbeatInterval == 0L) {
                    this.state.s_rhb = 321;
                    this.state.traceState();
                } else {
                    this.rhb_currentInterval = this.options.reverseHeartbeatInterval;
                    this.state.s_rhb = 322;
                    this.state.traceState();
                    this.schedule_evtRhbTimeout(Jvm.toLong(this.rhb_currentInterval));
                }
            } else if (this.options.reverseHeartbeatInterval > 0L && this.options.reverseHeartbeatInterval < Jvm.toLong(NullTools.sure(this.rhb_grantedInterval))) {
                this.rhb_currentInterval = this.options.reverseHeartbeatInterval;
                this.state.s_rhb = 323;
                this.state.traceState();
                this.schedule_evtRhbTimeout(Jvm.toLong(this.rhb_currentInterval));
            } else {
                this.rhb_currentInterval = this.rhb_grantedInterval;
                this.state.s_rhb = 323;
                this.state.traceState();
                this.schedule_evtRhbTimeout(Jvm.toLong(NullTools.sure(this.rhb_currentInterval)));
            }
        }
    }

    public void evtExtSetReverseHeartbeatInterval() {
        Integer _g;
        this.traceEvent("setReverseHeartbeatInterval");
        if (this.state.s_rhb != null && (_g = this.state.s_rhb) != null) {
            switch (Jvm.toInt(_g)) {
                default: {
                    break;
                }
                case 321: {
                    if (this.options.reverseHeartbeatInterval == 0L) break;
                    this.rhb_currentInterval = this.options.reverseHeartbeatInterval;
                    this.state.s_rhb = 322;
                    this.state.traceState();
                    this.schedule_evtRhbTimeout(Jvm.toLong(this.rhb_currentInterval));
                    break;
                }
                case 322: {
                    if (this.options.reverseHeartbeatInterval == 0L) {
                        this.state.s_rhb = 321;
                        this.state.traceState();
                        this.cancel_evtRhbTimeout();
                        break;
                    }
                    this.rhb_currentInterval = this.options.reverseHeartbeatInterval;
                    this.state.s_rhb = 322;
                    this.state.traceState();
                    break;
                }
                case 323: {
                    if (this.options.reverseHeartbeatInterval > 0L && this.options.reverseHeartbeatInterval < Jvm.toLong(NullTools.sure(this.rhb_grantedInterval))) {
                        this.rhb_currentInterval = this.options.reverseHeartbeatInterval;
                        this.state.s_rhb = 323;
                        this.state.traceState();
                        break;
                    }
                    this.rhb_currentInterval = this.rhb_grantedInterval;
                    this.state.s_rhb = 323;
                    this.state.traceState();
                }
            }
        }
    }

    public void evtRestartHeartbeat() {
        Integer _g;
        this.traceEvent("restart.heartbeat");
        if (this.state.s_rhb != null && (_g = this.state.s_rhb) != null) {
            switch (Jvm.toInt(_g)) {
                default: {
                    break;
                }
                case 322: {
                    this.state.s_rhb = 322;
                    this.state.traceState();
                    this.cancel_evtRhbTimeout();
                    this.schedule_evtRhbTimeout(Jvm.toLong(NullTools.sure(this.rhb_currentInterval)));
                    break;
                }
                case 323: {
                    this.state.s_rhb = 323;
                    this.state.traceState();
                    this.cancel_evtRhbTimeout();
                    this.schedule_evtRhbTimeout(Jvm.toLong(NullTools.sure(this.rhb_currentInterval)));
                    break;
                }
                case 324: {
                    Long l = this.rhb_grantedInterval;
                    if (l == null ? false : Jvm.toInt(l) == 0) {
                        if (this.options.reverseHeartbeatInterval != 0L) {
                            this.rhb_currentInterval = this.options.reverseHeartbeatInterval;
                            this.state.s_rhb = 322;
                            this.state.traceState();
                            this.schedule_evtRhbTimeout(Jvm.toLong(this.rhb_currentInterval));
                            break;
                        }
                        this.state.s_rhb = 321;
                        this.state.traceState();
                        break;
                    }
                    if (this.options.reverseHeartbeatInterval > 0L && this.options.reverseHeartbeatInterval < Jvm.toLong(NullTools.sure(this.rhb_grantedInterval))) {
                        this.rhb_currentInterval = this.options.reverseHeartbeatInterval;
                        this.state.s_rhb = 323;
                        this.state.traceState();
                        this.schedule_evtRhbTimeout(Jvm.toLong(this.rhb_currentInterval));
                        break;
                    }
                    this.rhb_currentInterval = this.rhb_grantedInterval;
                    this.state.s_rhb = 323;
                    this.state.traceState();
                    this.schedule_evtRhbTimeout(Jvm.toLong(NullTools.sure(this.rhb_currentInterval)));
                }
            }
        }
    }

    public void evtRhbTimeout() {
        this.traceEvent("rhb.timeout");
        Integer n = this.state.s_rhb;
        if (n == null ? false : Jvm.toInt(n) == 322) {
            this.state.s_rhb = 324;
            this.state.traceState();
            this.cancel_evtRhbTimeout();
            this.evtSendHeartbeat();
            return;
        }
        Integer n2 = this.state.s_rhb;
        if (n2 == null ? false : Jvm.toInt(n2) == 323) {
            this.state.s_rhb = 324;
            this.state.traceState();
            this.cancel_evtRhbTimeout();
            this.evtSendHeartbeat();
        }
    }

    public void evtDisposeCtrl() {
        this.traceEvent("du:dispose.ctrl");
        this.disposeCtrl();
    }

    public void evtStartRecovery() {
        this.traceEvent("start.recovery");
        Integer n = this.state.s_rec;
        if (n == null ? false : Jvm.toInt(n) == 1000) {
            this.recoverTs = Sys.time();
            this.state.s_rec = 1000;
            this.state.traceState();
        }
    }

    public void evtRecoveryTimeout() {
        this.traceEvent("recovery.timeout");
        Integer n = this.state.s_rec;
        if (n == null ? false : Jvm.toInt(n) == 1000) {
            this.sendRecovery();
            this.state.s_rec = 1001;
            this.state.traceState();
            this.cancel_evtRecoveryTimeout();
            this.schedule_evtTransportTimeout(this.options.retryDelay);
        }
    }

    public void evtCheckRecoveryTimeout(RecoveryRetryCause retryCause) {
        this.traceEvent("check.recovery.timeout");
        Integer n = this.state.s_rec;
        if (n == null ? false : Jvm.toInt(n) == 1002) {
            long retryDelayMs = this.options.retryDelay;
            long sessionRecoveryMs = this.options.sessionRecoveryTimeout;
            if (Timer.TimerStamp_Impl_.plus(this.connectTs, retryDelayMs) < Timer.TimerStamp_Impl_.plus(this.recoverTs, sessionRecoveryMs)) {
                this.cause = "recovery.error";
                double diffMs = Timer.TimerStamp_Impl_.minus(Sys.time(), this.connectTs);
                long pauseMs = retryDelayMs > Timer.TimerMillis_Impl_.toMillis(diffMs) ? Millis_Impl_.minus(retryDelayMs, Timer.TimerMillis_Impl_.toMillis(diffMs)) : Millis_Impl_.ZERO;
                this.state.s_rec = 1003;
                this.state.traceState();
                if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
                    if (pauseMs > 0L) {
                        if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
                            LoggerTools_Fields_.sessionLogger.error("Retrying recovery in " + Std.string(pauseMs) + "ms. Cause: " + Std.string((Object)retryCause), null);
                        }
                    } else if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
                        LoggerTools_Fields_.sessionLogger.error("Retrying recovery. Cause: " + Std.string((Object)retryCause), null);
                    }
                }
                this.schedule_evtRetryTimeout(pauseMs);
            } else {
                this.notifyStatus("DISCONNECTED:WILL-RETRY");
                this.cause = "recovery.timeout";
                this.state.goto_m_from_rec(113);
                this.exit_rec_to_m();
                this.entry_m113(RetryCause.recovery_timeout);
            }
        }
    }

    public void evtCreate() {
        this.traceEvent("du:create");
        if (this.state.s_du == 20) {
            this.state.s_du = 21;
            this.state.traceState();
            return;
        }
        if (this.state.s_du == 23) {
            this.state.s_du = 21;
            this.state.traceState();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void evtCheckTransport() {
        block10: {
            block7: {
                BestForBindingEnum best;
                block9: {
                    block8: {
                        block6: {
                            block5: {
                                block4: {
                                    this.traceEvent("check.transport");
                                    Integer n = this.state.s_swt;
                                    if (!(n == null ? false : Jvm.toInt(n) == 1300)) return;
                                    Integer n2 = this.state.s_tr;
                                    if (!(n2 == null ? true : Jvm.toInt(n2) != 220)) break block4;
                                    Integer n3 = this.state.s_tr;
                                    if (!(n3 == null ? true : Jvm.toInt(n3) != 230)) break block4;
                                    Integer n4 = this.state.s_tr;
                                    if (!(n4 == null ? false : Jvm.toInt(n4) == 260)) break block5;
                                }
                                this.state.s_swt = 1301;
                                this.state.traceState();
                                return;
                            }
                            best = this.getBestForBinding();
                            if (best != BestForBindingEnum.BFB_ws_streaming) break block6;
                            Integer n = this.state.s_tr;
                            if (!(n == null ? true : Jvm.toInt(n) != 210)) break block7;
                            Integer n5 = this.state.s_tr;
                            if (!(n5 == null ? true : Jvm.toInt(n5) != 240)) break block7;
                        }
                        if (best != BestForBindingEnum.BFB_http_streaming) break block8;
                        Integer n = this.state.s_tr;
                        if (!(n == null ? false : Jvm.toInt(n) == 270)) break block8;
                        Integer n6 = this.state.s_h;
                        if (!(n6 == null ? true : Jvm.toInt(n6) != 710)) break block7;
                    }
                    if (best != BestForBindingEnum.BFB_ws_polling) break block9;
                    Integer n = this.state.s_tr;
                    if (!(n == null ? true : Jvm.toInt(n) != 250)) break block7;
                }
                if (best != BestForBindingEnum.BFB_http_polling) break block10;
                Integer n = this.state.s_tr;
                if (!(n == null ? false : Jvm.toInt(n) == 270)) break block10;
                Integer n7 = this.state.s_h;
                if (!(n7 == null ? false : Jvm.toInt(n7) == 720)) break block10;
            }
            this.state.s_swt = 1301;
            this.state.traceState();
            return;
        }
        this.state.s_swt = 1302;
        this.state.traceState();
        this.evtSendControl(NullTools.sure(this.switchRequest));
    }

    public void evtCheckBW() {
        this.traceEvent("check.bw");
        Integer n = this.state.s_bw;
        if (n == null ? false : Jvm.toInt(n) == 1200) {
            if (this.bw_requestedMaxBandwidth != this.options.requestedMaxBandwidth && this.options.realMaxBandwidth != RealMaxBandwidth.BWUnmanaged) {
                this.bw_requestedMaxBandwidth = this.options.requestedMaxBandwidth;
                this.state.s_bw = 1202;
                this.state.traceState();
                this.evtSendControl(NullTools.sure(this.constrainRequest));
            } else {
                this.state.s_bw = 1201;
                this.state.traceState();
            }
        }
    }

    public void evtCheckCtrlRequests() {
        this.traceEvent("check.ctrl.requests");
        Integer n = this.state.s_ctrl;
        if (n == null ? false : Jvm.toInt(n) == 1100) {
            Array controls = this.getPendingControls();
            if (!Lambda.empty(controls)) {
                this.sendPendingControlsHTTP(controls);
                this.state.s_ctrl = 1102;
                this.state.traceState();
                this.evtRestartHeartbeat();
                this.schedule_evtCtrlTimeout(this.options.retryDelay);
            } else if (Lambda.exists(this.messageManagers, Closure_evtCheckCtrlRequests_0.ClientMachine$Closure_evtCheckCtrlRequests_0)) {
                this.sendPendingMessagesHTTP();
                this.state.s_ctrl = 1102;
                this.state.traceState();
                this.evtRestartHeartbeat();
                this.schedule_evtCtrlTimeout(this.options.retryDelay);
            } else {
                Integer n2 = this.state.s_rhb;
                if (n2 == null ? false : Jvm.toInt(n2) == 324) {
                    this.sendHeartbeatHTTP();
                    this.state.s_ctrl = 1102;
                    this.state.traceState();
                    this.evtRestartHeartbeat();
                    this.schedule_evtCtrlTimeout(this.options.retryDelay);
                } else {
                    this.state.s_ctrl = 1101;
                    this.state.traceState();
                }
            }
        }
    }

    public void evtCtrlDone() {
        this.traceEvent("ctrl.done");
        Integer n = this.state.s_ctrl;
        if (n == null ? false : Jvm.toInt(n) == 1102) {
            this.closeCtrl();
            this.state.s_ctrl = 1100;
            this.state.traceState();
            this.cancel_evtCtrlTimeout();
            this.evtCheckCtrlRequests();
        }
    }

    public void evtCtrlError() {
        this.traceEvent("ctrl.error");
        Integer n = this.state.s_ctrl;
        if (n == null ? false : Jvm.toInt(n) == 1102) {
            this.disposeCtrl();
            long pauseMs = this.waitingInterval(this.options.retryDelay, this.ctrl_connectTs);
            this.state.s_ctrl = 1103;
            this.state.traceState();
            this.cancel_evtCtrlTimeout();
            this.schedule_evtCtrlTimeout(pauseMs);
        }
    }

    public void evtCtrlTimeout() {
        this.traceEvent("ctrl.timeout");
        if (this.state.s_ctrl != null) {
            Integer n = this.state.s_ctrl;
            if (n == null ? false : Jvm.toInt(n) == 1102) {
                this.disposeCtrl();
                long pauseMs = this.waitingInterval(this.options.retryDelay, this.ctrl_connectTs);
                this.state.s_ctrl = 1103;
                this.state.traceState();
                this.cancel_evtCtrlTimeout();
                this.schedule_evtCtrlTimeout(pauseMs);
            } else {
                Integer n2 = this.state.s_ctrl;
                if (n2 == null ? false : Jvm.toInt(n2) == 1103) {
                    this.state.s_ctrl = 1100;
                    this.state.traceState();
                    this.cancel_evtCtrlTimeout();
                    this.evtCheckCtrlRequests();
                }
            }
        }
    }

    public void evtSendControl(Encodable request) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_evtSendControl_0(_gthis, request));
    }

    public void evtSendHeartbeat() {
        this.traceEvent("send.heartbeat");
        StateVar_w tmp = this.state.s_w;
        Integer n = tmp != null ? Integer.valueOf(tmp.s) : (Integer)null;
        if (n == null ? false : Jvm.toInt(n) == 340) {
            this.sendHeartbeatWS();
            this.state.s_w.s = 340;
            this.state.traceState();
            this.evtRestartHeartbeat();
            return;
        }
        StateVar_ws tmp2 = this.state.s_ws;
        Integer n2 = tmp2 != null ? tmp2.s : (Integer)null;
        if (n2 == null ? false : Jvm.toInt(n2) == 550) {
            this.sendHeartbeatWS();
            this.state.s_ws.s = 550;
            this.state.traceState();
            this.evtRestartHeartbeat();
            return;
        }
        Integer n3 = this.state.s_ctrl;
        if (n3 == null ? false : Jvm.toInt(n3) == 1101) {
            this.state.s_ctrl = 1100;
            this.state.traceState();
            this.evtCheckCtrlRequests();
        }
    }

    public void evtStartSession() {
        this.traceEvent("du:start.session");
        if (LoggerTools_Fields_.sessionLogger.isInfoEnabled()) {
            LoggerTools_Fields_.sessionLogger.info("Starting new session: " + this.sessionId, null);
        }
        switch (this.state.s_du) {
            default: {
                return;
            }
            case 21: 
        }
        this.state.s_du = 22;
        this.state.traceState();
    }

    public void evtEndSession() {
        if (LoggerTools_Fields_.sessionLogger.isInfoEnabled()) {
            LoggerTools_Fields_.sessionLogger.info("Destroying session: " + this.sessionId, null);
        }
    }

    public void evtRetry(RetryCause retryCause, Long timeout2) {
        this.traceEvent("du:retry");
        if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
            if (timeout2 != null && Jvm.toLong(timeout2) > 0L) {
                if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
                    LoggerTools_Fields_.sessionLogger.error("Retrying connection in " + Std.string(timeout2) + "ms. Cause: " + ClientMachine_Fields_.asErrorMsg(retryCause), null);
                }
            } else if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
                LoggerTools_Fields_.sessionLogger.error("Retrying connection. Cause: " + ClientMachine_Fields_.asErrorMsg(retryCause), null);
            }
        }
        boolean forward = true;
        switch (this.state.s_du) {
            default: {
                break;
            }
            case 21: {
                this.resetSequenceMap();
                this.state.s_du = 23;
                this.state.traceState();
                forward = this.evtRetry_NextRegion();
                this.genAbortMessages();
                break;
            }
            case 22: {
                this.disposeSession();
                this.state.s_du = 23;
                this.state.traceState();
                forward = this.evtRetry_NextRegion();
                this.genAbortSubscriptions();
                this.genAbortMessages();
            }
        }
        if (forward) {
            this.evtRetry_NextRegion();
        }
    }

    public boolean evtRetry_NextRegion() {
        return false;
    }

    public void evtTerminate(TerminationCause terminationCause) {
        this.traceEvent("du:terminate");
        if (LoggerTools_Fields_.sessionLogger.isInfoEnabled()) {
            switch (terminationCause.ordinal()) {
                default: {
                    break;
                }
                case 2: {
                    if (!LoggerTools_Fields_.sessionLogger.isInfoEnabled()) break;
                    LoggerTools_Fields_.sessionLogger.info("Disconnected. Cause: Requested by user", null);
                }
            }
        }
        if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
            switch (terminationCause.ordinal()) {
                case 0: {
                    if (!LoggerTools_Fields_.sessionLogger.isErrorEnabled()) break;
                    LoggerTools_Fields_.sessionLogger.error("Disconnected. Cause: " + ((TerminationCause.TC_standardError)terminationCause).code + " - " + ((TerminationCause.TC_standardError)terminationCause).msg, null);
                    break;
                }
                case 1: {
                    if (!LoggerTools_Fields_.sessionLogger.isErrorEnabled()) break;
                    LoggerTools_Fields_.sessionLogger.error("Disconnected. Cause: " + ((TerminationCause.TC_otherError)terminationCause).error, null);
                    break;
                }
            }
        }
        boolean forward = true;
        switch (this.state.s_du) {
            default: {
                break;
            }
            case 20: {
                this.disposeClient();
                this.doUnistallPageLifecycle();
                this.state.s_du = 20;
                this.state.traceState();
                forward = this.evtTerminate_NextRegion();
                this.genAbortMessages();
                break;
            }
            case 21: {
                this.disposeClient();
                this.doUnistallPageLifecycle();
                this.state.s_du = 20;
                this.state.traceState();
                forward = this.evtTerminate_NextRegion();
                this.genAbortMessages();
                break;
            }
            case 22: {
                this.disposeSession();
                this.disposeClient();
                this.doUnistallPageLifecycle();
                this.state.s_du = 20;
                this.state.traceState();
                forward = this.evtTerminate_NextRegion();
                this.genAbortSubscriptions();
                this.genAbortMessages();
                break;
            }
            case 23: {
                this.disposeClient();
                this.doUnistallPageLifecycle();
                this.state.s_du = 20;
                this.state.traceState();
                forward = this.evtTerminate_NextRegion();
                this.genAbortMessages();
            }
        }
        if (forward) {
            this.evtTerminate_NextRegion();
        }
    }

    public boolean evtTerminate_NextRegion() {
        return this.evtTerminate_NetworkReachabilityRegion();
    }

    public boolean evtTerminate_NetworkReachabilityRegion() {
        switch (this.state.s_nr) {
            default: {
                break;
            }
            case 1410: 
            case 1411: 
            case 1412: {
                IReachability rm = this.nr_reachabilityManager;
                this.nr_reachabilityManager = null;
                this.state.s_nr = 1400;
                this.state.traceState();
                if (rm == null) break;
                rm.stopListening();
            }
        }
        return false;
    }

    public void evtRetryTimeout() {
        this.traceEvent("retry.timeout");
        switch (this.state.s_m) {
            default: {
                return;
            }
            case 110: {
                this.notifyStatus("CONNECTING");
                this.sendCreateTTL();
                this.state.s_m = 140;
                this.state.traceState();
                this.evtCreate();
                this.schedule_evtTransportTimeout(60000L);
                return;
            }
            case 111: {
                this.notifyStatus("CONNECTING");
                this.delayCounter.increase();
                this.sendCreateTTL();
                this.state.s_m = 140;
                this.state.traceState();
                this.cancel_evtRetryTimeout();
                this.evtCreate();
                this.schedule_evtTransportTimeout(60000L);
                return;
            }
            case 112: {
                this.delayCounter.increase();
                this.state.s_m = 116;
                this.state.traceState();
                this.cancel_evtRetryTimeout();
                this.evtSelectCreate();
                return;
            }
            case 113: {
                this.state.s_m = 116;
                this.state.traceState();
                this.cancel_evtRetryTimeout();
                this.evtSelectCreate();
                return;
            }
            case 115: {
                this.state.s_m = 116;
                this.state.traceState();
                this.evtSelectCreate();
                return;
            }
            case 150: 
        }
        Integer n = this.state.s_rec;
        if (n == null ? false : Jvm.toInt(n) == 1003) {
            this.sendRecovery();
            this.state.s_rec = 1001;
            this.state.traceState();
            this.cancel_evtRetryTimeout();
            this.schedule_evtTransportTimeout(this.options.retryDelay);
        }
    }

    public void evtExtSetForcedTransport() {
        this.traceEvent("setForcedTransport");
        Integer n = this.state.s_swt;
        if (n == null ? false : Jvm.toInt(n) == 1301) {
            this.state.s_swt = 1300;
            this.state.traceState();
            this.evtCheckTransport();
        }
    }

    public void evtExtSetRequestedMaxBandwidth() {
        this.traceEvent("setRequestedMaxBandwidth");
        Integer n = this.state.s_bw;
        if (n == null ? false : Jvm.toInt(n) == 1201) {
            this.state.s_bw = 1200;
            this.state.traceState();
            this.evtCheckBW();
        }
    }

    public void evtForceSlowing() {
        this.traceEvent("force.slowing");
        Integer n = this.state.s_swt;
        if (n == null ? false : Jvm.toInt(n) == 1301) {
            this.state.s_swt = 1300;
            this.state.traceState();
            this.evtCheckTransport();
        }
    }

    public void evtForcePolling() {
        this.traceEvent("force.polling");
        Integer n = this.state.s_swt;
        if (n == null ? false : Jvm.toInt(n) == 1301) {
            this.state.s_swt = 1300;
            this.state.traceState();
            this.evtCheckTransport();
        }
    }

    public void evtSendMessage(MessageManager msg) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_evtSendMessage_0(_gthis, msg));
    }

    public void evtSwitchTransport() {
        boolean forward;
        block5: {
            block4: {
                this.traceEvent("switch.transport");
                forward = true;
                Integer n = this.state.s_swt;
                if (!(n == null ? true : Jvm.toInt(n) != 1302)) break block4;
                Integer n2 = this.state.s_swt;
                if (!(n2 == null ? false : Jvm.toInt(n2) == 1303)) break block5;
            }
            this.state.s_swt = 1300;
            this.state.traceState();
            forward = this.evtSwitchTransport_forwardToTransportRegion();
            this.evtCheckTransport();
        }
        if (forward) {
            this.evtSwitchTransport_forwardToTransportRegion();
        }
    }

    public boolean evtSwitchTransport_forwardToTransportRegion() {
        TerminationCause terminationCause = TerminationCause.TC_otherError("Selected transport " + this.options.forcedTransport + " is not available");
        Integer n = this.state.s_tr;
        if (n == null ? false : Jvm.toInt(n) == 200) {
            switch (this.getBestForBinding().ordinal()) {
                case 0: {
                    this.notifyStatus("DISCONNECTED");
                    this.state.goto_m_from_session(100);
                    this.evtEndSession();
                    this.evtTerminate(terminationCause);
                    break;
                }
                case 1: {
                    this.openWS_Bind();
                    this.state.s_tr = 240;
                    this.state.s_ws = new StateVar_ws(500);
                    this.state.traceState();
                    this.schedule_evtTransportTimeout(this.options.retryDelay);
                    break;
                }
                case 2: {
                    this.openWS_Bind();
                    this.state.s_tr = 250;
                    this.state.s_wp = new StateVar_wp(600);
                    this.state.traceState();
                    this.schedule_evtTransportTimeout(this.options.retryDelay);
                    break;
                }
                case 3: {
                    this.sendBindHTTP_Streaming();
                    this.state.s_tr = 270;
                    this.state.s_h = 710;
                    this.state.s_hs = new StateVar_hs(800);
                    this.state.s_ctrl = 1100;
                    this.state.traceState();
                    this.evtCheckCtrlRequests();
                    this.schedule_evtTransportTimeout(this.options.retryDelay);
                    break;
                }
                case 4: {
                    this.sendBindHTTP_Polling();
                    this.state.s_tr = 270;
                    this.state.s_h = 720;
                    this.state.s_hp = new StateVar_hp(900);
                    this.state.s_rhb = 320;
                    this.state.s_ctrl = 1100;
                    this.state.traceState();
                    this.evtCheckCtrlRequests();
                    this.schedule_evtIdleTimeout(Millis_Impl_.plus(Jvm.toLong(NullTools.sure(this.idleTimeout)), this.options.retryDelay));
                    this.evtSelectRhb();
                }
            }
        } else {
            StateVar_hs tmp = this.state.s_hs;
            Integer n2 = tmp != null ? tmp.p : (Integer)null;
            if (n2 == null ? false : Jvm.toInt(n2) == 811) {
                switch (this.getBestForBinding().ordinal()) {
                    case 0: {
                        this.notifyStatus("DISCONNECTED");
                        this.state.goto_m_from_hs(100);
                        this.exit_hs_to_m();
                        this.evtTerminate(terminationCause);
                        break;
                    }
                    case 1: {
                        this.openWS_Bind();
                        this.state.clear_hs();
                        this.state.s_h = null;
                        this.state.s_ctrl = null;
                        this.state.s_tr = 240;
                        this.state.s_ws = new StateVar_ws(500);
                        this.state.traceState();
                        this.exit_hs();
                        this.exit_ctrl();
                        this.schedule_evtTransportTimeout(this.options.retryDelay);
                        break;
                    }
                    case 2: {
                        this.openWS_Bind();
                        this.state.clear_hs();
                        this.state.s_h = null;
                        this.state.s_ctrl = null;
                        this.state.s_tr = 250;
                        this.state.s_wp = new StateVar_wp(600);
                        this.state.traceState();
                        this.exit_hs();
                        this.exit_ctrl();
                        this.schedule_evtTransportTimeout(this.options.retryDelay);
                        break;
                    }
                    case 3: {
                        this.sendBindHTTP_Streaming();
                        this.state.s_hs = new StateVar_hs(800);
                        this.state.traceState();
                        this.exit_hs();
                        this.schedule_evtTransportTimeout(this.options.retryDelay);
                        break;
                    }
                    case 4: {
                        this.sendBindHTTP_Polling();
                        this.state.clear_hs();
                        this.state.s_h = 720;
                        this.state.s_hp = new StateVar_hp(900);
                        this.state.s_rhb = 320;
                        this.state.traceState();
                        this.exit_hs();
                        this.schedule_evtIdleTimeout(Millis_Impl_.plus(Jvm.toLong(NullTools.sure(this.idleTimeout)), this.options.retryDelay));
                        this.evtSelectRhb();
                    }
                }
            } else {
                StateVar_hp tmp2 = this.state.s_hp;
                Integer n3 = tmp2 != null ? Integer.valueOf(tmp2.m) : (Integer)null;
                if (n3 == null ? false : Jvm.toInt(n3) == 904) {
                    switch (this.getBestForBinding().ordinal()) {
                        case 0: {
                            this.notifyStatus("DISCONNECTED");
                            this.state.goto_m_from_hp(100);
                            this.exit_hp_to_m();
                            this.evtTerminate(terminationCause);
                            break;
                        }
                        case 1: {
                            this.openWS_Bind();
                            this.state.clear_hp();
                            this.state.s_h = null;
                            this.state.s_ctrl = null;
                            this.state.s_tr = 240;
                            this.state.s_ws = new StateVar_ws(500);
                            this.state.traceState();
                            this.exit_hp();
                            this.exit_ctrl();
                            this.schedule_evtTransportTimeout(this.options.retryDelay);
                            break;
                        }
                        case 2: {
                            this.openWS_Bind();
                            this.state.clear_hp();
                            this.state.s_h = null;
                            this.state.s_ctrl = null;
                            this.state.s_tr = 250;
                            this.state.s_wp = new StateVar_wp(600);
                            this.state.traceState();
                            this.exit_hp();
                            this.exit_ctrl();
                            this.schedule_evtTransportTimeout(this.options.retryDelay);
                            break;
                        }
                        case 3: {
                            this.sendBindHTTP_Streaming();
                            this.state.clear_hp();
                            this.state.s_h = 710;
                            this.state.s_hs = new StateVar_hs(800);
                            this.state.traceState();
                            this.exit_hp();
                            this.schedule_evtTransportTimeout(this.options.retryDelay);
                            break;
                        }
                        case 4: {
                            this.sendBindHTTP_Polling();
                            this.state.s_hp = new StateVar_hp(900);
                            this.state.s_rhb = 320;
                            this.state.traceState();
                            this.exit_hp();
                            this.schedule_evtIdleTimeout(Millis_Impl_.plus(Jvm.toLong(NullTools.sure(this.idleTimeout)), this.options.retryDelay));
                            this.evtSelectRhb();
                        }
                    }
                }
            }
        }
        return false;
    }

    public void onFreshData() throws IllegalStateException {
        if (this.rec_serverProg != this.rec_clientProg) {
            throw new IllegalStateException("Assertion failure: " + "rec_serverProg == rec_clientProg");
        }
        ++this.rec_serverProg;
        ++this.rec_clientProg;
    }

    public void onStaleData() throws IllegalStateException {
        if (this.rec_serverProg >= this.rec_clientProg) {
            throw new IllegalStateException("Assertion failure: " + "rec_serverProg < rec_clientProg");
        }
        ++this.rec_serverProg;
    }

    public boolean isFreshData() {
        return this.rec_serverProg == this.rec_clientProg;
    }

    public IWsClient openWS(String url, StringMap headers) {
        ClientMachine _gthis = this;
        haxe.jvm.Function onOpen = new Closure_openWS_onOpen_0(_gthis);
        haxe.jvm.Function onText = new Closure_openWS_onText_0(_gthis);
        haxe.jvm.Function onError = new Closure_openWS_onError_0(_gthis);
        return (IWsClient)this.wsFactory.invoke(url, headers, onOpen, onText, onError);
    }

    public void openWS_Create() {
        this.connectTs = Sys.time();
        this.serverInstanceAddress = this.getServerAddress();
        String url = Url.build(this.serverInstanceAddress, "lightstreamer");
        this.ws = this.openWS(url, this.options.httpExtraHeaders);
    }

    public void openWS_Bind() {
        this.connectTs = Sys.time();
        String url = Url.build(NullTools.sure(this.serverInstanceAddress), "lightstreamer");
        StringMap headers = this.getHeadersForRequestOtherThanCreate();
        this.ws = this.openWS(url, headers);
    }

    public void sendCreateWS() {
        RequestedMaxBandwidth _g;
        RequestBuilder req = new RequestBuilder();
        if (this.options.keepaliveInterval > 0L) {
            req.LS_keepalive_millis(this.options.keepaliveInterval);
        }
        this.rhb_grantedInterval = this.options.reverseHeartbeatInterval;
        if (Jvm.toLong(this.rhb_grantedInterval) > 0L) {
            req.LS_inactivity_millis(Jvm.toLong(this.rhb_grantedInterval));
        }
        if ((_g = (this.bw_requestedMaxBandwidth = this.options.requestedMaxBandwidth)) != null) {
            switch (_g.ordinal()) {
                default: {
                    break;
                }
                case 0: {
                    req.LS_requested_max_bandwidth_Float(((RequestedMaxBandwidth.BWLimited)_g).bw);
                }
            }
        }
        if (this.details.adapterSet != null) {
            req.LS_adapter_set(this.details.adapterSet);
        }
        if (this.details.user != null) {
            req.LS_user(this.details.user);
        }
        req.LS_cid(Constants_Fields_.LS_CID);
        if (this.sessionId != null) {
            req.LS_old_session(this.sessionId);
        }
        if (!this.options.slowingEnabled) {
            req.LS_send_sync(false);
        }
        if (this.cause != null) {
            req.LS_cause(this.cause);
            this.cause = null;
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session create: " + Std.string(req), null);
        }
        if (this.details.password != null) {
            req.LS_password(this.details.password);
        }
        NullTools.sure(this.ws).send("wsok");
        NullTools.sure(this.ws).send("create_session\r\n" + req.getEncodedString());
    }

    public void sendBindWS_Streaming() {
        RequestBuilder req = new RequestBuilder();
        req.LS_session(NullTools.sure(this.sessionId));
        if (this.options.keepaliveInterval > 0L) {
            req.LS_keepalive_millis(this.options.keepaliveInterval);
        }
        this.rhb_grantedInterval = this.options.reverseHeartbeatInterval;
        if (Jvm.toLong(this.rhb_grantedInterval) > 0L) {
            req.LS_inactivity_millis(Jvm.toLong(this.rhb_grantedInterval));
        }
        if (!this.options.slowingEnabled) {
            req.LS_send_sync(false);
        }
        if (this.cause != null) {
            req.LS_cause(this.cause);
            this.cause = null;
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session bind: " + Std.string(req), null);
        }
        NullTools.sure(this.ws).send("wsok");
        NullTools.sure(this.ws).send("bind_session\r\n" + req.getEncodedString());
    }

    public void sendBindWS_FirstPolling() {
        RequestBuilder req = new RequestBuilder();
        req.LS_session(NullTools.sure(this.sessionId));
        req.LS_polling(true);
        req.LS_polling_millis(this.options.pollingInterval);
        this.idleTimeout = this.options.idleTimeout;
        req.LS_idle_millis(Jvm.toLong(this.idleTimeout));
        if (this.cause != null) {
            req.LS_cause(this.cause);
            this.cause = null;
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session bind: " + Std.string(req), null);
        }
        NullTools.sure(this.ws).send("bind_session\r\n" + req.getEncodedString());
    }

    public void sendBindWS_Polling() {
        RequestBuilder req = new RequestBuilder();
        req.LS_polling(true);
        req.LS_polling_millis(this.options.pollingInterval);
        this.idleTimeout = this.options.idleTimeout;
        req.LS_idle_millis(Jvm.toLong(this.idleTimeout));
        if (this.cause != null) {
            req.LS_cause(this.cause);
            this.cause = null;
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session bind: " + Std.string(req), null);
        }
        NullTools.sure(this.ws).send("bind_session\r\n" + req.getEncodedString());
    }

    public void sendDestroyWS(String cause) {
        if (cause == null) {
            cause = "api";
        }
        RequestBuilder req = new RequestBuilder();
        req.LS_reqId(this.generateFreshReqId());
        req.LS_op("destroy");
        req.LS_close_socket(true);
        req.LS_cause(cause);
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session destroy: " + Std.string(req), null);
        }
        NullTools.sure(this.ws).send("control\r\n" + req.getEncodedString());
    }

    public IHttpClient sendHttpRequest(String url, RequestBuilder req, StringMap headers) {
        ClientMachine _gthis = this;
        haxe.jvm.Function onText = new Closure_sendHttpRequest_onText_0(_gthis);
        haxe.jvm.Function onError = new Closure_sendHttpRequest_onError_0(_gthis);
        haxe.jvm.Function onDone = Closure_sendHttpRequest_onDone_0.ClientMachine$Closure_sendHttpRequest_onDone_0;
        return (IHttpClient)this.httpFactory.invoke(url, req.getEncodedString(), headers, onText, onError, onDone);
    }

    public void sendCreateHTTP() {
        RequestBuilder req = new RequestBuilder();
        req.LS_polling(true);
        req.LS_polling_millis(0L);
        req.LS_idle_millis(0L);
        RequestedMaxBandwidth _g = this.bw_requestedMaxBandwidth = this.options.requestedMaxBandwidth;
        if (_g != null) {
            switch (_g.ordinal()) {
                default: {
                    break;
                }
                case 0: {
                    req.LS_requested_max_bandwidth_Float(((RequestedMaxBandwidth.BWLimited)_g).bw);
                }
            }
        }
        if (this.details.adapterSet != null) {
            req.LS_adapter_set(this.details.adapterSet);
        }
        if (this.details.user != null) {
            req.LS_user(this.details.user);
        }
        req.LS_cid(Constants_Fields_.LS_CID);
        if (this.sessionId != null) {
            req.LS_old_session(this.sessionId);
        }
        if (this.cause != null) {
            req.LS_cause(this.cause);
            this.cause = null;
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session create: " + Std.string(req), null);
        }
        if (this.details.password != null) {
            req.LS_password(this.details.password);
        }
        this.connectTs = Sys.time();
        this.serverInstanceAddress = this.getServerAddress();
        String url = Url.build(this.serverInstanceAddress, "/lightstreamer" + Constants_Fields_.LS_CREATE_REALM + "/create_session.txt?LS_protocol=" + Constants_Fields_.TLCP_VERSION);
        this.http = this.sendHttpRequest(url, req, this.options.httpExtraHeaders);
    }

    public void sendBindHTTP_Streaming() {
        RequestBuilder req = new RequestBuilder();
        req.LS_session(NullTools.sure(this.sessionId));
        req.LS_content_length(this.options.contentLength);
        if (this.options.keepaliveInterval > 0L) {
            req.LS_keepalive_millis(this.options.keepaliveInterval);
        }
        this.rhb_grantedInterval = this.options.reverseHeartbeatInterval;
        if (Jvm.toLong(this.rhb_grantedInterval) > 0L) {
            req.LS_inactivity_millis(Jvm.toLong(this.rhb_grantedInterval));
        }
        if (!this.options.slowingEnabled) {
            req.LS_send_sync(false);
        }
        if (this.cause != null) {
            req.LS_cause(this.cause);
            this.cause = null;
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session bind: " + Std.string(req), null);
        }
        this.connectTs = Sys.time();
        String url = Url.build(NullTools.sure(this.serverInstanceAddress), "/lightstreamer/bind_session.txt?LS_protocol=" + Constants_Fields_.TLCP_VERSION);
        StringMap headers = this.getHeadersForRequestOtherThanCreate();
        this.http = this.sendHttpRequest(url, req, headers);
    }

    public void sendBindHTTP_Polling() {
        RequestBuilder req = new RequestBuilder();
        req.LS_session(NullTools.sure(this.sessionId));
        req.LS_polling(true);
        req.LS_polling_millis(this.options.pollingInterval);
        this.idleTimeout = this.options.idleTimeout;
        req.LS_idle_millis(Jvm.toLong(this.idleTimeout));
        if (this.cause != null) {
            req.LS_cause(this.cause);
            this.cause = null;
        }
        this.rhb_grantedInterval = 0L;
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session bind: " + Std.string(req), null);
        }
        this.connectTs = Sys.time();
        String url = Url.build(NullTools.sure(this.serverInstanceAddress), "/lightstreamer/bind_session.txt?LS_protocol=" + Constants_Fields_.TLCP_VERSION);
        StringMap headers = this.getHeadersForRequestOtherThanCreate();
        this.http = this.sendHttpRequest(url, req, headers);
    }

    public void sendCreateTTL() {
        RequestBuilder req = new RequestBuilder();
        req.LS_ttl_millis("unlimited");
        req.LS_polling(true);
        req.LS_polling_millis(0L);
        req.LS_idle_millis(0L);
        RequestedMaxBandwidth _g = this.bw_requestedMaxBandwidth = this.options.requestedMaxBandwidth;
        if (_g != null) {
            switch (_g.ordinal()) {
                default: {
                    break;
                }
                case 0: {
                    req.LS_requested_max_bandwidth_Float(((RequestedMaxBandwidth.BWLimited)_g).bw);
                }
            }
        }
        if (this.details.adapterSet != null) {
            req.LS_adapter_set(this.details.adapterSet);
        }
        if (this.details.user != null) {
            req.LS_user(this.details.user);
        }
        req.LS_cid(Constants_Fields_.LS_CID);
        if (this.sessionId != null) {
            req.LS_old_session(this.sessionId);
        }
        if (this.cause != null) {
            req.LS_cause(this.cause);
            this.cause = null;
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session create: " + Std.string(req), null);
        }
        if (this.details.password != null) {
            req.LS_password(this.details.password);
        }
        this.connectTs = Sys.time();
        this.serverInstanceAddress = this.getServerAddress();
        String url = Url.build(this.serverInstanceAddress, "/lightstreamer" + Constants_Fields_.LS_CREATE_REALM + "/create_session.txt?LS_protocol=" + Constants_Fields_.TLCP_VERSION);
        this.http = this.sendHttpRequest(url, req, this.options.httpExtraHeaders);
    }

    public void sendRecovery() {
        RequestBuilder req = new RequestBuilder();
        req.LS_session(NullTools.sure(this.sessionId));
        req.LS_recovery_from(this.rec_clientProg);
        req.LS_polling(true);
        req.LS_polling_millis(0L);
        req.LS_idle_millis(0L);
        if (this.cause != null) {
            req.LS_cause(this.cause);
            this.cause = null;
        }
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Sending session recovery: " + Std.string(req), null);
        }
        this.connectTs = Sys.time();
        String url = Url.build(NullTools.sure(this.serverInstanceAddress), "/lightstreamer/bind_session.txt?LS_protocol=" + Constants_Fields_.TLCP_VERSION);
        StringMap headers = this.getHeadersForRequestOtherThanCreate();
        this.http = this.sendHttpRequest(url, req, headers);
    }

    public void disposeWS() {
        if (this.ws != null) {
            this.ws.dispose();
            this.ws = null;
        }
    }

    public void closeWS() {
        if (this.ws != null) {
            this.ws.dispose();
            this.ws = null;
        }
    }

    public void suspendWS_Streaming() {
        if (LoggerTools_Fields_.sessionLogger.isWarnEnabled()) {
            LoggerTools_Fields_.sessionLogger.warn("Websocket suspended", null);
        }
        this.suspendedTransports.insert("WS-STREAMING");
    }

    public void disableWS() {
        if (LoggerTools_Fields_.sessionLogger.isWarnEnabled()) {
            LoggerTools_Fields_.sessionLogger.warn("Websocket disabled", null);
        }
        this.disabledTransports = this.disabledTransports.union(Array.ofNative(new String[]{"WS-STREAMING", "WS-POLLING"}));
    }

    public void disableHTTP_Streaming() {
        if (LoggerTools_Fields_.sessionLogger.isWarnEnabled()) {
            LoggerTools_Fields_.sessionLogger.warn("HTTP streaming disabled", null);
        }
        this.disabledTransports = this.disabledTransports.union(Array.ofNative(new String[]{"HTTP-STREAMING"}));
    }

    public void disableStreaming() {
        if (LoggerTools_Fields_.sessionLogger.isWarnEnabled()) {
            LoggerTools_Fields_.sessionLogger.warn("Streaming disabled", null);
        }
        this.disabledTransports = this.disabledTransports.union(Array.ofNative(new String[]{"WS-STREAMING", "HTTP-STREAMING"}));
    }

    public void enableAllTransports() {
        if (LoggerTools_Fields_.sessionLogger.isInfoEnabled() && (this.disabledTransports.count() > 0 || this.suspendedTransports.count() > 0) && LoggerTools_Fields_.sessionLogger.isInfoEnabled()) {
            LoggerTools_Fields_.sessionLogger.info("Transports enabled again.", null);
        }
        this.disabledTransports = new Set(null);
        this.suspendedTransports = new Set(null);
    }

    public void disposeHTTP() {
        if (this.http != null) {
            this.http.dispose();
            this.http = null;
        }
    }

    public void closeHTTP() {
        if (this.http != null) {
            this.http.dispose();
            this.http = null;
        }
    }

    public void disposeCtrl() {
        if (this.ctrl_http != null) {
            this.ctrl_http.dispose();
            this.ctrl_http = null;
        }
    }

    public void closeCtrl() {
        if (this.ctrl_http != null) {
            this.ctrl_http.dispose();
            this.ctrl_http = null;
        }
    }

    public void notifyStatus(String newStatus) {
        String oldStatus = this.m_status;
        this.m_status = newStatus;
        if (Jvm.stringCompare(oldStatus, newStatus) != 0) {
            if (LoggerTools_Fields_.sessionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.sessionLogger.info("Status: " + newStatus, null);
            }
            this.clientEventDispatcher.onStatusChange(newStatus);
        }
    }

    public BestForCreatingEnum getBestForCreating() {
        block15: {
            BestForBindingEnum bfb = this.getBestForBinding();
            switch (bfb.ordinal()) {
                default: {
                    break;
                }
                case 0: {
                    return BestForCreatingEnum.BFC_none;
                }
            }
            String ft = this.options.forcedTransport;
            Set<String> blackList = this.suspendedTransports.union(this.disabledTransports.toArray());
            if (ft == null) {
                if (!blackList.contains("WS-STREAMING")) {
                    return BestForCreatingEnum.BFC_ws;
                }
                return BestForCreatingEnum.BFC_http;
            }
            String _hx_tmp = ft;
            if (_hx_tmp == null) break block15;
            int n = -1;
            switch (_hx_tmp.hashCode()) {
                case 1739993745: {
                    if (_hx_tmp.equals("WS-STREAMING")) {
                        n = 1;
                    }
                    break;
                }
                case 2780: {
                    if (_hx_tmp.equals("WS")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    if (!blackList.contains("WS-STREAMING")) {
                        return BestForCreatingEnum.BFC_ws;
                    }
                    return BestForCreatingEnum.BFC_http;
                }
            }
        }
        return BestForCreatingEnum.BFC_http;
    }

    public BestForBindingEnum getBestForBinding() {
        String ft = this.options.forcedTransport;
        Set<String> blackList = this.disabledTransports;
        if (ft == null) {
            if (!blackList.contains("WS-STREAMING")) {
                return BestForBindingEnum.BFB_ws_streaming;
            }
            if (!blackList.contains("HTTP-STREAMING")) {
                return BestForBindingEnum.BFB_http_streaming;
            }
            if (!blackList.contains("WS-POLLING")) {
                return BestForBindingEnum.BFB_ws_polling;
            }
            return BestForBindingEnum.BFB_http_polling;
        }
        String _hx_tmp = ft;
        if (_hx_tmp != null) {
            switch (_hx_tmp.hashCode()) {
                case 1739993745: {
                    if (!_hx_tmp.equals("WS-STREAMING")) break;
                    if (!blackList.contains("WS-STREAMING")) {
                        return BestForBindingEnum.BFB_ws_streaming;
                    }
                    return BestForBindingEnum.BFB_none;
                }
                case 1825460658: {
                    if (!_hx_tmp.equals("WS-POLLING")) break;
                    if (!blackList.contains("WS-POLLING")) {
                        return BestForBindingEnum.BFB_ws_polling;
                    }
                    return BestForBindingEnum.BFB_none;
                }
                case 2780: {
                    if (!_hx_tmp.equals("WS")) break;
                    if (!blackList.contains("WS-STREAMING")) {
                        return BestForBindingEnum.BFB_ws_streaming;
                    }
                    if (!blackList.contains("WS-POLLING")) {
                        return BestForBindingEnum.BFB_ws_polling;
                    }
                    return BestForBindingEnum.BFB_none;
                }
                case 1532100925: {
                    if (!_hx_tmp.equals("HTTP-STREAMING")) break;
                    if (!blackList.contains("HTTP-STREAMING")) {
                        return BestForBindingEnum.BFB_http_streaming;
                    }
                    return BestForBindingEnum.BFB_none;
                }
                case -668607650: {
                    if (!_hx_tmp.equals("HTTP-POLLING")) break;
                    return BestForBindingEnum.BFB_http_polling;
                }
                case 0x220088: {
                    if (!_hx_tmp.equals("HTTP")) break;
                    if (!blackList.contains("HTTP-STREAMING")) {
                        return BestForBindingEnum.BFB_http_streaming;
                    }
                    return BestForBindingEnum.BFB_http_polling;
                }
            }
        }
        throw haxe.jvm.Exception.wrap((Object)"Match failure");
    }

    public void resetCurrentRetryDelay() {
        this.delayCounter.reset(this.options.retryDelay);
    }

    public void notifyServerErrorIfCauseIsError(TerminationCause terminationCause) {
        switch (terminationCause.ordinal()) {
            case 0: {
                this.clientEventDispatcher.onServerError(((TerminationCause.TC_standardError)terminationCause).code, ((TerminationCause.TC_standardError)terminationCause).msg);
                break;
            }
            case 1: {
                this.clientEventDispatcher.onServerError(61, ((TerminationCause.TC_otherError)terminationCause).error);
                break;
            }
            case 2: {
                return;
            }
        }
    }

    public void notifyServerError_CONERR(int code, String msg) {
        this.clientEventDispatcher.onServerError(code, msg);
    }

    public void notifyServerError_END(int code, String msg) {
        if (code > 0 && code < 30 || code > 39) {
            this.clientEventDispatcher.onServerError(39, msg);
            return;
        }
        this.clientEventDispatcher.onServerError(code, msg);
    }

    public void notifyServerError_ERROR(int code, String msg) {
        this.clientEventDispatcher.onServerError(code, msg);
    }

    public void notifyServerError_REQERR(int code, String msg) {
        if (code == 11) {
            this.clientEventDispatcher.onServerError(21, msg);
            return;
        }
        this.clientEventDispatcher.onServerError(code, msg);
    }

    public void doCONOK(String sessionId, int reqLimit, Long keepalive, Long idleTimeout, String clink) {
        this.sessionId = sessionId;
        this.details.setSessionId(sessionId);
        this.requestLimit = reqLimit;
        if (keepalive != null) {
            this.keepaliveInterval = keepalive;
            this.options.setKeepaliveInterval(Jvm.toLong(keepalive));
        } else if (idleTimeout != null) {
            this.idleTimeout = idleTimeout;
            this.options.setIdleTimeout(Jvm.toLong(idleTimeout));
        }
        if (Jvm.stringCompare(clink, "*") != 0 && !this.options.serverInstanceAddressIgnored) {
            this.serverInstanceAddress = clink = Url.completeControlLink(clink, this.getServerAddress());
            this.details.setServerInstanceAddress(clink);
        }
    }

    public void doCONOK_CreateWS(String sessionId, int reqLimit, long keepalive, String clink) {
        this.doCONOK(sessionId, reqLimit, keepalive, null, clink);
    }

    public void doCONOK_BindWS_Streaming(String sessionId, int reqLimit, long keepalive, String clink) {
        this.doCONOK(sessionId, reqLimit, keepalive, null, clink);
    }

    public void doCONOK_BindWS_Polling(String sessionId, int reqLimit, long idleTimeout, String clink) {
        this.doCONOK(sessionId, reqLimit, null, idleTimeout, clink);
    }

    public void doCONOK_CreateHTTP(String sessionId, int reqLimit, long keepalive, String clink) {
        this.doCONOK(sessionId, reqLimit, null, null, clink);
    }

    public void doCONOK_BindHTTP_Streaming(String sessionId, int reqLimit, long keepalive, String clink) {
        this.doCONOK(sessionId, reqLimit, keepalive, null, clink);
    }

    public void doCONOK_BindHTTP_Polling(String sessionId, int reqLimit, long idleTimeout, String clink) {
        this.doCONOK(sessionId, reqLimit, null, idleTimeout, clink);
    }

    public void doSERVNAME(String serverName) {
        this.details.setServerSocketName(serverName);
    }

    public void doCLIENTIP(String clientIp) {
        this.details.setClientIp(clientIp);
        String lastIp = this.lastKnownClientIp;
        if (lastIp != null && Jvm.stringCompare(lastIp, clientIp) != 0) {
            if (LoggerTools_Fields_.sessionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.sessionLogger.info("Client IP changed: " + lastIp + " -> " + clientIp, null);
            }
            this.enableAllTransports();
        }
        this.lastKnownClientIp = clientIp;
    }

    public void doCONS(RealMaxBandwidth bandwidth) {
        this.options.setRealMaxBandwidth(bandwidth);
    }

    public void doLOOP(long pollingMs) {
        this.options.setPollingInterval(pollingMs);
    }

    public void doPROG(int prog) throws IllegalStateException {
        if (prog > this.rec_clientProg) {
            throw new IllegalStateException("Assertion failure: " + "prog <= rec_clientProg");
        }
        this.rec_serverProg = prog;
    }

    public void doMSGDONE(String sequence2, int prog, String response) throws IllegalStateException {
        this.onFreshData();
        MyArray<MessageManager> messages = this.messageManagers.filter(new Closure_doMSGDONE_0(sequence2, prog));
        if (messages.values.length - messages.nRemoved > 1) {
            throw new IllegalStateException("Assertion failure: " + "messages.length <= 1");
        }
        MyArray.MyArrayIterator<MessageManager> msg = new MyArray.MyArrayIterator<MessageManager>(messages);
        while (msg.hasNext()) {
            MessageManager msg2 = msg.next();
            msg2.evtMSGDONE(response);
        }
    }

    public void doMSGFAIL(String sequence2, int prog, int errorCode, String errorMsg) throws IllegalStateException {
        this.onFreshData();
        if (errorCode == 39) {
            Integer count = Std.parseInt(errorMsg);
            if (count == null) {
                throw new IllegalStateException("Assertion failure: " + "count != null");
            }
            int _g = prog - Jvm.toInt(count) + 1;
            int _g1 = prog + 1;
            while (_g < _g1) {
                int p = _g++;
                MyArray<MessageManager> messages = this.messageManagers.filter(new Closure_doMSGFAIL_0(sequence2, p));
                if (messages.values.length - messages.nRemoved > 1) {
                    throw new IllegalStateException("Assertion failure: " + "messages.length <= 1");
                }
                MyArray.MyArrayIterator<MessageManager> msg = new MyArray.MyArrayIterator<MessageManager>(messages);
                while (msg.hasNext()) {
                    MessageManager msg2 = msg.next();
                    msg2.evtMSGFAIL(errorCode, errorMsg);
                }
            }
            return;
        }
        MyArray<MessageManager> messages = this.messageManagers.filter(new Closure_doMSGFAIL_1(sequence2, prog));
        if (messages.values.length - messages.nRemoved > 1) {
            throw new IllegalStateException("Assertion failure: " + "messages.length <= 1");
        }
        MyArray.MyArrayIterator<MessageManager> msg = new MyArray.MyArrayIterator<MessageManager>(messages);
        while (msg.hasNext()) {
            MessageManager msg3 = msg.next();
            msg3.evtMSGFAIL(errorCode, errorMsg);
        }
    }

    public void doU(int subId, int itemIdx, IntMap values2) {
        this.onFreshData();
        SubscriptionManager sub = (SubscriptionManager)this.subscriptionManagers._innerMap.get(subId);
        if (sub != null) {
            sub.evtU(itemIdx, values2);
            return;
        }
        SubscriptionManagerZombie sub2 = new SubscriptionManagerZombie(subId, this);
        sub2.evtU(itemIdx, values2);
    }

    public void doSUBOK(int subId, int nItems, int nFields) {
        this.onFreshData();
        SubscriptionManager sub = (SubscriptionManager)this.subscriptionManagers._innerMap.get(subId);
        if (sub != null) {
            sub.evtSUBOK(nItems, nFields);
            return;
        }
        SubscriptionManagerZombie sub2 = new SubscriptionManagerZombie(subId, this);
        sub2.evtSUBOK(nItems, nFields);
    }

    public void doSUBCMD(int subId, int nItems, int nFields, int keyIdx, int cmdIdx) {
        this.onFreshData();
        SubscriptionManager sub = (SubscriptionManager)this.subscriptionManagers._innerMap.get(subId);
        if (sub != null) {
            sub.evtSUBCMD(nItems, nFields, keyIdx, cmdIdx);
            return;
        }
        SubscriptionManagerZombie sub2 = new SubscriptionManagerZombie(subId, this);
        sub2.evtSUBCMD(nItems, nFields, keyIdx, cmdIdx);
    }

    public void doUNSUB(int subId) {
        this.onFreshData();
        SubscriptionManager sub = (SubscriptionManager)this.subscriptionManagers._innerMap.get(subId);
        if (sub != null) {
            sub.evtUNSUB();
        }
    }

    public void doEOS(int subId, int itemIdx) {
        this.onFreshData();
        SubscriptionManager sub = (SubscriptionManager)this.subscriptionManagers._innerMap.get(subId);
        if (sub != null) {
            sub.evtEOS(itemIdx);
            return;
        }
        SubscriptionManagerZombie sub2 = new SubscriptionManagerZombie(subId, this);
        sub2.evtEOS(itemIdx);
    }

    public void doCS(int subId, int itemIdx) {
        this.onFreshData();
        SubscriptionManager sub = (SubscriptionManager)this.subscriptionManagers._innerMap.get(subId);
        if (sub != null) {
            sub.evtCS(itemIdx);
            return;
        }
        SubscriptionManagerZombie sub2 = new SubscriptionManagerZombie(subId, this);
        sub2.evtCS(itemIdx);
    }

    public void doOV(int subId, int itemIdx, int lostUpdates) {
        this.onFreshData();
        SubscriptionManager sub = (SubscriptionManager)this.subscriptionManagers._innerMap.get(subId);
        if (sub != null) {
            sub.evtOV(itemIdx, lostUpdates);
            return;
        }
        SubscriptionManagerZombie sub2 = new SubscriptionManagerZombie(subId, this);
        sub2.evtOV(itemIdx, lostUpdates);
    }

    public void doCONF(int subId, RealMaxFrequency freq) {
        this.onFreshData();
        SubscriptionManager sub = (SubscriptionManager)this.subscriptionManagers._innerMap.get(subId);
        if (sub != null) {
            sub.evtCONF(freq);
            return;
        }
        SubscriptionManagerZombie sub2 = new SubscriptionManagerZombie(subId, this);
        sub2.evtCONF(freq);
    }

    public void doREQOK(int reqId) {
        IMap map = (OrderedIntMapImpl)((IMap)this.subscriptionManagers);
        Iterator _g_keys = map.keys();
        while (_g_keys.hasNext()) {
            int key = Jvm.toInt(_g_keys.next());
            SubscriptionManager _g_value = (SubscriptionManager)map.get(key);
            _g_value.evtREQOK(reqId);
        }
        this.subscriptionManagers._orderedKeys.compact();
        MyArray.MyArrayIterator<MessageManager> msg = new MyArray.MyArrayIterator<MessageManager>(this.messageManagers);
        while (msg.hasNext()) {
            MessageManager msg2 = msg.next();
            msg2.evtREQOK(reqId);
        }
        this.messageManagers.compact();
    }

    public void doREQERR(int reqId, int errorCode, String errorMsg) {
        IMap map = (OrderedIntMapImpl)((IMap)this.subscriptionManagers);
        Iterator _g_keys = map.keys();
        while (_g_keys.hasNext()) {
            int key = Jvm.toInt(_g_keys.next());
            SubscriptionManager _g_value = (SubscriptionManager)map.get(key);
            _g_value.evtREQERR(reqId, errorCode, errorMsg);
        }
        this.subscriptionManagers._orderedKeys.compact();
        MyArray.MyArrayIterator<MessageManager> msg = new MyArray.MyArrayIterator<MessageManager>(this.messageManagers);
        while (msg.hasNext()) {
            MessageManager msg2 = msg.next();
            msg2.evtREQERR(reqId, errorCode, errorMsg);
        }
        this.messageManagers.compact();
    }

    public void doSYNC(double syncMs) {
        this.slw_refTime = Sys.time();
        this.slw_avgDelayMs = -syncMs;
    }

    public SyncCheckResult doSYNC_G(double syncMs) {
        double diffTime = this.diffTimeSync(syncMs);
        if (diffTime > this.slw_hugeDelayMs && diffTime > this.slw_avgDelayMs * 2.0) {
            if (this.slw_avgDelayMs > this.slw_maxAvgDelayMs && this.options.slowingEnabled) {
                return SyncCheckResult.SCR_bad;
            }
            return SyncCheckResult.SCR_not_good;
        }
        this.slw_avgDelayMs = this.slowAvg(diffTime);
        if (this.slw_avgDelayMs > this.slw_maxAvgDelayMs && this.options.slowingEnabled) {
            return SyncCheckResult.SCR_bad;
        }
        if (this.slw_avgDelayMs < 60.0) {
            this.slw_avgDelayMs = 0.0;
        }
        return SyncCheckResult.SCR_good;
    }

    public SyncCheckResult doSYNC_NG(double syncMs) {
        double diffTime = this.diffTimeSync(syncMs);
        if (diffTime > this.slw_hugeDelayMs && diffTime > this.slw_avgDelayMs * 2.0) {
            this.slw_avgDelayMs = this.slowAvg(diffTime);
            if (this.slw_avgDelayMs > this.slw_maxAvgDelayMs && this.options.slowingEnabled) {
                return SyncCheckResult.SCR_bad;
            }
            if (this.slw_avgDelayMs < 60.0) {
                this.slw_avgDelayMs = 0.0;
            }
            return SyncCheckResult.SCR_good;
        }
        this.slw_avgDelayMs = this.slowAvg(diffTime);
        if (this.slw_avgDelayMs > this.slw_maxAvgDelayMs && this.options.slowingEnabled) {
            return SyncCheckResult.SCR_bad;
        }
        if (this.slw_avgDelayMs < 60.0) {
            this.slw_avgDelayMs = 0.0;
        }
        return SyncCheckResult.SCR_not_good;
    }

    public double diffTimeSync(double syncMs) {
        double diffMs = Timer.TimerStamp_Impl_.minus(Sys.time(), this.slw_refTime);
        double diffTime = diffMs - syncMs;
        return diffTime;
    }

    public double slowAvg(double diffTime) {
        return this.slw_avgDelayMs * this.slw_m + diffTime * (1.0 - this.slw_m);
    }

    public void schedule_evtTransportTimeout(long timeout2) {
        this.transportTimer = this.createTimer("transport.timeout", timeout2, new ClientMachine_evtTransportTimeout(this));
    }

    public void schedule_evtRetryTimeout(long timeout2) {
        this.retryTimer = this.createTimer("retry.timeout", timeout2, new ClientMachine_evtRetryTimeout(this));
    }

    public void schedule_evtRecoveryTimeout(long timeout2) {
        this.recoveryTimer = this.createTimer("recovery.timeout", timeout2, new ClientMachine_evtRecoveryTimeout(this));
    }

    public void schedule_evtIdleTimeout(long timeout2) {
        this.idleTimer = this.createTimer("idle.timeout", timeout2, new ClientMachine_evtIdleTimeout(this));
    }

    public void schedule_evtPollingTimeout(long timeout2) {
        this.pollingTimer = this.createTimer("polling.timeout", timeout2, new ClientMachine_evtPollingTimeout(this));
    }

    public void schedule_evtCtrlTimeout(long timeout2) {
        this.ctrlTimer = this.createTimer("ctrl.timeout", timeout2, new ClientMachine_evtCtrlTimeout(this));
    }

    public void schedule_evtKeepaliveTimeout(long timeout2) {
        this.keepaliveTimer = this.createTimer("keepalive.timeout", timeout2, new ClientMachine_evtKeepaliveTimeout(this));
    }

    public void schedule_evtStalledTimeout(long timeout2) {
        this.stalledTimer = this.createTimer("stalled.timeout", timeout2, new ClientMachine_evtStalledTimeout(this));
    }

    public void schedule_evtReconnectTimeout(long timeout2) {
        this.reconnectTimer = this.createTimer("reconnect.timeout", timeout2, new ClientMachine_evtReconnectTimeout(this));
    }

    public void schedule_evtRhbTimeout(long timeout2) {
        this.rhbTimer = this.createTimer("rhb.timeout", timeout2, new ClientMachine_evtRhbTimeout(this));
    }

    public ITimer createTimer(String id, long timeout2, haxe.jvm.Function callback) {
        ClientMachine _gthis = this;
        return (ITimer)this.timerFactory.invoke((Object)id, timeout2, (Object)new Closure_createTimer_0(_gthis, callback));
    }

    public void cancel_evtTransportTimeout() {
        if (this.transportTimer != null) {
            this.transportTimer.cancel();
            this.transportTimer = null;
        }
    }

    public void cancel_evtRetryTimeout() {
        if (this.retryTimer != null) {
            this.retryTimer.cancel();
            this.retryTimer = null;
        }
    }

    public void cancel_evtKeepaliveTimeout() {
        if (this.keepaliveTimer != null) {
            this.keepaliveTimer.cancel();
            this.keepaliveTimer = null;
        }
    }

    public void cancel_evtStalledTimeout() {
        if (this.stalledTimer != null) {
            this.stalledTimer.cancel();
            this.stalledTimer = null;
        }
    }

    public void cancel_evtReconnectTimeout() {
        if (this.reconnectTimer != null) {
            this.reconnectTimer.cancel();
            this.reconnectTimer = null;
        }
    }

    public void cancel_evtRhbTimeout() {
        if (this.rhbTimer != null) {
            this.rhbTimer.cancel();
            this.rhbTimer = null;
        }
    }

    public void cancel_evtIdleTimeout() {
        if (this.idleTimer != null) {
            this.idleTimer.cancel();
            this.idleTimer = null;
        }
    }

    public void cancel_evtPollingTimeout() {
        if (this.pollingTimer != null) {
            this.pollingTimer.cancel();
            this.pollingTimer = null;
        }
    }

    public void cancel_evtCtrlTimeout() {
        if (this.ctrlTimer != null) {
            this.ctrlTimer.cancel();
            this.ctrlTimer = null;
        }
    }

    public void cancel_evtRecoveryTimeout() {
        if (this.recoveryTimer != null) {
            this.recoveryTimer.cancel();
            this.recoveryTimer = null;
        }
    }

    public long waitingInterval(long expectedMs, double startTime) {
        double expected;
        double diffMs = Timer.TimerStamp_Impl_.minus(Sys.time(), startTime);
        if (diffMs < (expected = (double)((int)expectedMs))) {
            return (long)(expected - diffMs);
        }
        return 0;
    }

    public void exit_tr() {
        this.evtEndSession();
    }

    public void entry_m111(RetryCause retryCause, long timeout2) {
        this.evtRetry(retryCause, timeout2);
        this.schedule_evtRetryTimeout(timeout2);
    }

    public void entry_m112(RetryCause retryCause) {
        long pauseMs = this.waitingInterval(this.delayCounter.get_currentRetryDelay(), this.connectTs);
        this.evtRetry(retryCause, pauseMs);
        this.schedule_evtRetryTimeout(pauseMs);
    }

    public void entry_m113(RetryCause retryCause) {
        long pauseMs = this.randomPause(this.options.firstRetryMaxDelay);
        this.evtRetry(retryCause, pauseMs);
        this.schedule_evtRetryTimeout(pauseMs);
    }

    public void entry_m115(RetryCause retryCause) {
        this.evtRetry(retryCause, null);
        this.evtRetryTimeout();
    }

    public void entry_rec(long pause, RetryCause retryCause) {
        if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
            LoggerTools_Fields_.sessionLogger.error("Recovering connection in " + Std.string(pause) + " ms. Cause: " + ClientMachine_Fields_.asErrorMsg(retryCause), null);
        }
        this.evtStartRecovery();
        this.schedule_evtRecoveryTimeout(pause);
    }

    public void exit_w() {
        this.cancel_evtKeepaliveTimeout();
        this.cancel_evtStalledTimeout();
        this.cancel_evtReconnectTimeout();
        this.cancel_evtRhbTimeout();
    }

    public void exit_ws() {
        this.cancel_evtTransportTimeout();
        this.cancel_evtKeepaliveTimeout();
        this.cancel_evtStalledTimeout();
        this.cancel_evtReconnectTimeout();
        this.cancel_evtRhbTimeout();
    }

    public void exit_wp() {
        this.cancel_evtTransportTimeout();
        this.cancel_evtIdleTimeout();
        this.cancel_evtPollingTimeout();
    }

    public void exit_hs() {
        this.cancel_evtTransportTimeout();
        this.cancel_evtKeepaliveTimeout();
        this.cancel_evtStalledTimeout();
        this.cancel_evtReconnectTimeout();
        this.cancel_evtRhbTimeout();
    }

    public void exit_hp() {
        this.cancel_evtIdleTimeout();
        this.cancel_evtPollingTimeout();
        this.cancel_evtRhbTimeout();
    }

    public void exit_ctrl() {
        this.cancel_evtCtrlTimeout();
        this.evtDisposeCtrl();
    }

    public void exit_rec() {
        this.cancel_evtRecoveryTimeout();
        this.cancel_evtTransportTimeout();
        this.cancel_evtRetryTimeout();
    }

    public void exit_keepalive_unit() {
        this.cancel_evtKeepaliveTimeout();
        this.cancel_evtStalledTimeout();
        this.cancel_evtReconnectTimeout();
    }

    public void exit_w_to_m() {
        this.exit_w();
        this.exit_tr();
    }

    public void exit_ws_to_m() {
        this.exit_ws();
        this.exit_tr();
    }

    public void exit_wp_to_m() {
        this.exit_wp();
        this.exit_tr();
    }

    public void exit_hs_to_m() {
        this.exit_ctrl();
        this.exit_hs();
        this.exit_tr();
    }

    public void exit_hs_to_rec() {
        this.exit_ctrl();
        this.exit_hs();
    }

    public void exit_hp_to_m() {
        this.exit_ctrl();
        this.exit_hp();
        this.exit_tr();
    }

    public void exit_hp_to_rec() {
        this.exit_ctrl();
        this.exit_hp();
    }

    public void exit_ctrl_to_m() {
        this.exit_ctrl();
        this.exit_hs();
        this.exit_hp();
        this.exit_tr();
    }

    public void exit_rec_to_m() {
        this.exit_rec();
        this.exit_tr();
    }

    public long randomPause(long maxPause) {
        return this.randomGenerator.invoke(maxPause);
    }

    public int generateFreshReqId() {
        ClientMachine _gthis = this;
        return Jvm.toInt(this.lock.synchronized(new Closure_generateFreshReqId_0(_gthis)));
    }

    public int generateFreshSubId() {
        ClientMachine _gthis = this;
        return Jvm.toInt(this.lock.synchronized(new Closure_generateFreshSubId_0(_gthis)));
    }

    public void genAbortSubscriptions() {
        IMap map = (OrderedIntMapImpl)((IMap)this.subscriptionManagers);
        Iterator _g_keys = map.keys();
        while (_g_keys.hasNext()) {
            int key = Jvm.toInt(_g_keys.next());
            SubscriptionManager _g_value = (SubscriptionManager)map.get(key);
            _g_value.evtExtAbort();
        }
        this.subscriptionManagers._orderedKeys.compact();
    }

    public void genAckMessagesWS() {
        MyArray<MessageManager> messages = this.messageManagers.filter(Closure_genAckMessagesWS_0.ClientMachine$Closure_genAckMessagesWS_0);
        MyArray.MyArrayIterator<MessageManager> msg = new MyArray.MyArrayIterator<MessageManager>(messages);
        while (msg.hasNext()) {
            MessageManager msg2 = msg.next();
            msg2.evtWSSent();
        }
    }

    public void genAbortMessages() {
        MyArray.MyArrayIterator<MessageManager> msg = new MyArray.MyArrayIterator<MessageManager>(this.messageManagers);
        while (msg.hasNext()) {
            MessageManager msg2 = msg.next();
            msg2.evtAbort();
        }
        this.messageManagers.compact();
    }

    public void resetSequenceMap() {
        ((StringMap)((IMap)this.sequenceMap)).clear();
    }

    public boolean isSwitching() {
        if (this.state.s_m == 150) {
            Integer n = this.state.s_swt;
            if (n == null ? true : Jvm.toInt(n) != 1302) {
                Integer n2 = this.state.s_swt;
                return n2 == null ? false : Jvm.toInt(n2) == 1303;
            }
            return true;
        }
        return false;
    }

    public String encodeSwitch(boolean isWS) {
        ClientMachine _gthis = this;
        return (String)this.lock.synchronized(new Closure_encodeSwitch_0(_gthis, isWS));
    }

    public String encodeConstrain() {
        ClientMachine _gthis = this;
        return (String)this.lock.synchronized(new Closure_encodeConstrain_0(_gthis));
    }

    public Array getPendingControls() {
        Array<Object> res = new Array<Object>();
        if (NullTools.sure(this.switchRequest).isPending()) {
            res.push(NullTools.sure(this.switchRequest));
        }
        if (NullTools.sure(this.constrainRequest).isPending()) {
            res.push(NullTools.sure(this.constrainRequest));
        }
        IMap map = (OrderedIntMapImpl)((IMap)this.subscriptionManagers);
        Iterator _g_keys = map.keys();
        while (_g_keys.hasNext()) {
            int key = Jvm.toInt(_g_keys.next());
            SubscriptionManager _g_value = (SubscriptionManager)map.get(key);
            if (!_g_value.isPending()) continue;
            res.push(_g_value);
        }
        return res;
    }

    public void sendControlWS(Encodable request) {
        NullTools.sure(this.ws).send(request.encodeWS());
    }

    public void sendMsgWS(MessageManager msg) {
        NullTools.sure(this.ws).send(msg.encodeWS());
    }

    public void sendPengingControlsWS(Array pendings) {
        Array batches = this.prepareBatchWS("control", pendings, Jvm.toInt(NullTools.sure(this.requestLimit)));
        this.sendBatchWS(batches);
    }

    public void sendPendingMessagesWS() {
        Array<Encodable> _g = Array.ofNative(new Encodable[0]);
        MyArray.MyArrayIterator<MessageManager> msg = new MyArray.MyArrayIterator<MessageManager>(this.messageManagers);
        while (msg.hasNext()) {
            MessageManager msg2 = msg.next();
            if (!msg2.isPending()) continue;
            _g.push(msg2);
        }
        Array batches = this.prepareBatchWS("msg", _g, Jvm.toInt(NullTools.sure(this.requestLimit)));
        this.sendBatchWS(batches);
    }

    public void sendBatchWS(Array batches) {
        for (int _g = 0; _g < batches.length; ++_g) {
            String batch = (String)batches.__get(_g);
            NullTools.sure(this.ws).send(batch);
        }
    }

    public void sendHeartbeatWS() {
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Heartbeat request", null);
        }
        NullTools.sure(this.ws).send("heartbeat\r\n\r\n");
    }

    public void sendPendingControlsHTTP(Array pendings) {
        String body = this.prepareBatchHTTP(pendings, Jvm.toInt(NullTools.sure(this.requestLimit)));
        this.sendBatchHTTP(body, "control");
    }

    public void sendPendingMessagesHTTP() {
        Array<Encodable> _g = Array.ofNative(new Encodable[0]);
        MyArray.MyArrayIterator<MessageManager> msg = new MyArray.MyArrayIterator<MessageManager>(this.messageManagers);
        while (msg.hasNext()) {
            MessageManager msg2 = msg.next();
            if (!msg2.isPending()) continue;
            _g.push(msg2);
        }
        String body = this.prepareBatchHTTP(_g, Jvm.toInt(NullTools.sure(this.requestLimit)));
        this.sendBatchHTTP(body, "msg");
    }

    public void sendHeartbeatHTTP() {
        if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
            LoggerTools_Fields_.protocolLogger.info("Heartbeat request", null);
        }
        this.sendBatchHTTP("\r\n", "heartbeat");
    }

    public void sendBatchHTTP(String body, String reqType) {
        this.ctrl_connectTs = Sys.time();
        String url = Url.build(NullTools.sure(this.serverInstanceAddress), "/lightstreamer/" + reqType + ".txt?LS_protocol=" + Constants_Fields_.TLCP_VERSION + "&LS_session=" + this.sessionId);
        StringMap headers = this.getHeadersForRequestOtherThanCreate();
        ClientMachine _gthis = this;
        haxe.jvm.Function onText = new Closure_sendBatchHTTP_onText_0(_gthis);
        haxe.jvm.Function onError = new Closure_sendBatchHTTP_onError_0(_gthis);
        haxe.jvm.Function onDone = new Closure_sendBatchHTTP_onDone_0(_gthis);
        this.ctrl_http = (IHttpClient)this.ctrlFactory.invoke(url, body, headers, onText, onError, onDone);
    }

    public Array prepareBatchWS(String reqType, Array pendings, int requestLimit) throws IllegalStateException {
        if (pendings.length <= 0) {
            throw new IllegalStateException("Assertion failure: " + "pendings.length > 0");
        }
        Array<String> out = Array.ofNative(new String[0]);
        int i = 0;
        String subReq = ((Encodable)pendings.__get(0)).encode(true);
        while (i < pendings.length) {
            Request mainReq = new Request();
            mainReq.addSubRequest(reqType);
            mainReq.addSubRequest(subReq);
            ++i;
            while (i < pendings.length && mainReq.addSubRequestOnlyIfBodyIsLessThan(subReq = ((Encodable)pendings.__get(i)).encode(true), requestLimit)) {
                ++i;
            }
            out.push(mainReq.getBody());
        }
        return out;
    }

    public String prepareBatchHTTP(Array pendings, int requestLimit) throws IllegalStateException {
        if (pendings.length <= 0) {
            throw new IllegalStateException("Assertion failure: " + "pendings.length > 0");
        }
        Request mainReq = new Request();
        int i = 0;
        String subReq = ((Encodable)pendings.__get(0)).encode(false);
        mainReq.addSubRequest(subReq);
        for (i = 1; i < pendings.length && mainReq.addSubRequestOnlyIfBodyIsLessThan(subReq = ((Encodable)pendings.__get(i)).encode(false), requestLimit); ++i) {
        }
        return mainReq.getBody();
    }

    public StringMap getHeadersForRequestOtherThanCreate() {
        if (this.options.httpExtraHeadersOnSessionCreationOnly) {
            return null;
        }
        return this.options.httpExtraHeaders;
    }

    public String getServerAddress() {
        String addr = this.details.serverAddress;
        if (addr != null) {
            return addr;
        }
        return NullTools.sure(this.defaultServerAddress);
    }

    public void relateSubManager(SubscriptionManager subManager) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_relateSubManager_0(_gthis, subManager));
    }

    public void unrelateSubManager(SubscriptionManager subManager) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_unrelateSubManager_0(_gthis, subManager));
    }

    public boolean isRelatedWithSubManager(SubscriptionManager subManager) {
        return Lambda.has((OrderedIntMapImpl)((Iterable.Interface)this.subscriptionManagers), subManager);
    }

    public void relateMsgManager(MessageManager msgManager) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_relateMsgManager_0(_gthis, msgManager));
    }

    public void unrelateMsgManager(MessageManager msgManager) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_unrelateMsgManager_0(_gthis, msgManager));
    }

    public int getAndSetNextMsgProg(String sequence2) {
        ClientMachine _gthis = this;
        return Jvm.toInt(this.lock.synchronized(new Closure_getAndSetNextMsgProg_0(_gthis, sequence2)));
    }

    public void onPropertyChange(String property) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_onPropertyChange_0(_gthis, property));
    }

    public void traceEvent(String event) {
        if (LoggerTools_Fields_.internalLogger.isTraceEnabled()) {
            LoggerTools_Fields_.internalLogger.trace("event: " + event + " " + this.state.toString(), null);
        }
    }

    public void connect() {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_connect_0(_gthis));
    }

    public void disconnect() {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_disconnect_0(_gthis));
    }

    public FutureTask disconnectFuture() {
        ClientMachine _gthis = this;
        return (FutureTask)this.lock.synchronized(new Closure_disconnectFuture_0(_gthis));
    }

    public String getStatus() {
        ClientMachine _gthis = this;
        return (String)this.lock.synchronized(new Closure_getStatus_0(_gthis));
    }

    public void sendMessage(String message, String sequence2, int delayTimeout, ClientMessageListener listener, boolean enqueueWhileDisconnected) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_sendMessage_0(enqueueWhileDisconnected, _gthis, message, sequence2, delayTimeout, listener));
    }

    public void subscribeExt(LSSubscription subscription, Boolean isInternal) {
        boolean isInternal2 = isInternal == null ? false : Jvm.toBoolean(isInternal);
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_subscribeExt_0(subscription, _gthis, isInternal2));
    }

    public void unsubscribe(LSSubscription subscription) {
        ClientMachine _gthis = this;
        this.lock.synchronized(new Closure_unsubscribe_0(subscription, _gthis));
    }

    public Array getSubscriptions() {
        ClientMachine _gthis = this;
        return (Array)this.lock.synchronized(new Closure_getSubscriptions_0(_gthis));
    }

    /*
     * WARNING - void declaration
     */
    public ClientMachine(LSLightstreamerClient client, IFactory factory2) {
        void var3_5;
        this.state = new State();
        this.delayCounter = new RetryDelayCounter();
        this.m_status = "DISCONNECTED";
        this.m_nextReqId = 0;
        this.m_nextSubId = 0;
        double this1 = 0.0;
        this.connectTs = this1 = 0.0;
        this1 = 0.0;
        this.recoverTs = this1 = 0.0;
        this1 = 0.0;
        this.ctrl_connectTs = this1 = 0.0;
        this.suspendedTransports = new Set(null);
        this.disabledTransports = new Set(null);
        this.sequenceMap = new StringMap();
        this.messageManagers = new MyArray();
        OrderedIntMapImpl this2 = null;
        this2 = new OrderedIntMapImpl();
        this.subscriptionManagers = this2;
        this.rec_serverProg = 0;
        this.rec_clientProg = 0;
        this1 = 0.0;
        this.slw_refTime = this1 = 0.0;
        this1 = 0.0;
        this.slw_avgDelayMs = this1 = 0.0;
        this1 = 0.0;
        this.slw_maxAvgDelayMs = this1 = 7000.0;
        this1 = 0.0;
        this1 = 20000.0;
        this.slw_hugeDelayMs = var3_5;
        this.slw_m = 0.5;
        this.client = client;
        this.lock = client.lock;
        this.details = client.connectionDetails;
        this.options = client.connectionOptions;
        this.wsFactory = (haxe.jvm.Function)Jvm.readField(factory2, "createWsClient");
        this.httpFactory = (haxe.jvm.Function)Jvm.readField(factory2, "createHttpClient");
        this.ctrlFactory = (haxe.jvm.Function)Jvm.readField(factory2, "createCtrlClient");
        this.timerFactory = (haxe.jvm.Function)Jvm.readField(factory2, "createTimer");
        this.randomGenerator = (haxe.jvm.Function)Jvm.readField(factory2, "randomMillis");
        this.reachabilityFactory = (haxe.jvm.Function)Jvm.readField(factory2, "createReachabilityManager");
        this.frz_pageLifecycleFactory = (haxe.jvm.Function)Jvm.readField(factory2, "createPageLifecycleFactory");
        this.clientEventDispatcher = client.eventDispatcher;
        this.switchRequest = new SwitchRequest(this);
        this.constrainRequest = new ConstrainRequest(this);
        this.delayCounter.reset(this.options.retryDelay);
    }

    public /* synthetic */ ClientMachine(EmptyConstructor _) {
    }

    public static final class Closure_evtSendControl_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;
        public final Encodable request;

        /*
         * WARNING - void declaration
         */
        public Closure_evtSendControl_0(ClientMachine _gthis, Encodable encodable) {
            void request;
            this._gthis = _gthis;
            this.request = request;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("send.control");
            StateVar_w tmp = this._gthis.state.s_w;
            Integer n = tmp != null ? Integer.valueOf(tmp.s) : (Integer)null;
            if (n == null ? false : Jvm.toInt(n) == 340) {
                this._gthis.sendControlWS(this.request);
                this._gthis.state.s_w.s = 340;
                this._gthis.state.traceState();
                this._gthis.evtRestartHeartbeat();
                return;
            }
            StateVar_ws tmp2 = this._gthis.state.s_ws;
            Integer n2 = tmp2 != null ? tmp2.s : (Integer)null;
            if (n2 == null ? false : Jvm.toInt(n2) == 550) {
                this._gthis.sendControlWS(this.request);
                this._gthis.state.s_ws.s = 550;
                this._gthis.state.traceState();
                this._gthis.evtRestartHeartbeat();
                return;
            }
            StateVar_wp tmp3 = this._gthis.state.s_wp;
            Integer n3 = tmp3 != null ? tmp3.s : (Integer)null;
            if (n3 == null ? false : Jvm.toInt(n3) == 630) {
                this._gthis.sendControlWS(this.request);
                this._gthis.state.s_wp.s = 630;
                this._gthis.state.traceState();
                return;
            }
            Integer n4 = this._gthis.state.s_ctrl;
            if (n4 == null ? false : Jvm.toInt(n4) == 1101) {
                this._gthis.state.s_ctrl = 1100;
                this._gthis.state.traceState();
                this._gthis.evtCheckCtrlRequests();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtPollingTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtPollingTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtPollingTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtPollingTimeout)) {
                return false;
            }
            ClientMachine_evtPollingTimeout other2 = (ClientMachine_evtPollingTimeout)other;
            return this.this == other2.this;
        }
    }

    public static final class Closure_createTimer_0
    extends haxe.jvm.Function
    implements Function<Object, Object>,
    Function1<Object, Object> {
        public final ClientMachine _gthis;
        public final haxe.jvm.Function callback;

        /*
         * WARNING - void declaration
         */
        public Closure_createTimer_0(ClientMachine _gthis, haxe.jvm.Function function) {
            void callback;
            this._gthis = _gthis;
            this.callback = callback;
        }

        @Override
        public void invoke(ITimer timer) {
            this._gthis.lock.synchronized(new Closure_invoke_0(timer, this.callback));
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }

        public static final class Closure_invoke_0
        extends haxe.jvm.Function
        implements PrivilegedAction<Object>,
        PrivilegedExceptionAction<Object>,
        Callable<Object>,
        Supplier<Object>,
        Function0<Object> {
            public final ITimer timer;
            public final haxe.jvm.Function callback;

            /*
             * WARNING - void declaration
             */
            public Closure_invoke_0(ITimer timer, haxe.jvm.Function function) {
                void callback;
                this.timer = timer;
                this.callback = callback;
            }

            @Override
            public void invoke() {
                if (this.timer.isCanceled()) {
                    return;
                }
                this.callback.invoke();
            }

            @Override
            public Object get() {
                return this.invoke();
            }

            @Override
            public Object call() {
                return this.invoke();
            }

            @Override
            public Object run() {
                return this.invoke();
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_unrelateSubManager_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Boolean>,
    PrivilegedExceptionAction<Boolean>,
    Callable<Boolean>,
    Supplier<Boolean>,
    ClassReflectionInformation,
    Function0<Boolean> {
        public final ClientMachine _gthis;
        public final SubscriptionManager subManager;

        /*
         * WARNING - void declaration
         */
        public Closure_unrelateSubManager_0(ClientMachine _gthis, SubscriptionManager subscriptionManager) {
            void subManager;
            this._gthis = _gthis;
            this.subManager = subManager;
        }

        @Override
        public boolean invoke() {
            return this._gthis.subscriptionManagers.remove(Jvm.toInt(Jvm.readField(this.subManager, "subId")));
        }

        @Override
        public boolean hasSuperClass() {
            return this.invoke();
        }

        @Override
        public boolean get() {
            return this.invoke();
        }

        @Override
        public boolean call() {
            return this.invoke();
        }

        @Override
        public boolean run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_evtCheckCtrlRequests_0
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MessageManager>,
    Function<MessageManager, Boolean>,
    Predicate<MessageManager>,
    Function1<MessageManager, Boolean> {
        public static final Closure_evtCheckCtrlRequests_0 ClientMachine$Closure_evtCheckCtrlRequests_0 = new Closure_evtCheckCtrlRequests_0();

        Closure_evtCheckCtrlRequests_0() {
        }

        @Override
        public boolean invoke(MessageManager msg) {
            return msg.isPending();
        }

        @Override
        public boolean test(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    @EnumReflectionInformation(constructorNames={"BFC_ws", "BFC_http", "BFC_none"})
    public static abstract class BestForCreatingEnum
    extends Enum {
        public static final /* enum */ BestForCreatingEnum BFC_ws = new BFC_ws();
        public static final /* enum */ BestForCreatingEnum BFC_http = new BFC_http();
        public static final /* enum */ BestForCreatingEnum BFC_none = new BFC_none();

        /*
         * WARNING - void declaration
         */
        protected BestForCreatingEnum(int n, String string) {
            void name;
            void index;
        }

        public static BestForCreatingEnum[] values() {
            return new BestForCreatingEnum[]{BFC_ws, BFC_http, BFC_none};
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class BFC_none
        extends BestForCreatingEnum {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class BFC_http
        extends BestForCreatingEnum {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class BFC_ws
        extends BestForCreatingEnum {
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_doMSGDONE_0
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MessageManager>,
    Function<MessageManager, Boolean>,
    Predicate<MessageManager>,
    Function1<MessageManager, Boolean> {
        public final String sequence;
        public final int prog;

        /*
         * WARNING - void declaration
         */
        public Closure_doMSGDONE_0(String sequence2, int n) {
            void prog;
            this.sequence = sequence2;
            this.prog = prog;
        }

        @Override
        public boolean invoke(MessageManager msg) {
            if (Jvm.stringCompare(msg.sequence, this.sequence) == 0) {
                return msg.prog == this.prog;
            }
            return false;
        }

        @Override
        public boolean test(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtRhbTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtRhbTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtRhbTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtRhbTimeout)) {
                return false;
            }
            ClientMachine_evtRhbTimeout other2 = (ClientMachine_evtRhbTimeout)other;
            return this.this == other2.this;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_relateSubManager_0
    extends haxe.jvm.Function
    implements PrivilegedAction<SubscriptionManager>,
    PrivilegedExceptionAction<SubscriptionManager>,
    Callable<SubscriptionManager>,
    Supplier<SubscriptionManager>,
    Function0<SubscriptionManager> {
        public final ClientMachine _gthis;
        public final SubscriptionManager subManager;

        /*
         * WARNING - void declaration
         */
        public Closure_relateSubManager_0(ClientMachine _gthis, SubscriptionManager subscriptionManager) {
            void subManager;
            this._gthis = _gthis;
            this.subManager = subManager;
        }

        @Override
        public SubscriptionManager invoke() throws IllegalStateException {
            if ((SubscriptionManager)this._gthis.subscriptionManagers._innerMap.get(Jvm.toInt(Jvm.readField(this.subManager, "subId"))) != null) {
                throw new IllegalStateException("Assertion failure: " + "subscriptionManagers[subManager.subId] == null");
            }
            this._gthis.subscriptionManagers.set(Jvm.toInt(Jvm.readField(this.subManager, "subId")), this.subManager);
            return this.subManager;
        }

        @Override
        public SubscriptionManager get() {
            return this.invoke();
        }

        @Override
        public SubscriptionManager call() {
            return this.invoke();
        }

        @Override
        public SubscriptionManager run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encodeSwitch_0
    extends haxe.jvm.Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final ClientMachine _gthis;
        public final boolean isWS;

        /*
         * WARNING - void declaration
         */
        public Closure_encodeSwitch_0(ClientMachine _gthis, boolean bl) {
            void isWS;
            this._gthis = _gthis;
            this.isWS = isWS;
        }

        @Override
        public String invoke() {
            RequestBuilder req = new RequestBuilder();
            this._gthis.swt_lastReqId = this._gthis.generateFreshReqId();
            req.LS_reqId(Jvm.toInt(this._gthis.swt_lastReqId));
            req.LS_op("force_rebind");
            if (this.isWS) {
                req.LS_close_socket(true);
            }
            if (this._gthis.cause != null) {
                req.LS_cause(this._gthis.cause);
                this._gthis.cause = null;
            }
            if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
                LoggerTools_Fields_.protocolLogger.info("Sending transport switch: " + Std.string(req), null);
            }
            return req.getEncodedString();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_evtSendPendingMessages_0
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MessageManager>,
    Function<MessageManager, Boolean>,
    Predicate<MessageManager>,
    Function1<MessageManager, Boolean> {
        public static final Closure_evtSendPendingMessages_0 ClientMachine$Closure_evtSendPendingMessages_0 = new Closure_evtSendPendingMessages_0();

        Closure_evtSendPendingMessages_0() {
        }

        @Override
        public boolean invoke(MessageManager msg) {
            return msg.isPending();
        }

        @Override
        public boolean test(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtCtrlTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtCtrlTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtCtrlTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtCtrlTimeout)) {
                return false;
            }
            ClientMachine_evtCtrlTimeout other2 = (ClientMachine_evtCtrlTimeout)other;
            return this.this == other2.this;
        }
    }

    public static final class Closure_disconnect_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;

        public Closure_disconnect_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.actionLogger.info("Disconnection requested", null);
            }
            this._gthis.evtExtDisconnect(TerminationCause.TC_api);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtExtDisconnect_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;
        public final TerminationCause terminationCause;

        /*
         * WARNING - void declaration
         */
        public Closure_evtExtDisconnect_0(ClientMachine _gthis, TerminationCause terminationCause) {
            void terminationCause2;
            this._gthis = _gthis;
            this.terminationCause = terminationCause2;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("disconnect: cause=" + Std.string((Object)this.terminationCause));
            switch (this._gthis.state.s_m) {
                default: {
                    return;
                }
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: {
                    this._gthis.notifyStatus("DISCONNECTED");
                    this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                    this._gthis.state.s_m = 100;
                    this._gthis.state.traceState();
                    this._gthis.cancel_evtRetryTimeout();
                    this._gthis.evtTerminate(this.terminationCause);
                    return;
                }
                case 120: 
                case 121: 
                case 122: {
                    this._gthis.disposeWS();
                    this._gthis.notifyStatus("DISCONNECTED");
                    this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                    this._gthis.state.s_m = 100;
                    this._gthis.state.traceState();
                    this._gthis.cancel_evtTransportTimeout();
                    this._gthis.evtTerminate(this.terminationCause);
                    return;
                }
                case 130: {
                    this._gthis.disposeHTTP();
                    this._gthis.notifyStatus("DISCONNECTED");
                    this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                    this._gthis.state.s_m = 100;
                    this._gthis.state.traceState();
                    this._gthis.cancel_evtTransportTimeout();
                    this._gthis.evtTerminate(this.terminationCause);
                    return;
                }
                case 140: {
                    this._gthis.disposeHTTP();
                    this._gthis.notifyStatus("DISCONNECTED");
                    this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                    this._gthis.state.s_m = 100;
                    this._gthis.state.traceState();
                    this._gthis.cancel_evtTransportTimeout();
                    this._gthis.evtTerminate(this.terminationCause);
                    return;
                }
                case 150: 
            }
            Integer _g = this._gthis.state.s_tr;
            if (_g != null) {
                switch (Jvm.toInt(_g)) {
                    default: {
                        break;
                    }
                    case 210: {
                        this._gthis.sendDestroyWS(null);
                        this._gthis.closeWS();
                        this._gthis.notifyStatus("DISCONNECTED");
                        this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                        this._gthis.state.clear_w();
                        this._gthis.state.goto_m_from_session(100);
                        this._gthis.exit_w();
                        this._gthis.evtEndSession();
                        this._gthis.evtTerminate(this.terminationCause);
                        break;
                    }
                    case 220: {
                        this._gthis.disposeHTTP();
                        this._gthis.notifyStatus("DISCONNECTED");
                        this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                        this._gthis.state.goto_m_from_session(100);
                        this._gthis.cancel_evtTransportTimeout();
                        this._gthis.evtEndSession();
                        this._gthis.evtTerminate(this.terminationCause);
                        break;
                    }
                    case 230: {
                        this._gthis.disposeHTTP();
                        this._gthis.notifyStatus("DISCONNECTED");
                        this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                        this._gthis.state.goto_m_from_session(100);
                        this._gthis.cancel_evtTransportTimeout();
                        this._gthis.evtEndSession();
                        this._gthis.evtTerminate(this.terminationCause);
                        break;
                    }
                    case 240: {
                        StateVar_ws tmp = this._gthis.state.s_ws;
                        Integer n = tmp != null ? Integer.valueOf(tmp.m) : (Integer)null;
                        if (n == null ? false : Jvm.toInt(n) == 500) {
                            this._gthis.disposeWS();
                            this._gthis.notifyStatus("DISCONNECTED");
                            this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                            this._gthis.state.goto_m_from_ws(100);
                            this._gthis.exit_ws_to_m();
                            this._gthis.evtTerminate(this.terminationCause);
                            break;
                        }
                        boolean tmp2 = false;
                        boolean tmp1 = false;
                        StateVar_ws tmp22 = this._gthis.state.s_ws;
                        Integer n2 = tmp22 != null ? Integer.valueOf(tmp22.m) : (Integer)null;
                        if (n2 == null ? true : Jvm.toInt(n2) != 501) {
                            StateVar_ws tmp3 = this._gthis.state.s_ws;
                            Integer n3 = tmp3 != null ? Integer.valueOf(tmp3.m) : (Integer)null;
                            tmp1 = n3 == null ? false : Jvm.toInt(n3) == 502;
                        } else {
                            tmp1 = true;
                        }
                        if (!tmp1) {
                            StateVar_ws tmp12 = this._gthis.state.s_ws;
                            Integer n4 = tmp12 != null ? Integer.valueOf(tmp12.m) : (Integer)null;
                            tmp2 = n4 == null ? false : Jvm.toInt(n4) == 503;
                        } else {
                            tmp2 = true;
                        }
                        if (!tmp2) break;
                        this._gthis.sendDestroyWS(null);
                        this._gthis.closeWS();
                        this._gthis.notifyStatus("DISCONNECTED");
                        this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                        this._gthis.state.goto_m_from_ws(100);
                        this._gthis.exit_ws_to_m();
                        this._gthis.evtTerminate(this.terminationCause);
                        break;
                    }
                    case 250: {
                        boolean tmp = false;
                        StateVar_wp tmp1 = this._gthis.state.s_wp;
                        Integer n = tmp1 != null ? Integer.valueOf(tmp1.m) : (Integer)null;
                        if (n == null ? true : Jvm.toInt(n) != 600) {
                            StateVar_wp tmp13 = this._gthis.state.s_wp;
                            Integer n5 = tmp13 != null ? Integer.valueOf(tmp13.m) : (Integer)null;
                            tmp = n5 == null ? false : Jvm.toInt(n5) == 601;
                        } else {
                            tmp = true;
                        }
                        if (tmp) {
                            this._gthis.disposeWS();
                            this._gthis.notifyStatus("DISCONNECTED");
                            this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                            this._gthis.state.goto_m_from_wp(100);
                            this._gthis.exit_ws_to_m();
                            this._gthis.evtTerminate(this.terminationCause);
                            break;
                        }
                        StateVar_wp tmp4 = this._gthis.state.s_wp;
                        Integer n6 = tmp4 != null ? Integer.valueOf(tmp4.m) : (Integer)null;
                        if (!(n6 == null ? false : Jvm.toInt(n6) == 602)) break;
                        this._gthis.sendDestroyWS(null);
                        this._gthis.closeWS();
                        this._gthis.notifyStatus("DISCONNECTED");
                        this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                        this._gthis.state.goto_m_from_wp(100);
                        this._gthis.exit_wp_to_m();
                        this._gthis.evtTerminate(this.terminationCause);
                        break;
                    }
                    case 260: {
                        this._gthis.disposeHTTP();
                        this._gthis.notifyStatus("DISCONNECTED");
                        this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                        this._gthis.state.goto_m_from_rec(100);
                        this._gthis.exit_rec_to_m();
                        this._gthis.evtTerminate(this.terminationCause);
                        break;
                    }
                    case 270: {
                        Integer n = this._gthis.state.s_h;
                        if (n == null ? false : Jvm.toInt(n) == 710) {
                            this._gthis.disposeHTTP();
                            this._gthis.notifyStatus("DISCONNECTED");
                            this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                            this._gthis.state.goto_m_from_hs(100);
                            this._gthis.exit_hs_to_m();
                            this._gthis.evtTerminate(this.terminationCause);
                            break;
                        }
                        Integer n7 = this._gthis.state.s_h;
                        if (!(n7 == null ? false : Jvm.toInt(n7) == 720)) break;
                        this._gthis.disposeHTTP();
                        this._gthis.notifyStatus("DISCONNECTED");
                        this._gthis.notifyServerErrorIfCauseIsError(this.terminationCause);
                        this._gthis.state.goto_m_from_hp(100);
                        this._gthis.exit_hp_to_m();
                        this._gthis.evtTerminate(this.terminationCause);
                    }
                }
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtRecoveryTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtRecoveryTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtRecoveryTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtRecoveryTimeout)) {
                return false;
            }
            ClientMachine_evtRecoveryTimeout other2 = (ClientMachine_evtRecoveryTimeout)other;
            return this.this == other2.this;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_doMSGFAIL_1
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MessageManager>,
    Function<MessageManager, Boolean>,
    Predicate<MessageManager>,
    Function1<MessageManager, Boolean> {
        public final String sequence;
        public final int prog;

        /*
         * WARNING - void declaration
         */
        public Closure_doMSGFAIL_1(String sequence2, int n) {
            void prog;
            this.sequence = sequence2;
            this.prog = prog;
        }

        @Override
        public boolean invoke(MessageManager msg) {
            if (Jvm.stringCompare(msg.sequence, this.sequence) == 0) {
                return msg.prog == this.prog;
            }
            return false;
        }

        @Override
        public boolean test(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    public static final class Closure_generateFreshReqId_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;

        public Closure_generateFreshReqId_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public int invoke() {
            ++this._gthis.m_nextReqId;
            return this._gthis.m_nextReqId;
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_sendBatchHTTP_onDone_0
    extends haxe.jvm.Function
    implements Function<Object, Object>,
    Function1<Object, Object> {
        public final ClientMachine _gthis;

        public Closure_sendBatchHTTP_onDone_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke(IHttpClient client) {
            Threads_Fields_.sessionThread.exec.execute(new Closure_invoke_0(this._gthis, client));
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }

        public static final class com.lightstreamer.client.internal.ClientMachine$Closure_sendBatchHTTP_onDone_0$Closure_invoke_0
        extends haxe.jvm.Function
        implements Runnable {
            public final ClientMachine _gthis;
            public final IHttpClient client;

            /*
             * WARNING - void declaration
             */
            public com.lightstreamer.client.internal.ClientMachine$Closure_sendBatchHTTP_onDone_0$Closure_invoke_0(ClientMachine _gthis, IHttpClient iHttpClient) {
                void client;
                this._gthis = _gthis;
                this.client = client;
            }

            @Override
            public void invoke() {
                this._gthis.lock.synchronized(new Closure_invoke_0(this.client, this._gthis));
            }

            @Override
            public void run() {
                this.invoke();
            }

            public static final class Closure_invoke_0
            extends haxe.jvm.Function
            implements PrivilegedAction<Object>,
            PrivilegedExceptionAction<Object>,
            Callable<Object>,
            Supplier<Object>,
            Function0<Object> {
                public final IHttpClient client;
                public final ClientMachine _gthis;

                /*
                 * WARNING - void declaration
                 */
                public Closure_invoke_0(IHttpClient client, ClientMachine clientMachine) {
                    void _gthis;
                    this.client = client;
                    this._gthis = _gthis;
                }

                @Override
                public void invoke() {
                    if (this.client.isDisposed()) {
                        return;
                    }
                    this._gthis.evtCtrlDone();
                }

                @Override
                public Object get() {
                    return this.invoke();
                }

                @Override
                public Object call() {
                    return this.invoke();
                }

                @Override
                public Object run() {
                    return this.invoke();
                }
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_encodeConstrain_0
    extends haxe.jvm.Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final ClientMachine _gthis;

        public Closure_encodeConstrain_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            RequestBuilder req = new RequestBuilder();
            this._gthis.bw_lastReqId = this._gthis.generateFreshReqId();
            req.LS_reqId(Jvm.toInt(this._gthis.bw_lastReqId));
            req.LS_op("constrain");
            RequestedMaxBandwidth _g = NullTools.sure(this._gthis.bw_requestedMaxBandwidth);
            switch (_g.ordinal()) {
                case 0: {
                    req.LS_requested_max_bandwidth_Float(((RequestedMaxBandwidth.BWLimited)_g).bw);
                    break;
                }
                case 1: {
                    req.LS_requested_max_bandwidth("unlimited");
                }
            }
            if (LoggerTools_Fields_.protocolLogger.isInfoEnabled()) {
                LoggerTools_Fields_.protocolLogger.info("Sending bandwidth constrain: " + Std.string(req), null);
            }
            return req.getEncodedString();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtExtConnect_NetworkReachabilityRegion_0
    extends haxe.jvm.Function
    implements Function<Object, Object>,
    Function1<Object, Object> {
        public final ClientMachine _gthis;
        public final String hostAddress;

        /*
         * WARNING - void declaration
         */
        public Closure_evtExtConnect_NetworkReachabilityRegion_0(ClientMachine _gthis, String string) {
            void hostAddress;
            this._gthis = _gthis;
            this.hostAddress = hostAddress;
        }

        @Override
        public void invoke(ReachabilityStatus status) {
            switch (status.ordinal()) {
                case 0: {
                    this._gthis.evtNetworkReachable(this.hostAddress);
                    break;
                }
                case 1: {
                    this._gthis.evtNetworkNotReachable(this.hostAddress);
                }
            }
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtIdleTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtIdleTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtIdleTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtIdleTimeout)) {
                return false;
            }
            ClientMachine_evtIdleTimeout other2 = (ClientMachine_evtIdleTimeout)other;
            return this.this == other2.this;
        }
    }

    public static final class Closure_evtSendMessage_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;
        public final MessageManager msg;

        /*
         * WARNING - void declaration
         */
        public Closure_evtSendMessage_0(ClientMachine _gthis, MessageManager messageManager) {
            void msg;
            this._gthis = _gthis;
            this.msg = msg;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("send.message");
            StateVar_w tmp = this._gthis.state.s_w;
            Integer n = tmp != null ? Integer.valueOf(tmp.s) : (Integer)null;
            if (n == null ? false : Jvm.toInt(n) == 340) {
                this._gthis.sendMsgWS(this.msg);
                this._gthis.state.s_w.s = 340;
                this._gthis.state.traceState();
                this.msg.evtWSSent();
                this._gthis.evtRestartHeartbeat();
                return;
            }
            StateVar_ws tmp2 = this._gthis.state.s_ws;
            Integer n2 = tmp2 != null ? tmp2.s : (Integer)null;
            if (n2 == null ? false : Jvm.toInt(n2) == 550) {
                this._gthis.sendMsgWS(this.msg);
                this._gthis.state.s_ws.s = 550;
                this._gthis.state.traceState();
                this.msg.evtWSSent();
                this._gthis.evtRestartHeartbeat();
                return;
            }
            StateVar_wp tmp3 = this._gthis.state.s_wp;
            Integer n3 = tmp3 != null ? tmp3.s : (Integer)null;
            if (n3 == null ? false : Jvm.toInt(n3) == 630) {
                this._gthis.sendMsgWS(this.msg);
                this._gthis.state.s_wp.s = 630;
                this._gthis.state.traceState();
                this.msg.evtWSSent();
                return;
            }
            Integer n4 = this._gthis.state.s_ctrl;
            if (n4 == null ? false : Jvm.toInt(n4) == 1101) {
                this._gthis.state.s_ctrl = 1100;
                this._gthis.state.traceState();
                this._gthis.evtCheckCtrlRequests();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_sendBatchHTTP_onError_0
    extends haxe.jvm.Function
    implements BiFunction<Object, Object, Object>,
    Function2<Object, Object, Object>,
    BiConsumer<IHttpClient, String> {
        public final ClientMachine _gthis;

        public Closure_sendBatchHTTP_onError_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke(IHttpClient client, String error) {
            Threads_Fields_.sessionThread.exec.execute(new Closure_invoke_0(this._gthis, client));
        }

        @Override
        public void accept(IHttpClient arg0, String arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public void accept(Object arg0, Object arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public Object apply(Object arg0, Object arg1) {
            return this.invoke(arg0, arg1);
        }

        public static final class com.lightstreamer.client.internal.ClientMachine$Closure_sendBatchHTTP_onError_0$Closure_invoke_0
        extends haxe.jvm.Function
        implements Runnable {
            public final ClientMachine _gthis;
            public final IHttpClient client;

            /*
             * WARNING - void declaration
             */
            public com.lightstreamer.client.internal.ClientMachine$Closure_sendBatchHTTP_onError_0$Closure_invoke_0(ClientMachine _gthis, IHttpClient iHttpClient) {
                void client;
                this._gthis = _gthis;
                this.client = client;
            }

            @Override
            public void invoke() {
                this._gthis.lock.synchronized(new Closure_invoke_0(this.client, this._gthis));
            }

            @Override
            public void run() {
                this.invoke();
            }

            public static final class Closure_invoke_0
            extends haxe.jvm.Function
            implements PrivilegedAction<Object>,
            PrivilegedExceptionAction<Object>,
            Callable<Object>,
            Supplier<Object>,
            Function0<Object> {
                public final IHttpClient client;
                public final ClientMachine _gthis;

                /*
                 * WARNING - void declaration
                 */
                public Closure_invoke_0(IHttpClient client, ClientMachine clientMachine) {
                    void _gthis;
                    this.client = client;
                    this._gthis = _gthis;
                }

                @Override
                public void invoke() {
                    if (this.client.isDisposed()) {
                        return;
                    }
                    this._gthis.evtCtrlError();
                }

                @Override
                public Object get() {
                    return this.invoke();
                }

                @Override
                public Object call() {
                    return this.invoke();
                }

                @Override
                public Object run() {
                    return this.invoke();
                }
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_evtSendPendingMessages_1
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MessageManager>,
    Function<MessageManager, Boolean>,
    Predicate<MessageManager>,
    Function1<MessageManager, Boolean> {
        public static final Closure_evtSendPendingMessages_1 ClientMachine$Closure_evtSendPendingMessages_1 = new Closure_evtSendPendingMessages_1();

        Closure_evtSendPendingMessages_1() {
        }

        @Override
        public boolean invoke(MessageManager msg) {
            return msg.isPending();
        }

        @Override
        public boolean test(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getStatus_0
    extends haxe.jvm.Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final ClientMachine _gthis;

        public Closure_getStatus_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.m_status;
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getSubscriptions_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Array<LSSubscription>>,
    PrivilegedExceptionAction<Array<LSSubscription>>,
    Callable<Array<LSSubscription>>,
    Supplier<Array<LSSubscription>>,
    Function0<Array<LSSubscription>> {
        public final ClientMachine _gthis;

        public Closure_getSubscriptions_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public Array invoke() {
            Array<LSSubscription> ls = new Array<LSSubscription>();
            IMap map = (OrderedIntMapImpl)((IMap)this._gthis.subscriptionManagers);
            Iterator _g_keys = map.keys();
            while (_g_keys.hasNext()) {
                LSSubscription sub;
                int key = Jvm.toInt(_g_keys.next());
                SubscriptionManager _g_value = (SubscriptionManager)map.get(key);
                SubscriptionManagerLiving sml = Std.isOfType(_g_value, SubscriptionManagerLiving.class) ? (SubscriptionManagerLiving)_g_value : null;
                if (sml == null || !(sub = sml.m_subscription).isActive() || sub.isInternal()) continue;
                ls.push(sub);
            }
            return ls;
        }

        @Override
        public Array get() {
            return this.invoke();
        }

        @Override
        public Array call() {
            return this.invoke();
        }

        @Override
        public Array run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_evtExtConnect_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;

        public Closure_evtExtConnect_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.traceEvent("connect");
            boolean forward = true;
            if (this._gthis.state.s_m == 100) {
                if (Jvm.toBoolean(Jvm.readField(frz_globalPageLifecycle, "frozen"))) {
                    if (LoggerTools_Fields_.pageLogger.isWarnEnabled()) {
                        LoggerTools_Fields_.pageLogger.warn("connection requested while page is frozen", null);
                    }
                    this._gthis.cause = "page.frozen";
                    this._gthis.resetCurrentRetryDelay();
                    this._gthis.doInstallPageLifecycle();
                    this._gthis.state.s_m = 117;
                    this._gthis.state.traceState();
                    forward = this._gthis.evtExtConnect_NextRegion();
                    IPageLifecycle tmp = this._gthis.frz_pageLifecycle;
                    if (tmp != null) {
                        tmp.startListening();
                    }
                    this._gthis.evtRetry(RetryCause.page_frozen, null);
                } else {
                    this._gthis.cause = "api";
                    this._gthis.resetCurrentRetryDelay();
                    this._gthis.doInstallPageLifecycle();
                    this._gthis.state.s_m = 101;
                    this._gthis.state.traceState();
                    forward = this._gthis.evtExtConnect_NextRegion();
                    IPageLifecycle tmp = this._gthis.frz_pageLifecycle;
                    if (tmp != null) {
                        tmp.startListening();
                    }
                    this._gthis.evtSelectCreate();
                }
            }
            if (forward) {
                this._gthis.evtExtConnect_NextRegion();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    @EnumReflectionInformation(constructorNames={"standardError", "ws_unavailable", "ws_error", "http_error", "idle_timeout", "stalled_timeout", "ws_timeout", "http_timeout", "recovery_timeout", "prog_mismatch", "page_frozen"})
    public static abstract class RetryCause
    extends Enum {
        public static final /* enum */ RetryCause ws_unavailable = new ws_unavailable();
        public static final /* enum */ RetryCause ws_error = new ws_error();
        public static final /* enum */ RetryCause http_error = new http_error();
        public static final /* enum */ RetryCause idle_timeout = new idle_timeout();
        public static final /* enum */ RetryCause stalled_timeout = new stalled_timeout();
        public static final /* enum */ RetryCause ws_timeout = new ws_timeout();
        public static final /* enum */ RetryCause http_timeout = new http_timeout();
        public static final /* enum */ RetryCause recovery_timeout = new recovery_timeout();
        public static final /* enum */ RetryCause page_frozen = new page_frozen();

        /*
         * WARNING - void declaration
         */
        protected RetryCause(int n, String string) {
            void name;
            void index;
        }

        /*
         * WARNING - void declaration
         */
        public static RetryCause standardError(int n, String string) {
            void msg;
            int code;
            return new standardError(code, (String)msg);
        }

        /*
         * WARNING - void declaration
         */
        public static RetryCause prog_mismatch(int n, int n2) {
            void actual;
            int expected;
            return new prog_mismatch(expected, (int)actual);
        }

        public static RetryCause[] values() {
            return new RetryCause[]{ws_unavailable, ws_error, http_error, idle_timeout, stalled_timeout, ws_timeout, http_timeout, recovery_timeout, page_frozen};
        }

        @EnumValueReflectionInformation(argumentNames={"code", "msg"})
        public static final class standardError
        extends RetryCause {
            public final int code;
            public final String msg;

            /*
             * WARNING - void declaration
             */
            public standardError(int n, String string) {
                void msg;
                void code;
                this.code = code;
                this.msg = msg;
            }

            @Override
            public /* synthetic */ Object[] _hx_getParameters() {
                return new Object[]{this.code, this.msg};
            }

            public boolean equals(Enum other) {
                if (!(other instanceof standardError)) {
                    return false;
                }
                standardError other2 = (standardError)other;
                if (other2.ordinal() != this.ordinal()) {
                    return false;
                }
                if (other2.code != this.code) {
                    return false;
                }
                return Jvm.stringCompare(other2.msg, this.msg) == 0;
            }
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class http_timeout
        extends RetryCause {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class ws_timeout
        extends RetryCause {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class ws_unavailable
        extends RetryCause {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class http_error
        extends RetryCause {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class stalled_timeout
        extends RetryCause {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class idle_timeout
        extends RetryCause {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class recovery_timeout
        extends RetryCause {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class page_frozen
        extends RetryCause {
        }

        @EnumValueReflectionInformation(argumentNames={"expected", "actual"})
        public static final class prog_mismatch
        extends RetryCause {
            public final int expected;
            public final int actual;

            /*
             * WARNING - void declaration
             */
            public prog_mismatch(int n, int n2) {
                void actual;
                void expected;
                this.expected = expected;
                this.actual = actual;
            }

            @Override
            public /* synthetic */ Object[] _hx_getParameters() {
                return new Object[]{this.expected, this.actual};
            }

            public boolean equals(Enum other) {
                if (!(other instanceof prog_mismatch)) {
                    return false;
                }
                prog_mismatch other2 = (prog_mismatch)other;
                if (other2.ordinal() != this.ordinal()) {
                    return false;
                }
                if (other2.expected != this.expected) {
                    return false;
                }
                return other2.actual == this.actual;
            }
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class ws_error
        extends RetryCause {
        }
    }

    @EnumReflectionInformation(constructorNames={"RRC_transport_timeout", "RRC_transport_error"})
    public static abstract class RecoveryRetryCause
    extends Enum {
        public static final /* enum */ RecoveryRetryCause RRC_transport_timeout = new RRC_transport_timeout();
        public static final /* enum */ RecoveryRetryCause RRC_transport_error = new RRC_transport_error();

        /*
         * WARNING - void declaration
         */
        protected RecoveryRetryCause(int n, String string) {
            void name;
            void index;
        }

        public static RecoveryRetryCause[] values() {
            return new RecoveryRetryCause[]{RRC_transport_timeout, RRC_transport_error};
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class RRC_transport_error
        extends RecoveryRetryCause {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class RRC_transport_timeout
        extends RecoveryRetryCause {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtKeepaliveTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtKeepaliveTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtKeepaliveTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtKeepaliveTimeout)) {
                return false;
            }
            ClientMachine_evtKeepaliveTimeout other2 = (ClientMachine_evtKeepaliveTimeout)other;
            return this.this == other2.this;
        }
    }

    public static final class Closure_onPropertyChange_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;
        public final String property;

        /*
         * WARNING - void declaration
         */
        public Closure_onPropertyChange_0(ClientMachine _gthis, String string) {
            void property;
            this._gthis = _gthis;
            this.property = property;
        }

        @Override
        public void invoke() {
            this._gthis.clientEventDispatcher.onPropertyChange(this.property);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_evtSendPendingMessages_2
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MessageManager>,
    Function<MessageManager, Boolean>,
    Predicate<MessageManager>,
    Function1<MessageManager, Boolean> {
        public static final Closure_evtSendPendingMessages_2 ClientMachine$Closure_evtSendPendingMessages_2 = new Closure_evtSendPendingMessages_2();

        Closure_evtSendPendingMessages_2() {
        }

        @Override
        public boolean invoke(MessageManager msg) {
            return msg.isPending();
        }

        @Override
        public boolean test(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    @EnumReflectionInformation(constructorNames={"TC_standardError", "TC_otherError", "TC_api"})
    public static abstract class TerminationCause
    extends Enum {
        public static final /* enum */ TerminationCause TC_api = new TC_api();

        /*
         * WARNING - void declaration
         */
        protected TerminationCause(int n, String string) {
            void name;
            void index;
        }

        /*
         * WARNING - void declaration
         */
        public static TerminationCause TC_standardError(int n, String string) {
            void msg;
            int code;
            return new TC_standardError(code, (String)msg);
        }

        public static TerminationCause TC_otherError(String string) {
            String error;
            return new TC_otherError(error);
        }

        public static TerminationCause[] values() {
            return new TerminationCause[]{TC_api};
        }

        @EnumValueReflectionInformation(argumentNames={"error"})
        public static final class TC_otherError
        extends TerminationCause {
            public final String error;

            /*
             * WARNING - void declaration
             */
            public TC_otherError(String string) {
                void error;
                this.error = error;
            }

            @Override
            public /* synthetic */ Object[] _hx_getParameters() {
                return new Object[]{this.error};
            }

            public boolean equals(Enum other) {
                if (!(other instanceof TC_otherError)) {
                    return false;
                }
                TC_otherError other2 = (TC_otherError)other;
                if (other2.ordinal() != this.ordinal()) {
                    return false;
                }
                return Jvm.stringCompare(other2.error, this.error) == 0;
            }
        }

        @EnumValueReflectionInformation(argumentNames={"code", "msg"})
        public static final class TC_standardError
        extends TerminationCause {
            public final int code;
            public final String msg;

            /*
             * WARNING - void declaration
             */
            public TC_standardError(int n, String string) {
                void msg;
                void code;
                this.code = code;
                this.msg = msg;
            }

            @Override
            public /* synthetic */ Object[] _hx_getParameters() {
                return new Object[]{this.code, this.msg};
            }

            public boolean equals(Enum other) {
                if (!(other instanceof TC_standardError)) {
                    return false;
                }
                TC_standardError other2 = (TC_standardError)other;
                if (other2.ordinal() != this.ordinal()) {
                    return false;
                }
                if (other2.code != this.code) {
                    return false;
                }
                return Jvm.stringCompare(other2.msg, this.msg) == 0;
            }
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class TC_api
        extends TerminationCause {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtReconnectTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtReconnectTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtReconnectTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtReconnectTimeout)) {
                return false;
            }
            ClientMachine_evtReconnectTimeout other2 = (ClientMachine_evtReconnectTimeout)other;
            return this.this == other2.this;
        }
    }

    @ClassReflectionInformation(hasSuperClass=false)
    public static final class ClientMachine_Fields_
    extends haxe.jvm.Object {
        public static String asErrorMsg(RetryCause cause) {
            switch (cause.ordinal()) {
                default: {
                    throw haxe.jvm.Exception.wrap((Object)"Match failure");
                }
                case 0: {
                    return "" + ((RetryCause.standardError)cause).code + " - " + ((RetryCause.standardError)cause).msg;
                }
                case 1: {
                    return "Websocket transport not available";
                }
                case 2: {
                    return "Websocket error";
                }
                case 3: {
                    return "HTTP error";
                }
                case 4: {
                    return "idleTimeout expired";
                }
                case 5: {
                    return "stalledTimeout expired";
                }
                case 6: {
                    return "Websocket connect timeout expired";
                }
                case 7: {
                    return "HTTP connect timeout expired";
                }
                case 8: {
                    return "sessionRecoveryTimeout expired";
                }
                case 9: {
                    return "Recovery counter mismatch: expected " + ((RetryCause.prog_mismatch)cause).expected + " but found " + ((RetryCause.prog_mismatch)cause).actual;
                }
                case 10: 
            }
            return "page frozen";
        }

        public /* synthetic */ ClientMachine_Fields_(EmptyConstructor _) {
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_disconnectFuture_0
    extends haxe.jvm.Function
    implements PrivilegedAction<FutureTask<Object>>,
    PrivilegedExceptionAction<FutureTask<Object>>,
    Callable<FutureTask<Object>>,
    Supplier<FutureTask<Object>>,
    Function0<FutureTask<Object>> {
        public final ClientMachine _gthis;

        public Closure_disconnectFuture_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public FutureTask invoke() {
            if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.actionLogger.info("Future disconnection requested", null);
            }
            this._gthis.evtExtDisconnect(TerminationCause.TC_api);
            FutureTask<Object> future = new FutureTask<Object>(Closure_invoke_0.ClientMachine$Closure_disconnectFuture_0$Closure_invoke_0, null);
            new Thread(future).start();
            return future;
        }

        @Override
        public FutureTask get() {
            return this.invoke();
        }

        @Override
        public FutureTask call() {
            return this.invoke();
        }

        @Override
        public FutureTask run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public static final class Closure_invoke_0
        extends haxe.jvm.Function
        implements Runnable {
            public static final Closure_invoke_0 ClientMachine$Closure_disconnectFuture_0$Closure_invoke_0 = new Closure_invoke_0();

            Closure_invoke_0() {
            }

            @Override
            public void invoke() {
                if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                    LoggerTools_Fields_.actionLogger.info("Starting shutdown...", null);
                }
                Threads_Fields_.sessionThread.stop();
                Threads_Fields_.userThread.stop();
                if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                    LoggerTools_Fields_.actionLogger.info("Shutdown completed", null);
                }
            }

            @Override
            public void run() {
                this.invoke();
            }
        }
    }

    public static final class Closure_evtServerAddressChanged_0
    extends haxe.jvm.Function
    implements Function<Object, Object>,
    Function1<Object, Object> {
        public final ClientMachine _gthis;
        public final String hostAddress;

        /*
         * WARNING - void declaration
         */
        public Closure_evtServerAddressChanged_0(ClientMachine _gthis, String string) {
            void hostAddress;
            this._gthis = _gthis;
            this.hostAddress = hostAddress;
        }

        @Override
        public void invoke(ReachabilityStatus status) {
            switch (status.ordinal()) {
                case 0: {
                    this._gthis.evtNetworkReachable(this.hostAddress);
                    break;
                }
                case 1: {
                    this._gthis.evtNetworkNotReachable(this.hostAddress);
                }
            }
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    @EnumReflectionInformation(constructorNames={"SCR_good", "SCR_not_good", "SCR_bad"})
    public static abstract class SyncCheckResult
    extends Enum {
        public static final /* enum */ SyncCheckResult SCR_good = new SCR_good();
        public static final /* enum */ SyncCheckResult SCR_not_good = new SCR_not_good();
        public static final /* enum */ SyncCheckResult SCR_bad = new SCR_bad();

        /*
         * WARNING - void declaration
         */
        protected SyncCheckResult(int n, String string) {
            void name;
            void index;
        }

        public static SyncCheckResult[] values() {
            return new SyncCheckResult[]{SCR_good, SCR_not_good, SCR_bad};
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class SCR_good
        extends SyncCheckResult {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class SCR_bad
        extends SyncCheckResult {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class SCR_not_good
        extends SyncCheckResult {
        }
    }

    public static final class Closure_sendBatchHTTP_onText_0
    extends haxe.jvm.Function
    implements BiFunction<Object, Object, Object>,
    Function2<Object, Object, Object>,
    BiConsumer<IHttpClient, String> {
        public final ClientMachine _gthis;

        public Closure_sendBatchHTTP_onText_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke(IHttpClient client, String line) {
            Threads_Fields_.sessionThread.exec.execute(new Closure_invoke_0(this._gthis, client, line));
        }

        @Override
        public void accept(IHttpClient arg0, String arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public void accept(Object arg0, Object arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public Object apply(Object arg0, Object arg1) {
            return this.invoke(arg0, arg1);
        }

        public static final class com.lightstreamer.client.internal.ClientMachine$Closure_sendBatchHTTP_onText_0$Closure_invoke_0
        extends haxe.jvm.Function
        implements Runnable {
            public final ClientMachine _gthis;
            public final IHttpClient client;
            public final String line;

            /*
             * WARNING - void declaration
             */
            public com.lightstreamer.client.internal.ClientMachine$Closure_sendBatchHTTP_onText_0$Closure_invoke_0(ClientMachine _gthis, IHttpClient iHttpClient, String string) {
                void line;
                void client;
                this._gthis = _gthis;
                this.client = client;
                this.line = line;
            }

            @Override
            public void invoke() {
                this._gthis.lock.synchronized(new Closure_invoke_0(this.client, this._gthis, this.line));
            }

            @Override
            public void run() {
                this.invoke();
            }

            public static final class Closure_invoke_0
            extends haxe.jvm.Function
            implements PrivilegedAction<Object>,
            PrivilegedExceptionAction<Object>,
            Callable<Object>,
            Supplier<Object>,
            Function0<Object> {
                public final IHttpClient client;
                public final ClientMachine _gthis;
                public final String line;

                /*
                 * WARNING - void declaration
                 */
                public Closure_invoke_0(IHttpClient client, ClientMachine clientMachine, String string) {
                    void line;
                    void _gthis;
                    this.client = client;
                    this._gthis = _gthis;
                    this.line = line;
                }

                @Override
                public void invoke() {
                    if (this.client.isDisposed()) {
                        return;
                    }
                    this._gthis.evtCtrlMessage(this.line);
                }

                @Override
                public Object get() {
                    return this.invoke();
                }

                @Override
                public Object call() {
                    return this.invoke();
                }

                @Override
                public Object run() {
                    return this.invoke();
                }
            }
        }
    }

    public static final class Closure_connect_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;

        public Closure_connect_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() throws IllegalStateException {
            String serverAddress = this._gthis.details.getServerAddress();
            if (serverAddress == null) {
                throw new IllegalStateException("Configure the server address before trying to connect");
            }
            if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.actionLogger.info("Connection requested: details: " + Std.string(this._gthis.details) + " options: " + Std.string(this._gthis.options) + " env: " + Std.string(Globals.instance), null);
            }
            this._gthis.defaultServerAddress = serverAddress;
            this._gthis.evtExtConnect();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtRetryTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtRetryTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtRetryTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtRetryTimeout)) {
                return false;
            }
            ClientMachine_evtRetryTimeout other2 = (ClientMachine_evtRetryTimeout)other;
            return this.this == other2.this;
        }
    }

    public static final class Closure_generateFreshSubId_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;

        public Closure_generateFreshSubId_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public int invoke() {
            ++this._gthis.m_nextSubId;
            return this._gthis.m_nextSubId;
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_sendHttpRequest_onText_0
    extends haxe.jvm.Function
    implements BiFunction<Object, Object, Object>,
    Function2<Object, Object, Object>,
    BiConsumer<IHttpClient, String> {
        public final ClientMachine _gthis;

        public Closure_sendHttpRequest_onText_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke(IHttpClient client, String line) {
            Threads_Fields_.sessionThread.exec.execute(new Closure_invoke_0(this._gthis, client, line));
        }

        @Override
        public void accept(IHttpClient arg0, String arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public void accept(Object arg0, Object arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public Object apply(Object arg0, Object arg1) {
            return this.invoke(arg0, arg1);
        }

        public static final class com.lightstreamer.client.internal.ClientMachine$Closure_sendHttpRequest_onText_0$Closure_invoke_0
        extends haxe.jvm.Function
        implements Runnable {
            public final ClientMachine _gthis;
            public final IHttpClient client;
            public final String line;

            /*
             * WARNING - void declaration
             */
            public com.lightstreamer.client.internal.ClientMachine$Closure_sendHttpRequest_onText_0$Closure_invoke_0(ClientMachine _gthis, IHttpClient iHttpClient, String string) {
                void line;
                void client;
                this._gthis = _gthis;
                this.client = client;
                this.line = line;
            }

            @Override
            public void invoke() {
                this._gthis.lock.synchronized(new Closure_invoke_0(this.client, this._gthis, this.line));
            }

            @Override
            public void run() {
                this.invoke();
            }

            public static final class Closure_invoke_0
            extends haxe.jvm.Function
            implements PrivilegedAction<Object>,
            PrivilegedExceptionAction<Object>,
            Callable<Object>,
            Supplier<Object>,
            Function0<Object> {
                public final IHttpClient client;
                public final ClientMachine _gthis;
                public final String line;

                /*
                 * WARNING - void declaration
                 */
                public Closure_invoke_0(IHttpClient client, ClientMachine clientMachine, String string) {
                    void line;
                    void _gthis;
                    this.client = client;
                    this._gthis = _gthis;
                    this.line = line;
                }

                @Override
                public void invoke() {
                    if (this.client.isDisposed()) {
                        return;
                    }
                    try {
                        this._gthis.evtMessage(this.line);
                        return;
                    }
                    catch (Throwable _g) {
                        Exception _g2 = Exception.caught(_g);
                        if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
                            LoggerTools_Fields_.sessionLogger.error("" + _g2.get_message() + "\n" + _g2.details(), null);
                        }
                        this._gthis.evtExtDisconnect(TerminationCause.TC_standardError(61, _g2.get_message()));
                        return;
                    }
                }

                @Override
                public Object get() {
                    return this.invoke();
                }

                @Override
                public Object call() {
                    return this.invoke();
                }

                @Override
                public Object run() {
                    return this.invoke();
                }
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_doMSGFAIL_0
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MessageManager>,
    Function<MessageManager, Boolean>,
    Predicate<MessageManager>,
    Function1<MessageManager, Boolean> {
        public final String sequence;
        public final int p;

        /*
         * WARNING - void declaration
         */
        public Closure_doMSGFAIL_0(String sequence2, int n) {
            void p;
            this.sequence = sequence2;
            this.p = p;
        }

        @Override
        public boolean invoke(MessageManager msg) {
            if (Jvm.stringCompare(msg.sequence, this.sequence) == 0) {
                return msg.prog == this.p;
            }
            return false;
        }

        @Override
        public boolean test(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtTransportTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtTransportTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtTransportTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtTransportTimeout)) {
                return false;
            }
            ClientMachine_evtTransportTimeout other2 = (ClientMachine_evtTransportTimeout)other;
            return this.this == other2.this;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_genAckMessagesWS_0
    extends haxe.jvm.Function
    implements DirectoryStream.Filter<MessageManager>,
    Function<MessageManager, Boolean>,
    Predicate<MessageManager>,
    Function1<MessageManager, Boolean> {
        public static final Closure_genAckMessagesWS_0 ClientMachine$Closure_genAckMessagesWS_0 = new Closure_genAckMessagesWS_0();

        Closure_genAckMessagesWS_0() {
        }

        @Override
        public boolean invoke(MessageManager msg) {
            return msg.isPending();
        }

        @Override
        public boolean test(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(MessageManager arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean test(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean apply(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public boolean accept(Object arg0) {
            return this.invoke(arg0);
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    public static final class Closure_sendHttpRequest_onError_0
    extends haxe.jvm.Function
    implements BiFunction<Object, Object, Object>,
    Function2<Object, Object, Object>,
    BiConsumer<IHttpClient, String> {
        public final ClientMachine _gthis;

        public Closure_sendHttpRequest_onError_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke(IHttpClient client, String error) {
            Threads_Fields_.sessionThread.exec.execute(new Closure_invoke_0(this._gthis, client));
        }

        @Override
        public void accept(IHttpClient arg0, String arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public void accept(Object arg0, Object arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public Object apply(Object arg0, Object arg1) {
            return this.invoke(arg0, arg1);
        }

        public static final class com.lightstreamer.client.internal.ClientMachine$Closure_sendHttpRequest_onError_0$Closure_invoke_0
        extends haxe.jvm.Function
        implements Runnable {
            public final ClientMachine _gthis;
            public final IHttpClient client;

            /*
             * WARNING - void declaration
             */
            public com.lightstreamer.client.internal.ClientMachine$Closure_sendHttpRequest_onError_0$Closure_invoke_0(ClientMachine _gthis, IHttpClient iHttpClient) {
                void client;
                this._gthis = _gthis;
                this.client = client;
            }

            @Override
            public void invoke() {
                this._gthis.lock.synchronized(new Closure_invoke_0(this.client, this._gthis));
            }

            @Override
            public void run() {
                this.invoke();
            }

            public static final class Closure_invoke_0
            extends haxe.jvm.Function
            implements PrivilegedAction<Object>,
            PrivilegedExceptionAction<Object>,
            Callable<Object>,
            Supplier<Object>,
            Function0<Object> {
                public final IHttpClient client;
                public final ClientMachine _gthis;

                /*
                 * WARNING - void declaration
                 */
                public Closure_invoke_0(IHttpClient client, ClientMachine clientMachine) {
                    void _gthis;
                    this.client = client;
                    this._gthis = _gthis;
                }

                @Override
                public void invoke() {
                    if (this.client.isDisposed()) {
                        return;
                    }
                    this._gthis.evtTransportError();
                }

                @Override
                public Object get() {
                    return this.invoke();
                }

                @Override
                public Object call() {
                    return this.invoke();
                }

                @Override
                public Object run() {
                    return this.invoke();
                }
            }
        }
    }

    public static final class Closure_unsubscribe_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription subscription;
        public final ClientMachine _gthis;

        /*
         * WARNING - void declaration
         */
        public Closure_unsubscribe_0(LSSubscription subscription, ClientMachine clientMachine) {
            void _gthis;
            this.subscription = subscription;
            this._gthis = _gthis;
        }

        @Override
        public void invoke() throws IllegalArgumentException {
            SubscriptionManagerLiving sm = this.subscription.fetch_subManager();
            if (sm != null) {
                if (!this._gthis.isRelatedWithSubManager(sm)) {
                    throw new IllegalArgumentException("The Subscription is not subscribed to this Client");
                }
                if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                    LoggerTools_Fields_.actionLogger.info("Unsubscription requested: subId: " + sm.subId + " " + Std.string(this.subscription), null);
                }
                sm.evtExtUnsubscribe();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class ClientMachine_evtStalledTimeout
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine this;

        public ClientMachine_evtStalledTimeout(ClientMachine clientMachine) {
            this.this = clientMachine;
        }

        @Override
        public void invoke() {
            this.this.evtStalledTimeout();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ClientMachine_evtStalledTimeout)) {
                return false;
            }
            ClientMachine_evtStalledTimeout other2 = (ClientMachine_evtStalledTimeout)other;
            return this.this == other2.this;
        }
    }

    public static final class Closure_getAndSetNextMsgProg_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;
        public final String sequence;

        /*
         * WARNING - void declaration
         */
        public Closure_getAndSetNextMsgProg_0(ClientMachine _gthis, String string) {
            void sequence2;
            this._gthis = _gthis;
            this.sequence = sequence2;
        }

        @Override
        public int invoke() {
            Integer prog = Jvm.dynamicToInteger(((StringMap)((IMap)this._gthis.sequenceMap)).get(this.sequence));
            if (prog == null) {
                prog = 1;
            }
            int v = Jvm.toInt(prog) + 1;
            ((StringMap)((IMap)this._gthis.sequenceMap)).set(this.sequence, v);
            return Jvm.toInt(prog);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_openWS_onOpen_0
    extends haxe.jvm.Function
    implements Function<Object, Object>,
    Function1<Object, Object> {
        public final ClientMachine _gthis;

        public Closure_openWS_onOpen_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke(IWsClient client) {
            Threads_Fields_.sessionThread.exec.execute(new Closure_invoke_0(this._gthis, client));
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }

        public static final class com.lightstreamer.client.internal.ClientMachine$Closure_openWS_onOpen_0$Closure_invoke_0
        extends haxe.jvm.Function
        implements Runnable {
            public final ClientMachine _gthis;
            public final IWsClient client;

            /*
             * WARNING - void declaration
             */
            public com.lightstreamer.client.internal.ClientMachine$Closure_openWS_onOpen_0$Closure_invoke_0(ClientMachine _gthis, IWsClient iWsClient) {
                void client;
                this._gthis = _gthis;
                this.client = client;
            }

            @Override
            public void invoke() {
                this._gthis.lock.synchronized(new Closure_invoke_0(this.client, this._gthis));
            }

            @Override
            public void run() {
                this.invoke();
            }

            public static final class Closure_invoke_0
            extends haxe.jvm.Function
            implements PrivilegedAction<Object>,
            PrivilegedExceptionAction<Object>,
            Callable<Object>,
            Supplier<Object>,
            Function0<Object> {
                public final IWsClient client;
                public final ClientMachine _gthis;

                /*
                 * WARNING - void declaration
                 */
                public Closure_invoke_0(IWsClient client, ClientMachine clientMachine) {
                    void _gthis;
                    this.client = client;
                    this._gthis = _gthis;
                }

                @Override
                public void invoke() {
                    if (this.client.isDisposed()) {
                        return;
                    }
                    this._gthis.evtWSOpen();
                }

                @Override
                public Object get() {
                    return this.invoke();
                }

                @Override
                public Object call() {
                    return this.invoke();
                }

                @Override
                public Object run() {
                    return this.invoke();
                }
            }
        }
    }

    public static final class Closure_openWS_onError_0
    extends haxe.jvm.Function
    implements BiFunction<Object, Object, Object>,
    Function2<Object, Object, Object>,
    BiConsumer<IWsClient, String> {
        public final ClientMachine _gthis;

        public Closure_openWS_onError_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke(IWsClient client, String error) {
            Threads_Fields_.sessionThread.exec.execute(new Closure_invoke_0(this._gthis, client));
        }

        @Override
        public void accept(IWsClient arg0, String arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public void accept(Object arg0, Object arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public Object apply(Object arg0, Object arg1) {
            return this.invoke(arg0, arg1);
        }

        public static final class com.lightstreamer.client.internal.ClientMachine$Closure_openWS_onError_0$Closure_invoke_0
        extends haxe.jvm.Function
        implements Runnable {
            public final ClientMachine _gthis;
            public final IWsClient client;

            /*
             * WARNING - void declaration
             */
            public com.lightstreamer.client.internal.ClientMachine$Closure_openWS_onError_0$Closure_invoke_0(ClientMachine _gthis, IWsClient iWsClient) {
                void client;
                this._gthis = _gthis;
                this.client = client;
            }

            @Override
            public void invoke() {
                this._gthis.lock.synchronized(new Closure_invoke_0(this.client, this._gthis));
            }

            @Override
            public void run() {
                this.invoke();
            }

            public static final class Closure_invoke_0
            extends haxe.jvm.Function
            implements PrivilegedAction<Object>,
            PrivilegedExceptionAction<Object>,
            Callable<Object>,
            Supplier<Object>,
            Function0<Object> {
                public final IWsClient client;
                public final ClientMachine _gthis;

                /*
                 * WARNING - void declaration
                 */
                public Closure_invoke_0(IWsClient client, ClientMachine clientMachine) {
                    void _gthis;
                    this.client = client;
                    this._gthis = _gthis;
                }

                @Override
                public void invoke() {
                    if (this.client.isDisposed()) {
                        return;
                    }
                    this._gthis.evtTransportError();
                }

                @Override
                public Object get() {
                    return this.invoke();
                }

                @Override
                public Object call() {
                    return this.invoke();
                }

                @Override
                public Object run() {
                    return this.invoke();
                }
            }
        }
    }

    public static final class Closure_sendHttpRequest_onDone_0
    extends haxe.jvm.Function
    implements Function<Object, Object>,
    Function1<Object, Object> {
        public static final Closure_sendHttpRequest_onDone_0 ClientMachine$Closure_sendHttpRequest_onDone_0 = new Closure_sendHttpRequest_onDone_0();

        Closure_sendHttpRequest_onDone_0() {
        }

        @Override
        public void invoke(IHttpClient client) {
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    public static final class Closure_sendMessage_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final boolean enqueueWhileDisconnected;
        public final ClientMachine _gthis;
        public final String message;
        public final String sequence;
        public final int delayTimeout;
        public final ClientMessageListener listener;
        private static final CompiledPattern _hx_pattern_invoke_0 = EReg.compilePattern("^[a-zA-Z0-9_]*$", "");

        /*
         * WARNING - void declaration
         */
        public Closure_sendMessage_0(boolean enqueueWhileDisconnected, ClientMachine clientMachine, String string, String string2, int n, ClientMessageListener clientMessageListener) {
            void listener;
            void delayTimeout;
            void sequence2;
            void message;
            void _gthis;
            this.enqueueWhileDisconnected = enqueueWhileDisconnected;
            this._gthis = _gthis;
            this.message = message;
            this.sequence = sequence2;
            this.delayTimeout = delayTimeout;
            this.listener = listener;
        }

        @Override
        public void invoke() throws IllegalArgumentException {
            if (!this.enqueueWhileDisconnected && (this._gthis.state.inDisconnected() || this._gthis.state.inRetryUnit())) {
                if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                    StringMap<String> _g = new StringMap<String>();
                    _g.set("text", this.message);
                    _g.set("sequence", this.sequence != null ? this.sequence : "UNORDERED_MESSAGES");
                    _g.set("timeout", Std.string(this.delayTimeout));
                    _g.set("enqueueWhileDisconnected", Std.string(this.enqueueWhileDisconnected));
                    if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                        LoggerTools_Fields_.actionLogger.info("Message sending requested: " + (_g == null ? "null" : _g.toString()), null);
                    }
                }
                if (LoggerTools_Fields_.messageLogger.isWarnEnabled()) {
                    LoggerTools_Fields_.messageLogger.warn("Message " + (this.sequence != null ? this.sequence : "UNORDERED_MESSAGES") + " " + this.message + " aborted", null);
                }
                if (this.listener != null) {
                    MessageEventDispatcher dispatcher = new MessageEventDispatcher();
                    dispatcher.addListener(this.listener);
                    dispatcher.onAbort(this.message, false);
                }
                return;
            }
            if (this.sequence != null) {
                if (!new EReg(_hx_pattern_invoke_0).match(this.sequence)) {
                    throw new IllegalArgumentException("The given sequence name is not valid. Use only alphanumeric characters plus underscore or null");
                }
                MessageManager msg = new MessageManager(this.message, this.sequence, this.delayTimeout, this.listener, this.enqueueWhileDisconnected, this._gthis);
                if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                    LoggerTools_Fields_.actionLogger.info("Message sending requested: " + Std.string(msg), null);
                }
                msg.evtExtSendMessage();
                return;
            }
            MessageManager msg = new MessageManager(this.message, "UNORDERED_MESSAGES", this.delayTimeout, this.listener, this.enqueueWhileDisconnected, this._gthis);
            if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.actionLogger.info("Message sending requested: " + Std.string(msg), null);
            }
            msg.evtExtSendMessage();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_subscribeExt_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSSubscription subscription;
        public final ClientMachine _gthis;
        public final boolean isInternal;

        /*
         * WARNING - void declaration
         */
        public Closure_subscribeExt_0(LSSubscription subscription, ClientMachine clientMachine, boolean bl) {
            void isInternal;
            void _gthis;
            this.subscription = subscription;
            this._gthis = _gthis;
            this.isInternal = isInternal;
        }

        @Override
        public void invoke() throws IllegalStateException, IllegalArgumentException {
            if (this.subscription.isActive()) {
                throw new IllegalStateException("Cannot subscribe to an active Subscription");
            }
            if (this.subscription.fetchItems() == null && this.subscription.getItemGroup() == null) {
                throw new IllegalArgumentException("Specify property 'items' or 'itemGroup'");
            }
            if (this.subscription.fetchFields() == null && this.subscription.getFieldSchema() == null) {
                throw new IllegalArgumentException("Specify property 'fields' or 'fieldSchema'");
            }
            SubscriptionManagerLiving sm = new SubscriptionManagerLiving(this.subscription, this._gthis);
            if (LoggerTools_Fields_.actionLogger.isInfoEnabled()) {
                LoggerTools_Fields_.actionLogger.info("" + (this.isInternal ? "Internal subscription" : "Subscription") + " requested: subId: " + sm.subId + " " + Std.string(this.subscription), null);
            }
            sm.evtExtSubscribe();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    @EnumReflectionInformation(constructorNames={"BFB_none", "BFB_ws_streaming", "BFB_ws_polling", "BFB_http_streaming", "BFB_http_polling"})
    public static abstract class BestForBindingEnum
    extends Enum {
        public static final /* enum */ BestForBindingEnum BFB_none = new BFB_none();
        public static final /* enum */ BestForBindingEnum BFB_ws_streaming = new BFB_ws_streaming();
        public static final /* enum */ BestForBindingEnum BFB_ws_polling = new BFB_ws_polling();
        public static final /* enum */ BestForBindingEnum BFB_http_streaming = new BFB_http_streaming();
        public static final /* enum */ BestForBindingEnum BFB_http_polling = new BFB_http_polling();

        /*
         * WARNING - void declaration
         */
        protected BestForBindingEnum(int n, String string) {
            void name;
            void index;
        }

        public static BestForBindingEnum[] values() {
            return new BestForBindingEnum[]{BFB_none, BFB_ws_streaming, BFB_ws_polling, BFB_http_streaming, BFB_http_polling};
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class BFB_ws_polling
        extends BestForBindingEnum {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class BFB_none
        extends BestForBindingEnum {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class BFB_http_streaming
        extends BestForBindingEnum {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class BFB_ws_streaming
        extends BestForBindingEnum {
        }

        @EnumValueReflectionInformation(argumentNames={})
        public static final class BFB_http_polling
        extends BestForBindingEnum {
        }
    }

    public static final class Closure_unrelateMsgManager_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;
        public final MessageManager msgManager;

        /*
         * WARNING - void declaration
         */
        public Closure_unrelateMsgManager_0(ClientMachine _gthis, MessageManager messageManager) {
            void msgManager;
            this._gthis = _gthis;
            this.msgManager = msgManager;
        }

        @Override
        public void invoke() {
            this._gthis.messageManagers.remove(this.msgManager);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_doInstallPageLifecycle_0
    extends haxe.jvm.Function
    implements Function<Object, Object>,
    Function1<Object, Object> {
        public final ClientMachine _gthis;

        public Closure_doInstallPageLifecycle_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke(PageState e) {
            switch (e.ordinal()) {
                case 0: {
                    this._gthis.evtPageFrozen();
                    break;
                }
                case 1: {
                    this._gthis.evtPageResumed();
                }
            }
        }

        @Override
        public Object apply(Object arg0) {
            return this.invoke(arg0);
        }
    }

    public static final class Closure_openWS_onText_0
    extends haxe.jvm.Function
    implements BiFunction<Object, Object, Object>,
    Function2<Object, Object, Object>,
    BiConsumer<IWsClient, String> {
        public final ClientMachine _gthis;

        public Closure_openWS_onText_0(ClientMachine _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke(IWsClient client, String line) {
            Threads_Fields_.sessionThread.exec.execute(new Closure_invoke_0(this._gthis, client, line));
        }

        @Override
        public void accept(IWsClient arg0, String arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public void accept(Object arg0, Object arg1) {
            this.invoke(arg0, arg1);
        }

        @Override
        public Object apply(Object arg0, Object arg1) {
            return this.invoke(arg0, arg1);
        }

        public static final class com.lightstreamer.client.internal.ClientMachine$Closure_openWS_onText_0$Closure_invoke_0
        extends haxe.jvm.Function
        implements Runnable {
            public final ClientMachine _gthis;
            public final IWsClient client;
            public final String line;

            /*
             * WARNING - void declaration
             */
            public com.lightstreamer.client.internal.ClientMachine$Closure_openWS_onText_0$Closure_invoke_0(ClientMachine _gthis, IWsClient iWsClient, String string) {
                void line;
                void client;
                this._gthis = _gthis;
                this.client = client;
                this.line = line;
            }

            @Override
            public void invoke() {
                this._gthis.lock.synchronized(new Closure_invoke_0(this.client, this._gthis, this.line));
            }

            @Override
            public void run() {
                this.invoke();
            }

            public static final class Closure_invoke_0
            extends haxe.jvm.Function
            implements PrivilegedAction<Object>,
            PrivilegedExceptionAction<Object>,
            Callable<Object>,
            Supplier<Object>,
            Function0<Object> {
                public final IWsClient client;
                public final ClientMachine _gthis;
                public final String line;

                /*
                 * WARNING - void declaration
                 */
                public Closure_invoke_0(IWsClient client, ClientMachine clientMachine, String string) {
                    void line;
                    void _gthis;
                    this.client = client;
                    this._gthis = _gthis;
                    this.line = line;
                }

                @Override
                public void invoke() {
                    if (this.client.isDisposed()) {
                        return;
                    }
                    try {
                        this._gthis.evtMessage(this.line);
                        return;
                    }
                    catch (Throwable _g) {
                        Exception _g2 = Exception.caught(_g);
                        if (LoggerTools_Fields_.sessionLogger.isErrorEnabled()) {
                            LoggerTools_Fields_.sessionLogger.error("" + _g2.get_message() + "\n" + _g2.details(), null);
                        }
                        this._gthis.evtExtDisconnect(TerminationCause.TC_standardError(61, _g2.get_message()));
                        return;
                    }
                }

                @Override
                public Object get() {
                    return this.invoke();
                }

                @Override
                public Object call() {
                    return this.invoke();
                }

                @Override
                public Object run() {
                    return this.invoke();
                }
            }
        }
    }

    public static final class Closure_relateMsgManager_0
    extends haxe.jvm.Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final ClientMachine _gthis;
        public final MessageManager msgManager;

        /*
         * WARNING - void declaration
         */
        public Closure_relateMsgManager_0(ClientMachine _gthis, MessageManager messageManager) {
            void msgManager;
            this._gthis = _gthis;
            this.msgManager = msgManager;
        }

        @Override
        public void invoke() {
            this._gthis.messageManagers.values.push(new MyArray.Pair<MessageManager>(this.msgManager));
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }
}

