/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.internal;

import com.lightstreamer.internal.RLock;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Std;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.InMemoryCookieStore;
import java.net.URI;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;

@ClassReflectionInformation(hasSuperClass=false)
public class CookieHelper
extends haxe.jvm.Object {
    public static CookieHelper instance = new CookieHelper();
    public boolean firstTime;
    public CookieManager cookieHandler;
    public RLock lock;

    public void addCookies(URI uri, List cookies) {
        CookieHelper _gthis = this;
        this.lock.synchronized(new Closure_addCookies_0(_gthis, uri, cookies));
    }

    public List getCookies(URI uri) {
        CookieHelper _gthis = this;
        return (List)this.lock.synchronized(new Closure_getCookies_0(_gthis, uri));
    }

    public void clearCookies() {
        CookieHelper _gthis = this;
        this.lock.synchronized(new Closure_clearCookies_0(_gthis));
    }

    public CookieStore getCookieStore() {
        CookieManager manager;
        CookieHandler handler = this.getCookieHandler();
        CookieManager cookieManager = manager = Std.isOfType(handler, CookieManager.class) ? (CookieManager)handler : null;
        if (manager == null) {
            return null;
        }
        return manager.getCookieStore();
    }

    public CookieHandler getCookieHandler() {
        CookieHelper _gthis = this;
        return (CookieHandler)this.lock.synchronized(new Closure_getCookieHandler_0(_gthis));
    }

    public void logCookies(String message, List cookies) {
        for (HttpCookie cookie : cookies) {
            message = Jvm.stringConcat(message, "\r\n    " + cookie.toString());
            message = Jvm.stringConcat(message, " - domain " + cookie.getDomain());
            message = Jvm.stringConcat(message, " - path " + cookie.getPath());
            message = Jvm.stringConcat(message, " - expired " + Std.string(cookie.hasExpired()));
            message = Jvm.stringConcat(message, " - ports " + cookie.getPortlist());
            message = Jvm.stringConcat(message, " - secure " + Std.string(cookie.getSecure()));
            message = Jvm.stringConcat(message, " - max-age " + ("" + Std.string(cookie.getMaxAge())));
            message = Jvm.stringConcat(message, " - discard " + Std.string(cookie.getDiscard()));
            message = Jvm.stringConcat(message, " - version " + cookie.getVersion());
        }
        if (LoggerTools_Fields_.cookieLogger.isDebugEnabled()) {
            LoggerTools_Fields_.cookieLogger.debug(message, null);
        }
    }

    public CookieHelper() {
        this.firstTime = true;
        this.lock = new RLock();
    }

    public /* synthetic */ CookieHelper(EmptyConstructor _) {
    }

    public static final class Closure_addCookies_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final CookieHelper _gthis;
        public final URI uri;
        public final List cookies;

        /*
         * WARNING - void declaration
         */
        public Closure_addCookies_0(CookieHelper _gthis, URI uRI, List list) {
            void cookies;
            void uri;
            this._gthis = _gthis;
            this.uri = uri;
            this.cookies = cookies;
        }

        @Override
        public void invoke() {
            CookieStore store = this._gthis.getCookieStore();
            if (store != null) {
                if (LoggerTools_Fields_.cookieLogger.isDebugEnabled()) {
                    this._gthis.logCookies("Before adding cookies for " + Std.string(this.uri), store.getCookies());
                    this._gthis.logCookies("Cookies to be added for " + Std.string(this.uri), this.cookies);
                }
                for (HttpCookie cookie : this.cookies) {
                    store.add(this.uri, cookie);
                }
                if (LoggerTools_Fields_.cookieLogger.isDebugEnabled()) {
                    this._gthis.logCookies("After adding cookies for " + Std.string(this.uri), store.getCookies());
                }
                return;
            }
            if (LoggerTools_Fields_.cookieLogger.isWarnEnabled()) {
                LoggerTools_Fields_.cookieLogger.warn("Global CookieHandler not suitable for cookie storage", null);
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getCookies_0
    extends Function
    implements PrivilegedAction<List<HttpCookie>>,
    PrivilegedExceptionAction<List<HttpCookie>>,
    Callable<List<HttpCookie>>,
    Supplier<List<HttpCookie>>,
    Function0<List<HttpCookie>> {
        public final CookieHelper _gthis;
        public final URI uri;

        /*
         * WARNING - void declaration
         */
        public Closure_getCookies_0(CookieHelper _gthis, URI uRI) {
            void uri;
            this._gthis = _gthis;
            this.uri = uri;
        }

        @Override
        public List invoke() {
            CookieStore store = this._gthis.getCookieStore();
            if (store != null) {
                if (this.uri == null) {
                    if (LoggerTools_Fields_.cookieLogger.isDebugEnabled()) {
                        this._gthis.logCookies("While extracting cookies", store.getCookies());
                    }
                    return store.getCookies();
                }
                if (LoggerTools_Fields_.cookieLogger.isDebugEnabled()) {
                    this._gthis.logCookies("While getting cookies for " + Std.string(this.uri), store.getCookies());
                    this._gthis.logCookies("Result of getting cookies for " + Std.string(this.uri), store.get(this.uri));
                }
                return store.get(this.uri);
            }
            if (LoggerTools_Fields_.cookieLogger.isWarnEnabled()) {
                LoggerTools_Fields_.cookieLogger.warn("Global CookieHandler not suitable for cookie retrieval", null);
            }
            return Collections.emptyList();
        }

        @Override
        public List get() {
            return this.invoke();
        }

        @Override
        public List call() {
            return this.invoke();
        }

        @Override
        public List run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_clearCookies_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final CookieHelper _gthis;

        public Closure_clearCookies_0(CookieHelper _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            CookieStore store = this._gthis.getCookieStore();
            if (store != null) {
                store.removeAll();
            }
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getCookieHandler_0
    extends Function
    implements PrivilegedAction<CookieHandler>,
    PrivilegedExceptionAction<CookieHandler>,
    Callable<CookieHandler>,
    Supplier<CookieHandler>,
    Function0<CookieHandler> {
        public final CookieHelper _gthis;

        public Closure_getCookieHandler_0(CookieHelper _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public CookieHandler invoke() {
            if (this._gthis.firstTime) {
                this._gthis.firstTime = false;
                if (CookieHandler.getDefault() == null) {
                    this._gthis.cookieHandler = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
                    if (LoggerTools_Fields_.cookieLogger.isInfoEnabled()) {
                        LoggerTools_Fields_.cookieLogger.info("Setting up custom CookieHandler: " + Std.string(this._gthis.cookieHandler), null);
                    }
                    CookieStore defaultStore = this._gthis.cookieHandler.getCookieStore();
                    if (LoggerTools_Fields_.cookieLogger.isInfoEnabled()) {
                        LoggerTools_Fields_.cookieLogger.info("Default CookieStore type: " + ((Class)((Function)Jvm.readField(defaultStore, "getClass")).invoke()).getName(), null);
                    }
                    if (Jvm.stringCompare(((Class)((Function)Jvm.readField(defaultStore, "getClass")).invoke()).getName(), "sun.net.www.protocol.http.InMemoryCookieStore") == 0 || Jvm.stringCompare(((Class)((Function)Jvm.readField(defaultStore, "getClass")).invoke()).getName(), "java.net.CookieStoreImpl") == 0) {
                        this._gthis.cookieHandler = new CookieManager(new InMemoryCookieStore(), CookiePolicy.ACCEPT_ALL);
                        if (LoggerTools_Fields_.cookieLogger.isInfoEnabled()) {
                            LoggerTools_Fields_.cookieLogger.info("Improving the custom CookieHandler: " + Std.string(this._gthis.cookieHandler), null);
                        }
                    }
                } else if (LoggerTools_Fields_.cookieLogger.isInfoEnabled()) {
                    LoggerTools_Fields_.cookieLogger.info("Will use the default CookieHandler", null);
                }
            }
            if (this._gthis.cookieHandler != null) {
                return this._gthis.cookieHandler;
            }
            CookieHandler currentHandler = CookieHandler.getDefault();
            if (LoggerTools_Fields_.cookieLogger.isDebugEnabled()) {
                LoggerTools_Fields_.cookieLogger.debug("Using the current default CookieHandler: " + Std.string(currentHandler), null);
            }
            return currentHandler;
        }

        @Override
        public CookieHandler get() {
            return this.invoke();
        }

        @Override
        public CookieHandler call() {
            return this.invoke();
        }

        @Override
        public CookieHandler run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }
}

