/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.client;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.util.Named;
import com.lightstreamer.client.ClientEventDispatcher;
import com.lightstreamer.client.ClientListener;
import com.lightstreamer.client.ClientMessageListener;
import com.lightstreamer.client.LSConnectionDetails;
import com.lightstreamer.client.LSConnectionOptions;
import com.lightstreamer.client.LSSubscription;
import com.lightstreamer.client.internal.ClientMachine;
import com.lightstreamer.internal.CookieHelper;
import com.lightstreamer.internal.Factory;
import com.lightstreamer.internal.Globals;
import com.lightstreamer.internal.RLock;
import com.lightstreamer.internal._Constants.Constants_Fields_;
import com.lightstreamer.internal._NativeTypes.NativeList_Impl_;
import com.lightstreamer.log.LogManager;
import com.lightstreamer.log.LoggerProvider;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import java.net.ProtocolFamily;
import java.net.URI;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.AttributeView;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import javax.net.ssl.TrustManagerFactory;
import kotlin.jvm.functions.Function0;

@ClassReflectionInformation(hasSuperClass=false)
public class LSLightstreamerClient
extends haxe.jvm.Object {
    public static String LIB_NAME = Constants_Fields_.LS_LIB_NAME;
    public static String LIB_VERSION = Constants_Fields_.LS_LIB_VERSION;
    public LSConnectionDetails connectionDetails;
    public LSConnectionOptions connectionOptions;
    public ClientEventDispatcher eventDispatcher;
    public ClientMachine machine;
    public RLock lock;

    public static void setLoggerProvider(LoggerProvider provider) {
        LogManager.setLoggerProvider(provider);
    }

    public static void addCookies(URI uri, List cookies) {
        CookieHelper.instance.addCookies(uri, cookies);
    }

    public static List getCookies(URI uri) {
        return CookieHelper.instance.getCookies(uri);
    }

    public static void setTrustManagerFactory(TrustManagerFactory factory2) {
        Globals.instance.setTrustManagerFactory(factory2);
    }

    public void addListener(ClientListener listener) {
        LSLightstreamerClient _gthis = this;
        this.lock.synchronized(new Closure_addListener_0(_gthis, listener));
    }

    public void removeListener(ClientListener listener) {
        LSLightstreamerClient _gthis = this;
        this.lock.synchronized(new Closure_removeListener_0(_gthis, listener));
    }

    public List getListeners() {
        LSLightstreamerClient _gthis = this;
        return (List)this.lock.synchronized(new Closure_getListeners_0(_gthis));
    }

    public void connect() {
        LSLightstreamerClient _gthis = this;
        this.lock.synchronized(new Closure_connect_0(_gthis));
    }

    public void disconnect() {
        LSLightstreamerClient _gthis = this;
        this.lock.synchronized(new Closure_disconnect_0(_gthis));
    }

    public FutureTask disconnectFuture() {
        LSLightstreamerClient _gthis = this;
        return (FutureTask)this.lock.synchronized(new Closure_disconnectFuture_0(_gthis));
    }

    public String getStatus() {
        LSLightstreamerClient _gthis = this;
        return (String)this.lock.synchronized(new Closure_getStatus_0(_gthis));
    }

    public void sendMessage(String message) {
        LSLightstreamerClient _gthis = this;
        this.lock.synchronized(new Closure_sendMessage_0(_gthis, message));
    }

    public void sendMessage(String message, String sequence2, int delayTimeout, ClientMessageListener listener, boolean enqueueWhileDisconnected) {
        LSLightstreamerClient _gthis = this;
        this.lock.synchronized(new Closure_sendMessage_1(_gthis, message, sequence2, delayTimeout, listener, enqueueWhileDisconnected));
    }

    public void subscribe(LSSubscription subscription) {
        LSLightstreamerClient _gthis = this;
        this.lock.synchronized(new Closure_subscribe_0(_gthis, subscription));
    }

    public void unsubscribe(LSSubscription subscription) {
        LSLightstreamerClient _gthis = this;
        this.lock.synchronized(new Closure_unsubscribe_0(_gthis, subscription));
    }

    public List getSubscriptions() {
        LSLightstreamerClient _gthis = this;
        return (List)this.lock.synchronized(new Closure_getSubscriptions_0(_gthis));
    }

    public List getSubscriptionWrappers() {
        LSLightstreamerClient _gthis = this;
        return (List)this.lock.synchronized(new Closure_getSubscriptionWrappers_0(_gthis));
    }

    public LSLightstreamerClient(String serverAddress, String adapterSet) {
        this.eventDispatcher = new ClientEventDispatcher();
        this.lock = new RLock();
        this.connectionDetails = new LSConnectionDetails(this);
        this.connectionOptions = new LSConnectionOptions(this);
        this.machine = new ClientMachine(this, new Factory(this));
        if (serverAddress != null) {
            this.connectionDetails.setServerAddress(serverAddress);
        }
        if (adapterSet != null) {
            this.connectionDetails.setAdapterSet(adapterSet);
        }
    }

    public /* synthetic */ LSLightstreamerClient(EmptyConstructor _) {
    }

    public static final class Closure_removeListener_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSLightstreamerClient _gthis;
        public final ClientListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_removeListener_0(LSLightstreamerClient _gthis, ClientListener clientListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.removeListenerAndFireOnListenEnd(this.listener);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_disconnectFuture_0
    extends Function
    implements PrivilegedAction<FutureTask<Object>>,
    PrivilegedExceptionAction<FutureTask<Object>>,
    Callable<FutureTask<Object>>,
    Supplier<FutureTask<Object>>,
    Function0<FutureTask<Object>> {
        public final LSLightstreamerClient _gthis;

        public Closure_disconnectFuture_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public FutureTask invoke() {
            return this._gthis.machine.disconnectFuture();
        }

        @Override
        public FutureTask get() {
            return this.invoke();
        }

        @Override
        public FutureTask call() {
            return this.invoke();
        }

        @Override
        public FutureTask run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_sendMessage_1
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSLightstreamerClient _gthis;
        public final String message;
        public final String sequence;
        public final int delayTimeout;
        public final ClientMessageListener listener;
        public final boolean enqueueWhileDisconnected;

        /*
         * WARNING - void declaration
         */
        public Closure_sendMessage_1(LSLightstreamerClient _gthis, String string, String string2, int n, ClientMessageListener clientMessageListener, boolean bl) {
            void enqueueWhileDisconnected;
            void listener;
            void delayTimeout;
            void sequence2;
            void message;
            this._gthis = _gthis;
            this.message = message;
            this.sequence = sequence2;
            this.delayTimeout = delayTimeout;
            this.listener = listener;
            this.enqueueWhileDisconnected = enqueueWhileDisconnected;
        }

        @Override
        public void invoke() {
            this._gthis.machine.sendMessage(this.message, this.sequence, this.delayTimeout, this.listener, this.enqueueWhileDisconnected);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_connect_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSLightstreamerClient _gthis;

        public Closure_connect_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.machine.connect();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_subscribe_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSLightstreamerClient _gthis;
        public final LSSubscription subscription;

        /*
         * WARNING - void declaration
         */
        public Closure_subscribe_0(LSLightstreamerClient _gthis, LSSubscription lSSubscription) {
            void subscription;
            this._gthis = _gthis;
            this.subscription = subscription;
        }

        @Override
        public void invoke() {
            this._gthis.machine.subscribeExt(this.subscription, null);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getSubscriptionWrappers_0
    extends Function
    implements PrivilegedAction<List<Object>>,
    PrivilegedExceptionAction<List<Object>>,
    Callable<List<Object>>,
    Supplier<List<Object>>,
    Function0<List<Object>> {
        public final LSLightstreamerClient _gthis;

        public Closure_getSubscriptionWrappers_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public List invoke() {
            Array<Object> _g = Array.ofNative(new Object[0]);
            Array _g2 = this._gthis.machine.getSubscriptions();
            for (int _g1 = 0; _g1 < _g2.length; ++_g1) {
                LSSubscription sub = (LSSubscription)_g2.__get(_g1);
                if (sub.wrapper == null) continue;
                _g.push(sub.wrapper);
            }
            return NativeList_Impl_._new(_g);
        }

        @Override
        public List get() {
            return this.invoke();
        }

        @Override
        public List call() {
            return this.invoke();
        }

        @Override
        public List run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_sendMessage_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSLightstreamerClient _gthis;
        public final String message;

        /*
         * WARNING - void declaration
         */
        public Closure_sendMessage_0(LSLightstreamerClient _gthis, String string) {
            void message;
            this._gthis = _gthis;
            this.message = message;
        }

        @Override
        public void invoke() {
            this._gthis.machine.sendMessage(this.message, null, -1, null, false);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_addListener_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSLightstreamerClient _gthis;
        public final ClientListener listener;

        /*
         * WARNING - void declaration
         */
        public Closure_addListener_0(LSLightstreamerClient _gthis, ClientListener clientListener) {
            void listener;
            this._gthis = _gthis;
            this.listener = listener;
        }

        @Override
        public void invoke() {
            this._gthis.eventDispatcher.addListenerAndFireOnListenStart(this.listener);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_disconnect_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSLightstreamerClient _gthis;

        public Closure_disconnect_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public void invoke() {
            this._gthis.machine.disconnect();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getSubscriptions_0
    extends Function
    implements PrivilegedAction<List<LSSubscription>>,
    PrivilegedExceptionAction<List<LSSubscription>>,
    Callable<List<LSSubscription>>,
    Supplier<List<LSSubscription>>,
    Function0<List<LSSubscription>> {
        public final LSLightstreamerClient _gthis;

        public Closure_getSubscriptions_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public List invoke() {
            return NativeList_Impl_._new(this._gthis.machine.getSubscriptions());
        }

        @Override
        public List get() {
            return this.invoke();
        }

        @Override
        public List call() {
            return this.invoke();
        }

        @Override
        public List run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getStatus_0
    extends Function
    implements FormatSchema,
    Named,
    PrivilegedAction<String>,
    PrivilegedExceptionAction<String>,
    ProtocolFamily,
    WatchEvent.Modifier,
    AttributeView,
    Callable<String>,
    Supplier<String>,
    Function0<String> {
        public final LSLightstreamerClient _gthis;

        public Closure_getStatus_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public String invoke() {
            return this._gthis.machine.getStatus();
        }

        @Override
        public String get() {
            return this.invoke();
        }

        @Override
        public String call() {
            return this.invoke();
        }

        @Override
        public String name() {
            return this.invoke();
        }

        @Override
        public String run() {
            return this.invoke();
        }

        @Override
        public String getName() {
            return this.invoke();
        }

        @Override
        public String getSchemaType() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class Closure_getListeners_0
    extends Function
    implements PrivilegedAction<List<ClientListener>>,
    PrivilegedExceptionAction<List<ClientListener>>,
    Callable<List<ClientListener>>,
    Supplier<List<ClientListener>>,
    Function0<List<ClientListener>> {
        public final LSLightstreamerClient _gthis;

        public Closure_getListeners_0(LSLightstreamerClient _gthis) {
            this._gthis = _gthis;
        }

        @Override
        public List invoke() {
            return NativeList_Impl_._new(this._gthis.eventDispatcher.getListeners());
        }

        @Override
        public List get() {
            return this.invoke();
        }

        @Override
        public List call() {
            return this.invoke();
        }

        @Override
        public List run() {
            return this.invoke();
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }

    public static final class Closure_unsubscribe_0
    extends Function
    implements PrivilegedAction<Object>,
    PrivilegedExceptionAction<Object>,
    Callable<Object>,
    Supplier<Object>,
    Function0<Object> {
        public final LSLightstreamerClient _gthis;
        public final LSSubscription subscription;

        /*
         * WARNING - void declaration
         */
        public Closure_unsubscribe_0(LSLightstreamerClient _gthis, LSSubscription lSSubscription) {
            void subscription;
            this._gthis = _gthis;
            this.subscription = subscription;
        }

        @Override
        public void invoke() {
            this._gthis.machine.unsubscribe(this.subscription);
        }

        @Override
        public Object get() {
            return this.invoke();
        }

        @Override
        public Object call() {
            return this.invoke();
        }

        @Override
        public Object run() {
            return this.invoke();
        }
    }
}

