/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.internal;

import com.lightstreamer.client.LSConnectionOptions;
import com.lightstreamer.client.LSLightstreamerClient;
import com.lightstreamer.client.LSProxy;
import com.lightstreamer.internal.Globals;
import com.lightstreamer.internal.HttpClient;
import com.lightstreamer.internal.IFactory;
import com.lightstreamer.internal.IHttpClient;
import com.lightstreamer.internal.IPageLifecycle;
import com.lightstreamer.internal.IReachability;
import com.lightstreamer.internal.ITimer;
import com.lightstreamer.internal.IWsClient;
import com.lightstreamer.internal.PageLifecycle;
import com.lightstreamer.internal.ReachabilityManager;
import com.lightstreamer.internal.TimerImpl;
import com.lightstreamer.internal.WsClient;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Std;
import javax.net.ssl.TrustManagerFactory;

@ClassReflectionInformation(hasSuperClass=false)
public class Factory
extends haxe.jvm.Object
implements IFactory {
    public LSConnectionOptions connectionOptions;

    @Override
    public IWsClient createWsClient(String url, StringMap headers, Function onOpen, Function onText, Function onError) {
        LSProxy proxy = this.connectionOptions.getProxy();
        TrustManagerFactory trustManager = Globals.instance.getTrustManagerFactory();
        return new WsClient(url, headers, proxy, trustManager, onOpen, onText, onError);
    }

    @Override
    public IHttpClient createHttpClient(String url, String body, StringMap headers, Function onText, Function onError, Function onDone) {
        LSProxy proxy = this.connectionOptions.getProxy();
        TrustManagerFactory trustManager = Globals.instance.getTrustManagerFactory();
        return new HttpClient(url, body, headers, proxy, trustManager, onText, onError, onDone);
    }

    @Override
    public IHttpClient createCtrlClient(String url, String body, StringMap headers, Function onText, Function onError, Function onDone) {
        return this.createHttpClient(url, body, headers, onText, onError, onDone);
    }

    @Override
    public IReachability createReachabilityManager(String host) {
        return new ReachabilityManager();
    }

    @Override
    public ITimer createTimer(String id, long delay, Function callback) {
        return new TimerImpl(id, delay, callback);
    }

    @Override
    public long randomMillis(long max) {
        return Std.random((int)max);
    }

    @Override
    public IPageLifecycle createPageLifecycleFactory(Function onEvent) {
        return new PageLifecycle(onEvent);
    }

    public Factory(LSLightstreamerClient client) {
        this.connectionOptions = client.connectionOptions;
    }

    public /* synthetic */ Factory(EmptyConstructor _) {
    }
}

