/*
 * Decompiled with CFR 0.152.
 */
package com.lightstreamer.internal;

import com.lightstreamer.client.LSProxy;
import com.lightstreamer.internal.CookieHelper;
import com.lightstreamer.internal.HttpClient;
import com.lightstreamer.internal.IWsClient;
import com.lightstreamer.internal._Constants.Constants_Fields_;
import com.lightstreamer.log._LoggerTools.LoggerTools_Fields_;
import haxe.ds.StringMap;
import haxe.jvm.EmptyConstructor;
import haxe.jvm.Function;
import haxe.jvm.Jvm;
import haxe.jvm.StringExt;
import haxe.jvm.annotation.ClassReflectionInformation;
import haxe.root.Array;
import haxe.root.Std;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.JavaNetCookieJar;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;

@ClassReflectionInformation(hasSuperClass=true)
public class WsClient
extends WebSocketListener
implements Authenticator,
IWsClient {
    public WebSocket ws;
    public LSProxy proxy;
    public Function onOpenCb;
    public Function onTextCb;
    public Function onErrorCb;
    public volatile boolean isCanceled;

    @Override
    public void send(String txt) {
        if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
            LoggerTools_Fields_.streamLogger.debug("WS sending: " + txt, null);
        }
        this.ws.send(txt);
    }

    @Override
    public void dispose() {
        if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
            LoggerTools_Fields_.streamLogger.debug("WS disposing", null);
        }
        this.isCanceled = true;
        this.ws.close(1000, "");
        this.ws.cancel();
    }

    @Override
    public boolean isDisposed() {
        return this.isCanceled;
    }

    @Override
    public void onOpen(WebSocket webSocket, Response response) {
        if (this.isCanceled) {
            return;
        }
        if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
            LoggerTools_Fields_.streamLogger.debug("WS event: open", null);
        }
        this.onOpenCb.invoke(this);
    }

    @Override
    public void onMessage(WebSocket webSocket, String text) {
        if (this.isCanceled) {
            return;
        }
        int _g = 0;
        Array _g1 = StringExt.split(text, "\r\n");
        while (_g < _g1.length) {
            String line = (String)_g1.__get(_g);
            ++_g;
            if (this.isCanceled) {
                return;
            }
            if (Jvm.stringCompare(line, "") == 0) continue;
            if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
                LoggerTools_Fields_.streamLogger.debug("WS event: text(" + line + ")", null);
            }
            this.onTextCb.invoke(this, line);
        }
    }

    @Override
    public void onFailure(WebSocket webSocket, Throwable ex, Response response) {
        if (this.isCanceled) {
            return;
        }
        String msg = ex.getMessage();
        if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
            LoggerTools_Fields_.streamLogger.debug("WS event: error(" + msg + ")", ex);
        }
        this.onErrorCb.invoke(this, msg);
        webSocket.cancel();
    }

    @Override
    public void onClosing(WebSocket webSocket, int code, String reason) {
        if (this.isCanceled) {
            return;
        }
        String msg = "unexpected disconnection: " + code + " - " + reason;
        if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
            LoggerTools_Fields_.streamLogger.debug("WS event: error(" + msg + ")", null);
        }
        this.onErrorCb.invoke(this, msg);
        webSocket.cancel();
    }

    @Override
    public Request authenticate(Route route, Response response) throws IllegalStateException {
        String password;
        if (this.proxy == null) {
            throw new IllegalStateException("Assertion failure: " + "proxy != null");
        }
        String user = this.proxy.user == null ? "" : this.proxy.user;
        String string = password = this.proxy.password == null ? "" : this.proxy.password;
        if (response.request().header("Proxy-Authorization") != null) {
            return null;
        }
        String credential = Credentials.basic(user, password);
        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
    }

    /*
     * Unable to fully structure code
     */
    public WsClient(String url, StringMap headers, LSProxy proxy, TrustManagerFactory trustManagerFactory, Function onOpen, Function onText, Function onError) throws IllegalStateException {
        this.isCanceled = false;
        super();
        if (LoggerTools_Fields_.streamLogger.isDebugEnabled()) {
            LoggerTools_Fields_.streamLogger.debug("WS connecting: " + url + " headers(" + (headers == null ? "null" : headers.toString()) + ") proxy(" + Std.string(proxy) + ") trustManager(" + Std.string(trustManagerFactory) + ")", null);
        }
        this.proxy = proxy;
        this.onOpenCb = onOpen;
        this.onTextCb = onText;
        this.onErrorCb = onError;
        reqBuilder = new Request.Builder();
        if (headers != null) {
            map = headers;
            _g_keys = map.keys();
            while (_g_keys.hasNext()) {
                key = (String)_g_keys.next();
                _g_value = (String)map.get(key);
                reqBuilder.header(key, _g_value);
            }
        }
        reqBuilder.header("Sec-WebSocket-Protocol", Constants_Fields_.FULL_TLCP_VERSION);
        reqBuilder.url(url);
        request = reqBuilder.build();
        clientBuilder = HttpClient.client.newBuilder();
        cookieHandler = CookieHelper.instance.getCookieHandler();
        if (cookieHandler != null) {
            clientBuilder.cookieJar(new JavaNetCookieJar(cookieHandler));
        }
        if (proxy != null) {
            inet = new InetSocketAddress(proxy.host, proxy.port);
            javaProxy = null;
            _hx_tmp = proxy.type;
            if (_hx_tmp != null) {
                switch (_hx_tmp.hashCode()) {
                    case -1843718906: {
                        if (_hx_tmp.equals("SOCKS5")) break;
                        ** break;
                    }
                    case -1843718907: {
                        if (_hx_tmp.equals("SOCKS4")) break;
                        ** break;
                    }
                    case 0x220088: {
                        if (!_hx_tmp.equals("HTTP")) ** break;
                        javaProxy = Proxy.Type.HTTP;
                        ** break;
                    }
                }
                javaProxy = Proxy.Type.SOCKS;
                ** break;
            }
lbl47:
            // 8 sources

            javaProxy = new Proxy(javaProxy, inet);
            clientBuilder.proxy(javaProxy).proxyAuthenticator(this);
        }
        if (trustManagerFactory != null) {
            trustManagers = trustManagerFactory.getTrustManagers();
            x509TrustManager = null;
            tmp = false;
            if (trustManagers.length == 1) {
                value = trustManagers[0];
                x509TrustManager = Std.isOfType(value, X509TrustManager.class) != false ? (X509TrustManager)value : null;
                tmp = x509TrustManager == null;
            } else {
                tmp = true;
            }
            if (tmp) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
            sslSocketFactory = sslContext.getSocketFactory();
            clientBuilder.sslSocketFactory(sslSocketFactory, x509TrustManager);
        }
        this.ws = clientBuilder.build().newWebSocket(request, this);
    }

    public /* synthetic */ WsClient(EmptyConstructor _) {
        super(_);
    }
}

